// owl/mojom/notification_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_NOTIFICATION_SERVICE_MOJOM_H_
#define OWL_MOJOM_NOTIFICATION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/notification_service.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/notification_service.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/notification_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class NotificationServiceProxy;

template <typename ImplRefTraits>
class NotificationServiceStub;

class NotificationServiceRequestValidator;


class NotificationService
    : public NotificationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.NotificationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NotificationServiceInterfaceBase;
  using Proxy_ = NotificationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = NotificationServiceStub<ImplRefTraits>;

  using RequestValidator_ = NotificationServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotificationClickedMinVersion = 0,
    kNotificationClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotificationClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotificationClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NotificationService() = default;

  virtual void NotificationClicked(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, std::optional<int32_t> action_index) = 0;

  virtual void NotificationClosed(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, bool by_user) = 0;
};

class NotificationServiceClientProxy;

template <typename ImplRefTraits>
class NotificationServiceClientStub;

class NotificationServiceClientRequestValidator;


class NotificationServiceClient
    : public NotificationServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.NotificationServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NotificationServiceClientInterfaceBase;
  using Proxy_ = NotificationServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NotificationServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = NotificationServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kShowNotificationMinVersion = 0,
    kRemoveNotificationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ShowNotification_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveNotification_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NotificationServiceClient() = default;

  virtual void ShowNotification(const std::string& notification_id, int32_t handler_type, const ::std::u16string& title, const ::std::u16string& message, const ::std::u16string& display_source, const ::GURL& origin_url, const ::gfx::ImageSkia& icon) = 0;

  virtual void RemoveNotification(const std::string& notification_id) = 0;
};



class  NotificationServiceProxy
    : public NotificationService {
 public:
  using InterfaceType = NotificationService;

  explicit NotificationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotificationClicked(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, std::optional<int32_t> action_index) final;
  
  void NotificationClosed(const std::string& notification_id, int32_t handler_type, const ::GURL& origin_url, bool by_user) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NotificationServiceClientProxy
    : public NotificationServiceClient {
 public:
  using InterfaceType = NotificationServiceClient;

  explicit NotificationServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ShowNotification(const std::string& notification_id, int32_t handler_type, const ::std::u16string& title, const ::std::u16string& message, const ::std::u16string& display_source, const ::GURL& origin_url, const ::gfx::ImageSkia& icon) final;
  
  void RemoveNotification(const std::string& notification_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NotificationServiceStubDispatch {
 public:
  static bool Accept(NotificationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NotificationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NotificationService>>
class NotificationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NotificationServiceStub() = default;
  ~NotificationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NotificationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NotificationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NotificationServiceClientStubDispatch {
 public:
  static bool Accept(NotificationServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NotificationServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NotificationServiceClient>>
class NotificationServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NotificationServiceClientStub() = default;
  ~NotificationServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NotificationServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NotificationServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NotificationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NotificationServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // owl::mojom

namespace mojo {

}  // namespace mojo

#endif  // OWL_MOJOM_NOTIFICATION_SERVICE_MOJOM_H_