// owl/mojom/icloud_passkeys.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/icloud_passkeys.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"


namespace owl::mojom {
class ICloudKeychainPasskeyResultDataView;

class PRFInputDataView;

class PublicKeyCredentialDescriptorDataView;

class RequestIDDataView;

class CtapMakeCredentialRequestDataView;

class CtapGetAssertionRequestDataView;

class ICloudCredentialPrfDataDataView;

class ICloudCredentialDataView;

class MakeCredentialResultDataView;

class AuthenticatorDataDataView;

class GetAssertionResultDataView;

class ExistingCredentialDataView;

class GetCredentialsResultDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::ICloudKeychainPasskeyResultDataView> {
  using Data = ::owl::mojom::internal::ICloudKeychainPasskeyResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PRFInputDataView> {
  using Data = ::owl::mojom::internal::PRFInput_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PublicKeyCredentialDescriptorDataView> {
  using Data = ::owl::mojom::internal::PublicKeyCredentialDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::RequestIDDataView> {
  using Data = ::owl::mojom::internal::RequestID_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CtapMakeCredentialRequestDataView> {
  using Data = ::owl::mojom::internal::CtapMakeCredentialRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CtapGetAssertionRequestDataView> {
  using Data = ::owl::mojom::internal::CtapGetAssertionRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ICloudCredentialPrfDataDataView> {
  using Data = ::owl::mojom::internal::ICloudCredentialPrfData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ICloudCredentialDataView> {
  using Data = ::owl::mojom::internal::ICloudCredential_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::MakeCredentialResultDataView> {
  using Data = ::owl::mojom::internal::MakeCredentialResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::AuthenticatorDataDataView> {
  using Data = ::owl::mojom::internal::AuthenticatorData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::GetAssertionResultDataView> {
  using Data = ::owl::mojom::internal::GetAssertionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ExistingCredentialDataView> {
  using Data = ::owl::mojom::internal::ExistingCredential_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::GetCredentialsResultDataView> {
  using Data = ::owl::mojom::internal::GetCredentialsResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class UserVerificationRequirement : int32_t {
  
  kDiscouraged = 0,
  
  kPreferred = 1,
  
  kRequired = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserVerificationRequirement value);
inline bool IsKnownEnumValue(UserVerificationRequirement value) {
  return internal::UserVerificationRequirement_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LargeBlobSupport : int32_t {
  
  kRequired = 0,
  
  kPreferred = 1,
  
  kNotRequested = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, LargeBlobSupport value);
inline bool IsKnownEnumValue(LargeBlobSupport value) {
  return internal::LargeBlobSupport_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MakeCredentialFailureReason : int32_t {
  
  kUserConsentButCredentialExcluded = 0,
  
  kUserConsentDenied = 1,
  
  kUnavailable = 2,
  
  kUnknown = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MakeCredentialFailureReason value);
inline bool IsKnownEnumValue(MakeCredentialFailureReason value) {
  return internal::MakeCredentialFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GetAssertionFailureReason : int32_t {
  
  kICloudKeychainNoCredentials = 0,
  
  kUserConsentDenied = 1,
  
  kUnavailable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, GetAssertionFailureReason value);
inline bool IsKnownEnumValue(GetAssertionFailureReason value) {
  return internal::GetAssertionFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GetCredentialsFailureReason : int32_t {
  
  kNotAuthorizedOrDenied = 0,
  
  kUnavailable = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GetCredentialsFailureReason value);
inline bool IsKnownEnumValue(GetCredentialsFailureReason value) {
  return internal::GetCredentialsFailureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ICloudKeychainPasskeyBridgeInterfaceBase {};

using ICloudKeychainPasskeyBridgePtrDataView =
    mojo::InterfacePtrDataView<ICloudKeychainPasskeyBridgeInterfaceBase>;
using ICloudKeychainPasskeyBridgeRequestDataView =
    mojo::InterfaceRequestDataView<ICloudKeychainPasskeyBridgeInterfaceBase>;
using ICloudKeychainPasskeyBridgeAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ICloudKeychainPasskeyBridgeInterfaceBase>;
using ICloudKeychainPasskeyBridgeAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ICloudKeychainPasskeyBridgeInterfaceBase>;


class ICloudKeychainPasskeyResultDataView {
 public:
  ICloudKeychainPasskeyResultDataView() = default;

  ICloudKeychainPasskeyResultDataView(
      internal::ICloudKeychainPasskeyResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRawAttestationObjectDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawAttestationObject(UserType* output) {
    
    auto* pointer = data_->raw_attestation_object.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ICloudKeychainPasskeyResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PRFInputDataView {
 public:
  PRFInputDataView() = default;

  PRFInputDataView(
      internal::PRFInput_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetInput1DataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput1(UserType* output) {
    
    auto* pointer = data_->input1.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetInput2DataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput2(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `input2` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInput2` instead "
    "of `ReadInput2 if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->input2.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::PRFInput_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PublicKeyCredentialDescriptorDataView {
 public:
  PublicKeyCredentialDescriptorDataView() = default;

  PublicKeyCredentialDescriptorDataView(
      internal::PublicKeyCredentialDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetTransportsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransports(UserType* output) {
    
    auto* pointer = data_->transports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PublicKeyCredentialDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestIDDataView {
 public:
  RequestIDDataView() = default;

  RequestIDDataView(
      internal::RequestID_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RequestID_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CtapMakeCredentialRequestDataView {
 public:
  CtapMakeCredentialRequestDataView() = default;

  CtapMakeCredentialRequestDataView(
      internal::CtapMakeCredentialRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      RequestIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::owl::mojom::RequestIDDataView>(
        pointer, output, message_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClientDataHashDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientDataHash(UserType* output) {
    
    auto* pointer = data_->client_data_hash.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetUserIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserId(UserType* output) {
    
    auto* pointer = data_->user_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetUserNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserName(UserType* output) {
    
    auto* pointer = data_->user_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserVerification(UserType* output) const {
    auto data_value = data_->user_verification;
    return mojo::internal::Deserialize<::owl::mojom::UserVerificationRequirement>(
        data_value, output);
  }
  UserVerificationRequirement user_verification() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::UserVerificationRequirement>(data_->user_verification));
  }
  inline void GetUserDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserDisplayName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `user_display_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserDisplayName` instead "
    "of `ReadUserDisplayName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_prf() const {
    return data_->has_prf;
  }
  inline void GetPrfInputDataView(
      PRFInputDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfInput(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::PRFInputDataView, UserType>(),
    "Attempting to read the optional `prf_input` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfInput` instead "
    "of `ReadPrfInput if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_input.Get();
    return mojo::internal::Deserialize<::owl::mojom::PRFInputDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlobSupport(UserType* output) const {
    auto data_value = data_->large_blob_support;
    return mojo::internal::Deserialize<::owl::mojom::LargeBlobSupport>(
        data_value, output);
  }
  LargeBlobSupport large_blob_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::LargeBlobSupport>(data_->large_blob_support));
  }
  inline void GetPublicKeyAlgorithmsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPublicKeyAlgorithms(UserType* output) {
    
    auto* pointer = data_->public_key_algorithms.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  bool resident_key_required() const {
    return data_->resident_key_required;
  }
  inline void GetExcludeListDataView(
      mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludeList(UserType* output) {
    
    auto* pointer = data_->exclude_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::PublicKeyCredentialDescriptorDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CtapMakeCredentialRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CtapGetAssertionRequestDataView {
 public:
  CtapGetAssertionRequestDataView() = default;

  CtapGetAssertionRequestDataView(
      internal::CtapGetAssertionRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      RequestIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::owl::mojom::RequestIDDataView>(
        pointer, output, message_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetClientDataHashDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientDataHash(UserType* output) {
    
    auto* pointer = data_->client_data_hash.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAllowedIdsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedIds(UserType* output) {
    
    auto* pointer = data_->allowed_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserVerification(UserType* output) const {
    auto data_value = data_->user_verification;
    return mojo::internal::Deserialize<::owl::mojom::UserVerificationRequirement>(
        data_value, output);
  }
  UserVerificationRequirement user_verification() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::UserVerificationRequirement>(data_->user_verification));
  }
  inline void GetPrfInputsDataView(
      mojo::ArrayDataView<PRFInputDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfInputs(UserType* output) {
    
    auto* pointer = data_->prf_inputs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::PRFInputDataView>>(
        pointer, output, message_);
  }
  bool large_blob_read() const {
    return data_->large_blob_read;
  }
  inline void GetLargeBlobWriteDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlobWrite(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `large_blob_write` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargeBlobWrite` instead "
    "of `ReadLargeBlobWrite if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->large_blob_write.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::CtapGetAssertionRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ICloudCredentialPrfDataDataView {
 public:
  ICloudCredentialPrfDataDataView() = default;

  ICloudCredentialPrfDataDataView(
      internal::ICloudCredentialPrfData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool prf_enabled() const {
    return data_->prf_enabled;
  }
  inline void GetPrfResultsDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfResults(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `prf_results` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfResults` instead "
    "of `ReadPrfResults if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ICloudCredentialPrfData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ICloudCredentialDataView {
 public:
  ICloudCredentialDataView() = default;

  ICloudCredentialDataView(
      internal::ICloudCredential_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRawAttestationObjectDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawAttestationObject(UserType* output) {
    
    auto* pointer = data_->raw_attestation_object.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialId(UserType* output) {
    
    auto* pointer = data_->credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetPrfDataDataView(
      ICloudCredentialPrfDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrfData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::ICloudCredentialPrfDataDataView, UserType>(),
    "Attempting to read the optional `prf_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrfData` instead "
    "of `ReadPrfData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prf_data.Get();
    return mojo::internal::Deserialize<::owl::mojom::ICloudCredentialPrfDataDataView>(
        pointer, output, message_);
  }
  bool is_bespoke_large_blob() const {
    return data_->is_bespoke_large_blob;
  }
 private:
  internal::ICloudCredential_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MakeCredentialResultDataView {
 public:
  MakeCredentialResultDataView() = default;

  MakeCredentialResultDataView(
      internal::MakeCredentialResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialDataView(
      ICloudCredentialDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredential(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::ICloudCredentialDataView, UserType>(),
    "Attempting to read the optional `credential` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredential` instead "
    "of `ReadCredential if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->credential.Get();
    return mojo::internal::Deserialize<::owl::mojom::ICloudCredentialDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    if (!data_->failure_reason_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::owl::mojom::MakeCredentialFailureReason>(
        data_->failure_reason_$value, &output->emplace());
  }
  std::optional<MakeCredentialFailureReason> failure_reason() const {
    if (!data_->failure_reason_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::MakeCredentialFailureReason>(data_->failure_reason_$value));
  }
 private:
  internal::MakeCredentialResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AuthenticatorDataDataView {
 public:
  AuthenticatorDataDataView() = default;

  AuthenticatorDataDataView(
      internal::AuthenticatorData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRawAuthenticatorDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawAuthenticatorData(UserType* output) {
    
    auto* pointer = data_->raw_authenticator_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetUserIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserId(UserType* output) {
    
    auto* pointer = data_->user_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialId(UserType* output) {
    
    auto* pointer = data_->credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetHmacSecretDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHmacSecret(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `hmac_secret` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHmacSecret` instead "
    "of `ReadHmacSecret if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hmac_secret.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetLargeBlobDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLargeBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `large_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLargeBlob` instead "
    "of `ReadLargeBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->large_blob.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool large_blob_written() const {
    return data_->large_blob_written;
  }
 private:
  internal::AuthenticatorData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetAssertionResultDataView {
 public:
  GetAssertionResultDataView() = default;

  GetAssertionResultDataView(
      internal::GetAssertionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      AuthenticatorDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::AuthenticatorDataDataView, UserType>(),
    "Attempting to read the optional `data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadData` instead "
    "of `ReadData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::owl::mojom::AuthenticatorDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    if (!data_->failure_reason_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::owl::mojom::GetAssertionFailureReason>(
        data_->failure_reason_$value, &output->emplace());
  }
  std::optional<GetAssertionFailureReason> failure_reason() const {
    if (!data_->failure_reason_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::GetAssertionFailureReason>(data_->failure_reason_$value));
  }
 private:
  internal::GetAssertionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExistingCredentialDataView {
 public:
  ExistingCredentialDataView() = default;

  ExistingCredentialDataView(
      internal::ExistingCredential_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialId(UserType* output) {
    
    auto* pointer = data_->credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetProviderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `provider_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProviderName` instead "
    "of `ReadProviderName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->provider_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUserHandleDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserHandle(UserType* output) {
    
    auto* pointer = data_->user_handle.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExistingCredential_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetCredentialsResultDataView {
 public:
  GetCredentialsResultDataView() = default;

  GetCredentialsResultDataView(
      internal::GetCredentialsResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialsDataView(
      mojo::ArrayDataView<ExistingCredentialDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentials(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::owl::mojom::ExistingCredentialDataView>, UserType>(),
    "Attempting to read the optional `credentials` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredentials` instead "
    "of `ReadCredentials if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::ExistingCredentialDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFailureReason(UserType* output) const {
    if (!data_->failure_reason_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::owl::mojom::GetCredentialsFailureReason>(
        data_->failure_reason_$value, &output->emplace());
  }
  std::optional<GetCredentialsFailureReason> failure_reason() const {
    if (!data_->failure_reason_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::GetCredentialsFailureReason>(data_->failure_reason_$value));
  }
 private:
  internal::GetCredentialsResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_ICLOUD_PASSKEYS_MOJOM_DATA_VIEW_H_