// owl/mojom/extension_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_EXTENSION_SERVICE_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_EXTENSION_SERVICE_MOJOM_TEST_UTILS_H_

#include "owl/mojom/extension_service.mojom.h"


namespace owl::mojom {


class  ExtensionServiceClientInterceptorForTesting : public ExtensionServiceClient {
  virtual ExtensionServiceClient* GetForwardingInterface() = 0;
  void OnExtensionInstalled(ExtensionInfoPtr extension_info, bool is_update) override;
  void OnExtensionUninstalled(const std::string& extension_id) override;
  void OnExtensionLoaded(const std::string& extension_id) override;
  void OnExtensionUnloaded(const std::string& extension_id) override;
  void OnExtensionActionIconUpdated(const std::string& extension_id, const ::gfx::ImageSkia& icon) override;
  void OnExtensionMenuUpdated(const std::string& extension_id, std::vector<ExtensionMenuItemPtr> items) override;
};
class  ExtensionServiceClientAsyncWaiter {
 public:
  explicit ExtensionServiceClientAsyncWaiter(ExtensionServiceClient* proxy);

  ExtensionServiceClientAsyncWaiter(const ExtensionServiceClientAsyncWaiter&) = delete;
  ExtensionServiceClientAsyncWaiter& operator=(const ExtensionServiceClientAsyncWaiter&) = delete;

  ~ExtensionServiceClientAsyncWaiter();

 private:
  ExtensionServiceClient* const proxy_;
};


class  ExtensionServiceInterceptorForTesting : public ExtensionService {
  virtual ExtensionService* GetForwardingInterface() = 0;
  void GetInstalledExtensions(GetInstalledExtensionsCallback callback) override;
  void ClickExtension(const std::string& extension_id) override;
  void InstallExtensionById(const std::string& extension_id, InstallExtensionByIdCallback callback) override;
  void SelectMenuItem(const std::string& extension_id, ExtensionMenuItemIdPtr item_id) override;
};
class  ExtensionServiceAsyncWaiter {
 public:
  explicit ExtensionServiceAsyncWaiter(ExtensionService* proxy);

  ExtensionServiceAsyncWaiter(const ExtensionServiceAsyncWaiter&) = delete;
  ExtensionServiceAsyncWaiter& operator=(const ExtensionServiceAsyncWaiter&) = delete;

  ~ExtensionServiceAsyncWaiter();
  void GetInstalledExtensions(
      std::vector<ExtensionInfoPtr>* out_extensions);
  std::vector<ExtensionInfoPtr> GetInstalledExtensions();
  void InstallExtensionById(
      const std::string& extension_id, bool* out_success);
  bool InstallExtensionById(const std::string& extension_id);

 private:
  ExtensionService* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_EXTENSION_SERVICE_MOJOM_TEST_UTILS_H_