// owl/mojom/chatgpt_frontend.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_H_
#define OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/chatgpt_frontend.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/chatgpt_frontend.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/chatgpt_frontend.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class ChatGPTFrontendHostProxy;

template <typename ImplRefTraits>
class ChatGPTFrontendHostStub;

class ChatGPTFrontendHostRequestValidator;
class ChatGPTFrontendHostResponseValidator;


class ChatGPTFrontendHost
    : public ChatGPTFrontendHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ChatGPTFrontendHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChatGPTFrontendHostInterfaceBase;
  using Proxy_ = ChatGPTFrontendHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChatGPTFrontendHostStub<ImplRefTraits>;

  using RequestValidator_ = ChatGPTFrontendHostRequestValidator;
  using ResponseValidator_ = ChatGPTFrontendHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetFrontendMinVersion = 0,
    kGetAccountIDMinVersion = 0,
    kSendMessageMinVersion = 0,
    kReceivedFirstTokenMinVersion = 0,
    kBindReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetFrontend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAccountID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceivedFirstToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChatGPTFrontendHost() = default;

  virtual void SetFrontend(::mojo::PendingRemote<ChatGPTFrontend> frontend) = 0;

  using GetAccountIDCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using GetAccountIDMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void GetAccountID(GetAccountIDCallback callback) = 0;

  using SendMessageCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using SendMessageMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) = 0;

  virtual void ReceivedFirstToken(const std::string& server_conversation_id) = 0;

  virtual void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) = 0;
};

class ChatGPTFrontendProxy;

template <typename ImplRefTraits>
class ChatGPTFrontendStub;

class ChatGPTFrontendRequestValidator;
class ChatGPTFrontendResponseValidator;


class ChatGPTFrontend
    : public ChatGPTFrontendInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.ChatGPTFrontend";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChatGPTFrontendInterfaceBase;
  using Proxy_ = ChatGPTFrontendProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChatGPTFrontendStub<ImplRefTraits>;

  using RequestValidator_ = ChatGPTFrontendRequestValidator;
  using ResponseValidator_ = ChatGPTFrontendResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLogConsoleMessageMinVersion = 0,
    kSendMessageMinVersion = 0,
    kBindReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LogConsoleMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChatGPTFrontend() = default;

  virtual void LogConsoleMessage(const std::string& message) = 0;

  using SendMessageCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using SendMessageMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) = 0;

  virtual void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) = 0;
};



class  ChatGPTFrontendHostProxy
    : public ChatGPTFrontendHost {
 public:
  using InterfaceType = ChatGPTFrontendHost;

  explicit ChatGPTFrontendHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFrontend(::mojo::PendingRemote<ChatGPTFrontend> frontend) final;
  
  void GetAccountID(GetAccountIDCallback callback) final;
  
  void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) final;
  
  void ReceivedFirstToken(const std::string& server_conversation_id) final;
  
  void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ChatGPTFrontendProxy
    : public ChatGPTFrontend {
 public:
  using InterfaceType = ChatGPTFrontend;

  explicit ChatGPTFrontendProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LogConsoleMessage(const std::string& message) final;
  
  void SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) final;
  
  void BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ChatGPTFrontendHostStubDispatch {
 public:
  static bool Accept(ChatGPTFrontendHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChatGPTFrontendHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChatGPTFrontendHost>>
class ChatGPTFrontendHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChatGPTFrontendHostStub() = default;
  ~ChatGPTFrontendHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChatGPTFrontendHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChatGPTFrontendHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChatGPTFrontendStubDispatch {
 public:
  static bool Accept(ChatGPTFrontend* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChatGPTFrontend* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChatGPTFrontend>>
class ChatGPTFrontendStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChatGPTFrontendStub() = default;
  ~ChatGPTFrontendStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChatGPTFrontendStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChatGPTFrontendStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChatGPTFrontendHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChatGPTFrontendRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChatGPTFrontendHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChatGPTFrontendResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // owl::mojom

namespace mojo {

}  // namespace mojo

#endif  // OWL_MOJOM_CHATGPT_FRONTEND_MOJOM_H_