// owl/mojom/chatgpt_frontend.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/chatgpt_frontend.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/chatgpt_frontend.mojom-params-data.h"
#include "owl/mojom/chatgpt_frontend.mojom-shared-message-ids.h"

#include "owl/mojom/chatgpt_frontend.mojom-import-headers.h"
#include "owl/mojom/chatgpt_frontend.mojom-test-utils.h"


namespace owl::mojom {
// The declaration includes the definition on other builds.

ChatGPTFrontendHost::IPCStableHashFunction ChatGPTFrontendHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChatGPTFrontendHost>(message.name())) {
    case messages::ChatGPTFrontendHost::kSetFrontend: {
      return &ChatGPTFrontendHost::SetFrontend_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontendHost::kGetAccountID: {
      return &ChatGPTFrontendHost::GetAccountID_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontendHost::kSendMessage: {
      return &ChatGPTFrontendHost::SendMessage_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontendHost::kReceivedFirstToken: {
      return &ChatGPTFrontendHost::ReceivedFirstToken_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontendHost::kBindReceiver: {
      return &ChatGPTFrontendHost::BindReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChatGPTFrontendHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChatGPTFrontendHost>(message.name())) {
      case messages::ChatGPTFrontendHost::kSetFrontend:
            return "Receive owl::mojom::ChatGPTFrontendHost::SetFrontend";
      case messages::ChatGPTFrontendHost::kGetAccountID:
            return "Receive owl::mojom::ChatGPTFrontendHost::GetAccountID";
      case messages::ChatGPTFrontendHost::kSendMessage:
            return "Receive owl::mojom::ChatGPTFrontendHost::SendMessage";
      case messages::ChatGPTFrontendHost::kReceivedFirstToken:
            return "Receive owl::mojom::ChatGPTFrontendHost::ReceivedFirstToken";
      case messages::ChatGPTFrontendHost::kBindReceiver:
            return "Receive owl::mojom::ChatGPTFrontendHost::BindReceiver";
    }
  } else {
    switch (static_cast<messages::ChatGPTFrontendHost>(message.name())) {
      case messages::ChatGPTFrontendHost::kSetFrontend:
            return "Receive reply owl::mojom::ChatGPTFrontendHost::SetFrontend";
      case messages::ChatGPTFrontendHost::kGetAccountID:
            return "Receive reply owl::mojom::ChatGPTFrontendHost::GetAccountID";
      case messages::ChatGPTFrontendHost::kSendMessage:
            return "Receive reply owl::mojom::ChatGPTFrontendHost::SendMessage";
      case messages::ChatGPTFrontendHost::kReceivedFirstToken:
            return "Receive reply owl::mojom::ChatGPTFrontendHost::ReceivedFirstToken";
      case messages::ChatGPTFrontendHost::kBindReceiver:
            return "Receive reply owl::mojom::ChatGPTFrontendHost::BindReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChatGPTFrontendHost::SetFrontend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf064370;  // IPCStableHash for owl::mojom::ChatGPTFrontendHost::SetFrontend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontendHost::GetAccountID_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d02ffb7;  // IPCStableHash for owl::mojom::ChatGPTFrontendHost::GetAccountID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontendHost::SendMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdaa5fe0b;  // IPCStableHash for owl::mojom::ChatGPTFrontendHost::SendMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontendHost::ReceivedFirstToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5173e516;  // IPCStableHash for owl::mojom::ChatGPTFrontendHost::ReceivedFirstToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontendHost::BindReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4dc35fc7;  // IPCStableHash for owl::mojom::ChatGPTFrontendHost::BindReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChatGPTFrontendHost_GetAccountID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChatGPTFrontendHost_GetAccountID_ForwardToCallback(
      ChatGPTFrontendHost::GetAccountIDCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChatGPTFrontendHost_GetAccountID_ForwardToCallback(const ChatGPTFrontendHost_GetAccountID_ForwardToCallback&) = delete;
  ChatGPTFrontendHost_GetAccountID_ForwardToCallback& operator=(const ChatGPTFrontendHost_GetAccountID_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChatGPTFrontendHost::GetAccountIDCallback callback_;
};

class ChatGPTFrontendHost_SendMessage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChatGPTFrontendHost_SendMessage_ForwardToCallback(
      ChatGPTFrontendHost::SendMessageCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChatGPTFrontendHost_SendMessage_ForwardToCallback(const ChatGPTFrontendHost_SendMessage_ForwardToCallback&) = delete;
  ChatGPTFrontendHost_SendMessage_ForwardToCallback& operator=(const ChatGPTFrontendHost_SendMessage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChatGPTFrontendHost::SendMessageCallback callback_;
};

ChatGPTFrontendHostProxy::ChatGPTFrontendHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChatGPTFrontendHostProxy::SetFrontend(
    ::mojo::PendingRemote<ChatGPTFrontend> in_frontend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontendHost::SetFrontend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frontend"), in_frontend,
                        "<value of type ::mojo::PendingRemote<ChatGPTFrontend>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kSetFrontend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_SetFrontend_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::owl::mojom::ChatGPTFrontendInterfaceBase>>(
    in_frontend,
    &params->frontend,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frontend)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frontend in ChatGPTFrontendHost.SetFrontend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("SetFrontend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChatGPTFrontendHostProxy::GetAccountID(
    GetAccountIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::ChatGPTFrontendHost::GetAccountID");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kGetAccountID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_GetAccountID_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("GetAccountID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChatGPTFrontendHost_GetAccountID_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChatGPTFrontendHostProxy::SendMessage(
    const std::string& in_name, const std::optional<std::string>& in_payload, SendMessageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontendHost::SendMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payload"), in_payload,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kSendMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_SendMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ChatGPTFrontendHost.SendMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->payload)::BaseType> payload_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_payload,
    payload_fragment);

  params->payload.Set(
      payload_fragment.is_null() ? nullptr : payload_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("SendMessage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChatGPTFrontendHost_SendMessage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChatGPTFrontendHostProxy::ReceivedFirstToken(
    const std::string& in_server_conversation_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontendHost::ReceivedFirstToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("server_conversation_id"), in_server_conversation_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kReceivedFirstToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_ReceivedFirstToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->server_conversation_id)::BaseType> server_conversation_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_server_conversation_id,
    server_conversation_id_fragment);

  params->server_conversation_id.Set(
      server_conversation_id_fragment.is_null() ? nullptr : server_conversation_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->server_conversation_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null server_conversation_id in ChatGPTFrontendHost.ReceivedFirstToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("ReceivedFirstToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChatGPTFrontendHostProxy::BindReceiver(
    const std::string& in_interface_name, ::mojo::ScopedMessagePipeHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontendHost::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kBindReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_BindReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_interface_name,
    interface_name_fragment);

  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interface_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interface_name in ChatGPTFrontendHost.BindReceiver request");

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in ChatGPTFrontendHost.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ChatGPTFrontendHost_GetAccountID_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChatGPTFrontendHost::GetAccountIDCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChatGPTFrontendHost_GetAccountID_ProxyToResponder> proxy(
        new ChatGPTFrontendHost_GetAccountID_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChatGPTFrontendHost_GetAccountID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChatGPTFrontendHost_GetAccountID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChatGPTFrontendHost_GetAccountID_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChatGPTFrontendHost::GetAccountIDCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_id);
};

bool ChatGPTFrontendHost_GetAccountID_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChatGPTFrontendHost_GetAccountID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChatGPTFrontendHost_GetAccountID_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChatGPTFrontendHost.1
  bool success = true;
  std::optional<std::string> p_id{};
  ChatGPTFrontendHost_GetAccountID_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChatGPTFrontendHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_id));
  }
  return true;
}

void ChatGPTFrontendHost_GetAccountID_ProxyToResponder::Run(
    const std::optional<std::string>& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ChatGPTFrontendHost::GetAccountID", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kGetAccountID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_GetAccountID_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("GetAccountID");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ChatGPTFrontendHost_SendMessage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChatGPTFrontendHost::SendMessageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChatGPTFrontendHost_SendMessage_ProxyToResponder> proxy(
        new ChatGPTFrontendHost_SendMessage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChatGPTFrontendHost_SendMessage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChatGPTFrontendHost_SendMessage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChatGPTFrontendHost_SendMessage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChatGPTFrontendHost::SendMessageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_reply);
};

bool ChatGPTFrontendHost_SendMessage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChatGPTFrontendHost_SendMessage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChatGPTFrontendHost_SendMessage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChatGPTFrontendHost.2
  bool success = true;
  std::optional<std::string> p_reply{};
  ChatGPTFrontendHost_SendMessage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChatGPTFrontendHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reply));
  }
  return true;
}

void ChatGPTFrontendHost_SendMessage_ProxyToResponder::Run(
    const std::optional<std::string>& in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ChatGPTFrontendHost::SendMessage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontendHost::kSendMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontendHost_SendMessage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reply,
    reply_fragment);

  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontendHost::Name_);
  message.set_method_name("SendMessage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChatGPTFrontendHostStubDispatch::Accept(
    ChatGPTFrontendHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChatGPTFrontendHost>(message->header()->name)) {
    case messages::ChatGPTFrontendHost::kSetFrontend: {
      DCHECK(message->is_serialized());
      internal::ChatGPTFrontendHost_SetFrontend_Params_Data* params =
          reinterpret_cast<internal::ChatGPTFrontendHost_SetFrontend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChatGPTFrontendHost.0
      bool success = true;
      ::mojo::PendingRemote<ChatGPTFrontend> p_frontend{};
      ChatGPTFrontendHost_SetFrontend_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_frontend =
            input_data_view.TakeFrontend<decltype(p_frontend)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontendHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrontend(        
        std::move(p_frontend));
      return true;
    }
    case messages::ChatGPTFrontendHost::kGetAccountID: {
      break;
    }
    case messages::ChatGPTFrontendHost::kSendMessage: {
      break;
    }
    case messages::ChatGPTFrontendHost::kReceivedFirstToken: {
      DCHECK(message->is_serialized());
      internal::ChatGPTFrontendHost_ReceivedFirstToken_Params_Data* params =
          reinterpret_cast<internal::ChatGPTFrontendHost_ReceivedFirstToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChatGPTFrontendHost.3
      bool success = true;
      std::string p_server_conversation_id{};
      ChatGPTFrontendHost_ReceivedFirstToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServerConversationId(&p_server_conversation_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontendHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceivedFirstToken(        
        std::move(p_server_conversation_id));
      return true;
    }
    case messages::ChatGPTFrontendHost::kBindReceiver: {
      DCHECK(message->is_serialized());
      internal::ChatGPTFrontendHost_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::ChatGPTFrontendHost_BindReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChatGPTFrontendHost.4
      bool success = true;
      std::string p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_pipe{};
      ChatGPTFrontendHost_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontendHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(        
        std::move(p_interface_name), 
        std::move(p_pipe));
      return true;
    }
  }
  return false;
}

// static
bool ChatGPTFrontendHostStubDispatch::AcceptWithResponder(
    ChatGPTFrontendHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChatGPTFrontendHost>(message->header()->name)) {
    case messages::ChatGPTFrontendHost::kSetFrontend: {
      break;
    }
    case messages::ChatGPTFrontendHost::kGetAccountID: {
      internal::ChatGPTFrontendHost_GetAccountID_Params_Data* params =
          reinterpret_cast<
              internal::ChatGPTFrontendHost_GetAccountID_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChatGPTFrontendHost.1
      bool success = true;
      ChatGPTFrontendHost_GetAccountID_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontendHost::Name_, 1, false);
        return false;
      }
      auto callback =
          ChatGPTFrontendHost_GetAccountID_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAccountID(std::move(callback));
      return true;
    }
    case messages::ChatGPTFrontendHost::kSendMessage: {
      internal::ChatGPTFrontendHost_SendMessage_Params_Data* params =
          reinterpret_cast<
              internal::ChatGPTFrontendHost_SendMessage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChatGPTFrontendHost.2
      bool success = true;
      std::string p_name{};
      std::optional<std::string> p_payload{};
      ChatGPTFrontendHost_SendMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadPayload(&p_payload))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontendHost::Name_, 2, false);
        return false;
      }
      auto callback =
          ChatGPTFrontendHost_SendMessage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessage(        
        std::move(p_name), 
        std::move(p_payload), std::move(callback));
      return true;
    }
    case messages::ChatGPTFrontendHost::kReceivedFirstToken: {
      break;
    }
    case messages::ChatGPTFrontendHost::kBindReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChatGPTFrontendHostValidationInfo[] = {
    { &internal::ChatGPTFrontendHost_SetFrontend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChatGPTFrontendHost_GetAccountID_Params_Data::Validate,
     &internal::ChatGPTFrontendHost_GetAccountID_ResponseParams_Data::Validate},
    { &internal::ChatGPTFrontendHost_SendMessage_Params_Data::Validate,
     &internal::ChatGPTFrontendHost_SendMessage_ResponseParams_Data::Validate},
    { &internal::ChatGPTFrontendHost_ReceivedFirstToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChatGPTFrontendHost_BindReceiver_Params_Data::Validate,
     nullptr /* no response */},
};

bool ChatGPTFrontendHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ChatGPTFrontendHost::Name_,
    kChatGPTFrontendHostValidationInfo);
}

bool ChatGPTFrontendHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::ChatGPTFrontendHost::Name_,
    kChatGPTFrontendHostValidationInfo);
}
// The declaration includes the definition on other builds.

ChatGPTFrontend::IPCStableHashFunction ChatGPTFrontend::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChatGPTFrontend>(message.name())) {
    case messages::ChatGPTFrontend::kLogConsoleMessage: {
      return &ChatGPTFrontend::LogConsoleMessage_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontend::kSendMessage: {
      return &ChatGPTFrontend::SendMessage_Sym::IPCStableHash;
    }
    case messages::ChatGPTFrontend::kBindReceiver: {
      return &ChatGPTFrontend::BindReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChatGPTFrontend::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChatGPTFrontend>(message.name())) {
      case messages::ChatGPTFrontend::kLogConsoleMessage:
            return "Receive owl::mojom::ChatGPTFrontend::LogConsoleMessage";
      case messages::ChatGPTFrontend::kSendMessage:
            return "Receive owl::mojom::ChatGPTFrontend::SendMessage";
      case messages::ChatGPTFrontend::kBindReceiver:
            return "Receive owl::mojom::ChatGPTFrontend::BindReceiver";
    }
  } else {
    switch (static_cast<messages::ChatGPTFrontend>(message.name())) {
      case messages::ChatGPTFrontend::kLogConsoleMessage:
            return "Receive reply owl::mojom::ChatGPTFrontend::LogConsoleMessage";
      case messages::ChatGPTFrontend::kSendMessage:
            return "Receive reply owl::mojom::ChatGPTFrontend::SendMessage";
      case messages::ChatGPTFrontend::kBindReceiver:
            return "Receive reply owl::mojom::ChatGPTFrontend::BindReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChatGPTFrontend::LogConsoleMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe78f842;  // IPCStableHash for owl::mojom::ChatGPTFrontend::LogConsoleMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontend::SendMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fb7f877;  // IPCStableHash for owl::mojom::ChatGPTFrontend::SendMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChatGPTFrontend::BindReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f7b9c2f;  // IPCStableHash for owl::mojom::ChatGPTFrontend::BindReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChatGPTFrontend_SendMessage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChatGPTFrontend_SendMessage_ForwardToCallback(
      ChatGPTFrontend::SendMessageCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChatGPTFrontend_SendMessage_ForwardToCallback(const ChatGPTFrontend_SendMessage_ForwardToCallback&) = delete;
  ChatGPTFrontend_SendMessage_ForwardToCallback& operator=(const ChatGPTFrontend_SendMessage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChatGPTFrontend::SendMessageCallback callback_;
};

ChatGPTFrontendProxy::ChatGPTFrontendProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChatGPTFrontendProxy::LogConsoleMessage(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontend::LogConsoleMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontend::kLogConsoleMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontend_LogConsoleMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ChatGPTFrontend.LogConsoleMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontend::Name_);
  message.set_method_name("LogConsoleMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ChatGPTFrontendProxy::SendMessage(
    const std::string& in_name, const std::optional<std::string>& in_payload, SendMessageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontend::SendMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("payload"), in_payload,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontend::kSendMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontend_SendMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ChatGPTFrontend.SendMessage request");
  mojo::internal::MessageFragment<
      typename decltype(params->payload)::BaseType> payload_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_payload,
    payload_fragment);

  params->payload.Set(
      payload_fragment.is_null() ? nullptr : payload_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontend::Name_);
  message.set_method_name("SendMessage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChatGPTFrontend_SendMessage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChatGPTFrontendProxy::BindReceiver(
    const std::string& in_interface_name, ::mojo::ScopedMessagePipeHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::ChatGPTFrontend::BindReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontend::kBindReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontend_BindReceiver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_interface_name,
    interface_name_fragment);

  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interface_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interface_name in ChatGPTFrontend.BindReceiver request");

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in ChatGPTFrontend.BindReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontend::Name_);
  message.set_method_name("BindReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ChatGPTFrontend_SendMessage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChatGPTFrontend::SendMessageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChatGPTFrontend_SendMessage_ProxyToResponder> proxy(
        new ChatGPTFrontend_SendMessage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChatGPTFrontend_SendMessage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChatGPTFrontend_SendMessage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChatGPTFrontend_SendMessage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ChatGPTFrontend::SendMessageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_reply);
};

bool ChatGPTFrontend_SendMessage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChatGPTFrontend_SendMessage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChatGPTFrontend_SendMessage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ChatGPTFrontend.1
  bool success = true;
  std::optional<std::string> p_reply{};
  ChatGPTFrontend_SendMessage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadReply(&p_reply))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChatGPTFrontend::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_reply));
  }
  return true;
}

void ChatGPTFrontend_SendMessage_ProxyToResponder::Run(
    const std::optional<std::string>& in_reply) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::ChatGPTFrontend::SendMessage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reply"), in_reply,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChatGPTFrontend::kSendMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::ChatGPTFrontend_SendMessage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reply)::BaseType> reply_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reply,
    reply_fragment);

  params->reply.Set(
      reply_fragment.is_null() ? nullptr : reply_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChatGPTFrontend::Name_);
  message.set_method_name("SendMessage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChatGPTFrontendStubDispatch::Accept(
    ChatGPTFrontend* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChatGPTFrontend>(message->header()->name)) {
    case messages::ChatGPTFrontend::kLogConsoleMessage: {
      DCHECK(message->is_serialized());
      internal::ChatGPTFrontend_LogConsoleMessage_Params_Data* params =
          reinterpret_cast<internal::ChatGPTFrontend_LogConsoleMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChatGPTFrontend.0
      bool success = true;
      std::string p_message{};
      ChatGPTFrontend_LogConsoleMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontend::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LogConsoleMessage(        
        std::move(p_message));
      return true;
    }
    case messages::ChatGPTFrontend::kSendMessage: {
      break;
    }
    case messages::ChatGPTFrontend::kBindReceiver: {
      DCHECK(message->is_serialized());
      internal::ChatGPTFrontend_BindReceiver_Params_Data* params =
          reinterpret_cast<internal::ChatGPTFrontend_BindReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ChatGPTFrontend.2
      bool success = true;
      std::string p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_pipe{};
      ChatGPTFrontend_BindReceiver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontend::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindReceiver(        
        std::move(p_interface_name), 
        std::move(p_pipe));
      return true;
    }
  }
  return false;
}

// static
bool ChatGPTFrontendStubDispatch::AcceptWithResponder(
    ChatGPTFrontend* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChatGPTFrontend>(message->header()->name)) {
    case messages::ChatGPTFrontend::kLogConsoleMessage: {
      break;
    }
    case messages::ChatGPTFrontend::kSendMessage: {
      internal::ChatGPTFrontend_SendMessage_Params_Data* params =
          reinterpret_cast<
              internal::ChatGPTFrontend_SendMessage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ChatGPTFrontend.1
      bool success = true;
      std::string p_name{};
      std::optional<std::string> p_payload{};
      ChatGPTFrontend_SendMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadPayload(&p_payload))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChatGPTFrontend::Name_, 1, false);
        return false;
      }
      auto callback =
          ChatGPTFrontend_SendMessage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendMessage(        
        std::move(p_name), 
        std::move(p_payload), std::move(callback));
      return true;
    }
    case messages::ChatGPTFrontend::kBindReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kChatGPTFrontendValidationInfo[] = {
    { &internal::ChatGPTFrontend_LogConsoleMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ChatGPTFrontend_SendMessage_Params_Data::Validate,
     &internal::ChatGPTFrontend_SendMessage_ResponseParams_Data::Validate},
    { &internal::ChatGPTFrontend_BindReceiver_Params_Data::Validate,
     nullptr /* no response */},
};

bool ChatGPTFrontendRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::ChatGPTFrontend::Name_,
    kChatGPTFrontendValidationInfo);
}

bool ChatGPTFrontendResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::ChatGPTFrontend::Name_,
    kChatGPTFrontendValidationInfo);
}


}  // owl::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void ChatGPTFrontendHostInterceptorForTesting::SetFrontend(::mojo::PendingRemote<ChatGPTFrontend> frontend) {
  GetForwardingInterface()->SetFrontend(
    std::move(frontend)
    );
}
void ChatGPTFrontendHostInterceptorForTesting::GetAccountID(GetAccountIDCallback callback) {
  GetForwardingInterface()->GetAccountID(std::move(callback));
}
void ChatGPTFrontendHostInterceptorForTesting::SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) {
  GetForwardingInterface()->SendMessage(
    std::move(name)
    , 
    std::move(payload)
    , std::move(callback));
}
void ChatGPTFrontendHostInterceptorForTesting::ReceivedFirstToken(const std::string& server_conversation_id) {
  GetForwardingInterface()->ReceivedFirstToken(
    std::move(server_conversation_id)
    );
}
void ChatGPTFrontendHostInterceptorForTesting::BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) {
  GetForwardingInterface()->BindReceiver(
    std::move(interface_name)
    , 
    std::move(pipe)
    );
}
ChatGPTFrontendHostAsyncWaiter::ChatGPTFrontendHostAsyncWaiter(
    ChatGPTFrontendHost* proxy) : proxy_(proxy) {}

ChatGPTFrontendHostAsyncWaiter::~ChatGPTFrontendHostAsyncWaiter() = default;


void ChatGPTFrontendHostAsyncWaiter::GetAccountID(
    std::optional<std::string>* out_id) {
  base::RunLoop loop;
  proxy_->GetAccountID(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_id
,
             const std::optional<std::string>& id) {*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_id));
  loop.Run();
}

std::optional<std::string> ChatGPTFrontendHostAsyncWaiter::GetAccountID(
    ) {
  std::optional<std::string> async_wait_result;
  GetAccountID(&async_wait_result);
  return async_wait_result;
}

void ChatGPTFrontendHostAsyncWaiter::SendMessage(
    const std::string& name, const std::optional<std::string>& payload, std::optional<std::string>* out_reply) {
  base::RunLoop loop;
  proxy_->SendMessage(
      std::move(name),
      std::move(payload),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_reply
,
             const std::optional<std::string>& reply) {*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_reply));
  loop.Run();
}

std::optional<std::string> ChatGPTFrontendHostAsyncWaiter::SendMessage(
    const std::string& name, const std::optional<std::string>& payload) {
  std::optional<std::string> async_wait_result;
  SendMessage(std::move(name),std::move(payload),&async_wait_result);
  return async_wait_result;
}




void ChatGPTFrontendInterceptorForTesting::LogConsoleMessage(const std::string& message) {
  GetForwardingInterface()->LogConsoleMessage(
    std::move(message)
    );
}
void ChatGPTFrontendInterceptorForTesting::SendMessage(const std::string& name, const std::optional<std::string>& payload, SendMessageCallback callback) {
  GetForwardingInterface()->SendMessage(
    std::move(name)
    , 
    std::move(payload)
    , std::move(callback));
}
void ChatGPTFrontendInterceptorForTesting::BindReceiver(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) {
  GetForwardingInterface()->BindReceiver(
    std::move(interface_name)
    , 
    std::move(pipe)
    );
}
ChatGPTFrontendAsyncWaiter::ChatGPTFrontendAsyncWaiter(
    ChatGPTFrontend* proxy) : proxy_(proxy) {}

ChatGPTFrontendAsyncWaiter::~ChatGPTFrontendAsyncWaiter() = default;


void ChatGPTFrontendAsyncWaiter::SendMessage(
    const std::string& name, const std::optional<std::string>& payload, std::optional<std::string>* out_reply) {
  base::RunLoop loop;
  proxy_->SendMessage(
      std::move(name),
      std::move(payload),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_reply
,
             const std::optional<std::string>& reply) {*out_reply = std::move(reply);
            loop->Quit();
          },
          &loop,
          out_reply));
  loop.Run();
}

std::optional<std::string> ChatGPTFrontendAsyncWaiter::SendMessage(
    const std::string& name, const std::optional<std::string>& payload) {
  std::optional<std::string> async_wait_result;
  SendMessage(std::move(name),std::move(payload),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif