// owl/mojom/card_prompt.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/card_prompt.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/card_prompt.mojom-params-data.h"
#include "owl/mojom/card_prompt.mojom-shared-message-ids.h"

#include "owl/mojom/card_prompt.mojom-import-headers.h"
#include "owl/mojom/card_prompt.mojom-test-utils.h"


namespace owl::mojom {
SaveCardPromptDetails::SaveCardPromptDetails()
    : card_label(),
      expiration_date() {}

SaveCardPromptDetails::SaveCardPromptDetails(
    const ::std::u16string& card_label_in,
    const ::std::u16string& expiration_date_in)
    : card_label(std::move(card_label_in)),
      expiration_date(std::move(expiration_date_in)) {}

SaveCardPromptDetails::~SaveCardPromptDetails() = default;

void SaveCardPromptDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "card_label"), this->card_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration_date"), this->expiration_date,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SaveCardPromptDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SaveCardPrompt::IPCStableHashFunction SaveCardPrompt::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SaveCardPrompt>(message.name())) {
    case messages::SaveCardPrompt::kClose: {
      return &SaveCardPrompt::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SaveCardPrompt::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SaveCardPrompt>(message.name())) {
      case messages::SaveCardPrompt::kClose:
            return "Receive owl::mojom::SaveCardPrompt::Close";
    }
  } else {
    switch (static_cast<messages::SaveCardPrompt>(message.name())) {
      case messages::SaveCardPrompt::kClose:
            return "Receive reply owl::mojom::SaveCardPrompt::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SaveCardPrompt::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa80c25d3;  // IPCStableHash for owl::mojom::SaveCardPrompt::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SaveCardPromptProxy::SaveCardPromptProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SaveCardPromptProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SaveCardPrompt::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SaveCardPrompt::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SaveCardPrompt_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SaveCardPrompt::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SaveCardPromptStubDispatch::Accept(
    SaveCardPrompt* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SaveCardPrompt>(message->header()->name)) {
    case messages::SaveCardPrompt::kClose: {
      DCHECK(message->is_serialized());
      internal::SaveCardPrompt_Close_Params_Data* params =
          reinterpret_cast<internal::SaveCardPrompt_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SaveCardPrompt.0
      bool success = true;
      SaveCardPrompt_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SaveCardPrompt::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool SaveCardPromptStubDispatch::AcceptWithResponder(
    SaveCardPrompt* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SaveCardPrompt>(message->header()->name)) {
    case messages::SaveCardPrompt::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSaveCardPromptValidationInfo[] = {
    { &internal::SaveCardPrompt_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool SaveCardPromptRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SaveCardPrompt::Name_,
    kSaveCardPromptValidationInfo);
}

// The declaration includes the definition on other builds.

SaveCardPromptClient::IPCStableHashFunction SaveCardPromptClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SaveCardPromptClient>(message.name())) {
    case messages::SaveCardPromptClient::kAccept: {
      return &SaveCardPromptClient::Accept_Sym::IPCStableHash;
    }
    case messages::SaveCardPromptClient::kDecline: {
      return &SaveCardPromptClient::Decline_Sym::IPCStableHash;
    }
    case messages::SaveCardPromptClient::kDismiss: {
      return &SaveCardPromptClient::Dismiss_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SaveCardPromptClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SaveCardPromptClient>(message.name())) {
      case messages::SaveCardPromptClient::kAccept:
            return "Receive owl::mojom::SaveCardPromptClient::Accept";
      case messages::SaveCardPromptClient::kDecline:
            return "Receive owl::mojom::SaveCardPromptClient::Decline";
      case messages::SaveCardPromptClient::kDismiss:
            return "Receive owl::mojom::SaveCardPromptClient::Dismiss";
    }
  } else {
    switch (static_cast<messages::SaveCardPromptClient>(message.name())) {
      case messages::SaveCardPromptClient::kAccept:
            return "Receive reply owl::mojom::SaveCardPromptClient::Accept";
      case messages::SaveCardPromptClient::kDecline:
            return "Receive reply owl::mojom::SaveCardPromptClient::Decline";
      case messages::SaveCardPromptClient::kDismiss:
            return "Receive reply owl::mojom::SaveCardPromptClient::Dismiss";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SaveCardPromptClient::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85f14d60;  // IPCStableHash for owl::mojom::SaveCardPromptClient::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SaveCardPromptClient::Decline_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4285522d;  // IPCStableHash for owl::mojom::SaveCardPromptClient::Decline
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SaveCardPromptClient::Dismiss_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe32da60f;  // IPCStableHash for owl::mojom::SaveCardPromptClient::Dismiss
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SaveCardPromptClientProxy::SaveCardPromptClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SaveCardPromptClientProxy::Accept(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SaveCardPromptClient::Accept");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SaveCardPromptClient::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SaveCardPromptClient_Accept_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SaveCardPromptClient::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SaveCardPromptClientProxy::Decline(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SaveCardPromptClient::Decline");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SaveCardPromptClient::kDecline), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SaveCardPromptClient_Decline_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SaveCardPromptClient::Name_);
  message.set_method_name("Decline");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SaveCardPromptClientProxy::Dismiss(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SaveCardPromptClient::Dismiss");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SaveCardPromptClient::kDismiss), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SaveCardPromptClient_Dismiss_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SaveCardPromptClient::Name_);
  message.set_method_name("Dismiss");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SaveCardPromptClientStubDispatch::Accept(
    SaveCardPromptClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SaveCardPromptClient>(message->header()->name)) {
    case messages::SaveCardPromptClient::kAccept: {
      DCHECK(message->is_serialized());
      internal::SaveCardPromptClient_Accept_Params_Data* params =
          reinterpret_cast<internal::SaveCardPromptClient_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SaveCardPromptClient.0
      bool success = true;
      SaveCardPromptClient_Accept_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SaveCardPromptClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        );
      return true;
    }
    case messages::SaveCardPromptClient::kDecline: {
      DCHECK(message->is_serialized());
      internal::SaveCardPromptClient_Decline_Params_Data* params =
          reinterpret_cast<internal::SaveCardPromptClient_Decline_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SaveCardPromptClient.1
      bool success = true;
      SaveCardPromptClient_Decline_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SaveCardPromptClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decline(        );
      return true;
    }
    case messages::SaveCardPromptClient::kDismiss: {
      DCHECK(message->is_serialized());
      internal::SaveCardPromptClient_Dismiss_Params_Data* params =
          reinterpret_cast<internal::SaveCardPromptClient_Dismiss_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SaveCardPromptClient.2
      bool success = true;
      SaveCardPromptClient_Dismiss_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SaveCardPromptClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dismiss(        );
      return true;
    }
  }
  return false;
}

// static
bool SaveCardPromptClientStubDispatch::AcceptWithResponder(
    SaveCardPromptClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SaveCardPromptClient>(message->header()->name)) {
    case messages::SaveCardPromptClient::kAccept: {
      break;
    }
    case messages::SaveCardPromptClient::kDecline: {
      break;
    }
    case messages::SaveCardPromptClient::kDismiss: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSaveCardPromptClientValidationInfo[] = {
    { &internal::SaveCardPromptClient_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SaveCardPromptClient_Decline_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SaveCardPromptClient_Dismiss_Params_Data::Validate,
     nullptr /* no response */},
};

bool SaveCardPromptClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SaveCardPromptClient::Name_,
    kSaveCardPromptClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::SaveCardPromptDetails::DataView, ::owl::mojom::SaveCardPromptDetailsPtr>::Read(
    ::owl::mojom::SaveCardPromptDetails::DataView input,
    ::owl::mojom::SaveCardPromptDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::SaveCardPromptDetailsPtr result(::owl::mojom::SaveCardPromptDetails::New());
  
      if (success && !input.ReadCardLabel(&result->card_label))
        success = false;
      if (success && !input.ReadExpirationDate(&result->expiration_date))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void SaveCardPromptInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
SaveCardPromptAsyncWaiter::SaveCardPromptAsyncWaiter(
    SaveCardPrompt* proxy) : proxy_(proxy) {}

SaveCardPromptAsyncWaiter::~SaveCardPromptAsyncWaiter() = default;





void SaveCardPromptClientInterceptorForTesting::Accept() {
  GetForwardingInterface()->Accept();
}
void SaveCardPromptClientInterceptorForTesting::Decline() {
  GetForwardingInterface()->Decline();
}
void SaveCardPromptClientInterceptorForTesting::Dismiss() {
  GetForwardingInterface()->Dismiss();
}
SaveCardPromptClientAsyncWaiter::SaveCardPromptClientAsyncWaiter(
    SaveCardPromptClient* proxy) : proxy_(proxy) {}

SaveCardPromptClientAsyncWaiter::~SaveCardPromptClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif