// owl/mojom/bookmark_model.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_BOOKMARK_MODEL_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_BOOKMARK_MODEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/bookmark_model.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace owl::mojom {
class BookmarkNodeDataView;

class BookmarksDataView;



}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::BookmarkNodeDataView> {
  using Data = ::owl::mojom::internal::BookmarkNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::BookmarksDataView> {
  using Data = ::owl::mojom::internal::Bookmarks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class BookmarkType : int32_t {
  
  kURL = 0,
  
  kFolder = 1,
  
  kBookmarkBar = 2,
  
  kOtherNode = 3,
  
  kMobile = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, BookmarkType value);
inline bool IsKnownEnumValue(BookmarkType value) {
  return internal::BookmarkType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BookmarkModelInterfaceBase {};

using BookmarkModelPtrDataView =
    mojo::InterfacePtrDataView<BookmarkModelInterfaceBase>;
using BookmarkModelRequestDataView =
    mojo::InterfaceRequestDataView<BookmarkModelInterfaceBase>;
using BookmarkModelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarkModelInterfaceBase>;
using BookmarkModelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarkModelInterfaceBase>;
class BookmarkModelClientInterfaceBase {};

using BookmarkModelClientPtrDataView =
    mojo::InterfacePtrDataView<BookmarkModelClientInterfaceBase>;
using BookmarkModelClientRequestDataView =
    mojo::InterfaceRequestDataView<BookmarkModelClientInterfaceBase>;
using BookmarkModelClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BookmarkModelClientInterfaceBase>;
using BookmarkModelClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BookmarkModelClientInterfaceBase>;


class BookmarkNodeDataView {
 public:
  BookmarkNodeDataView() = default;

  BookmarkNodeDataView(
      internal::BookmarkNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetUuidDataView(
      ::mojo_base::mojom::UuidDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UuidDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::owl::mojom::BookmarkType>(
        data_value, output);
  }
  BookmarkType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::BookmarkType>(data_->type));
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<BookmarkNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::BookmarkNodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BookmarkNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BookmarksDataView {
 public:
  BookmarksDataView() = default;

  BookmarksDataView(
      internal::Bookmarks_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBookmarkBarNodeDataView(
      BookmarkNodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBookmarkBarNode(UserType* output) {
    
    auto* pointer = data_->bookmark_bar_node.Get();
    return mojo::internal::Deserialize<::owl::mojom::BookmarkNodeDataView>(
        pointer, output, message_);
  }
  inline void GetOtherNodeDataView(
      BookmarkNodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOtherNode(UserType* output) {
    
    auto* pointer = data_->other_node.Get();
    return mojo::internal::Deserialize<::owl::mojom::BookmarkNodeDataView>(
        pointer, output, message_);
  }
  inline void GetMobileNodeDataView(
      BookmarkNodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMobileNode(UserType* output) {
    
    auto* pointer = data_->mobile_node.Get();
    return mojo::internal::Deserialize<::owl::mojom::BookmarkNodeDataView>(
        pointer, output, message_);
  }
 private:
  internal::Bookmarks_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // owl::mojom

#endif  // OWL_MOJOM_BOOKMARK_MODEL_MOJOM_DATA_VIEW_H_