// owl/mojom/autofill_popup.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/autofill_popup.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/autofill_popup.mojom-params-data.h"
#include "owl/mojom/autofill_popup.mojom-shared-message-ids.h"

#include "owl/mojom/autofill_popup.mojom-import-headers.h"
#include "owl/mojom/autofill_popup.mojom-test-utils.h"


namespace owl::mojom {
AutofillSuggestionText::AutofillSuggestionText()
    : value(),
      is_primary(),
      should_truncate() {}

AutofillSuggestionText::AutofillSuggestionText(
    const ::std::u16string& value_in,
    bool is_primary_in,
    bool should_truncate_in)
    : value(std::move(value_in)),
      is_primary(std::move(is_primary_in)),
      should_truncate(std::move(should_truncate_in)) {}

AutofillSuggestionText::~AutofillSuggestionText() = default;

void AutofillSuggestionText::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_primary"), this->is_primary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_truncate"), this->should_truncate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutofillSuggestionText::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutofillSuggestion::AutofillSuggestion()
    : type(),
      main_text(),
      minor_text(),
      label(),
      type_v1(),
      main_text_v1(),
      minor_texts(),
      labels(),
      additional_label(),
      additional_label_alignment_right(),
      custom_icon(),
      icon(),
      trailing_icon(),
      icon_image() {}

AutofillSuggestion::AutofillSuggestion(
    uint32_t type_in,
    const ::std::u16string& main_text_in,
    const ::std::u16string& minor_text_in,
    const ::std::u16string& label_in,
    AutofillSuggestionType type_v1_in,
    AutofillSuggestionTextPtr main_text_v1_in,
    std::vector<AutofillSuggestionTextPtr> minor_texts_in,
    std::vector<std::vector<AutofillSuggestionTextPtr>> labels_in,
    const ::std::u16string& additional_label_in,
    bool additional_label_alignment_right_in,
    AutofillSuggestionCustomIconPtr custom_icon_in,
    AutofillSuggestionIcon icon_in,
    AutofillSuggestionIcon trailing_icon_in,
    const ::gfx::ImageSkia& icon_image_in)
    : type(std::move(type_in)),
      main_text(std::move(main_text_in)),
      minor_text(std::move(minor_text_in)),
      label(std::move(label_in)),
      type_v1(std::move(type_v1_in)),
      main_text_v1(std::move(main_text_v1_in)),
      minor_texts(std::move(minor_texts_in)),
      labels(std::move(labels_in)),
      additional_label(std::move(additional_label_in)),
      additional_label_alignment_right(std::move(additional_label_alignment_right_in)),
      custom_icon(std::move(custom_icon_in)),
      icon(std::move(icon_in)),
      trailing_icon(std::move(trailing_icon_in)),
      icon_image(std::move(icon_image_in)) {}

AutofillSuggestion::~AutofillSuggestion() = default;

void AutofillSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_text"), this->main_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minor_text"), this->minor_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type_v1"), this->type_v1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_text_v1"), this->main_text_v1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionTextPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minor_texts"), this->minor_texts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutofillSuggestionTextPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "labels"), this->labels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<std::vector<AutofillSuggestionTextPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_label"), this->additional_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_label_alignment_right"), this->additional_label_alignment_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_icon"), this->custom_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionCustomIconPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionIcon>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trailing_icon"), this->trailing_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionIcon>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_image"), this->icon_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutofillSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutofillPopupDetails::AutofillPopupDetails()
    : x(),
      y(),
      width(),
      height(),
      suggestions() {}

AutofillPopupDetails::AutofillPopupDetails(
    double x_in,
    double y_in,
    double width_in,
    double height_in,
    std::vector<AutofillSuggestionPtr> suggestions_in)
    : x(std::move(x_in)),
      y(std::move(y_in)),
      width(std::move(width_in)),
      height(std::move(height_in)),
      suggestions(std::move(suggestions_in)) {}

AutofillPopupDetails::~AutofillPopupDetails() = default;

void AutofillPopupDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions"), this->suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutofillSuggestionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutofillPopupDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutofillSuggestionCustomIconPtr
AutofillSuggestionCustomIcon::NewImage(
    const ::gfx::ImageSkia& value) {
  return AutofillSuggestionCustomIconPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kImage)>,
      std::move(value));
}

AutofillSuggestionCustomIconPtr
AutofillSuggestionCustomIcon::NewUrl(
    const ::GURL& value) {
  return AutofillSuggestionCustomIconPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUrl)>,
      std::move(value));
}

AutofillSuggestionCustomIconPtr
AutofillSuggestionCustomIcon::NewMonogram(
    const ::std::u16string& value) {
  return AutofillSuggestionCustomIconPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMonogram)>,
      std::move(value));
}

AutofillSuggestionCustomIcon::AutofillSuggestionCustomIcon(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    const ::gfx::ImageSkia& value)
    : tag_(Tag::kImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kImage)>,
            std::move(value)) {}

AutofillSuggestionCustomIcon::AutofillSuggestionCustomIcon(
    std::in_place_index_t<static_cast<size_t>(Tag::kUrl)>,
    const ::GURL& value)
    : tag_(Tag::kUrl),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUrl)>,
            std::move(value)) {}

AutofillSuggestionCustomIcon::AutofillSuggestionCustomIcon(
    std::in_place_index_t<static_cast<size_t>(Tag::kMonogram)>,
    const ::std::u16string& value)
    : tag_(Tag::kMonogram),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMonogram)>,
            std::move(value)) {}
AutofillSuggestionCustomIcon::~AutofillSuggestionCustomIcon() {
  DestroyActive();
}

void AutofillSuggestionCustomIcon::set_image(const ::gfx::ImageSkia& image) {
  if (tag_ == Tag::kImage) {
    data_.image = std::move(image);
  } else {
    DestroyActive();
    tag_ = Tag::kImage;
    new (&data_.image) ::gfx::ImageSkia(
        std::move(image));
  }
}

void AutofillSuggestionCustomIcon::set_url(const ::GURL& url) {
  if (tag_ == Tag::kUrl) {
    data_.url = std::move(url);
  } else {
    DestroyActive();
    tag_ = Tag::kUrl;
    new (&data_.url) ::GURL(
        std::move(url));
  }
}

void AutofillSuggestionCustomIcon::set_monogram(const ::std::u16string& monogram) {
  if (tag_ == Tag::kMonogram) {
    data_.monogram = std::move(monogram);
  } else {
    DestroyActive();
    tag_ = Tag::kMonogram;
    new (&data_.monogram) ::std::u16string(
        std::move(monogram));
  }
}


AutofillSuggestionCustomIcon::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    const ::gfx::ImageSkia& value)
    : image(std::move(value)) {}

AutofillSuggestionCustomIcon::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUrl)>,
    const ::GURL& value)
    : url(std::move(value)) {}

AutofillSuggestionCustomIcon::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMonogram)>,
    const ::std::u16string& value)
    : monogram(std::move(value)) {}

void AutofillSuggestionCustomIcon::DestroyActive() {
  switch (tag_) {

    case Tag::kImage:
      std::destroy_at(&data_.image);
      break;
    case Tag::kUrl:
      std::destroy_at(&data_.url);
      break;
    case Tag::kMonogram:
      std::destroy_at(&data_.monogram);
      break;
  }
}

bool AutofillSuggestionCustomIcon::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

AutofillPopup::IPCStableHashFunction AutofillPopup::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillPopup>(message.name())) {
    case messages::AutofillPopup::kClose: {
      return &AutofillPopup::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillPopup::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillPopup>(message.name())) {
      case messages::AutofillPopup::kClose:
            return "Receive owl::mojom::AutofillPopup::Close";
    }
  } else {
    switch (static_cast<messages::AutofillPopup>(message.name())) {
      case messages::AutofillPopup::kClose:
            return "Receive reply owl::mojom::AutofillPopup::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillPopup::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3277117;  // IPCStableHash for owl::mojom::AutofillPopup::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutofillPopupProxy::AutofillPopupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillPopupProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillPopup::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillPopup::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillPopup_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillPopup::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutofillPopupStubDispatch::Accept(
    AutofillPopup* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillPopup>(message->header()->name)) {
    case messages::AutofillPopup::kClose: {
      DCHECK(message->is_serialized());
      internal::AutofillPopup_Close_Params_Data* params =
          reinterpret_cast<internal::AutofillPopup_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillPopup.0
      bool success = true;
      AutofillPopup_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillPopup::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool AutofillPopupStubDispatch::AcceptWithResponder(
    AutofillPopup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillPopup>(message->header()->name)) {
    case messages::AutofillPopup::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutofillPopupValidationInfo[] = {
    { &internal::AutofillPopup_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutofillPopupRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutofillPopup::Name_,
    kAutofillPopupValidationInfo);
}

// The declaration includes the definition on other builds.

AutofillPopupClient::IPCStableHashFunction AutofillPopupClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutofillPopupClient>(message.name())) {
    case messages::AutofillPopupClient::kAccept: {
      return &AutofillPopupClient::Accept_Sym::IPCStableHash;
    }
    case messages::AutofillPopupClient::kSelect: {
      return &AutofillPopupClient::Select_Sym::IPCStableHash;
    }
    case messages::AutofillPopupClient::kRemove: {
      return &AutofillPopupClient::Remove_Sym::IPCStableHash;
    }
    case messages::AutofillPopupClient::kDismiss: {
      return &AutofillPopupClient::Dismiss_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutofillPopupClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutofillPopupClient>(message.name())) {
      case messages::AutofillPopupClient::kAccept:
            return "Receive owl::mojom::AutofillPopupClient::Accept";
      case messages::AutofillPopupClient::kSelect:
            return "Receive owl::mojom::AutofillPopupClient::Select";
      case messages::AutofillPopupClient::kRemove:
            return "Receive owl::mojom::AutofillPopupClient::Remove";
      case messages::AutofillPopupClient::kDismiss:
            return "Receive owl::mojom::AutofillPopupClient::Dismiss";
    }
  } else {
    switch (static_cast<messages::AutofillPopupClient>(message.name())) {
      case messages::AutofillPopupClient::kAccept:
            return "Receive reply owl::mojom::AutofillPopupClient::Accept";
      case messages::AutofillPopupClient::kSelect:
            return "Receive reply owl::mojom::AutofillPopupClient::Select";
      case messages::AutofillPopupClient::kRemove:
            return "Receive reply owl::mojom::AutofillPopupClient::Remove";
      case messages::AutofillPopupClient::kDismiss:
            return "Receive reply owl::mojom::AutofillPopupClient::Dismiss";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutofillPopupClient::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac71f953;  // IPCStableHash for owl::mojom::AutofillPopupClient::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillPopupClient::Select_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6aa3de5;  // IPCStableHash for owl::mojom::AutofillPopupClient::Select
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillPopupClient::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8c01335;  // IPCStableHash for owl::mojom::AutofillPopupClient::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutofillPopupClient::Dismiss_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3cf9022a;  // IPCStableHash for owl::mojom::AutofillPopupClient::Dismiss
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutofillPopupClientProxy::AutofillPopupClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutofillPopupClientProxy::Accept(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillPopupClient::Accept", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillPopupClient::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillPopupClient_Accept_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillPopupClient::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillPopupClientProxy::Select(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillPopupClient::Select", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillPopupClient::kSelect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillPopupClient_Select_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillPopupClient::Name_);
  message.set_method_name("Select");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillPopupClientProxy::Remove(
    int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutofillPopupClient::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillPopupClient::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillPopupClient_Remove_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillPopupClient::Name_);
  message.set_method_name("Remove");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutofillPopupClientProxy::Dismiss(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutofillPopupClient::Dismiss");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutofillPopupClient::kDismiss), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutofillPopupClient_Dismiss_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutofillPopupClient::Name_);
  message.set_method_name("Dismiss");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutofillPopupClientStubDispatch::Accept(
    AutofillPopupClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutofillPopupClient>(message->header()->name)) {
    case messages::AutofillPopupClient::kAccept: {
      DCHECK(message->is_serialized());
      internal::AutofillPopupClient_Accept_Params_Data* params =
          reinterpret_cast<internal::AutofillPopupClient_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillPopupClient.0
      bool success = true;
      int32_t p_index{};
      AutofillPopupClient_Accept_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillPopupClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        
        std::move(p_index));
      return true;
    }
    case messages::AutofillPopupClient::kSelect: {
      DCHECK(message->is_serialized());
      internal::AutofillPopupClient_Select_Params_Data* params =
          reinterpret_cast<internal::AutofillPopupClient_Select_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillPopupClient.1
      bool success = true;
      int32_t p_index{};
      AutofillPopupClient_Select_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillPopupClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Select(        
        std::move(p_index));
      return true;
    }
    case messages::AutofillPopupClient::kRemove: {
      DCHECK(message->is_serialized());
      internal::AutofillPopupClient_Remove_Params_Data* params =
          reinterpret_cast<internal::AutofillPopupClient_Remove_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillPopupClient.2
      bool success = true;
      int32_t p_index{};
      AutofillPopupClient_Remove_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillPopupClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_index));
      return true;
    }
    case messages::AutofillPopupClient::kDismiss: {
      DCHECK(message->is_serialized());
      internal::AutofillPopupClient_Dismiss_Params_Data* params =
          reinterpret_cast<internal::AutofillPopupClient_Dismiss_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutofillPopupClient.3
      bool success = true;
      AutofillPopupClient_Dismiss_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutofillPopupClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dismiss(        );
      return true;
    }
  }
  return false;
}

// static
bool AutofillPopupClientStubDispatch::AcceptWithResponder(
    AutofillPopupClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutofillPopupClient>(message->header()->name)) {
    case messages::AutofillPopupClient::kAccept: {
      break;
    }
    case messages::AutofillPopupClient::kSelect: {
      break;
    }
    case messages::AutofillPopupClient::kRemove: {
      break;
    }
    case messages::AutofillPopupClient::kDismiss: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutofillPopupClientValidationInfo[] = {
    { &internal::AutofillPopupClient_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillPopupClient_Select_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillPopupClient_Remove_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutofillPopupClient_Dismiss_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutofillPopupClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutofillPopupClient::Name_,
    kAutofillPopupClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::AutofillSuggestionText::DataView, ::owl::mojom::AutofillSuggestionTextPtr>::Read(
    ::owl::mojom::AutofillSuggestionText::DataView input,
    ::owl::mojom::AutofillSuggestionTextPtr* output) {
  bool success = true;
  ::owl::mojom::AutofillSuggestionTextPtr result(::owl::mojom::AutofillSuggestionText::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success)
        result->is_primary = input.is_primary();
      if (success)
        result->should_truncate = input.should_truncate();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::AutofillSuggestion::DataView, ::owl::mojom::AutofillSuggestionPtr>::Read(
    ::owl::mojom::AutofillSuggestion::DataView input,
    ::owl::mojom::AutofillSuggestionPtr* output) {
  bool success = true;
  ::owl::mojom::AutofillSuggestionPtr result(::owl::mojom::AutofillSuggestion::New());
  
      if (success)
        result->type = input.type();
      if (success && !input.ReadMainText(&result->main_text))
        success = false;
      if (success && !input.ReadMinorText(&result->minor_text))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadTypeV1(&result->type_v1))
        success = false;
      if (success && !input.ReadMainTextV1(&result->main_text_v1))
        success = false;
      if (success && !input.ReadMinorTexts(&result->minor_texts))
        success = false;
      if (success && !input.ReadLabels(&result->labels))
        success = false;
      if (success && !input.ReadAdditionalLabel(&result->additional_label))
        success = false;
      if (success)
        result->additional_label_alignment_right = input.additional_label_alignment_right();
      if (success && !input.ReadCustomIcon(&result->custom_icon))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadTrailingIcon(&result->trailing_icon))
        success = false;
      if (success && !input.ReadIconImage(&result->icon_image))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::AutofillPopupDetails::DataView, ::owl::mojom::AutofillPopupDetailsPtr>::Read(
    ::owl::mojom::AutofillPopupDetails::DataView input,
    ::owl::mojom::AutofillPopupDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::AutofillPopupDetailsPtr result(::owl::mojom::AutofillPopupDetails::New());
  
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadSuggestions(&result->suggestions))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::AutofillSuggestionCustomIcon::DataView, ::owl::mojom::AutofillSuggestionCustomIconPtr>::Read(
    ::owl::mojom::AutofillSuggestionCustomIcon::DataView input,
    ::owl::mojom::AutofillSuggestionCustomIconPtr* output) {
  using UnionType = ::owl::mojom::AutofillSuggestionCustomIcon;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kImage: {
      ::gfx::ImageSkia result_image{};
      if (!input.ReadImage(&result_image))
        return false;

      *output = UnionType::NewImage(
          std::move(result_image));
      break;
    }
    case Tag::kUrl: {
      ::GURL result_url{};
      if (!input.ReadUrl(&result_url))
        return false;

      *output = UnionType::NewUrl(
          std::move(result_url));
      break;
    }
    case Tag::kMonogram: {
      ::std::u16string result_monogram{};
      if (!input.ReadMonogram(&result_monogram))
        return false;

      *output = UnionType::NewMonogram(
          std::move(result_monogram));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void AutofillPopupInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
AutofillPopupAsyncWaiter::AutofillPopupAsyncWaiter(
    AutofillPopup* proxy) : proxy_(proxy) {}

AutofillPopupAsyncWaiter::~AutofillPopupAsyncWaiter() = default;





void AutofillPopupClientInterceptorForTesting::Accept(int32_t index) {
  GetForwardingInterface()->Accept(
    std::move(index)
    );
}
void AutofillPopupClientInterceptorForTesting::Select(int32_t index) {
  GetForwardingInterface()->Select(
    std::move(index)
    );
}
void AutofillPopupClientInterceptorForTesting::Remove(int32_t index) {
  GetForwardingInterface()->Remove(
    std::move(index)
    );
}
void AutofillPopupClientInterceptorForTesting::Dismiss() {
  GetForwardingInterface()->Dismiss();
}
AutofillPopupClientAsyncWaiter::AutofillPopupClientAsyncWaiter(
    AutofillPopupClient* proxy) : proxy_(proxy) {}

AutofillPopupClientAsyncWaiter::~AutofillPopupClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif