// owl/mojom/autofill_popup.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/autofill_popup.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/autofill_popup.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* AutofillSuggestionIconToStringHelper(AutofillSuggestionIcon value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutofillSuggestionIcon::kUnknown:
      return "kUnknown";
    case AutofillSuggestionIcon::kNoIcon:
      return "kNoIcon";
    case AutofillSuggestionIcon::kAccount:
      return "kAccount";
    case AutofillSuggestionIcon::kClear:
      return "kClear";
    case AutofillSuggestionIcon::kCreate:
      return "kCreate";
    case AutofillSuggestionIcon::kCode:
      return "kCode";
    case AutofillSuggestionIcon::kDelete:
      return "kDelete";
    case AutofillSuggestionIcon::kDevice:
      return "kDevice";
    case AutofillSuggestionIcon::kEdit:
      return "kEdit";
    case AutofillSuggestionIcon::kEmail:
      return "kEmail";
    case AutofillSuggestionIcon::kError:
      return "kError";
    case AutofillSuggestionIcon::kFlight:
      return "kFlight";
    case AutofillSuggestionIcon::kGlobe:
      return "kGlobe";
    case AutofillSuggestionIcon::kGoogle:
      return "kGoogle";
    case AutofillSuggestionIcon::kGoogleMonochrome:
      return "kGoogleMonochrome";
    case AutofillSuggestionIcon::kGooglePasswordManager:
      return "kGooglePasswordManager";
    case AutofillSuggestionIcon::kGooglePay:
      return "kGooglePay";
    case AutofillSuggestionIcon::kGoogleWallet:
      return "kGoogleWallet";
    case AutofillSuggestionIcon::kGoogleWalletMonochrome:
      return "kGoogleWalletMonochrome";
    case AutofillSuggestionIcon::kHome:
      return "kHome";
    case AutofillSuggestionIcon::kHttpWarning:
      return "kHttpWarning";
    case AutofillSuggestionIcon::kHttpsInvalid:
      return "kHttpsInvalid";
    case AutofillSuggestionIcon::kIdCard:
      return "kIdCard";
    case AutofillSuggestionIcon::kKey:
      return "kKey";
    case AutofillSuggestionIcon::kLocation:
      return "kLocation";
    case AutofillSuggestionIcon::kLoyalty:
      return "kLoyalty";
    case AutofillSuggestionIcon::kMagic:
      return "kMagic";
    case AutofillSuggestionIcon::kOfferTag:
      return "kOfferTag";
    case AutofillSuggestionIcon::kPenSpark:
      return "kPenSpark";
    case AutofillSuggestionIcon::kPlusAddress:
      return "kPlusAddress";
    case AutofillSuggestionIcon::kQuestionMark:
      return "kQuestionMark";
    case AutofillSuggestionIcon::kRecoveryPassword:
      return "kRecoveryPassword";
    case AutofillSuggestionIcon::kScanCreditCard:
      return "kScanCreditCard";
    case AutofillSuggestionIcon::kSettings:
      return "kSettings";
    case AutofillSuggestionIcon::kSettingsAndroid:
      return "kSettingsAndroid";
    case AutofillSuggestionIcon::kUndo:
      return "kUndo";
    case AutofillSuggestionIcon::kVehicle:
      return "kVehicle";
    case AutofillSuggestionIcon::kWork:
      return "kWork";
    case AutofillSuggestionIcon::kCardGeneric:
      return "kCardGeneric";
    case AutofillSuggestionIcon::kCardAmericanExpress:
      return "kCardAmericanExpress";
    case AutofillSuggestionIcon::kCardDiners:
      return "kCardDiners";
    case AutofillSuggestionIcon::kCardDiscover:
      return "kCardDiscover";
    case AutofillSuggestionIcon::kCardElo:
      return "kCardElo";
    case AutofillSuggestionIcon::kCardJCB:
      return "kCardJCB";
    case AutofillSuggestionIcon::kCardMasterCard:
      return "kCardMasterCard";
    case AutofillSuggestionIcon::kCardMir:
      return "kCardMir";
    case AutofillSuggestionIcon::kCardTroy:
      return "kCardTroy";
    case AutofillSuggestionIcon::kCardUnionPay:
      return "kCardUnionPay";
    case AutofillSuggestionIcon::kCardVerve:
      return "kCardVerve";
    case AutofillSuggestionIcon::kCardVisa:
      return "kCardVisa";
    case AutofillSuggestionIcon::kIban:
      return "kIban";
    case AutofillSuggestionIcon::kBnpl:
      return "kBnpl";
    case AutofillSuggestionIcon::kSaveAndFill:
      return "kSaveAndFill";
    case AutofillSuggestionIcon::kPersonCheck:
      return "kPersonCheck";
    case AutofillSuggestionIcon::kAndroidMessages:
      return "kAndroidMessages";
    default:
      return nullptr;
  }
}

std::string AutofillSuggestionIconToString(AutofillSuggestionIcon value) {
  const char *str = AutofillSuggestionIconToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutofillSuggestionIcon value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutofillSuggestionIcon value) {
  return os << AutofillSuggestionIconToString(value);
}

NOINLINE static const char* AutofillSuggestionTypeToStringHelper(AutofillSuggestionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutofillSuggestionType::kUnknown:
      return "kUnknown";
    case AutofillSuggestionType::kAutocompleteEntry:
      return "kAutocompleteEntry";
    case AutofillSuggestionType::kAddressEntry:
      return "kAddressEntry";
    case AutofillSuggestionType::kICloudPromo:
      return "kICloudPromo";
    case AutofillSuggestionType::kAddressFieldByFieldFilling:
      return "kAddressFieldByFieldFilling";
    case AutofillSuggestionType::kManageAddress:
      return "kManageAddress";
    case AutofillSuggestionType::kManageCreditCard:
      return "kManageCreditCard";
    case AutofillSuggestionType::kManageIban:
      return "kManageIban";
    case AutofillSuggestionType::kManagePlusAddress:
      return "kManagePlusAddress";
    case AutofillSuggestionType::kComposeProactiveNudge:
      return "kComposeProactiveNudge";
    case AutofillSuggestionType::kComposeResumeNudge:
      return "kComposeResumeNudge";
    case AutofillSuggestionType::kComposeSavedStateNotification:
      return "kComposeSavedStateNotification";
    case AutofillSuggestionType::kComposeDisable:
      return "kComposeDisable";
    case AutofillSuggestionType::kComposeGoToSettings:
      return "kComposeGoToSettings";
    case AutofillSuggestionType::kComposeNeverShowOnThisSiteAgain:
      return "kComposeNeverShowOnThisSiteAgain";
    case AutofillSuggestionType::kDatalistEntry:
      return "kDatalistEntry";
    case AutofillSuggestionType::kPasswordEntry:
      return "kPasswordEntry";
    case AutofillSuggestionType::kAllSavedPasswordsEntry:
      return "kAllSavedPasswordsEntry";
    case AutofillSuggestionType::kGeneratePasswordEntry:
      return "kGeneratePasswordEntry";
    case AutofillSuggestionType::kAccountStoragePasswordEntry:
      return "kAccountStoragePasswordEntry";
    case AutofillSuggestionType::kPasswordFieldByFieldFilling:
      return "kPasswordFieldByFieldFilling";
    case AutofillSuggestionType::kFillPassword:
      return "kFillPassword";
    case AutofillSuggestionType::kViewPasswordDetails:
      return "kViewPasswordDetails";
    case AutofillSuggestionType::kCreditCardEntry:
      return "kCreditCardEntry";
    case AutofillSuggestionType::kInsecureContextPaymentDisabledMessage:
      return "kInsecureContextPaymentDisabledMessage";
    case AutofillSuggestionType::kScanCreditCard:
      return "kScanCreditCard";
    case AutofillSuggestionType::kVirtualCreditCardEntry:
      return "kVirtualCreditCardEntry";
    case AutofillSuggestionType::kIbanEntry:
      return "kIbanEntry";
    case AutofillSuggestionType::kCreateNewPlusAddress:
      return "kCreateNewPlusAddress";
    case AutofillSuggestionType::kFillExistingPlusAddress:
      return "kFillExistingPlusAddress";
    case AutofillSuggestionType::kMerchantPromoCodeEntry:
      return "kMerchantPromoCodeEntry";
    case AutofillSuggestionType::kSeePromoCodeDetails:
      return "kSeePromoCodeDetails";
    case AutofillSuggestionType::kWebauthnCredential:
      return "kWebauthnCredential";
    case AutofillSuggestionType::kWebauthnSignInWithAnotherDevice:
      return "kWebauthnSignInWithAnotherDevice";
    case AutofillSuggestionType::kTitle:
      return "kTitle";
    case AutofillSuggestionType::kSeparator:
      return "kSeparator";
    case AutofillSuggestionType::kUndoOrClear:
      return "kUndoOrClear";
    case AutofillSuggestionType::kMixedFormMessage:
      return "kMixedFormMessage";
    case AutofillSuggestionType::kDevtoolsTestAddresses:
      return "kDevtoolsTestAddresses";
    case AutofillSuggestionType::kDevtoolsTestAddressEntry:
      return "kDevtoolsTestAddressEntry";
    case AutofillSuggestionType::kDevtoolsTestAddressByCountry:
      return "kDevtoolsTestAddressByCountry";
    case AutofillSuggestionType::kCreateNewPlusAddressInline:
      return "kCreateNewPlusAddressInline";
    case AutofillSuggestionType::kFillAutofillAi:
      return "kFillAutofillAi";
    case AutofillSuggestionType::kPlusAddressError:
      return "kPlusAddressError";
    case AutofillSuggestionType::kBnplEntry:
      return "kBnplEntry";
    case AutofillSuggestionType::kSaveAndFillCreditCardEntry:
      return "kSaveAndFillCreditCardEntry";
    case AutofillSuggestionType::kAddressEntryOnTyping:
      return "kAddressEntryOnTyping";
    case AutofillSuggestionType::kManageAutofillAi:
      return "kManageAutofillAi";
    case AutofillSuggestionType::kPendingStateSignin:
      return "kPendingStateSignin";
    case AutofillSuggestionType::kIdentityCredential:
      return "kIdentityCredential";
    case AutofillSuggestionType::kLoyaltyCardEntry:
      return "kLoyaltyCardEntry";
    case AutofillSuggestionType::kManageLoyaltyCard:
      return "kManageLoyaltyCard";
    case AutofillSuggestionType::kBackupPasswordEntry:
      return "kBackupPasswordEntry";
    case AutofillSuggestionType::kTroubleSigningInEntry:
      return "kTroubleSigningInEntry";
    case AutofillSuggestionType::kFreeformFooter:
      return "kFreeformFooter";
    case AutofillSuggestionType::kAllLoyaltyCardsEntry:
      return "kAllLoyaltyCardsEntry";
    case AutofillSuggestionType::kOneTimePasswordEntry:
      return "kOneTimePasswordEntry";
    default:
      return nullptr;
  }
}

std::string AutofillSuggestionTypeToString(AutofillSuggestionType value) {
  const char *str = AutofillSuggestionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutofillSuggestionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutofillSuggestionType value) {
  return os << AutofillSuggestionTypeToString(value);
}

namespace internal {
// static
bool AutofillSuggestionCustomIcon_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AutofillSuggestionCustomIcon_Data* object = static_cast<const AutofillSuggestionCustomIcon_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AutofillSuggestionCustomIcon_Tag::kImage: {

      if (!mojo::internal::ValidateStruct(object->data.f_image, validation_context))
        return false;
      return true;
    }
    case AutofillSuggestionCustomIcon_Tag::kUrl: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_url, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_url, validation_context))
        return false;
      return true;
    }
    case AutofillSuggestionCustomIcon_Tag::kMonogram: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_monogram, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_monogram, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AutofillSuggestionCustomIcon");
      return false;
    }
  }
}


// static
bool AutofillSuggestionText_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillSuggestionText_Data* object =
      static_cast<const AutofillSuggestionText_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AutofillSuggestionText_Data::AutofillSuggestionText_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillSuggestion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillSuggestion_Data* object =
      static_cast<const AutofillSuggestion_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_text, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minor_text, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minor_text, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;


  if (!::owl::mojom::internal::AutofillSuggestionType_Data
        ::Validate(object->type_v1, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_text_v1, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_text_v1, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minor_texts, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& minor_texts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->minor_texts, validation_context,
                                         &minor_texts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->labels, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& labels_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->labels, validation_context,
                                         &labels_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_label, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->additional_label, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->custom_icon, validation_context))
    return false;


  if (!::owl::mojom::internal::AutofillSuggestionIcon_Data
        ::Validate(object->icon, validation_context))
    return false;


  if (!::owl::mojom::internal::AutofillSuggestionIcon_Data
        ::Validate(object->trailing_icon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->icon_image, validation_context))
    return false;

  return true;
}

AutofillSuggestion_Data::AutofillSuggestion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopupDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopupDetails_Data* object =
      static_cast<const AutofillPopupDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  return true;
}

AutofillPopupDetails_Data::AutofillPopupDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopup_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopup_Close_Params_Data* object =
      static_cast<const AutofillPopup_Close_Params_Data*>(data);

  return true;
}

AutofillPopup_Close_Params_Data::AutofillPopup_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopupClient_Accept_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopupClient_Accept_Params_Data* object =
      static_cast<const AutofillPopupClient_Accept_Params_Data*>(data);

  return true;
}

AutofillPopupClient_Accept_Params_Data::AutofillPopupClient_Accept_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopupClient_Select_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopupClient_Select_Params_Data* object =
      static_cast<const AutofillPopupClient_Select_Params_Data*>(data);

  return true;
}

AutofillPopupClient_Select_Params_Data::AutofillPopupClient_Select_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopupClient_Remove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopupClient_Remove_Params_Data* object =
      static_cast<const AutofillPopupClient_Remove_Params_Data*>(data);

  return true;
}

AutofillPopupClient_Remove_Params_Data::AutofillPopupClient_Remove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutofillPopupClient_Dismiss_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutofillPopupClient_Dismiss_Params_Data* object =
      static_cast<const AutofillPopupClient_Dismiss_Params_Data*>(data);

  return true;
}

AutofillPopupClient_Dismiss_Params_Data::AutofillPopupClient_Dismiss_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::AutofillSuggestionIcon>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::AutofillSuggestionIcon value) {
  return std::move(context).WriteString(::owl::mojom::AutofillSuggestionIconToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::AutofillSuggestionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::AutofillSuggestionType value) {
  return std::move(context).WriteString(::owl::mojom::AutofillSuggestionTypeToString(value));
}

} // namespace perfetto