// owl/mojom/autofill.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_AUTOFILL_MOJOM_H_
#define OWL_MOJOM_AUTOFILL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/autofill.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/autofill.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/autofill.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>








namespace owl::mojom {









class  AutofillAddressEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillAddressEntry, T>::value>;
  using DataView = AutofillAddressEntryDataView;
  using Data_ = internal::AutofillAddressEntry_Data;

  template <typename... Args>
  static AutofillAddressEntryPtr New(Args&&... args) {
    return AutofillAddressEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillAddressEntryPtr From(const U& u) {
    return mojo::TypeConverter<AutofillAddressEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillAddressEntry>::Convert(*this);
  }


  AutofillAddressEntry();

  AutofillAddressEntry(
      const std::string& guid,
      const ::std::u16string& full_name,
      const ::std::u16string& single_line_address);


  ~AutofillAddressEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillAddressEntryPtr>
  AutofillAddressEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillAddressEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillAddressEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillAddressEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillAddressEntry_UnserializedMessageContext<
            UserType, AutofillAddressEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillAddressEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillAddressEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillAddressEntry_UnserializedMessageContext<
            UserType, AutofillAddressEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillAddressEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string guid;
  
  ::std::u16string full_name;
  
  ::std::u16string single_line_address;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillAddressEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AutofillCreditCardEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutofillCreditCardEntry, T>::value>;
  using DataView = AutofillCreditCardEntryDataView;
  using Data_ = internal::AutofillCreditCardEntry_Data;

  template <typename... Args>
  static AutofillCreditCardEntryPtr New(Args&&... args) {
    return AutofillCreditCardEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutofillCreditCardEntryPtr From(const U& u) {
    return mojo::TypeConverter<AutofillCreditCardEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutofillCreditCardEntry>::Convert(*this);
  }


  AutofillCreditCardEntry();

  AutofillCreditCardEntry(
      const std::string& guid,
      const ::std::u16string& name,
      const ::std::u16string& card_number,
      const ::std::u16string& expiration,
      const ::std::u16string& network,
      const ::std::u16string& nickname);


  ~AutofillCreditCardEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutofillCreditCardEntryPtr>
  AutofillCreditCardEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillCreditCardEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutofillCreditCardEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutofillCreditCardEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutofillCreditCardEntry_UnserializedMessageContext<
            UserType, AutofillCreditCardEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutofillCreditCardEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutofillCreditCardEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutofillCreditCardEntry_UnserializedMessageContext<
            UserType, AutofillCreditCardEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutofillCreditCardEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string guid;
  
  ::std::u16string name;
  
  ::std::u16string card_number;
  
  ::std::u16string expiration;
  
  ::std::u16string network;
  
  ::std::u16string nickname;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutofillCreditCardEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AutofillAddressEntryPtr AutofillAddressEntry::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(full_name),
      mojo::Clone(single_line_address)
  );
}

template <typename T, AutofillAddressEntry::EnableIfSame<T>*>
bool AutofillAddressEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->full_name, other_struct.full_name))
    return false;
  if (!mojo::Equals(this->single_line_address, other_struct.single_line_address))
    return false;
  return true;
}

template <typename T, AutofillAddressEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.full_name < rhs.full_name)
    return true;
  if (rhs.full_name < lhs.full_name)
    return false;
  if (lhs.single_line_address < rhs.single_line_address)
    return true;
  if (rhs.single_line_address < lhs.single_line_address)
    return false;
  return false;
}
template <typename StructPtrType>
AutofillCreditCardEntryPtr AutofillCreditCardEntry::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(name),
      mojo::Clone(card_number),
      mojo::Clone(expiration),
      mojo::Clone(network),
      mojo::Clone(nickname)
  );
}

template <typename T, AutofillCreditCardEntry::EnableIfSame<T>*>
bool AutofillCreditCardEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->card_number, other_struct.card_number))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  if (!mojo::Equals(this->network, other_struct.network))
    return false;
  if (!mojo::Equals(this->nickname, other_struct.nickname))
    return false;
  return true;
}

template <typename T, AutofillCreditCardEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.card_number < rhs.card_number)
    return true;
  if (rhs.card_number < lhs.card_number)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  if (lhs.network < rhs.network)
    return true;
  if (rhs.network < lhs.network)
    return false;
  if (lhs.nickname < rhs.nickname)
    return true;
  if (rhs.nickname < lhs.nickname)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::AutofillAddressEntry::DataView,
                                         ::owl::mojom::AutofillAddressEntryPtr> {
  static bool IsNull(const ::owl::mojom::AutofillAddressEntryPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillAddressEntryPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::AutofillAddressEntry::guid)& guid(
      const ::owl::mojom::AutofillAddressEntryPtr& input) {
    return input->guid;
  }

  static const decltype(::owl::mojom::AutofillAddressEntry::full_name)& full_name(
      const ::owl::mojom::AutofillAddressEntryPtr& input) {
    return input->full_name;
  }

  static const decltype(::owl::mojom::AutofillAddressEntry::single_line_address)& single_line_address(
      const ::owl::mojom::AutofillAddressEntryPtr& input) {
    return input->single_line_address;
  }

  static bool Read(::owl::mojom::AutofillAddressEntry::DataView input, ::owl::mojom::AutofillAddressEntryPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::AutofillCreditCardEntry::DataView,
                                         ::owl::mojom::AutofillCreditCardEntryPtr> {
  static bool IsNull(const ::owl::mojom::AutofillCreditCardEntryPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::AutofillCreditCardEntryPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::guid)& guid(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->guid;
  }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::name)& name(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->name;
  }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::card_number)& card_number(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->card_number;
  }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::expiration)& expiration(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->expiration;
  }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::network)& network(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->network;
  }

  static const decltype(::owl::mojom::AutofillCreditCardEntry::nickname)& nickname(
      const ::owl::mojom::AutofillCreditCardEntryPtr& input) {
    return input->nickname;
  }

  static bool Read(::owl::mojom::AutofillCreditCardEntry::DataView input, ::owl::mojom::AutofillCreditCardEntryPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_AUTOFILL_MOJOM_H_