// owl/mojom/autocomplete.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/autocomplete.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/autocomplete.mojom-params-data.h"
#include "owl/mojom/autocomplete.mojom-shared-message-ids.h"

#include "owl/mojom/autocomplete.mojom-import-headers.h"
#include "owl/mojom/autocomplete.mojom-test-utils.h"


namespace owl::mojom {
AutocompleteMatch::AutocompleteMatch()
    : type(),
      fill_into_edit(),
      inline_autocompletion(),
      score(),
      target_url(),
      title() {}

AutocompleteMatch::AutocompleteMatch(
    AutocompleteMatchType type_in,
    const ::std::u16string& fill_into_edit_in,
    const ::std::u16string& inline_autocompletion_in,
    double score_in,
    const ::GURL& target_url_in,
    const ::std::u16string& title_in)
    : type(std::move(type_in)),
      fill_into_edit(std::move(fill_into_edit_in)),
      inline_autocompletion(std::move(inline_autocompletion_in)),
      score(std::move(score_in)),
      target_url(std::move(target_url_in)),
      title(std::move(title_in)) {}

AutocompleteMatch::~AutocompleteMatch() = default;

void AutocompleteMatch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutocompleteMatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_into_edit"), this->fill_into_edit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inline_autocompletion"), this->inline_autocompletion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "score"), this->score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteMatch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteResults::AutocompleteResults()
    : matches() {}

AutocompleteResults::AutocompleteResults(
    std::vector<AutocompleteMatchPtr> matches_in)
    : matches(std::move(matches_in)) {}

AutocompleteResults::~AutocompleteResults() = default;

void AutocompleteResults::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matches"), this->matches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutocompleteMatchPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteResults::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AutocompleteController::IPCStableHashFunction AutocompleteController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutocompleteController>(message.name())) {
    case messages::AutocompleteController::kDestroy: {
      return &AutocompleteController::Destroy_Sym::IPCStableHash;
    }
    case messages::AutocompleteController::kStart: {
      return &AutocompleteController::Start_Sym::IPCStableHash;
    }
    case messages::AutocompleteController::kStop: {
      return &AutocompleteController::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutocompleteController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutocompleteController>(message.name())) {
      case messages::AutocompleteController::kDestroy:
            return "Receive owl::mojom::AutocompleteController::Destroy";
      case messages::AutocompleteController::kStart:
            return "Receive owl::mojom::AutocompleteController::Start";
      case messages::AutocompleteController::kStop:
            return "Receive owl::mojom::AutocompleteController::Stop";
    }
  } else {
    switch (static_cast<messages::AutocompleteController>(message.name())) {
      case messages::AutocompleteController::kDestroy:
            return "Receive reply owl::mojom::AutocompleteController::Destroy";
      case messages::AutocompleteController::kStart:
            return "Receive reply owl::mojom::AutocompleteController::Start";
      case messages::AutocompleteController::kStop:
            return "Receive reply owl::mojom::AutocompleteController::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutocompleteController::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a862d4e;  // IPCStableHash for owl::mojom::AutocompleteController::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutocompleteController::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x078e1ab1;  // IPCStableHash for owl::mojom::AutocompleteController::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AutocompleteController::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf59e6bd1;  // IPCStableHash for owl::mojom::AutocompleteController::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutocompleteControllerProxy::AutocompleteControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutocompleteControllerProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutocompleteController::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutocompleteController::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutocompleteController_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutocompleteController::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutocompleteControllerProxy::Start(
    const ::std::u16string& in_input, std::optional<uint32_t> in_cursor_position, ::mojo::PendingAssociatedRemote<AutocompleteClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutocompleteController::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor_position"), in_cursor_position,
                        "<value of type std::optional<uint32_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<AutocompleteClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutocompleteController::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutocompleteController_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in AutocompleteController.Start request");
  params->cursor_position_$flag = in_cursor_position.has_value();
  if (in_cursor_position.has_value()) {
    params->cursor_position_$value = in_cursor_position.value();
  }

  
  mojo::internal::Serialize<::owl::mojom::AutocompleteClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in AutocompleteController.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutocompleteController::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AutocompleteControllerProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::AutocompleteController::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutocompleteController::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutocompleteController_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutocompleteController::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutocompleteControllerStubDispatch::Accept(
    AutocompleteController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutocompleteController>(message->header()->name)) {
    case messages::AutocompleteController::kDestroy: {
      DCHECK(message->is_serialized());
      internal::AutocompleteController_Destroy_Params_Data* params =
          reinterpret_cast<internal::AutocompleteController_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutocompleteController.0
      bool success = true;
      AutocompleteController_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutocompleteController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
    case messages::AutocompleteController::kStart: {
      DCHECK(message->is_serialized());
      internal::AutocompleteController_Start_Params_Data* params =
          reinterpret_cast<internal::AutocompleteController_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutocompleteController.1
      bool success = true;
      ::std::u16string p_input{};
      std::optional<uint32_t> p_cursor_position{};
      ::mojo::PendingAssociatedRemote<AutocompleteClient> p_client{};
      AutocompleteController_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (success) {
        p_cursor_position = input_data_view.cursor_position();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutocompleteController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_input), 
        std::move(p_cursor_position), 
        std::move(p_client));
      return true;
    }
    case messages::AutocompleteController::kStop: {
      DCHECK(message->is_serialized());
      internal::AutocompleteController_Stop_Params_Data* params =
          reinterpret_cast<internal::AutocompleteController_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutocompleteController.2
      bool success = true;
      AutocompleteController_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutocompleteController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
  }
  return false;
}

// static
bool AutocompleteControllerStubDispatch::AcceptWithResponder(
    AutocompleteController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutocompleteController>(message->header()->name)) {
    case messages::AutocompleteController::kDestroy: {
      break;
    }
    case messages::AutocompleteController::kStart: {
      break;
    }
    case messages::AutocompleteController::kStop: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutocompleteControllerValidationInfo[] = {
    { &internal::AutocompleteController_Destroy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutocompleteController_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AutocompleteController_Stop_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutocompleteControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutocompleteController::Name_,
    kAutocompleteControllerValidationInfo);
}

// The declaration includes the definition on other builds.

AutocompleteClient::IPCStableHashFunction AutocompleteClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AutocompleteClient>(message.name())) {
    case messages::AutocompleteClient::kOnResults: {
      return &AutocompleteClient::OnResults_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AutocompleteClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AutocompleteClient>(message.name())) {
      case messages::AutocompleteClient::kOnResults:
            return "Receive owl::mojom::AutocompleteClient::OnResults";
    }
  } else {
    switch (static_cast<messages::AutocompleteClient>(message.name())) {
      case messages::AutocompleteClient::kOnResults:
            return "Receive reply owl::mojom::AutocompleteClient::OnResults";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AutocompleteClient::OnResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5be14820;  // IPCStableHash for owl::mojom::AutocompleteClient::OnResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AutocompleteClientProxy::AutocompleteClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AutocompleteClientProxy::OnResults(
    AutocompleteResultsPtr in_results, bool in_is_done) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::AutocompleteClient::OnResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type AutocompleteResultsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_done"), in_is_done,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AutocompleteClient::kOnResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::AutocompleteClient_OnResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::AutocompleteResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in AutocompleteClient.OnResults request");

  params->is_done = in_is_done;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AutocompleteClient::Name_);
  message.set_method_name("OnResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AutocompleteClientStubDispatch::Accept(
    AutocompleteClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AutocompleteClient>(message->header()->name)) {
    case messages::AutocompleteClient::kOnResults: {
      DCHECK(message->is_serialized());
      internal::AutocompleteClient_OnResults_Params_Data* params =
          reinterpret_cast<internal::AutocompleteClient_OnResults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AutocompleteClient.0
      bool success = true;
      AutocompleteResultsPtr p_results{};
      bool p_is_done{};
      AutocompleteClient_OnResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResults(&p_results))
        success = false;
      if (success)
        p_is_done = input_data_view.is_done();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AutocompleteClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResults(        
        std::move(p_results), 
        std::move(p_is_done));
      return true;
    }
  }
  return false;
}

// static
bool AutocompleteClientStubDispatch::AcceptWithResponder(
    AutocompleteClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AutocompleteClient>(message->header()->name)) {
    case messages::AutocompleteClient::kOnResults: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAutocompleteClientValidationInfo[] = {
    { &internal::AutocompleteClient_OnResults_Params_Data::Validate,
     nullptr /* no response */},
};

bool AutocompleteClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::AutocompleteClient::Name_,
    kAutocompleteClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::AutocompleteMatch::DataView, ::owl::mojom::AutocompleteMatchPtr>::Read(
    ::owl::mojom::AutocompleteMatch::DataView input,
    ::owl::mojom::AutocompleteMatchPtr* output) {
  bool success = true;
  ::owl::mojom::AutocompleteMatchPtr result(::owl::mojom::AutocompleteMatch::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadFillIntoEdit(&result->fill_into_edit))
        success = false;
      if (success && !input.ReadInlineAutocompletion(&result->inline_autocompletion))
        success = false;
      if (success)
        result->score = input.score();
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::AutocompleteResults::DataView, ::owl::mojom::AutocompleteResultsPtr>::Read(
    ::owl::mojom::AutocompleteResults::DataView input,
    ::owl::mojom::AutocompleteResultsPtr* output) {
  bool success = true;
  ::owl::mojom::AutocompleteResultsPtr result(::owl::mojom::AutocompleteResults::New());
  
      if (success && !input.ReadMatches(&result->matches))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void AutocompleteControllerInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
void AutocompleteControllerInterceptorForTesting::Start(const ::std::u16string& input, std::optional<uint32_t> cursor_position, ::mojo::PendingAssociatedRemote<AutocompleteClient> client) {
  GetForwardingInterface()->Start(
    std::move(input)
    , 
    std::move(cursor_position)
    , 
    std::move(client)
    );
}
void AutocompleteControllerInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
AutocompleteControllerAsyncWaiter::AutocompleteControllerAsyncWaiter(
    AutocompleteController* proxy) : proxy_(proxy) {}

AutocompleteControllerAsyncWaiter::~AutocompleteControllerAsyncWaiter() = default;





void AutocompleteClientInterceptorForTesting::OnResults(AutocompleteResultsPtr results, bool is_done) {
  GetForwardingInterface()->OnResults(
    std::move(results)
    , 
    std::move(is_done)
    );
}
AutocompleteClientAsyncWaiter::AutocompleteClientAsyncWaiter(
    AutocompleteClient* proxy) : proxy_(proxy) {}

AutocompleteClientAsyncWaiter::~AutocompleteClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif