// mojo/public/mojom/base/values.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SEND_VALIDATION_H_
#define MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SEND_VALIDATION_H_

#include "mojo/public/mojom/base/values.mojom-shared-internal.h"

#include "mojo/public/mojom/base/values.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::DictionaryValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::DictionaryValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::DictionaryValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::storage(input)) in_storage = Traits::storage(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage)::BaseType>
          storage_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& storage_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ValueDataView>, send_validation>(
        in_storage,
        storage_fragment,
        &storage_validate_params);

      fragment->storage.Set(
          storage_fragment.is_null() ? nullptr : storage_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->storage.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage in DictionaryValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::ListValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::ListValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::ListValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::storage(input)) in_storage = Traits::storage(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage)::BaseType>
          storage_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& storage_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ValueDataView>, send_validation>(
        in_storage,
        storage_fragment,
        &storage_validate_params);

      fragment->storage.Set(
          storage_fragment.is_null() ? nullptr : storage_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->storage.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage in ListValue struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::mojo_base::mojom::ValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::mojo_base::mojom::ValueDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::mojo_base::mojom::internal::Value_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::mojo_base::mojom::ValueDataView::Tag::kNullValue: {
    decltype(Traits::null_value(input))
    in_null_value = Traits::null_value(input);
    fragment->data.f_null_value = in_null_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kBoolValue: {
    decltype(Traits::bool_value(input))
    in_bool_value = Traits::bool_value(input);
    fragment->data.f_bool_value = in_bool_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kIntValue: {
    decltype(Traits::int_value(input))
    in_int_value = Traits::int_value(input);
    fragment->data.f_int_value = in_int_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kDoubleValue: {
    decltype(Traits::double_value(input))
    in_double_value = Traits::double_value(input);
    fragment->data.f_double_value = in_double_value;
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kStringValue: {
    decltype(Traits::string_value(input))
    in_string_value = Traits::string_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_string_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_value in Value union");
    fragment->data.f_string_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kBinaryValue: {
    decltype(Traits::binary_value(input))
    in_binary_value = Traits::binary_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary_value)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& binary_value_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_binary_value,
  value_fragment,
  &binary_value_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary_value in Value union");
    fragment->data.f_binary_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kDictionaryValue: {
    decltype(Traits::dictionary_value(input))
    in_dictionary_value = Traits::dictionary_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dictionary_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView, send_validation>(
  in_dictionary_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dictionary_value in Value union");
    fragment->data.f_dictionary_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::mojo_base::mojom::ValueDataView::Tag::kListValue: {
    decltype(Traits::list_value(input))
    in_list_value = Traits::list_value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_list_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView, send_validation>(
  in_list_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null list_value in Value union");
    fragment->data.f_list_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MOJO_PUBLIC_MOJOM_BASE_VALUES_MOJOM_SEND_VALIDATION_H_