// mojo/public/mojom/base/big_buffer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_H_
#define MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/big_buffer.mojom-features.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/base/big_buffer_mojom_traits.h"
#include "base/component_export.h"




namespace mojo_base::mojom {






class COMPONENT_EXPORT(MOJO_BASE_MOJOM) BigBuffer {
 public:
  using DataView = BigBufferDataView;
  using Data_ = internal::BigBuffer_Data;
  using Tag = Data_::BigBuffer_Tag;

  template <typename... Args>
  static BigBufferPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |bytes|.
  static BigBufferPtr NewBytes(
      std::vector<uint8_t> value);
  // Construct an instance holding |shared_memory|.
  static BigBufferPtr NewSharedMemory(
      BigBufferSharedMemoryRegionPtr value);
  // Construct an instance holding |invalid_buffer|.
  static BigBufferPtr NewInvalidBuffer(
      bool value);

  template <typename U>
  static BigBufferPtr From(const U& u) {
    return mojo::TypeConverter<BigBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BigBuffer>::Convert(*this);
  }
  ~BigBuffer();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  BigBuffer(const BigBuffer& other) = delete;
  BigBuffer& operator=(const BigBuffer& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BigBufferPtr>
  BigBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BigBuffer>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, BigBuffer>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_bytes() const { return tag_ == Tag::kBytes; }
  const std::vector<uint8_t>& get_bytes() const {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  std::vector<uint8_t>& get_bytes() {
    CHECK(tag_ == Tag::kBytes);
    return data_.bytes;
  }
  void set_bytes(std::vector<uint8_t> bytes);

  bool is_shared_memory() const { return tag_ == Tag::kSharedMemory; }
  const BigBufferSharedMemoryRegionPtr& get_shared_memory() const {
    CHECK(tag_ == Tag::kSharedMemory);
    return data_.shared_memory;
  }
  BigBufferSharedMemoryRegionPtr& get_shared_memory() {
    CHECK(tag_ == Tag::kSharedMemory);
    return data_.shared_memory;
  }
  void set_shared_memory(BigBufferSharedMemoryRegionPtr shared_memory);

  bool is_invalid_buffer() const { return tag_ == Tag::kInvalidBuffer; }
  bool get_invalid_buffer() const {
    CHECK(tag_ == Tag::kInvalidBuffer);
    return data_.invalid_buffer;
  }
  void set_invalid_buffer(bool invalid_buffer);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BigBuffer::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<BigBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
        std::vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemory)>,
        BigBufferSharedMemoryRegionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInvalidBuffer)>,
        bool value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<uint8_t> bytes;
    BigBufferSharedMemoryRegionPtr shared_memory;
    bool invalid_buffer;
  };

  BigBuffer(
      std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
      std::vector<uint8_t> value);
  BigBuffer(
      std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemory)>,
      BigBufferSharedMemoryRegionPtr value);
  BigBuffer(
      std::in_place_index_t<static_cast<size_t>(Tag::kInvalidBuffer)>,
      bool value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(MOJO_BASE_MOJOM) BigBufferSharedMemoryRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BigBufferSharedMemoryRegion, T>::value>;
  using DataView = BigBufferSharedMemoryRegionDataView;
  using Data_ = internal::BigBufferSharedMemoryRegion_Data;

  template <typename... Args>
  static BigBufferSharedMemoryRegionPtr New(Args&&... args) {
    return BigBufferSharedMemoryRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BigBufferSharedMemoryRegionPtr From(const U& u) {
    return mojo::TypeConverter<BigBufferSharedMemoryRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BigBufferSharedMemoryRegion>::Convert(*this);
  }


  BigBufferSharedMemoryRegion();

  BigBufferSharedMemoryRegion(
      ::mojo::ScopedSharedBufferHandle buffer_handle,
      uint32_t size);

BigBufferSharedMemoryRegion(const BigBufferSharedMemoryRegion&) = delete;
BigBufferSharedMemoryRegion& operator=(const BigBufferSharedMemoryRegion&) = delete;

  ~BigBufferSharedMemoryRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BigBufferSharedMemoryRegionPtr>
  BigBufferSharedMemoryRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BigBufferSharedMemoryRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BigBufferSharedMemoryRegion_UnserializedMessageContext<
            UserType, BigBufferSharedMemoryRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BigBufferSharedMemoryRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BigBufferSharedMemoryRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BigBufferSharedMemoryRegion_UnserializedMessageContext<
            UserType, BigBufferSharedMemoryRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BigBufferSharedMemoryRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::ScopedSharedBufferHandle buffer_handle;
  
  uint32_t size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
BigBufferPtr BigBuffer::Clone() const {
  switch (tag_) {
    case Tag::kBytes:
      return NewBytes(
          mojo::Clone(data_.bytes));
    case Tag::kSharedMemory:
      return NewSharedMemory(
          mojo::Clone(data_.shared_memory));
    case Tag::kInvalidBuffer:
      return NewInvalidBuffer(
          mojo::Clone(data_.invalid_buffer));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BigBuffer>::value>::type*>
bool BigBuffer::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBytes:
      return mojo::Equals(data_.bytes, other.data_.bytes);
    case Tag::kSharedMemory:
      return mojo::Equals(data_.shared_memory, other.data_.shared_memory);
    case Tag::kInvalidBuffer:
      return mojo::Equals(data_.invalid_buffer, other.data_.invalid_buffer);
  }

  return false;
}
template <typename StructPtrType>
BigBufferSharedMemoryRegionPtr BigBufferSharedMemoryRegion::Clone() const {
  return New(
      mojo::Clone(buffer_handle),
      mojo::Clone(size)
  );
}

template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>*>
bool BigBufferSharedMemoryRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer_handle, other_struct.buffer_handle))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, BigBufferSharedMemoryRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer_handle < rhs.buffer_handle)
    return true;
  if (rhs.buffer_handle < lhs.buffer_handle)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  return false;
}


}  // mojo_base::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) StructTraits<::mojo_base::mojom::BigBufferSharedMemoryRegion::DataView,
                                         ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr> {
  static bool IsNull(const ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::BigBufferSharedMemoryRegionPtr* output) { output->reset(); }

  static  decltype(::mojo_base::mojom::BigBufferSharedMemoryRegion::buffer_handle)& buffer_handle(
       ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr& input) {
    return input->buffer_handle;
  }

  static decltype(::mojo_base::mojom::BigBufferSharedMemoryRegion::size) size(
      const ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr& input) {
    return input->size;
  }

  static bool Read(::mojo_base::mojom::BigBufferSharedMemoryRegion::DataView input, ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_BASE_MOJOM) UnionTraits<::mojo_base::mojom::BigBuffer::DataView,
                                        ::mojo_base::mojom::BigBufferPtr> {
  static bool IsNull(const ::mojo_base::mojom::BigBufferPtr& input) { return !input; }
  static void SetToNull(::mojo_base::mojom::BigBufferPtr* output) { output->reset(); }

  static ::mojo_base::mojom::BigBuffer::Tag GetTag(const ::mojo_base::mojom::BigBufferPtr& input) {
    return input->which();
  }

  static const std::vector<uint8_t>& bytes(const ::mojo_base::mojom::BigBufferPtr& input) {
    return input->get_bytes();
  }

  static  ::mojo_base::mojom::BigBufferSharedMemoryRegionPtr& shared_memory( ::mojo_base::mojom::BigBufferPtr& input) {
    return input->get_shared_memory();
  }

  static  bool invalid_buffer(const ::mojo_base::mojom::BigBufferPtr& input) {
    return input->get_invalid_buffer();
  }

  static bool Read(::mojo_base::mojom::BigBuffer::DataView input, ::mojo_base::mojom::BigBufferPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_H_