// mojo/public/mojom/base/big_buffer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/big_buffer.mojom-params-data.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared-message-ids.h"

#include "mojo/public/mojom/base/big_buffer.mojom-blink-import-headers.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace mojo_base::mojom::blink {
BigBufferSharedMemoryRegion::BigBufferSharedMemoryRegion()
    : buffer_handle(),
      size() {}

BigBufferSharedMemoryRegion::BigBufferSharedMemoryRegion(
    ::mojo::ScopedSharedBufferHandle buffer_handle_in,
    uint32_t size_in)
    : buffer_handle(std::move(buffer_handle_in)),
      size(std::move(size_in)) {}

BigBufferSharedMemoryRegion::~BigBufferSharedMemoryRegion() = default;

void BigBufferSharedMemoryRegion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_handle"), this->buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedSharedBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BigBufferSharedMemoryRegion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BigBufferPtr
BigBuffer::NewBytes(
    ::blink::Vector<uint8_t> value) {
  return BigBufferPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
      std::move(value));
}

BigBufferPtr
BigBuffer::NewSharedMemory(
    BigBufferSharedMemoryRegionPtr value) {
  return BigBufferPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedMemory)>,
      std::move(value));
}

BigBufferPtr
BigBuffer::NewInvalidBuffer(
    bool value) {
  return BigBufferPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kInvalidBuffer)>,
      std::move(value));
}

BigBuffer::BigBuffer(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    ::blink::Vector<uint8_t> value)
    : tag_(Tag::kBytes),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
            std::move(value)) {}

BigBuffer::BigBuffer(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemory)>,
    BigBufferSharedMemoryRegionPtr value)
    : tag_(Tag::kSharedMemory),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedMemory)>,
            std::move(value)) {}

BigBuffer::BigBuffer(
    std::in_place_index_t<static_cast<size_t>(Tag::kInvalidBuffer)>,
    bool value)
    : tag_(Tag::kInvalidBuffer),
      data_(std::in_place_index<static_cast<size_t>(Tag::kInvalidBuffer)>,
            std::move(value)) {}
BigBuffer::~BigBuffer() {
  DestroyActive();
}

void BigBuffer::set_bytes(::blink::Vector<uint8_t> bytes) {
  if (tag_ == Tag::kBytes) {
    data_.bytes = std::move(bytes);
  } else {
    DestroyActive();
    tag_ = Tag::kBytes;
    new (&data_.bytes) ::blink::Vector<uint8_t>(
        std::move(bytes));
  }
}

void BigBuffer::set_shared_memory(BigBufferSharedMemoryRegionPtr shared_memory) {
  if (tag_ == Tag::kSharedMemory) {
    data_.shared_memory = std::move(shared_memory);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedMemory;
    new (&data_.shared_memory) BigBufferSharedMemoryRegionPtr(
        std::move(shared_memory));
  }
}

void BigBuffer::set_invalid_buffer(bool invalid_buffer) {
  if (tag_ != Tag::kInvalidBuffer) {
    DestroyActive();
    tag_ = Tag::kInvalidBuffer;
  }
  data_.invalid_buffer = invalid_buffer;
}


BigBuffer::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    ::blink::Vector<uint8_t> value)
    : bytes(std::move(value)) {}

BigBuffer::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemory)>,
    BigBufferSharedMemoryRegionPtr value)
    : shared_memory(std::move(value)) {}

BigBuffer::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kInvalidBuffer)>,
    bool value)
    : invalid_buffer(std::move(value)) {}

void BigBuffer::DestroyActive() {
  switch (tag_) {

    case Tag::kBytes:
      std::destroy_at(&data_.bytes);
      break;
    case Tag::kSharedMemory:
      std::destroy_at(&data_.shared_memory);
      break;
    case Tag::kInvalidBuffer:
      std::destroy_at(&data_.invalid_buffer);
      break;
  }
}

bool BigBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // mojo_base::mojom::blink


namespace mojo {


// static
bool StructTraits<::mojo_base::mojom::blink::BigBufferSharedMemoryRegion::DataView, ::mojo_base::mojom::blink::BigBufferSharedMemoryRegionPtr>::Read(
    ::mojo_base::mojom::blink::BigBufferSharedMemoryRegion::DataView input,
    ::mojo_base::mojom::blink::BigBufferSharedMemoryRegionPtr* output) {
  bool success = true;
  ::mojo_base::mojom::blink::BigBufferSharedMemoryRegionPtr result(::mojo_base::mojom::blink::BigBufferSharedMemoryRegion::New());
  
      if (success)
        result->buffer_handle = input.TakeBufferHandle();
      if (success)
        result->size = input.size();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::mojo_base::mojom::blink::BigBuffer::DataView, ::mojo_base::mojom::blink::BigBufferPtr>::Read(
    ::mojo_base::mojom::blink::BigBuffer::DataView input,
    ::mojo_base::mojom::blink::BigBufferPtr* output) {
  using UnionType = ::mojo_base::mojom::blink::BigBuffer;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBytes: {
      ::blink::Vector<uint8_t> result_bytes{};
      if (!input.ReadBytes(&result_bytes))
        return false;

      *output = UnionType::NewBytes(
          std::move(result_bytes));
      break;
    }
    case Tag::kSharedMemory: {
      ::mojo_base::mojom::blink::BigBufferSharedMemoryRegionPtr result_shared_memory{};
      if (!input.ReadSharedMemory(&result_shared_memory))
        return false;

      *output = UnionType::NewSharedMemory(
          std::move(result_shared_memory));
      break;
    }
    case Tag::kInvalidBuffer: {
      *output = UnionType::NewInvalidBuffer(input.invalid_buffer());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojo_base::mojom::blink {




}  // mojo_base::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif