// media/mojo/mojom/webrtc_video_perf.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_H_
#define MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/webrtc_video_perf.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/webrtc_video_perf.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/webrtc_video_perf.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {

class WebrtcVideoPerfRecorderProxy;

template <typename ImplRefTraits>
class WebrtcVideoPerfRecorderStub;

class WebrtcVideoPerfRecorderRequestValidator;


class WebrtcVideoPerfRecorder
    : public WebrtcVideoPerfRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.WebrtcVideoPerfRecorder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebrtcVideoPerfRecorderInterfaceBase;
  using Proxy_ = WebrtcVideoPerfRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebrtcVideoPerfRecorderStub<ImplRefTraits>;

  using RequestValidator_ = WebrtcVideoPerfRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateRecordMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateRecord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebrtcVideoPerfRecorder() = default;

  virtual void UpdateRecord(WebrtcPredictionFeaturesPtr features, WebrtcVideoStatsPtr video_stats) = 0;
};

class WebrtcVideoPerfHistoryProxy;

template <typename ImplRefTraits>
class WebrtcVideoPerfHistoryStub;

class WebrtcVideoPerfHistoryRequestValidator;
class WebrtcVideoPerfHistoryResponseValidator;


class WebrtcVideoPerfHistory
    : public WebrtcVideoPerfHistoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.WebrtcVideoPerfHistory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebrtcVideoPerfHistoryInterfaceBase;
  using Proxy_ = WebrtcVideoPerfHistoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebrtcVideoPerfHistoryStub<ImplRefTraits>;

  using RequestValidator_ = WebrtcVideoPerfHistoryRequestValidator;
  using ResponseValidator_ = WebrtcVideoPerfHistoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPerfInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPerfInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebrtcVideoPerfHistory() = default;

  using GetPerfInfoCallback = base::OnceCallback<void(bool)>;
  using GetPerfInfoMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetPerfInfo(WebrtcPredictionFeaturesPtr features, int32_t frames_per_second, GetPerfInfoCallback callback) = 0;
};



class  WebrtcVideoPerfRecorderProxy
    : public WebrtcVideoPerfRecorder {
 public:
  using InterfaceType = WebrtcVideoPerfRecorder;

  explicit WebrtcVideoPerfRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateRecord(WebrtcPredictionFeaturesPtr features, WebrtcVideoStatsPtr video_stats) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebrtcVideoPerfHistoryProxy
    : public WebrtcVideoPerfHistory {
 public:
  using InterfaceType = WebrtcVideoPerfHistory;

  explicit WebrtcVideoPerfHistoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPerfInfo(WebrtcPredictionFeaturesPtr features, int32_t frames_per_second, GetPerfInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebrtcVideoPerfRecorderStubDispatch {
 public:
  static bool Accept(WebrtcVideoPerfRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebrtcVideoPerfRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebrtcVideoPerfRecorder>>
class WebrtcVideoPerfRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebrtcVideoPerfRecorderStub() = default;
  ~WebrtcVideoPerfRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebrtcVideoPerfRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebrtcVideoPerfRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebrtcVideoPerfHistoryStubDispatch {
 public:
  static bool Accept(WebrtcVideoPerfHistory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebrtcVideoPerfHistory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebrtcVideoPerfHistory>>
class WebrtcVideoPerfHistoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebrtcVideoPerfHistoryStub() = default;
  ~WebrtcVideoPerfHistoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebrtcVideoPerfHistoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebrtcVideoPerfHistoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebrtcVideoPerfRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebrtcVideoPerfHistoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebrtcVideoPerfHistoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  WebrtcPredictionFeatures {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebrtcPredictionFeatures, T>::value>;
  using DataView = WebrtcPredictionFeaturesDataView;
  using Data_ = internal::WebrtcPredictionFeatures_Data;

  template <typename... Args>
  static WebrtcPredictionFeaturesPtr New(Args&&... args) {
    return WebrtcPredictionFeaturesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebrtcPredictionFeaturesPtr From(const U& u) {
    return mojo::TypeConverter<WebrtcPredictionFeaturesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebrtcPredictionFeatures>::Convert(*this);
  }


  WebrtcPredictionFeatures();

  WebrtcPredictionFeatures(
      bool is_decode_stats,
      ::media::VideoCodecProfile profile,
      int32_t video_pixels,
      bool hardware_accelerated);


  ~WebrtcPredictionFeatures();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebrtcPredictionFeaturesPtr>
  WebrtcPredictionFeaturesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebrtcPredictionFeatures::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebrtcPredictionFeatures::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebrtcPredictionFeatures::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebrtcPredictionFeatures_UnserializedMessageContext<
            UserType, WebrtcPredictionFeatures::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebrtcPredictionFeatures::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebrtcPredictionFeatures::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebrtcPredictionFeatures_UnserializedMessageContext<
            UserType, WebrtcPredictionFeatures::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebrtcPredictionFeatures::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_decode_stats;
  
  ::media::VideoCodecProfile profile;
  
  int32_t video_pixels;
  
  bool hardware_accelerated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebrtcVideoStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebrtcVideoStats, T>::value>;
  using DataView = WebrtcVideoStatsDataView;
  using Data_ = internal::WebrtcVideoStats_Data;

  template <typename... Args>
  static WebrtcVideoStatsPtr New(Args&&... args) {
    return WebrtcVideoStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebrtcVideoStatsPtr From(const U& u) {
    return mojo::TypeConverter<WebrtcVideoStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebrtcVideoStats>::Convert(*this);
  }


  WebrtcVideoStats();

  WebrtcVideoStats(
      uint32_t frames_processed,
      uint32_t key_frames_processed,
      float p99_processing_time_ms);


  ~WebrtcVideoStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebrtcVideoStatsPtr>
  WebrtcVideoStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebrtcVideoStats::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebrtcVideoStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebrtcVideoStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebrtcVideoStats_UnserializedMessageContext<
            UserType, WebrtcVideoStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebrtcVideoStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebrtcVideoStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebrtcVideoStats_UnserializedMessageContext<
            UserType, WebrtcVideoStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebrtcVideoStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t frames_processed;
  
  uint32_t key_frames_processed;
  
  float p99_processing_time_ms;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebrtcVideoStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
WebrtcPredictionFeaturesPtr WebrtcPredictionFeatures::Clone() const {
  return New(
      mojo::Clone(is_decode_stats),
      mojo::Clone(profile),
      mojo::Clone(video_pixels),
      mojo::Clone(hardware_accelerated)
  );
}

template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>*>
bool WebrtcPredictionFeatures::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_decode_stats, other_struct.is_decode_stats))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->video_pixels, other_struct.video_pixels))
    return false;
  if (!mojo::Equals(this->hardware_accelerated, other_struct.hardware_accelerated))
    return false;
  return true;
}

template <typename T, WebrtcPredictionFeatures::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_decode_stats < rhs.is_decode_stats)
    return true;
  if (rhs.is_decode_stats < lhs.is_decode_stats)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.video_pixels < rhs.video_pixels)
    return true;
  if (rhs.video_pixels < lhs.video_pixels)
    return false;
  if (lhs.hardware_accelerated < rhs.hardware_accelerated)
    return true;
  if (rhs.hardware_accelerated < lhs.hardware_accelerated)
    return false;
  return false;
}
template <typename StructPtrType>
WebrtcVideoStatsPtr WebrtcVideoStats::Clone() const {
  return New(
      mojo::Clone(frames_processed),
      mojo::Clone(key_frames_processed),
      mojo::Clone(p99_processing_time_ms)
  );
}

template <typename T, WebrtcVideoStats::EnableIfSame<T>*>
bool WebrtcVideoStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frames_processed, other_struct.frames_processed))
    return false;
  if (!mojo::Equals(this->key_frames_processed, other_struct.key_frames_processed))
    return false;
  if (!mojo::Equals(this->p99_processing_time_ms, other_struct.p99_processing_time_ms))
    return false;
  return true;
}

template <typename T, WebrtcVideoStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frames_processed < rhs.frames_processed)
    return true;
  if (rhs.frames_processed < lhs.frames_processed)
    return false;
  if (lhs.key_frames_processed < rhs.key_frames_processed)
    return true;
  if (rhs.key_frames_processed < lhs.key_frames_processed)
    return false;
  if (lhs.p99_processing_time_ms < rhs.p99_processing_time_ms)
    return true;
  if (rhs.p99_processing_time_ms < lhs.p99_processing_time_ms)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::WebrtcPredictionFeatures::DataView,
                                         ::media::mojom::WebrtcPredictionFeaturesPtr> {
  static bool IsNull(const ::media::mojom::WebrtcPredictionFeaturesPtr& input) { return !input; }
  static void SetToNull(::media::mojom::WebrtcPredictionFeaturesPtr* output) { output->reset(); }

  static decltype(::media::mojom::WebrtcPredictionFeatures::is_decode_stats) is_decode_stats(
      const ::media::mojom::WebrtcPredictionFeaturesPtr& input) {
    return input->is_decode_stats;
  }

  static decltype(::media::mojom::WebrtcPredictionFeatures::profile) profile(
      const ::media::mojom::WebrtcPredictionFeaturesPtr& input) {
    return input->profile;
  }

  static decltype(::media::mojom::WebrtcPredictionFeatures::video_pixels) video_pixels(
      const ::media::mojom::WebrtcPredictionFeaturesPtr& input) {
    return input->video_pixels;
  }

  static decltype(::media::mojom::WebrtcPredictionFeatures::hardware_accelerated) hardware_accelerated(
      const ::media::mojom::WebrtcPredictionFeaturesPtr& input) {
    return input->hardware_accelerated;
  }

  static bool Read(::media::mojom::WebrtcPredictionFeatures::DataView input, ::media::mojom::WebrtcPredictionFeaturesPtr* output);
};


template <>
struct  StructTraits<::media::mojom::WebrtcVideoStats::DataView,
                                         ::media::mojom::WebrtcVideoStatsPtr> {
  static bool IsNull(const ::media::mojom::WebrtcVideoStatsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::WebrtcVideoStatsPtr* output) { output->reset(); }

  static decltype(::media::mojom::WebrtcVideoStats::frames_processed) frames_processed(
      const ::media::mojom::WebrtcVideoStatsPtr& input) {
    return input->frames_processed;
  }

  static decltype(::media::mojom::WebrtcVideoStats::key_frames_processed) key_frames_processed(
      const ::media::mojom::WebrtcVideoStatsPtr& input) {
    return input->key_frames_processed;
  }

  static decltype(::media::mojom::WebrtcVideoStats::p99_processing_time_ms) p99_processing_time_ms(
      const ::media::mojom::WebrtcVideoStatsPtr& input) {
    return input->p99_processing_time_ms;
  }

  static bool Read(::media::mojom::WebrtcVideoStats::DataView input, ::media::mojom::WebrtcVideoStatsPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_WEBRTC_VIDEO_PERF_MOJOM_H_