// media/mojo/mojom/watch_time_recorder.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/watch_time_recorder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PlaybackPropertiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PlaybackPropertiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PlaybackProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_audio = Traits::has_audio(input);

      fragment->has_video = Traits::has_video(input);

      fragment->is_background = Traits::is_background(input);

      fragment->is_muted = Traits::is_muted(input);

      fragment->is_eme = Traits::is_eme(input);

      fragment->is_embedded_media_experience = Traits::is_embedded_media_experience(input);

      
      mojo::internal::Serialize<::media::mojom::MediaStreamType>(
        Traits::media_stream_type(input),
        &fragment->media_stream_type);

      
      mojo::internal::Serialize<::media::mojom::RendererType>(
        Traits::renderer_type(input),
        &fragment->renderer_type);

      
      mojo::internal::Serialize<::media::mojom::DemuxerType>(
        Traits::demuxer_type(input),
        &fragment->demuxer_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SecondaryPlaybackPropertiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SecondaryPlaybackPropertiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SecondaryPlaybackProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::AudioCodec>(
        Traits::audio_codec(input),
        &fragment->audio_codec);

      
      mojo::internal::Serialize<::media::mojom::VideoCodec>(
        Traits::video_codec(input),
        &fragment->video_codec);

      
      mojo::internal::Serialize<::media::mojom::AudioCodecProfile>(
        Traits::audio_codec_profile(input),
        &fragment->audio_codec_profile);

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::video_codec_profile(input),
        &fragment->video_codec_profile);

      
      mojo::internal::Serialize<::media::mojom::AudioDecoderType>(
        Traits::audio_decoder(input),
        &fragment->audio_decoder);

      
      mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
        Traits::video_decoder(input),
        &fragment->video_decoder);

      
      mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
        Traits::audio_encryption_scheme(input),
        &fragment->audio_encryption_scheme);

      
      mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
        Traits::video_encryption_scheme(input),
        &fragment->video_encryption_scheme);

      decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_natural_size,
        natural_size_fragment);

      fragment->natural_size.Set(
          natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->natural_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null natural_size in SecondaryPlaybackProperties struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_SEND_VALIDATION_H_