// media/mojo/mojom/watch_time_recorder.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioCodec');
goog.require('media.mojom.AudioCodecProfile');
goog.require('media.mojom.AudioDecoderType');
goog.require('media.mojom.DemuxerType');
goog.require('media.mojom.EncryptionScheme');
goog.require('media.mojom.MediaStreamType');
goog.require('media.mojom.RendererType');
goog.require('media.mojom.VideoCodec');
goog.require('media.mojom.VideoCodecProfile');
goog.require('media.mojom.VideoDecoderType');
goog.require('media.mojom.WatchTimeKey');
goog.require('media.mojom.PipelineStatus');
goog.require('gfx.mojom.Size');
goog.require('mojoBase.mojom.TimeDelta');






goog.provide('media.mojom.WatchTimeRecorder');
goog.provide('media.mojom.WatchTimeRecorderReceiver');
goog.provide('media.mojom.WatchTimeRecorderCallbackRouter');
goog.provide('media.mojom.WatchTimeRecorderInterface');
goog.provide('media.mojom.WatchTimeRecorderRemote');
goog.provide('media.mojom.WatchTimeRecorderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.WatchTimeRecorderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.WatchTimeRecorder.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.WatchTimeRecorderInterface = class {
  
  /**
   * @param { !media.mojom.WatchTimeKey } key
   * @param { !mojoBase.mojom.TimeDelta } watchTime
   */

  recordWatchTime(key, watchTime) {}
  
  /**
   * @param { !Array<!media.mojom.WatchTimeKey> } watchTimeKeys
   */

  finalizeWatchTime(watchTimeKeys) {}
  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(status) {}
  
  /**
   * @param { !media.mojom.SecondaryPlaybackProperties } secondaryProperties
   */

  updateSecondaryProperties(secondaryProperties) {}
  
  /**
   * @param { !boolean } value
   */

  setAutoplayInitiated(value) {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } duration
   */

  onDurationChanged(duration) {}
  
  /**
   * @param { !number } framesDecoded
   * @param { !number } framesDropped
   */

  updateVideoDecodeStats(framesDecoded, framesDropped) {}
  
  /**
   * @param { !number } totalCount
   */

  updateUnderflowCount(totalCount) {}
  
  /**
   * @param { !number } totalCompletedCount
   * @param { !mojoBase.mojom.TimeDelta } totalDuration
   */

  updateUnderflowDuration(totalCompletedCount, totalDuration) {}
};

/**
 * @export
 * @implements { media.mojom.WatchTimeRecorderInterface }
 */
media.mojom.WatchTimeRecorderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.WatchTimeRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.WatchTimeRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.WatchTimeRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.WatchTimeKey } key
   * @param { !mojoBase.mojom.TimeDelta } watchTime
   */

  recordWatchTime(
      key,
      watchTime) {
    this.proxy.sendMessage(
        0,
        media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        [
          key,
          watchTime
        ],
        false);
  }

  
  /**
   * @param { !Array<!media.mojom.WatchTimeKey> } watchTimeKeys
   */

  finalizeWatchTime(
      watchTimeKeys) {
    this.proxy.sendMessage(
        1,
        media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        [
          watchTimeKeys
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        2,
        media.mojom.WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.SecondaryPlaybackProperties } secondaryProperties
   */

  updateSecondaryProperties(
      secondaryProperties) {
    this.proxy.sendMessage(
        3,
        media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        [
          secondaryProperties
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setAutoplayInitiated(
      value) {
    this.proxy.sendMessage(
        4,
        media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } duration
   */

  onDurationChanged(
      duration) {
    this.proxy.sendMessage(
        5,
        media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        [
          duration
        ],
        false);
  }

  
  /**
   * @param { !number } framesDecoded
   * @param { !number } framesDropped
   */

  updateVideoDecodeStats(
      framesDecoded,
      framesDropped) {
    this.proxy.sendMessage(
        6,
        media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        [
          framesDecoded,
          framesDropped
        ],
        false);
  }

  
  /**
   * @param { !number } totalCount
   */

  updateUnderflowCount(
      totalCount) {
    this.proxy.sendMessage(
        7,
        media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        [
          totalCount
        ],
        false);
  }

  
  /**
   * @param { !number } totalCompletedCount
   * @param { !mojoBase.mojom.TimeDelta } totalDuration
   */

  updateUnderflowDuration(
      totalCompletedCount,
      totalDuration) {
    this.proxy.sendMessage(
        8,
        media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        [
          totalCompletedCount,
          totalDuration
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WatchTimeRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.WatchTimeRecorderReceiver = class {
  /**
   * @param {!media.mojom.WatchTimeRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.WatchTimeRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.WatchTimeRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.WatchTimeRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        impl.recordWatchTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        impl.finalizeWatchTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        impl.updateSecondaryProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        impl.setAutoplayInitiated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        impl.onDurationChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        impl.updateVideoDecodeStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        impl.updateUnderflowCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        impl.updateUnderflowDuration.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.WatchTimeRecorder = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.WatchTimeRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.WatchTimeRecorderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.WatchTimeRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WatchTimeRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.WatchTimeRecorderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.WatchTimeRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.WatchTimeRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordWatchTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
        null,
        this.recordWatchTime.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finalizeWatchTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
        null,
        this.finalizeWatchTime.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.WatchTimeRecorder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSecondaryProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
        null,
        this.updateSecondaryProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAutoplayInitiated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
        null,
        this.setAutoplayInitiated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDurationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
        null,
        this.onDurationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVideoDecodeStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
        null,
        this.updateVideoDecodeStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUnderflowCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
        null,
        this.updateUnderflowCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUnderflowDuration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
        null,
        this.updateUnderflowDuration.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.PlaybackPropertiesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.PlaybackPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.SecondaryPlaybackPropertiesSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.SecondaryPlaybackPropertiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.PlaybackPropertiesSpec.$,
    'PlaybackProperties',
    [
      mojo.internal.StructField(
        'hasAudio', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasVideo', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBackground', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMuted', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isEme', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isEmbeddedMediaExperience', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaStreamType', 4,
        0,
        media.mojom.MediaStreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rendererType', 8,
        0,
        media.mojom.RendererTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'demuxerType', 12,
        0,
        media.mojom.DemuxerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.PlaybackProperties');

/** @record */
media.mojom.PlaybackProperties = class {
  constructor() {
    /** @export { !boolean } */
    this.hasAudio;
    /** @export { !boolean } */
    this.hasVideo;
    /** @export { !boolean } */
    this.isBackground;
    /** @export { !boolean } */
    this.isMuted;
    /** @export { !boolean } */
    this.isEme;
    /** @export { !boolean } */
    this.isEmbeddedMediaExperience;
    /** @export { !media.mojom.MediaStreamType } */
    this.mediaStreamType;
    /** @export { !media.mojom.RendererType } */
    this.rendererType;
    /** @export { !media.mojom.DemuxerType } */
    this.demuxerType;
  }
};



mojo.internal.Struct(
    media.mojom.SecondaryPlaybackPropertiesSpec.$,
    'SecondaryPlaybackProperties',
    [
      mojo.internal.StructField(
        'audioCodec', 0,
        0,
        media.mojom.AudioCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoCodec', 4,
        0,
        media.mojom.VideoCodecSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioCodecProfile', 8,
        0,
        media.mojom.AudioCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoCodecProfile', 12,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioDecoder', 16,
        0,
        media.mojom.AudioDecoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoDecoder', 20,
        0,
        media.mojom.VideoDecoderTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioEncryptionScheme', 24,
        0,
        media.mojom.EncryptionSchemeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoEncryptionScheme', 28,
        0,
        media.mojom.EncryptionSchemeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'naturalSize', 32,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('media.mojom.SecondaryPlaybackProperties');

/** @record */
media.mojom.SecondaryPlaybackProperties = class {
  constructor() {
    /** @export { !media.mojom.AudioCodec } */
    this.audioCodec;
    /** @export { !media.mojom.VideoCodec } */
    this.videoCodec;
    /** @export { !media.mojom.AudioCodecProfile } */
    this.audioCodecProfile;
    /** @export { !media.mojom.VideoCodecProfile } */
    this.videoCodecProfile;
    /** @export { !media.mojom.AudioDecoderType } */
    this.audioDecoder;
    /** @export { !media.mojom.VideoDecoderType } */
    this.videoDecoder;
    /** @export { !media.mojom.EncryptionScheme } */
    this.audioEncryptionScheme;
    /** @export { !media.mojom.EncryptionScheme } */
    this.videoEncryptionScheme;
    /** @export { !gfx.mojom.Size } */
    this.naturalSize;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_RecordWatchTime_ParamsSpec.$,
    'WatchTimeRecorder_RecordWatchTime_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        media.mojom.WatchTimeKeySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'watchTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.WatchTimeRecorder_RecordWatchTime_Params');

/** @record */
media.mojom.WatchTimeRecorder_RecordWatchTime_Params = class {
  constructor() {
    /** @export { !media.mojom.WatchTimeKey } */
    this.key;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.watchTime;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_FinalizeWatchTime_ParamsSpec.$,
    'WatchTimeRecorder_FinalizeWatchTime_Params',
    [
      mojo.internal.StructField(
        'watchTimeKeys', 0,
        0,
        mojo.internal.Array(media.mojom.WatchTimeKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_FinalizeWatchTime_Params');

/** @record */
media.mojom.WatchTimeRecorder_FinalizeWatchTime_Params = class {
  constructor() {
    /** @export { !Array<!media.mojom.WatchTimeKey> } */
    this.watchTimeKeys;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_OnError_ParamsSpec.$,
    'WatchTimeRecorder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_OnError_Params');

/** @record */
media.mojom.WatchTimeRecorder_OnError_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_ParamsSpec.$,
    'WatchTimeRecorder_UpdateSecondaryProperties_Params',
    [
      mojo.internal.StructField(
        'secondaryProperties', 0,
        0,
        media.mojom.SecondaryPlaybackPropertiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_Params');

/** @record */
media.mojom.WatchTimeRecorder_UpdateSecondaryProperties_Params = class {
  constructor() {
    /** @export { !media.mojom.SecondaryPlaybackProperties } */
    this.secondaryProperties;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_SetAutoplayInitiated_ParamsSpec.$,
    'WatchTimeRecorder_SetAutoplayInitiated_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_SetAutoplayInitiated_Params');

/** @record */
media.mojom.WatchTimeRecorder_SetAutoplayInitiated_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_OnDurationChanged_ParamsSpec.$,
    'WatchTimeRecorder_OnDurationChanged_Params',
    [
      mojo.internal.StructField(
        'duration', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_OnDurationChanged_Params');

/** @record */
media.mojom.WatchTimeRecorder_OnDurationChanged_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.duration;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_ParamsSpec.$,
    'WatchTimeRecorder_UpdateVideoDecodeStats_Params',
    [
      mojo.internal.StructField(
        'framesDecoded', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'framesDropped', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_Params');

/** @record */
media.mojom.WatchTimeRecorder_UpdateVideoDecodeStats_Params = class {
  constructor() {
    /** @export { !number } */
    this.framesDecoded;
    /** @export { !number } */
    this.framesDropped;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_UpdateUnderflowCount_ParamsSpec.$,
    'WatchTimeRecorder_UpdateUnderflowCount_Params',
    [
      mojo.internal.StructField(
        'totalCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.WatchTimeRecorder_UpdateUnderflowCount_Params');

/** @record */
media.mojom.WatchTimeRecorder_UpdateUnderflowCount_Params = class {
  constructor() {
    /** @export { !number } */
    this.totalCount;
  }
};



mojo.internal.Struct(
    media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_ParamsSpec.$,
    'WatchTimeRecorder_UpdateUnderflowDuration_Params',
    [
      mojo.internal.StructField(
        'totalCompletedCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'totalDuration', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_Params');

/** @record */
media.mojom.WatchTimeRecorder_UpdateUnderflowDuration_Params = class {
  constructor() {
    /** @export { !number } */
    this.totalCompletedCount;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.totalDuration;
  }
};

