// media/mojo/mojom/video_encoder_metrics_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  SVCScalabilityMode as media_mojom_SVCScalabilityMode,
  SVCScalabilityModeSpec as media_mojom_SVCScalabilityModeSpec,
  VideoCodecProfile as media_mojom_VideoCodecProfile,
  VideoCodecProfileSpec as media_mojom_VideoCodecProfileSpec,
  EncoderStatus as media_mojom_EncoderStatus,
  EncoderStatusSpec as media_mojom_EncoderStatusSpec
} from './media_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoEncoderUseCaseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoEncoderUseCase = {
  
  kCastMirroring: 0,
  kMediaRecorder: 1,
  kWebCodecs: 2,
  kWebRTC: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoEncoderMetricsProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoEncoderMetricsProvider', scope);
  }
}

/** @interface */
export class VideoEncoderMetricsProviderInterface {
  
  /**
   * @param { !bigint } encoderId
   * @param { !VideoEncoderUseCase } encoderUseCase
   * @param { !media_mojom_VideoCodecProfile } profile
   * @param { !gfx_mojom_Size } encodeSize
   * @param { !boolean } isHardwareEncoder
   * @param { !media_mojom_SVCScalabilityMode } svcMode
   */

  initialize(encoderId, encoderUseCase, profile, encodeSize, isHardwareEncoder, svcMode) {}
  
  /**
   * @param { !bigint } encoderId
   * @param { !bigint } numEncodedFrames
   */

  setEncodedFrameCount(encoderId, numEncodedFrames) {}
  
  /**
   * @param { !bigint } encoderId
   * @param { !media_mojom_EncoderStatus } status
   */

  setError(encoderId, status) {}
  
  /**
   * @param { !bigint } encoderId
   */

  complete(encoderId) {}
}

/**
 * @implements { VideoEncoderMetricsProviderInterface }
 */
export class VideoEncoderMetricsProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoEncoderMetricsProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoEncoderMetricsProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoEncoderMetricsProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !VideoEncoderUseCase } encoderUseCase
   * @param { !media_mojom_VideoCodecProfile } profile
   * @param { !gfx_mojom_Size } encodeSize
   * @param { !boolean } isHardwareEncoder
   * @param { !media_mojom_SVCScalabilityMode } svcMode
   */

  initialize(
      encoderId,
      encoderUseCase,
      profile,
      encodeSize,
      isHardwareEncoder,
      svcMode) {
    this.proxy.sendMessage(
        0,
        VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        [
          encoderId,
          encoderUseCase,
          profile,
          encodeSize,
          isHardwareEncoder,
          svcMode
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !bigint } numEncodedFrames
   */

  setEncodedFrameCount(
      encoderId,
      numEncodedFrames) {
    this.proxy.sendMessage(
        1,
        VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        [
          encoderId,
          numEncodedFrames
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !media_mojom_EncoderStatus } status
   */

  setError(
      encoderId,
      status) {
    this.proxy.sendMessage(
        2,
        VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        [
          encoderId,
          status
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   */

  complete(
      encoderId) {
    this.proxy.sendMessage(
        3,
        VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        [
          encoderId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoEncoderMetricsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoEncoderMetricsProviderReceiver {
  /**
   * @param {!VideoEncoderMetricsProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoEncoderMetricsProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoEncoderMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncoderMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        impl.setEncodedFrameCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        impl.setError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoEncoderMetricsProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncoderMetricsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoEncoderMetricsProviderRemote}
   */
  static getRemote() {
    let remote = new VideoEncoderMetricsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoEncoderMetricsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoEncoderMetricsProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoEncoderMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoEncoderMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEncodedFrameCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        this.setEncodedFrameCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        this.setError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncoderMetricsProvider_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncoderMetricsProvider_SetError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoEncoderMetricsProvider_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
    'VideoEncoderMetricsProvider_Initialize_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encoderUseCase', 8,
        0,
        VideoEncoderUseCaseSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'profile', 12,
        0,
        media_mojom_VideoCodecProfileSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encodeSize', 16,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isHardwareEncoder', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'svcMode', 28,
        0,
        media_mojom_SVCScalabilityModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class VideoEncoderMetricsProvider_Initialize_Params {
  constructor() {
    /** @type { !bigint } */
    this.encoderId;
    /** @type { !VideoEncoderUseCase } */
    this.encoderUseCase;
    /** @type { !media_mojom_VideoCodecProfile } */
    this.profile;
    /** @type { !gfx_mojom_Size } */
    this.encodeSize;
    /** @type { !boolean } */
    this.isHardwareEncoder;
    /** @type { !media_mojom_SVCScalabilityMode } */
    this.svcMode;
  }
}



mojo.internal.Struct(
    VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
    'VideoEncoderMetricsProvider_SetEncodedFrameCount_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numEncodedFrames', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncoderMetricsProvider_SetEncodedFrameCount_Params {
  constructor() {
    /** @type { !bigint } */
    this.encoderId;
    /** @type { !bigint } */
    this.numEncodedFrames;
  }
}



mojo.internal.Struct(
    VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
    'VideoEncoderMetricsProvider_SetError_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        media_mojom_EncoderStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoEncoderMetricsProvider_SetError_Params {
  constructor() {
    /** @type { !bigint } */
    this.encoderId;
    /** @type { !media_mojom_EncoderStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
    'VideoEncoderMetricsProvider_Complete_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoEncoderMetricsProvider_Complete_Params {
  constructor() {
    /** @type { !bigint } */
    this.encoderId;
  }
}

