// media/mojo/mojom/video_encoder_metrics_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-params-data.h"
#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-blink-import-headers.h"
#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

VideoEncoderMetricsProvider::IPCStableHashFunction VideoEncoderMetricsProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEncoderMetricsProvider>(message.name())) {
    case messages::VideoEncoderMetricsProvider::kInitialize: {
      return &VideoEncoderMetricsProvider::Initialize_Sym::IPCStableHash;
    }
    case messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount: {
      return &VideoEncoderMetricsProvider::SetEncodedFrameCount_Sym::IPCStableHash;
    }
    case messages::VideoEncoderMetricsProvider::kSetError: {
      return &VideoEncoderMetricsProvider::SetError_Sym::IPCStableHash;
    }
    case messages::VideoEncoderMetricsProvider::kComplete: {
      return &VideoEncoderMetricsProvider::Complete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEncoderMetricsProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEncoderMetricsProvider>(message.name())) {
      case messages::VideoEncoderMetricsProvider::kInitialize:
            return "Receive media::mojom::VideoEncoderMetricsProvider::Initialize";
      case messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount:
            return "Receive media::mojom::VideoEncoderMetricsProvider::SetEncodedFrameCount";
      case messages::VideoEncoderMetricsProvider::kSetError:
            return "Receive media::mojom::VideoEncoderMetricsProvider::SetError";
      case messages::VideoEncoderMetricsProvider::kComplete:
            return "Receive media::mojom::VideoEncoderMetricsProvider::Complete";
    }
  } else {
    switch (static_cast<messages::VideoEncoderMetricsProvider>(message.name())) {
      case messages::VideoEncoderMetricsProvider::kInitialize:
            return "Receive reply media::mojom::VideoEncoderMetricsProvider::Initialize";
      case messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount:
            return "Receive reply media::mojom::VideoEncoderMetricsProvider::SetEncodedFrameCount";
      case messages::VideoEncoderMetricsProvider::kSetError:
            return "Receive reply media::mojom::VideoEncoderMetricsProvider::SetError";
      case messages::VideoEncoderMetricsProvider::kComplete:
            return "Receive reply media::mojom::VideoEncoderMetricsProvider::Complete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEncoderMetricsProvider::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c0b7af0;  // IPCStableHash for media::mojom::VideoEncoderMetricsProvider::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncoderMetricsProvider::SetEncodedFrameCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ae72f4b;  // IPCStableHash for media::mojom::VideoEncoderMetricsProvider::SetEncodedFrameCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncoderMetricsProvider::SetError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91901288;  // IPCStableHash for media::mojom::VideoEncoderMetricsProvider::SetError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncoderMetricsProvider::Complete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2dc03d4c;  // IPCStableHash for media::mojom::VideoEncoderMetricsProvider::Complete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoEncoderMetricsProviderProxy::VideoEncoderMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEncoderMetricsProviderProxy::Initialize(
    uint64_t in_encoder_id, VideoEncoderUseCase in_encoder_use_case, ::media::VideoCodecProfile in_profile, const ::gfx::Size& in_encode_size, bool in_is_hardware_encoder, ::media::mojom::blink::SVCScalabilityMode in_svc_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncoderMetricsProvider::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoder_id"), in_encoder_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoder_use_case"), in_encoder_use_case,
                        "<value of type VideoEncoderUseCase>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile"), in_profile,
                        "<value of type ::media::VideoCodecProfile>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encode_size"), in_encode_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hardware_encoder"), in_is_hardware_encoder,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("svc_mode"), in_svc_mode,
                        "<value of type ::media::mojom::blink::SVCScalabilityMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncoderMetricsProvider::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncoderMetricsProvider_Initialize_Params_Data> params(
          message);
  params.Allocate();

  params->encoder_id = in_encoder_id;

  
  mojo::internal::Serialize<::media::mojom::VideoEncoderUseCase>(
    in_encoder_use_case,
    &params->encoder_use_case);

  
  mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
    in_profile,
    &params->profile);
  mojo::internal::MessageFragment<
      typename decltype(params->encode_size)::BaseType> encode_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_encode_size,
    encode_size_fragment);

  params->encode_size.Set(
      encode_size_fragment.is_null() ? nullptr : encode_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->encode_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null encode_size in VideoEncoderMetricsProvider.Initialize request");

  params->is_hardware_encoder = in_is_hardware_encoder;

  
  mojo::internal::Serialize<::media::mojom::SVCScalabilityMode>(
    in_svc_mode,
    &params->svc_mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncoderMetricsProvider::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncoderMetricsProviderProxy::SetEncodedFrameCount(
    uint64_t in_encoder_id, uint64_t in_num_encoded_frames) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncoderMetricsProvider::SetEncodedFrameCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoder_id"), in_encoder_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_encoded_frames"), in_num_encoded_frames,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data> params(
          message);
  params.Allocate();

  params->encoder_id = in_encoder_id;

  params->num_encoded_frames = in_num_encoded_frames;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncoderMetricsProvider::Name_);
  message.set_method_name("SetEncodedFrameCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncoderMetricsProviderProxy::SetError(
    uint64_t in_encoder_id, ::media::mojom::blink::EncoderStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncoderMetricsProvider::SetError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoder_id"), in_encoder_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::EncoderStatusPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncoderMetricsProvider::kSetError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncoderMetricsProvider_SetError_Params_Data> params(
          message);
  params.Allocate();

  params->encoder_id = in_encoder_id;
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in VideoEncoderMetricsProvider.SetError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncoderMetricsProvider::Name_);
  message.set_method_name("SetError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncoderMetricsProviderProxy::Complete(
    uint64_t in_encoder_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncoderMetricsProvider::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encoder_id"), in_encoder_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncoderMetricsProvider::kComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncoderMetricsProvider_Complete_Params_Data> params(
          message);
  params.Allocate();

  params->encoder_id = in_encoder_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncoderMetricsProvider::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoEncoderMetricsProviderStubDispatch::Accept(
    VideoEncoderMetricsProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEncoderMetricsProvider>(message->header()->name)) {
    case messages::VideoEncoderMetricsProvider::kInitialize: {
      DCHECK(message->is_serialized());
      internal::VideoEncoderMetricsProvider_Initialize_Params_Data* params =
          reinterpret_cast<internal::VideoEncoderMetricsProvider_Initialize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncoderMetricsProvider.0
      bool success = true;
      uint64_t p_encoder_id{};
      VideoEncoderUseCase p_encoder_use_case{};
      ::media::VideoCodecProfile p_profile{};
      ::gfx::Size p_encode_size{};
      bool p_is_hardware_encoder{};
      ::media::mojom::blink::SVCScalabilityMode p_svc_mode{};
      VideoEncoderMetricsProvider_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_encoder_id = input_data_view.encoder_id();
      if (success && !input_data_view.ReadEncoderUseCase(&p_encoder_use_case))
        success = false;
      if (success && !input_data_view.ReadProfile(&p_profile))
        success = false;
      if (success && !input_data_view.ReadEncodeSize(&p_encode_size))
        success = false;
      if (success)
        p_is_hardware_encoder = input_data_view.is_hardware_encoder();
      if (success && !input_data_view.ReadSvcMode(&p_svc_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncoderMetricsProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_encoder_id), 
        std::move(p_encoder_use_case), 
        std::move(p_profile), 
        std::move(p_encode_size), 
        std::move(p_is_hardware_encoder), 
        std::move(p_svc_mode));
      return true;
    }
    case messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount: {
      DCHECK(message->is_serialized());
      internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data* params =
          reinterpret_cast<internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncoderMetricsProvider.1
      bool success = true;
      uint64_t p_encoder_id{};
      uint64_t p_num_encoded_frames{};
      VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_encoder_id = input_data_view.encoder_id();
      if (success)
        p_num_encoded_frames = input_data_view.num_encoded_frames();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncoderMetricsProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEncodedFrameCount(        
        std::move(p_encoder_id), 
        std::move(p_num_encoded_frames));
      return true;
    }
    case messages::VideoEncoderMetricsProvider::kSetError: {
      DCHECK(message->is_serialized());
      internal::VideoEncoderMetricsProvider_SetError_Params_Data* params =
          reinterpret_cast<internal::VideoEncoderMetricsProvider_SetError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncoderMetricsProvider.2
      bool success = true;
      uint64_t p_encoder_id{};
      ::media::mojom::blink::EncoderStatusPtr p_status{};
      VideoEncoderMetricsProvider_SetError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_encoder_id = input_data_view.encoder_id();
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncoderMetricsProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetError(        
        std::move(p_encoder_id), 
        std::move(p_status));
      return true;
    }
    case messages::VideoEncoderMetricsProvider::kComplete: {
      DCHECK(message->is_serialized());
      internal::VideoEncoderMetricsProvider_Complete_Params_Data* params =
          reinterpret_cast<internal::VideoEncoderMetricsProvider_Complete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncoderMetricsProvider.3
      bool success = true;
      uint64_t p_encoder_id{};
      VideoEncoderMetricsProvider_Complete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_encoder_id = input_data_view.encoder_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncoderMetricsProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(        
        std::move(p_encoder_id));
      return true;
    }
  }
  return false;
}

// static
bool VideoEncoderMetricsProviderStubDispatch::AcceptWithResponder(
    VideoEncoderMetricsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEncoderMetricsProvider>(message->header()->name)) {
    case messages::VideoEncoderMetricsProvider::kInitialize: {
      break;
    }
    case messages::VideoEncoderMetricsProvider::kSetEncodedFrameCount: {
      break;
    }
    case messages::VideoEncoderMetricsProvider::kSetError: {
      break;
    }
    case messages::VideoEncoderMetricsProvider::kComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoEncoderMetricsProviderValidationInfo[] = {
    { &internal::VideoEncoderMetricsProvider_Initialize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncoderMetricsProvider_SetError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncoderMetricsProvider_Complete_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoEncoderMetricsProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::VideoEncoderMetricsProvider::Name_,
    kVideoEncoderMetricsProviderValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void VideoEncoderMetricsProviderInterceptorForTesting::Initialize(uint64_t encoder_id, VideoEncoderUseCase encoder_use_case, ::media::VideoCodecProfile profile, const ::gfx::Size& encode_size, bool is_hardware_encoder, ::media::mojom::blink::SVCScalabilityMode svc_mode) {
  GetForwardingInterface()->Initialize(
    std::move(encoder_id)
    , 
    std::move(encoder_use_case)
    , 
    std::move(profile)
    , 
    std::move(encode_size)
    , 
    std::move(is_hardware_encoder)
    , 
    std::move(svc_mode)
    );
}
void VideoEncoderMetricsProviderInterceptorForTesting::SetEncodedFrameCount(uint64_t encoder_id, uint64_t num_encoded_frames) {
  GetForwardingInterface()->SetEncodedFrameCount(
    std::move(encoder_id)
    , 
    std::move(num_encoded_frames)
    );
}
void VideoEncoderMetricsProviderInterceptorForTesting::SetError(uint64_t encoder_id, ::media::mojom::blink::EncoderStatusPtr status) {
  GetForwardingInterface()->SetError(
    std::move(encoder_id)
    , 
    std::move(status)
    );
}
void VideoEncoderMetricsProviderInterceptorForTesting::Complete(uint64_t encoder_id) {
  GetForwardingInterface()->Complete(
    std::move(encoder_id)
    );
}
VideoEncoderMetricsProviderAsyncWaiter::VideoEncoderMetricsProviderAsyncWaiter(
    VideoEncoderMetricsProvider* proxy) : proxy_(proxy) {}

VideoEncoderMetricsProviderAsyncWaiter::~VideoEncoderMetricsProviderAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif