// media/mojo/mojom/video_encode_accelerator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encode_accelerator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-params-data.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-import-headers.h"
#include "media/mojo/mojom/video_encode_accelerator.mojom-test-utils.h"


namespace media::mojom {
VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile()
    : profile(),
      min_resolution(),
      max_resolution(),
      max_framerate_numerator(),
      max_framerate_denominator(),
      rate_control_modes(),
      scalability_modes(),
      is_software_codec(),
      gpu_supported_pixel_formats(),
      supports_gpu_shared_images() {}

VideoEncodeAcceleratorSupportedProfile::VideoEncodeAcceleratorSupportedProfile(
    ::media::VideoCodecProfile profile_in,
    const ::gfx::Size& min_resolution_in,
    const ::gfx::Size& max_resolution_in,
    uint32_t max_framerate_numerator_in,
    uint32_t max_framerate_denominator_in,
    std::vector<VideoEncodeAcceleratorSupportedRateControlMode> rate_control_modes_in,
    std::vector<::media::SVCScalabilityMode> scalability_modes_in,
    bool is_software_codec_in,
    std::vector<::media::VideoPixelFormat> gpu_supported_pixel_formats_in,
    bool supports_gpu_shared_images_in)
    : profile(std::move(profile_in)),
      min_resolution(std::move(min_resolution_in)),
      max_resolution(std::move(max_resolution_in)),
      max_framerate_numerator(std::move(max_framerate_numerator_in)),
      max_framerate_denominator(std::move(max_framerate_denominator_in)),
      rate_control_modes(std::move(rate_control_modes_in)),
      scalability_modes(std::move(scalability_modes_in)),
      is_software_codec(std::move(is_software_codec_in)),
      gpu_supported_pixel_formats(std::move(gpu_supported_pixel_formats_in)),
      supports_gpu_shared_images(std::move(supports_gpu_shared_images_in)) {}

VideoEncodeAcceleratorSupportedProfile::~VideoEncodeAcceleratorSupportedProfile() = default;

void VideoEncodeAcceleratorSupportedProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_resolution"), this->min_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_resolution"), this->max_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_numerator"), this->max_framerate_numerator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_denominator"), this->max_framerate_denominator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rate_control_modes"), this->rate_control_modes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<VideoEncodeAcceleratorSupportedRateControlMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scalability_modes"), this->scalability_modes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::SVCScalabilityMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_software_codec"), this->is_software_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_supported_pixel_formats"), this->gpu_supported_pixel_formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::VideoPixelFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_gpu_shared_images"), this->supports_gpu_shared_images,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeAcceleratorSupportedProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EncodeCommandBufferId::EncodeCommandBufferId()
    : channel_token(),
      route_id() {}

EncodeCommandBufferId::EncodeCommandBufferId(
    const ::base::UnguessableToken& channel_token_in,
    int32_t route_id_in)
    : channel_token(std::move(channel_token_in)),
      route_id(std::move(route_id_in)) {}

EncodeCommandBufferId::~EncodeCommandBufferId() = default;

void EncodeCommandBufferId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_token"), this->channel_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "route_id"), this->route_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EncodeCommandBufferId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VariableBitratePeak::VariableBitratePeak()
    : bps() {}

VariableBitratePeak::VariableBitratePeak(
    uint32_t bps_in)
    : bps(std::move(bps_in)) {}

VariableBitratePeak::~VariableBitratePeak() = default;
size_t VariableBitratePeak::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->bps);
  return seed;
}

void VariableBitratePeak::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bps"), this->bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VariableBitratePeak::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoBitrateAllocation::VideoBitrateAllocation()
    : bitrates(),
      variable_bitrate_peak() {}

VideoBitrateAllocation::VideoBitrateAllocation(
    std::vector<uint32_t> bitrates_in,
    VariableBitratePeakPtr variable_bitrate_peak_in)
    : bitrates(std::move(bitrates_in)),
      variable_bitrate_peak(std::move(variable_bitrate_peak_in)) {}

VideoBitrateAllocation::~VideoBitrateAllocation() = default;

void VideoBitrateAllocation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrates"), this->bitrates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variable_bitrate_peak"), this->variable_bitrate_peak,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VariableBitratePeakPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoBitrateAllocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpatialLayer::SpatialLayer()
    : width(),
      height(),
      bitrate_bps(),
      framerate(),
      max_qp(),
      num_of_temporal_layers() {}

SpatialLayer::SpatialLayer(
    int32_t width_in,
    int32_t height_in,
    uint32_t bitrate_bps_in,
    uint32_t framerate_in,
    uint8_t max_qp_in,
    uint8_t num_of_temporal_layers_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      bitrate_bps(std::move(bitrate_bps_in)),
      framerate(std::move(framerate_in)),
      max_qp(std::move(max_qp_in)),
      num_of_temporal_layers(std::move(num_of_temporal_layers_in)) {}

SpatialLayer::~SpatialLayer() = default;

void SpatialLayer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate_bps"), this->bitrate_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framerate"), this->framerate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_qp"), this->max_qp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_of_temporal_layers"), this->num_of_temporal_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpatialLayer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConstantBitrate::ConstantBitrate()
    : target_bps(0U) {}

ConstantBitrate::ConstantBitrate(
    uint32_t target_bps_in)
    : target_bps(std::move(target_bps_in)) {}

ConstantBitrate::~ConstantBitrate() = default;

void ConstantBitrate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_bps"), this->target_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConstantBitrate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VariableBitrate::VariableBitrate()
    : target_bps(0U),
      peak_bps() {}

VariableBitrate::VariableBitrate(
    uint32_t target_bps_in,
    uint32_t peak_bps_in)
    : target_bps(std::move(target_bps_in)),
      peak_bps(std::move(peak_bps_in)) {}

VariableBitrate::~VariableBitrate() = default;

void VariableBitrate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_bps"), this->target_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peak_bps"), this->peak_bps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VariableBitrate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExternalBitrate::ExternalBitrate() {}

ExternalBitrate::~ExternalBitrate() = default;
size_t ExternalBitrate::Hash(size_t seed) const {
  return seed;
}

void ExternalBitrate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ExternalBitrate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncodeAcceleratorConfig::VideoEncodeAcceleratorConfig()
    : input_format(),
      input_visible_size(),
      output_profile(),
      bitrate(),
      framerate(),
      storage_type(),
      content_type(),
      gop_length(),
      has_gop_length(),
      h264_output_level(),
      has_h264_output_level(),
      is_constrained_h264(),
      drop_frame_thresh_percentage(),
      spatial_layers(),
      inter_layer_pred(),
      require_low_delay(),
      required_encoder_type(),
      manual_reference_buffer_control() {}

VideoEncodeAcceleratorConfig::VideoEncodeAcceleratorConfig(
    ::media::VideoPixelFormat input_format_in,
    const ::gfx::Size& input_visible_size_in,
    ::media::VideoCodecProfile output_profile_in,
    const ::media::Bitrate& bitrate_in,
    uint32_t framerate_in,
    VideoEncodeAcceleratorConfig::StorageType storage_type_in,
    VideoEncodeAcceleratorConfig::ContentType content_type_in,
    uint32_t gop_length_in,
    bool has_gop_length_in,
    uint8_t h264_output_level_in,
    bool has_h264_output_level_in,
    bool is_constrained_h264_in,
    uint8_t drop_frame_thresh_percentage_in,
    std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer> spatial_layers_in,
    ::media::SVCInterLayerPredMode inter_layer_pred_in,
    bool require_low_delay_in,
    VideoEncodeAcceleratorConfig::EncoderType required_encoder_type_in,
    bool manual_reference_buffer_control_in)
    : input_format(std::move(input_format_in)),
      input_visible_size(std::move(input_visible_size_in)),
      output_profile(std::move(output_profile_in)),
      bitrate(std::move(bitrate_in)),
      framerate(std::move(framerate_in)),
      storage_type(std::move(storage_type_in)),
      content_type(std::move(content_type_in)),
      gop_length(std::move(gop_length_in)),
      has_gop_length(std::move(has_gop_length_in)),
      h264_output_level(std::move(h264_output_level_in)),
      has_h264_output_level(std::move(has_h264_output_level_in)),
      is_constrained_h264(std::move(is_constrained_h264_in)),
      drop_frame_thresh_percentage(std::move(drop_frame_thresh_percentage_in)),
      spatial_layers(std::move(spatial_layers_in)),
      inter_layer_pred(std::move(inter_layer_pred_in)),
      require_low_delay(std::move(require_low_delay_in)),
      required_encoder_type(std::move(required_encoder_type_in)),
      manual_reference_buffer_control(std::move(manual_reference_buffer_control_in)) {}

VideoEncodeAcceleratorConfig::~VideoEncodeAcceleratorConfig() = default;

void VideoEncodeAcceleratorConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_format"), this->input_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_visible_size"), this->input_visible_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_profile"), this->output_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate"), this->bitrate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::Bitrate&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "framerate"), this->framerate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_type"), this->storage_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::StorageType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_type"), this->content_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::ContentType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gop_length"), this->gop_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_gop_length"), this->has_gop_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "h264_output_level"), this->h264_output_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_h264_output_level"), this->has_h264_output_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_constrained_h264"), this->is_constrained_h264,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "drop_frame_thresh_percentage"), this->drop_frame_thresh_percentage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layers"), this->spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::VideoEncodeAccelerator::Config::SpatialLayer>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inter_layer_pred"), this->inter_layer_pred,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SVCInterLayerPredMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_low_delay"), this->require_low_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_encoder_type"), this->required_encoder_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoEncodeAcceleratorConfig::EncoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manual_reference_buffer_control"), this->manual_reference_buffer_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeAcceleratorConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncodeOptions::VideoEncodeOptions()
    : force_keyframe(),
      quantizer(),
      update_buffer(),
      reference_buffers() {}

VideoEncodeOptions::VideoEncodeOptions(
    bool force_keyframe_in,
    int32_t quantizer_in,
    std::optional<uint8_t> update_buffer_in,
    std::vector<uint8_t> reference_buffers_in)
    : force_keyframe(std::move(force_keyframe_in)),
      quantizer(std::move(quantizer_in)),
      update_buffer(std::move(update_buffer_in)),
      reference_buffers(std::move(reference_buffers_in)) {}

VideoEncodeOptions::~VideoEncodeOptions() = default;

void VideoEncodeOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_keyframe"), this->force_keyframe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quantizer"), this->quantizer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_buffer"), this->update_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint8_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_buffers"), this->reference_buffers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoEncodeOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DropFrameMetadata::DropFrameMetadata()
    : spatial_idx(),
      end_of_picture() {}

DropFrameMetadata::DropFrameMetadata(
    uint8_t spatial_idx_in,
    bool end_of_picture_in)
    : spatial_idx(std::move(spatial_idx_in)),
      end_of_picture(std::move(end_of_picture_in)) {}

DropFrameMetadata::~DropFrameMetadata() = default;
size_t DropFrameMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->spatial_idx);
  seed = mojo::internal::Hash(seed, this->end_of_picture);
  return seed;
}

void DropFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_idx"), this->spatial_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_picture"), this->end_of_picture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DropFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
H264Metadata::H264Metadata()
    : temporal_idx(),
      layer_sync() {}

H264Metadata::H264Metadata(
    uint8_t temporal_idx_in,
    bool layer_sync_in)
    : temporal_idx(std::move(temporal_idx_in)),
      layer_sync(std::move(layer_sync_in)) {}

H264Metadata::~H264Metadata() = default;
size_t H264Metadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->temporal_idx);
  seed = mojo::internal::Hash(seed, this->layer_sync);
  return seed;
}

void H264Metadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_sync"), this->layer_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool H264Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Vp8Metadata::Vp8Metadata()
    : non_reference(),
      temporal_idx(),
      layer_sync() {}

Vp8Metadata::Vp8Metadata(
    bool non_reference_in,
    uint8_t temporal_idx_in,
    bool layer_sync_in)
    : non_reference(std::move(non_reference_in)),
      temporal_idx(std::move(temporal_idx_in)),
      layer_sync(std::move(layer_sync_in)) {}

Vp8Metadata::~Vp8Metadata() = default;

void Vp8Metadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "non_reference"), this->non_reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_sync"), this->layer_sync,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Vp8Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Vp9Metadata::Vp9Metadata()
    : inter_pic_predicted(),
      temporal_up_switch(),
      referenced_by_upper_spatial_layers(),
      reference_lower_spatial_layers(),
      end_of_picture(),
      temporal_idx(),
      spatial_idx(),
      spatial_layer_resolutions(),
      begin_active_spatial_layer_index(),
      end_active_spatial_layer_index(),
      p_diffs() {}

Vp9Metadata::Vp9Metadata(
    bool inter_pic_predicted_in,
    bool temporal_up_switch_in,
    bool referenced_by_upper_spatial_layers_in,
    bool reference_lower_spatial_layers_in,
    bool end_of_picture_in,
    uint8_t temporal_idx_in,
    uint8_t spatial_idx_in,
    std::vector<::gfx::Size> spatial_layer_resolutions_in,
    uint8_t begin_active_spatial_layer_index_in,
    uint8_t end_active_spatial_layer_index_in,
    std::vector<uint8_t> p_diffs_in)
    : inter_pic_predicted(std::move(inter_pic_predicted_in)),
      temporal_up_switch(std::move(temporal_up_switch_in)),
      referenced_by_upper_spatial_layers(std::move(referenced_by_upper_spatial_layers_in)),
      reference_lower_spatial_layers(std::move(reference_lower_spatial_layers_in)),
      end_of_picture(std::move(end_of_picture_in)),
      temporal_idx(std::move(temporal_idx_in)),
      spatial_idx(std::move(spatial_idx_in)),
      spatial_layer_resolutions(std::move(spatial_layer_resolutions_in)),
      begin_active_spatial_layer_index(std::move(begin_active_spatial_layer_index_in)),
      end_active_spatial_layer_index(std::move(end_active_spatial_layer_index_in)),
      p_diffs(std::move(p_diffs_in)) {}

Vp9Metadata::~Vp9Metadata() = default;

void Vp9Metadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inter_pic_predicted"), this->inter_pic_predicted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_up_switch"), this->temporal_up_switch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referenced_by_upper_spatial_layers"), this->referenced_by_upper_spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_lower_spatial_layers"), this->reference_lower_spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_picture"), this->end_of_picture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_idx"), this->spatial_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layer_resolutions"), this->spatial_layer_resolutions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "begin_active_spatial_layer_index"), this->begin_active_spatial_layer_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_active_spatial_layer_index"), this->end_active_spatial_layer_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "p_diffs"), this->p_diffs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Vp9Metadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SVCGenericMetadata::SVCGenericMetadata()
    : follow_svc_spec(),
      temporal_idx(),
      spatial_idx(),
      reference_flags(),
      refresh_flags() {}

SVCGenericMetadata::SVCGenericMetadata(
    bool follow_svc_spec_in,
    uint8_t temporal_idx_in,
    uint8_t spatial_idx_in,
    std::optional<uint16_t> reference_flags_in,
    std::optional<uint16_t> refresh_flags_in)
    : follow_svc_spec(std::move(follow_svc_spec_in)),
      temporal_idx(std::move(temporal_idx_in)),
      spatial_idx(std::move(spatial_idx_in)),
      reference_flags(std::move(reference_flags_in)),
      refresh_flags(std::move(refresh_flags_in)) {}

SVCGenericMetadata::~SVCGenericMetadata() = default;

void SVCGenericMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "follow_svc_spec"), this->follow_svc_spec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temporal_idx"), this->temporal_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_idx"), this->spatial_idx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_flags"), this->reference_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "refresh_flags"), this->refresh_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SVCGenericMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BitstreamBufferMetadata::BitstreamBufferMetadata()
    : payload_size_bytes(),
      key_frame(),
      timestamp(),
      qp(),
      optional_metadata(),
      svc_generic(),
      encoded_size(),
      encoded_color_space() {}

BitstreamBufferMetadata::BitstreamBufferMetadata(
    uint32_t payload_size_bytes_in,
    bool key_frame_in,
    ::base::TimeDelta timestamp_in,
    int32_t qp_in,
    OptionalMetadataPtr optional_metadata_in,
    SVCGenericMetadataPtr svc_generic_in,
    const std::optional<::gfx::Size>& encoded_size_in,
    const std::optional<::gfx::ColorSpace>& encoded_color_space_in)
    : payload_size_bytes(std::move(payload_size_bytes_in)),
      key_frame(std::move(key_frame_in)),
      timestamp(std::move(timestamp_in)),
      qp(std::move(qp_in)),
      optional_metadata(std::move(optional_metadata_in)),
      svc_generic(std::move(svc_generic_in)),
      encoded_size(std::move(encoded_size_in)),
      encoded_color_space(std::move(encoded_color_space_in)) {}

BitstreamBufferMetadata::~BitstreamBufferMetadata() = default;

void BitstreamBufferMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_size_bytes"), this->payload_size_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_frame"), this->key_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "qp"), this->qp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "optional_metadata"), this->optional_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OptionalMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "svc_generic"), this->svc_generic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SVCGenericMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_size"), this->encoded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_color_space"), this->encoded_color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::ColorSpace>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BitstreamBufferMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BitratePtr
Bitrate::NewConstant(
    const ::media::Bitrate& value) {
  return BitratePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kConstant)>,
      std::move(value));
}

BitratePtr
Bitrate::NewVariable(
    const ::media::Bitrate& value) {
  return BitratePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVariable)>,
      std::move(value));
}

BitratePtr
Bitrate::NewExternal(
    ExternalBitratePtr value) {
  return BitratePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExternal)>,
      std::move(value));
}

Bitrate::Bitrate(
    std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
    const ::media::Bitrate& value)
    : tag_(Tag::kConstant),
      data_(std::in_place_index<static_cast<size_t>(Tag::kConstant)>,
            std::move(value)) {}

Bitrate::Bitrate(
    std::in_place_index_t<static_cast<size_t>(Tag::kVariable)>,
    const ::media::Bitrate& value)
    : tag_(Tag::kVariable),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVariable)>,
            std::move(value)) {}

Bitrate::Bitrate(
    std::in_place_index_t<static_cast<size_t>(Tag::kExternal)>,
    ExternalBitratePtr value)
    : tag_(Tag::kExternal),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExternal)>,
            std::move(value)) {}
Bitrate::~Bitrate() {
  DestroyActive();
}

void Bitrate::set_constant(const ::media::Bitrate& constant) {
  if (tag_ == Tag::kConstant) {
    data_.constant = std::move(constant);
  } else {
    DestroyActive();
    tag_ = Tag::kConstant;
    new (&data_.constant) ::media::Bitrate(
        std::move(constant));
  }
}

void Bitrate::set_variable(const ::media::Bitrate& variable) {
  if (tag_ == Tag::kVariable) {
    data_.variable = std::move(variable);
  } else {
    DestroyActive();
    tag_ = Tag::kVariable;
    new (&data_.variable) ::media::Bitrate(
        std::move(variable));
  }
}

void Bitrate::set_external(ExternalBitratePtr external) {
  if (tag_ == Tag::kExternal) {
    data_.external = std::move(external);
  } else {
    DestroyActive();
    tag_ = Tag::kExternal;
    new (&data_.external) ExternalBitratePtr(
        std::move(external));
  }
}


Bitrate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
    const ::media::Bitrate& value)
    : constant(std::move(value)) {}

Bitrate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVariable)>,
    const ::media::Bitrate& value)
    : variable(std::move(value)) {}

Bitrate::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExternal)>,
    ExternalBitratePtr value)
    : external(std::move(value)) {}

void Bitrate::DestroyActive() {
  switch (tag_) {

    case Tag::kConstant:
      std::destroy_at(&data_.constant);
      break;
    case Tag::kVariable:
      std::destroy_at(&data_.variable);
      break;
    case Tag::kExternal:
      std::destroy_at(&data_.external);
      break;
  }
}

bool Bitrate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
OptionalMetadataPtr
OptionalMetadata::NewDrop(
    DropFrameMetadataPtr value) {
  return OptionalMetadataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDrop)>,
      std::move(value));
}

OptionalMetadataPtr
OptionalMetadata::NewH264(
    H264MetadataPtr value) {
  return OptionalMetadataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kH264)>,
      std::move(value));
}

OptionalMetadataPtr
OptionalMetadata::NewVp8(
    const ::media::Vp8Metadata& value) {
  return OptionalMetadataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVp8)>,
      std::move(value));
}

OptionalMetadataPtr
OptionalMetadata::NewVp9(
    const ::media::Vp9Metadata& value) {
  return OptionalMetadataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVp9)>,
      std::move(value));
}

OptionalMetadata::OptionalMetadata(
    std::in_place_index_t<static_cast<size_t>(Tag::kDrop)>,
    DropFrameMetadataPtr value)
    : tag_(Tag::kDrop),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDrop)>,
            std::move(value)) {}

OptionalMetadata::OptionalMetadata(
    std::in_place_index_t<static_cast<size_t>(Tag::kH264)>,
    H264MetadataPtr value)
    : tag_(Tag::kH264),
      data_(std::in_place_index<static_cast<size_t>(Tag::kH264)>,
            std::move(value)) {}

OptionalMetadata::OptionalMetadata(
    std::in_place_index_t<static_cast<size_t>(Tag::kVp8)>,
    const ::media::Vp8Metadata& value)
    : tag_(Tag::kVp8),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVp8)>,
            std::move(value)) {}

OptionalMetadata::OptionalMetadata(
    std::in_place_index_t<static_cast<size_t>(Tag::kVp9)>,
    const ::media::Vp9Metadata& value)
    : tag_(Tag::kVp9),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVp9)>,
            std::move(value)) {}
OptionalMetadata::~OptionalMetadata() {
  DestroyActive();
}

void OptionalMetadata::set_drop(DropFrameMetadataPtr drop) {
  if (tag_ == Tag::kDrop) {
    data_.drop = std::move(drop);
  } else {
    DestroyActive();
    tag_ = Tag::kDrop;
    new (&data_.drop) DropFrameMetadataPtr(
        std::move(drop));
  }
}

void OptionalMetadata::set_h264(H264MetadataPtr h264) {
  if (tag_ == Tag::kH264) {
    data_.h264 = std::move(h264);
  } else {
    DestroyActive();
    tag_ = Tag::kH264;
    new (&data_.h264) H264MetadataPtr(
        std::move(h264));
  }
}

void OptionalMetadata::set_vp8(const ::media::Vp8Metadata& vp8) {
  if (tag_ == Tag::kVp8) {
    data_.vp8 = std::move(vp8);
  } else {
    DestroyActive();
    tag_ = Tag::kVp8;
    new (&data_.vp8) ::media::Vp8Metadata(
        std::move(vp8));
  }
}

void OptionalMetadata::set_vp9(const ::media::Vp9Metadata& vp9) {
  if (tag_ == Tag::kVp9) {
    data_.vp9 = std::move(vp9);
  } else {
    DestroyActive();
    tag_ = Tag::kVp9;
    new (&data_.vp9) ::media::Vp9Metadata(
        std::move(vp9));
  }
}


OptionalMetadata::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDrop)>,
    DropFrameMetadataPtr value)
    : drop(std::move(value)) {}

OptionalMetadata::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kH264)>,
    H264MetadataPtr value)
    : h264(std::move(value)) {}

OptionalMetadata::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVp8)>,
    const ::media::Vp8Metadata& value)
    : vp8(std::move(value)) {}

OptionalMetadata::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVp9)>,
    const ::media::Vp9Metadata& value)
    : vp9(std::move(value)) {}

void OptionalMetadata::DestroyActive() {
  switch (tag_) {

    case Tag::kDrop:
      std::destroy_at(&data_.drop);
      break;
    case Tag::kH264:
      std::destroy_at(&data_.h264);
      break;
    case Tag::kVp8:
      std::destroy_at(&data_.vp8);
      break;
    case Tag::kVp9:
      std::destroy_at(&data_.vp9);
      break;
  }
}

bool OptionalMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

VideoEncodeAcceleratorProvider::IPCStableHashFunction VideoEncodeAcceleratorProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEncodeAcceleratorProvider>(message.name())) {
    case messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator: {
      return &VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles: {
      return &VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEncodeAcceleratorProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEncodeAcceleratorProvider>(message.name())) {
      case messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator:
            return "Receive media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator";
      case messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles:
            return "Receive media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles";
    }
  } else {
    switch (static_cast<messages::VideoEncodeAcceleratorProvider>(message.name())) {
      case messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator:
            return "Receive reply media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator";
      case messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles:
            return "Receive reply media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5adab260;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a0dc3a6;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles(std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_profiles) {
  NOTREACHED();
}
class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse(
      bool* result, std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_profiles)
      : result_(result), out_profiles_(out_profiles) {
    DCHECK(!*result_);
  }

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse(const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse&) = delete;
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse& operator=(const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_profiles_;};

class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback(
      VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback(const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback&) = delete;
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback& operator=(const VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback callback_;
};

VideoEncodeAcceleratorProviderProxy::VideoEncodeAcceleratorProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEncodeAcceleratorProviderProxy::CreateVideoEncodeAccelerator(
    EncodeCommandBufferIdPtr in_command_buffer_id, ::mojo::PendingReceiver<VideoEncodeAccelerator> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAcceleratorProvider::CreateVideoEncodeAccelerator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_buffer_id"), in_command_buffer_id,
                        "<value of type EncodeCommandBufferIdPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<VideoEncodeAccelerator>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->command_buffer_id)::BaseType> command_buffer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncodeCommandBufferIdDataView>(
    in_command_buffer_id,
    command_buffer_id_fragment);

  params->command_buffer_id.Set(
      command_buffer_id_fragment.is_null() ? nullptr : command_buffer_id_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in VideoEncodeAcceleratorProvider.CreateVideoEncodeAccelerator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("CreateVideoEncodeAccelerator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool VideoEncodeAcceleratorProviderProxy::GetVideoEncodeAcceleratorSupportedProfiles(
    std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_param_profiles) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles (sync)");
#else
  TRACE_EVENT0("mojom", "VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("GetVideoEncodeAcceleratorSupportedProfiles");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse(
          &result, out_param_profiles));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profiles"), out_param_profiles,
                        "<value of type const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>&>");
   });
#endif
  return result;
}

void VideoEncodeAcceleratorProviderProxy::GetVideoEncodeAcceleratorSupportedProfiles(
    GetVideoEncodeAcceleratorSupportedProfilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("GetVideoEncodeAcceleratorSupportedProfiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder> proxy(
        new VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfilesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>& in_profiles);
};

bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoEncodeAcceleratorProvider.1
  bool success = true;
  std::vector<::media::VideoEncodeAccelerator::SupportedProfile> p_profiles{};
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfiles(&p_profiles))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAcceleratorProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_profiles));
  }
  return true;
}

void VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::Run(
    const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>& in_profiles) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoEncodeAcceleratorProvider::GetVideoEncodeAcceleratorSupportedProfiles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profiles"), in_profiles,
                        "<value of type const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profiles)::BaseType>
      profiles_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView>>(
    in_profiles,
    profiles_fragment,
    &profiles_validate_params);

  params->profiles.Set(
      profiles_fragment.is_null() ? nullptr : profiles_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profiles.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profiles in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorProvider::Name_);
  message.set_method_name("GetVideoEncodeAcceleratorSupportedProfiles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for VideoEncodeAcceleratorProvider.1
  bool success = true;
  std::vector<::media::VideoEncodeAccelerator::SupportedProfile> p_profiles{};
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfiles(&p_profiles))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAcceleratorProvider::Name_, 1, true);
    return false;
  }
  *out_profiles_ = std::move(p_profiles);
  *result_ = true;
  return true;
}

// static
bool VideoEncodeAcceleratorProviderStubDispatch::Accept(
    VideoEncodeAcceleratorProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEncodeAcceleratorProvider>(message->header()->name)) {
    case messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorProvider.0
      bool success = true;
      EncodeCommandBufferIdPtr p_command_buffer_id{};
      ::mojo::PendingReceiver<VideoEncodeAccelerator> p_receiver{};
      VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommandBufferId(&p_command_buffer_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAccelerator(        
        std::move(p_command_buffer_id), 
        std::move(p_receiver));
      return true;
    }
    case messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles: {
      break;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorProviderStubDispatch::AcceptWithResponder(
    VideoEncodeAcceleratorProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEncodeAcceleratorProvider>(message->header()->name)) {
    case messages::VideoEncodeAcceleratorProvider::kCreateVideoEncodeAccelerator: {
      break;
    }
    case messages::VideoEncodeAcceleratorProvider::kGetVideoEncodeAcceleratorSupportedProfiles: {
      internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorProvider.1
      bool success = true;
      VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoEncodeAcceleratorSupportedProfiles(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoEncodeAcceleratorProviderValidationInfo[] = {
    { &internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data::Validate,
     &internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data::Validate},
};

bool VideoEncodeAcceleratorProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoEncodeAcceleratorProvider::Name_,
    kVideoEncodeAcceleratorProviderValidationInfo);
}

bool VideoEncodeAcceleratorProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::VideoEncodeAcceleratorProvider::Name_,
    kVideoEncodeAcceleratorProviderValidationInfo);
}
// The declaration includes the definition on other builds.

VideoEncodeAccelerator::IPCStableHashFunction VideoEncodeAccelerator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEncodeAccelerator>(message.name())) {
    case messages::VideoEncodeAccelerator::kInitialize: {
      return &VideoEncodeAccelerator::Initialize_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kEncode: {
      return &VideoEncodeAccelerator::Encode_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer: {
      return &VideoEncodeAccelerator::UseOutputBitstreamBuffer_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers: {
      return &VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate: {
      return &VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kIsFlushSupported: {
      return &VideoEncodeAccelerator::IsFlushSupported_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAccelerator::kFlush: {
      return &VideoEncodeAccelerator::Flush_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEncodeAccelerator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEncodeAccelerator>(message.name())) {
      case messages::VideoEncodeAccelerator::kInitialize:
            return "Receive media::mojom::VideoEncodeAccelerator::Initialize";
      case messages::VideoEncodeAccelerator::kEncode:
            return "Receive media::mojom::VideoEncodeAccelerator::Encode";
      case messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer:
            return "Receive media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer";
      case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers:
            return "Receive media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers";
      case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate:
            return "Receive media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate";
      case messages::VideoEncodeAccelerator::kIsFlushSupported:
            return "Receive media::mojom::VideoEncodeAccelerator::IsFlushSupported";
      case messages::VideoEncodeAccelerator::kFlush:
            return "Receive media::mojom::VideoEncodeAccelerator::Flush";
    }
  } else {
    switch (static_cast<messages::VideoEncodeAccelerator>(message.name())) {
      case messages::VideoEncodeAccelerator::kInitialize:
            return "Receive reply media::mojom::VideoEncodeAccelerator::Initialize";
      case messages::VideoEncodeAccelerator::kEncode:
            return "Receive reply media::mojom::VideoEncodeAccelerator::Encode";
      case messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer:
            return "Receive reply media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer";
      case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers:
            return "Receive reply media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers";
      case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate:
            return "Receive reply media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate";
      case messages::VideoEncodeAccelerator::kIsFlushSupported:
            return "Receive reply media::mojom::VideoEncodeAccelerator::IsFlushSupported";
      case messages::VideoEncodeAccelerator::kFlush:
            return "Receive reply media::mojom::VideoEncodeAccelerator::Flush";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEncodeAccelerator::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x284fb2dc;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::Encode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe571719;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::Encode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::UseOutputBitstreamBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe574639b;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9dea253;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4198291b;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::IsFlushSupported_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7a913da;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::IsFlushSupported
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAccelerator::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfcbdf3a7;  // IPCStableHash for media::mojom::VideoEncodeAccelerator::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool VideoEncodeAccelerator::Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log, ::media::EncoderStatus* out_result) {
  NOTREACHED();
}
bool VideoEncodeAccelerator::IsFlushSupported(bool* out_result) {
  NOTREACHED();
}
class VideoEncodeAccelerator_Initialize_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Initialize_HandleSyncResponse(
      bool* result, ::media::EncoderStatus* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  VideoEncodeAccelerator_Initialize_HandleSyncResponse(const VideoEncodeAccelerator_Initialize_HandleSyncResponse&) = delete;
  VideoEncodeAccelerator_Initialize_HandleSyncResponse& operator=(const VideoEncodeAccelerator_Initialize_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::media::EncoderStatus* out_result_;};

class VideoEncodeAccelerator_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Initialize_ForwardToCallback(
      VideoEncodeAccelerator::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEncodeAccelerator_Initialize_ForwardToCallback(const VideoEncodeAccelerator_Initialize_ForwardToCallback&) = delete;
  VideoEncodeAccelerator_Initialize_ForwardToCallback& operator=(const VideoEncodeAccelerator_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::InitializeCallback callback_;
};

class VideoEncodeAccelerator_Encode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Encode_ForwardToCallback(
      VideoEncodeAccelerator::EncodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEncodeAccelerator_Encode_ForwardToCallback(const VideoEncodeAccelerator_Encode_ForwardToCallback&) = delete;
  VideoEncodeAccelerator_Encode_ForwardToCallback& operator=(const VideoEncodeAccelerator_Encode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::EncodeCallback callback_;
};
class VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse(const VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse&) = delete;
  VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse& operator=(const VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;};

class VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback(
      VideoEncodeAccelerator::IsFlushSupportedCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback(const VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback&) = delete;
  VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback& operator=(const VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::IsFlushSupportedCallback callback_;
};

class VideoEncodeAccelerator_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEncodeAccelerator_Flush_ForwardToCallback(
      VideoEncodeAccelerator::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEncodeAccelerator_Flush_ForwardToCallback(const VideoEncodeAccelerator_Flush_ForwardToCallback&) = delete;
  VideoEncodeAccelerator_Flush_ForwardToCallback& operator=(const VideoEncodeAccelerator_Flush_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEncodeAccelerator::FlushCallback callback_;
};

VideoEncodeAcceleratorProxy::VideoEncodeAcceleratorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool VideoEncodeAcceleratorProxy::Initialize(
    const ::media::VideoEncodeAccelerator::Config& param_config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> param_client, ::mojo::PendingRemote<::media::mojom::MediaLog> param_media_log, ::media::EncoderStatus* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call media::mojom::VideoEncodeAccelerator::Initialize (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), param_config,
                        "<value of type const ::media::VideoEncodeAccelerator::Config&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), param_client,
                        "<value of type ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), param_media_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::MediaLog>>");
   });
#else
  TRACE_EVENT0("mojom", "VideoEncodeAccelerator::Initialize");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfigDataView>(
    param_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in VideoEncodeAccelerator.Initialize request");

  
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorClientAssociatedPtrInfoDataView>(
    param_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in VideoEncodeAccelerator.Initialize request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
    param_media_log,
    &params->media_log,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_log)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_log in VideoEncodeAccelerator.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Initialize_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VideoEncodeAccelerator::Initialize", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::media::EncoderStatus&>");
   });
#endif
  return result;
}

void VideoEncodeAcceleratorProxy::Initialize(
    const ::media::VideoEncodeAccelerator::Config& in_config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> in_client, ::mojo::PendingRemote<::media::mojom::MediaLog> in_media_log, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAccelerator::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::VideoEncodeAccelerator::Config&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("media_log"), in_media_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::MediaLog>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in VideoEncodeAccelerator.Initialize request");

  
  mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in VideoEncodeAccelerator.Initialize request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
    in_media_log,
    &params->media_log,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->media_log)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid media_log in VideoEncodeAccelerator.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoEncodeAcceleratorProxy::Encode(
    const ::scoped_refptr<::media::VideoFrame>& in_frame, const ::media::VideoEncoder::EncodeOptions& in_options, EncodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAccelerator::Encode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type const ::scoped_refptr<::media::VideoFrame>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type const ::media::VideoEncoder::EncodeOptions&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kEncode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Encode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoFrameDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in VideoEncodeAccelerator.Encode request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoEncodeOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in VideoEncodeAccelerator.Encode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Encode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Encode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoEncodeAcceleratorProxy::UseOutputBitstreamBuffer(
    int32_t in_bitstream_buffer_id, ::base::UnsafeSharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAccelerator::UseOutputBitstreamBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitstream_buffer_id"), in_bitstream_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->bitstream_buffer_id = in_bitstream_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in VideoEncodeAccelerator.UseOutputBitstreamBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("UseOutputBitstreamBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncodeAcceleratorProxy::RequestEncodingParametersChangeWithLayers(
    const ::media::VideoBitrateAllocation& in_bitrate_allocation, uint32_t in_framerate, const std::optional<::gfx::Size>& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithLayers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitrate_allocation"), in_bitrate_allocation,
                        "<value of type const ::media::VideoBitrateAllocation&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("framerate"), in_framerate,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const std::optional<::gfx::Size>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitrate_allocation)::BaseType> bitrate_allocation_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoBitrateAllocationDataView>(
    in_bitrate_allocation,
    bitrate_allocation_fragment);

  params->bitrate_allocation.Set(
      bitrate_allocation_fragment.is_null() ? nullptr : bitrate_allocation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bitrate_allocation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bitrate_allocation in VideoEncodeAccelerator.RequestEncodingParametersChangeWithLayers request");

  params->framerate = in_framerate;
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("RequestEncodingParametersChangeWithLayers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncodeAcceleratorProxy::RequestEncodingParametersChangeWithBitrate(
    const ::media::Bitrate& in_bitrate, uint32_t in_framerate, const std::optional<::gfx::Size>& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAccelerator::RequestEncodingParametersChangeWithBitrate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitrate"), in_bitrate,
                        "<value of type const ::media::Bitrate&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("framerate"), in_framerate,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const std::optional<::gfx::Size>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->bitrate)>
      bitrate_fragment(params.message());
  bitrate_fragment.Claim(&params->bitrate);
  
  mojo::internal::Serialize<::media::mojom::BitrateDataView>(
    in_bitrate,
    bitrate_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bitrate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bitrate in VideoEncodeAccelerator.RequestEncodingParametersChangeWithBitrate request");

  params->framerate = in_framerate;
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("RequestEncodingParametersChangeWithBitrate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool VideoEncodeAcceleratorProxy::IsFlushSupported(
    bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call media::mojom::VideoEncodeAccelerator::IsFlushSupported (sync)");
#else
  TRACE_EVENT0("mojom", "VideoEncodeAccelerator::IsFlushSupported");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kIsFlushSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "VideoEncodeAccelerator::IsFlushSupported", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void VideoEncodeAcceleratorProxy::IsFlushSupported(
    IsFlushSupportedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoEncodeAccelerator::IsFlushSupported");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kIsFlushSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoEncodeAcceleratorProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::VideoEncodeAccelerator::Flush");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEncodeAccelerator_Flush_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VideoEncodeAccelerator_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEncodeAccelerator::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEncodeAccelerator_Initialize_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEncodeAccelerator_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEncodeAccelerator_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoEncodeAccelerator::InitializeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::media::EncoderStatus& in_result);
};

bool VideoEncodeAccelerator_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.0
  bool success = true;
  ::media::EncoderStatus p_result{};
  VideoEncodeAccelerator_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void VideoEncodeAccelerator_Initialize_ProxyToResponder::Run(
    const ::media::EncoderStatus& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoEncodeAccelerator::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::media::EncoderStatus&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoEncodeAccelerator_Initialize_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.0
  bool success = true;
  ::media::EncoderStatus p_result{};
  VideoEncodeAccelerator_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class VideoEncodeAccelerator_Encode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEncodeAccelerator::EncodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEncodeAccelerator_Encode_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Encode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEncodeAccelerator_Encode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Encode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEncodeAccelerator_Encode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoEncodeAccelerator::EncodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool VideoEncodeAccelerator_Encode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Encode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Encode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.1
  bool success = true;
  VideoEncodeAccelerator_Encode_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void VideoEncodeAccelerator_Encode_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::mojom::VideoEncodeAccelerator::Encode");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kEncode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Encode_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Encode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEncodeAccelerator::IsFlushSupportedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoEncodeAccelerator::IsFlushSupportedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool VideoEncodeAccelerator_IsFlushSupported_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.5
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoEncodeAccelerator::IsFlushSupported", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kIsFlushSupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("IsFlushSupported");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool VideoEncodeAccelerator_IsFlushSupported_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* params =
      reinterpret_cast<internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.5
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 5, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class VideoEncodeAccelerator_Flush_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEncodeAccelerator::FlushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEncodeAccelerator_Flush_ProxyToResponder> proxy(
        new VideoEncodeAccelerator_Flush_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEncodeAccelerator_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEncodeAccelerator_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEncodeAccelerator_Flush_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoEncodeAccelerator::FlushCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool VideoEncodeAccelerator_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEncodeAccelerator_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEncodeAccelerator_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoEncodeAccelerator.6
  bool success = true;
  bool p_result{};
  VideoEncodeAccelerator_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEncodeAccelerator::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void VideoEncodeAccelerator_Flush_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoEncodeAccelerator::Flush", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAccelerator::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAccelerator_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAccelerator::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoEncodeAcceleratorStubDispatch::Accept(
    VideoEncodeAccelerator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEncodeAccelerator>(message->header()->name)) {
    case messages::VideoEncodeAccelerator::kInitialize: {
      break;
    }
    case messages::VideoEncodeAccelerator::kEncode: {
      break;
    }
    case messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.2
      bool success = true;
      int32_t p_bitstream_buffer_id{};
      ::base::UnsafeSharedMemoryRegion p_region{};
      VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bitstream_buffer_id = input_data_view.bitstream_buffer_id();
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UseOutputBitstreamBuffer(        
        std::move(p_bitstream_buffer_id), 
        std::move(p_region));
      return true;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.3
      bool success = true;
      ::media::VideoBitrateAllocation p_bitrate_allocation{};
      uint32_t p_framerate{};
      std::optional<::gfx::Size> p_size{};
      VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitrateAllocation(&p_bitrate_allocation))
        success = false;
      if (success)
        p_framerate = input_data_view.framerate();
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEncodingParametersChangeWithLayers(        
        std::move(p_bitrate_allocation), 
        std::move(p_framerate), 
        std::move(p_size));
      return true;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.4
      bool success = true;
      ::media::Bitrate p_bitrate{};
      uint32_t p_framerate{};
      std::optional<::gfx::Size> p_size{};
      VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBitrate(&p_bitrate))
        success = false;
      if (success)
        p_framerate = input_data_view.framerate();
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestEncodingParametersChangeWithBitrate(        
        std::move(p_bitrate), 
        std::move(p_framerate), 
        std::move(p_size));
      return true;
    }
    case messages::VideoEncodeAccelerator::kIsFlushSupported: {
      break;
    }
    case messages::VideoEncodeAccelerator::kFlush: {
      break;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorStubDispatch::AcceptWithResponder(
    VideoEncodeAccelerator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEncodeAccelerator>(message->header()->name)) {
    case messages::VideoEncodeAccelerator::kInitialize: {
      internal::VideoEncodeAccelerator_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Initialize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.0
      bool success = true;
      ::media::VideoEncodeAccelerator::Config p_config{};
      ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::MediaLog> p_media_log{};
      VideoEncodeAccelerator_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_media_log =
            input_data_view.TakeMediaLog<decltype(p_media_log)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 0, false);
        return false;
      }
      auto callback =
          VideoEncodeAccelerator_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_config), 
        std::move(p_client), 
        std::move(p_media_log), std::move(callback));
      return true;
    }
    case messages::VideoEncodeAccelerator::kEncode: {
      internal::VideoEncodeAccelerator_Encode_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Encode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.1
      bool success = true;
      ::scoped_refptr<::media::VideoFrame> p_frame{};
      ::media::VideoEncoder::EncodeOptions p_options{};
      VideoEncodeAccelerator_Encode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 1, false);
        return false;
      }
      auto callback =
          VideoEncodeAccelerator_Encode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Encode(        
        std::move(p_frame), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::VideoEncodeAccelerator::kUseOutputBitstreamBuffer: {
      break;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithLayers: {
      break;
    }
    case messages::VideoEncodeAccelerator::kRequestEncodingParametersChangeWithBitrate: {
      break;
    }
    case messages::VideoEncodeAccelerator::kIsFlushSupported: {
      internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.5
      bool success = true;
      VideoEncodeAccelerator_IsFlushSupported_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 5, false);
        return false;
      }
      auto callback =
          VideoEncodeAccelerator_IsFlushSupported_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsFlushSupported(std::move(callback));
      return true;
    }
    case messages::VideoEncodeAccelerator::kFlush: {
      internal::VideoEncodeAccelerator_Flush_Params_Data* params =
          reinterpret_cast<
              internal::VideoEncodeAccelerator_Flush_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoEncodeAccelerator.6
      bool success = true;
      VideoEncodeAccelerator_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAccelerator::Name_, 6, false);
        return false;
      }
      auto callback =
          VideoEncodeAccelerator_Flush_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoEncodeAcceleratorValidationInfo[] = {
    { &internal::VideoEncodeAccelerator_Initialize_Params_Data::Validate,
     &internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data::Validate},
    { &internal::VideoEncodeAccelerator_Encode_Params_Data::Validate,
     &internal::VideoEncodeAccelerator_Encode_ResponseParams_Data::Validate},
    { &internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data::Validate,
     &internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data::Validate},
    { &internal::VideoEncodeAccelerator_Flush_Params_Data::Validate,
     &internal::VideoEncodeAccelerator_Flush_ResponseParams_Data::Validate},
};

bool VideoEncodeAcceleratorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoEncodeAccelerator::Name_,
    kVideoEncodeAcceleratorValidationInfo);
}

bool VideoEncodeAcceleratorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::VideoEncodeAccelerator::Name_,
    kVideoEncodeAcceleratorValidationInfo);
}
// The declaration includes the definition on other builds.

VideoEncodeAcceleratorClient::IPCStableHashFunction VideoEncodeAcceleratorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEncodeAcceleratorClient>(message.name())) {
    case messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers: {
      return &VideoEncodeAcceleratorClient::RequireBitstreamBuffers_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady: {
      return &VideoEncodeAcceleratorClient::BitstreamBufferReady_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus: {
      return &VideoEncodeAcceleratorClient::NotifyErrorStatus_Sym::IPCStableHash;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange: {
      return &VideoEncodeAcceleratorClient::NotifyEncoderInfoChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEncodeAcceleratorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEncodeAcceleratorClient>(message.name())) {
      case messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers:
            return "Receive media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers";
      case messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady:
            return "Receive media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady";
      case messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus:
            return "Receive media::mojom::VideoEncodeAcceleratorClient::NotifyErrorStatus";
      case messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange:
            return "Receive media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange";
    }
  } else {
    switch (static_cast<messages::VideoEncodeAcceleratorClient>(message.name())) {
      case messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers:
            return "Receive reply media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers";
      case messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady:
            return "Receive reply media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady";
      case messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus:
            return "Receive reply media::mojom::VideoEncodeAcceleratorClient::NotifyErrorStatus";
      case messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange:
            return "Receive reply media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEncodeAcceleratorClient::RequireBitstreamBuffers_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb09fa10;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAcceleratorClient::BitstreamBufferReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc41e6aca;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAcceleratorClient::NotifyErrorStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57c9aed4;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorClient::NotifyErrorStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoEncodeAcceleratorClient::NotifyEncoderInfoChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5fa984b;  // IPCStableHash for media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoEncodeAcceleratorClientProxy::VideoEncodeAcceleratorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEncodeAcceleratorClientProxy::RequireBitstreamBuffers(
    uint32_t in_input_count, const ::gfx::Size& in_input_coded_size, uint32_t in_output_buffer_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAcceleratorClient::RequireBitstreamBuffers", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_count"), in_input_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_coded_size"), in_input_coded_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_buffer_size"), in_output_buffer_size,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data> params(
          message);
  params.Allocate();

  params->input_count = in_input_count;
  mojo::internal::MessageFragment<
      typename decltype(params->input_coded_size)::BaseType> input_coded_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_input_coded_size,
    input_coded_size_fragment);

  params->input_coded_size.Set(
      input_coded_size_fragment.is_null() ? nullptr : input_coded_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_coded_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_coded_size in VideoEncodeAcceleratorClient.RequireBitstreamBuffers request");

  params->output_buffer_size = in_output_buffer_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("RequireBitstreamBuffers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncodeAcceleratorClientProxy::BitstreamBufferReady(
    int32_t in_bitstream_buffer_id, const ::media::BitstreamBufferMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAcceleratorClient::BitstreamBufferReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitstream_buffer_id"), in_bitstream_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::media::BitstreamBufferMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data> params(
          message);
  params.Allocate();

  params->bitstream_buffer_id = in_bitstream_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::BitstreamBufferMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in VideoEncodeAcceleratorClient.BitstreamBufferReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("BitstreamBufferReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncodeAcceleratorClientProxy::NotifyErrorStatus(
    const ::media::EncoderStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAcceleratorClient::NotifyErrorStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::EncoderStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in VideoEncodeAcceleratorClient.NotifyErrorStatus request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("NotifyErrorStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoEncodeAcceleratorClientProxy::NotifyEncoderInfoChange(
    const ::media::VideoEncoderInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoEncodeAcceleratorClient::NotifyEncoderInfoChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::VideoEncoderInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoEncoderInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in VideoEncodeAcceleratorClient.NotifyEncoderInfoChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEncodeAcceleratorClient::Name_);
  message.set_method_name("NotifyEncoderInfoChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoEncodeAcceleratorClientStubDispatch::Accept(
    VideoEncodeAcceleratorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEncodeAcceleratorClient>(message->header()->name)) {
    case messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorClient.0
      bool success = true;
      uint32_t p_input_count{};
      ::gfx::Size p_input_coded_size{};
      uint32_t p_output_buffer_size{};
      VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_input_count = input_data_view.input_count();
      if (success && !input_data_view.ReadInputCodedSize(&p_input_coded_size))
        success = false;
      if (success)
        p_output_buffer_size = input_data_view.output_buffer_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequireBitstreamBuffers(        
        std::move(p_input_count), 
        std::move(p_input_coded_size), 
        std::move(p_output_buffer_size));
      return true;
    }
    case messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorClient.1
      bool success = true;
      int32_t p_bitstream_buffer_id{};
      ::media::BitstreamBufferMetadata p_metadata{};
      VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_bitstream_buffer_id = input_data_view.bitstream_buffer_id();
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BitstreamBufferReady(        
        std::move(p_bitstream_buffer_id), 
        std::move(p_metadata));
      return true;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorClient.2
      bool success = true;
      ::media::EncoderStatus p_status{};
      VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyErrorStatus(        
        std::move(p_status));
      return true;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange: {
      DCHECK(message->is_serialized());
      internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* params =
          reinterpret_cast<internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoEncodeAcceleratorClient.3
      bool success = true;
      ::media::VideoEncoderInfo p_info{};
      VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEncodeAcceleratorClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyEncoderInfoChange(        
        std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool VideoEncodeAcceleratorClientStubDispatch::AcceptWithResponder(
    VideoEncodeAcceleratorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEncodeAcceleratorClient>(message->header()->name)) {
    case messages::VideoEncodeAcceleratorClient::kRequireBitstreamBuffers: {
      break;
    }
    case messages::VideoEncodeAcceleratorClient::kBitstreamBufferReady: {
      break;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyErrorStatus: {
      break;
    }
    case messages::VideoEncodeAcceleratorClient::kNotifyEncoderInfoChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoEncodeAcceleratorClientValidationInfo[] = {
    { &internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoEncodeAcceleratorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoEncodeAcceleratorClient::Name_,
    kVideoEncodeAcceleratorClientValidationInfo);
}



}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView, ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr>::Read(
    ::media::mojom::VideoEncodeAcceleratorSupportedProfile::DataView input,
    ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr* output) {
  bool success = true;
  ::media::mojom::VideoEncodeAcceleratorSupportedProfilePtr result(::media::mojom::VideoEncodeAcceleratorSupportedProfile::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadMinResolution(&result->min_resolution))
        success = false;
      if (success && !input.ReadMaxResolution(&result->max_resolution))
        success = false;
      if (success)
        result->max_framerate_numerator = input.max_framerate_numerator();
      if (success)
        result->max_framerate_denominator = input.max_framerate_denominator();
      if (success && !input.ReadRateControlModes(&result->rate_control_modes))
        success = false;
      if (success && !input.ReadScalabilityModes(&result->scalability_modes))
        success = false;
      if (success)
        result->is_software_codec = input.is_software_codec();
      if (success && !input.ReadGpuSupportedPixelFormats(&result->gpu_supported_pixel_formats))
        success = false;
      if (success)
        result->supports_gpu_shared_images = input.supports_gpu_shared_images();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EncodeCommandBufferId::DataView, ::media::mojom::EncodeCommandBufferIdPtr>::Read(
    ::media::mojom::EncodeCommandBufferId::DataView input,
    ::media::mojom::EncodeCommandBufferIdPtr* output) {
  bool success = true;
  ::media::mojom::EncodeCommandBufferIdPtr result(::media::mojom::EncodeCommandBufferId::New());
  
      if (success && !input.ReadChannelToken(&result->channel_token))
        success = false;
      if (success)
        result->route_id = input.route_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VariableBitratePeak::DataView, ::media::mojom::VariableBitratePeakPtr>::Read(
    ::media::mojom::VariableBitratePeak::DataView input,
    ::media::mojom::VariableBitratePeakPtr* output) {
  bool success = true;
  ::media::mojom::VariableBitratePeakPtr result(::media::mojom::VariableBitratePeak::New());
  
      if (success)
        result->bps = input.bps();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoBitrateAllocation::DataView, ::media::mojom::VideoBitrateAllocationPtr>::Read(
    ::media::mojom::VideoBitrateAllocation::DataView input,
    ::media::mojom::VideoBitrateAllocationPtr* output) {
  bool success = true;
  ::media::mojom::VideoBitrateAllocationPtr result(::media::mojom::VideoBitrateAllocation::New());
  
      if (success && !input.ReadBitrates(&result->bitrates))
        success = false;
      if (success && !input.ReadVariableBitratePeak(&result->variable_bitrate_peak))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SpatialLayer::DataView, ::media::mojom::SpatialLayerPtr>::Read(
    ::media::mojom::SpatialLayer::DataView input,
    ::media::mojom::SpatialLayerPtr* output) {
  bool success = true;
  ::media::mojom::SpatialLayerPtr result(::media::mojom::SpatialLayer::New());
  
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success)
        result->bitrate_bps = input.bitrate_bps();
      if (success)
        result->framerate = input.framerate();
      if (success)
        result->max_qp = input.max_qp();
      if (success)
        result->num_of_temporal_layers = input.num_of_temporal_layers();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::ConstantBitrate::DataView, ::media::mojom::ConstantBitratePtr>::Read(
    ::media::mojom::ConstantBitrate::DataView input,
    ::media::mojom::ConstantBitratePtr* output) {
  bool success = true;
  ::media::mojom::ConstantBitratePtr result(::media::mojom::ConstantBitrate::New());
  
      if (success)
        result->target_bps = input.target_bps();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VariableBitrate::DataView, ::media::mojom::VariableBitratePtr>::Read(
    ::media::mojom::VariableBitrate::DataView input,
    ::media::mojom::VariableBitratePtr* output) {
  bool success = true;
  ::media::mojom::VariableBitratePtr result(::media::mojom::VariableBitrate::New());
  
      if (success)
        result->target_bps = input.target_bps();
      if (success)
        result->peak_bps = input.peak_bps();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::ExternalBitrate::DataView, ::media::mojom::ExternalBitratePtr>::Read(
    ::media::mojom::ExternalBitrate::DataView input,
    ::media::mojom::ExternalBitratePtr* output) {
  bool success = true;
  ::media::mojom::ExternalBitratePtr result(::media::mojom::ExternalBitrate::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEncodeAcceleratorConfig::DataView, ::media::mojom::VideoEncodeAcceleratorConfigPtr>::Read(
    ::media::mojom::VideoEncodeAcceleratorConfig::DataView input,
    ::media::mojom::VideoEncodeAcceleratorConfigPtr* output) {
  bool success = true;
  ::media::mojom::VideoEncodeAcceleratorConfigPtr result(::media::mojom::VideoEncodeAcceleratorConfig::New());
  
      if (success && !input.ReadInputFormat(&result->input_format))
        success = false;
      if (success && !input.ReadInputVisibleSize(&result->input_visible_size))
        success = false;
      if (success && !input.ReadOutputProfile(&result->output_profile))
        success = false;
      if (success && !input.ReadBitrate(&result->bitrate))
        success = false;
      if (success)
        result->framerate = input.framerate();
      if (success && !input.ReadStorageType(&result->storage_type))
        success = false;
      if (success && !input.ReadContentType(&result->content_type))
        success = false;
      if (success)
        result->gop_length = input.gop_length();
      if (success)
        result->has_gop_length = input.has_gop_length();
      if (success)
        result->h264_output_level = input.h264_output_level();
      if (success)
        result->has_h264_output_level = input.has_h264_output_level();
      if (success)
        result->is_constrained_h264 = input.is_constrained_h264();
      if (success)
        result->drop_frame_thresh_percentage = input.drop_frame_thresh_percentage();
      if (success && !input.ReadSpatialLayers(&result->spatial_layers))
        success = false;
      if (success && !input.ReadInterLayerPred(&result->inter_layer_pred))
        success = false;
      if (success)
        result->require_low_delay = input.require_low_delay();
      if (success && !input.ReadRequiredEncoderType(&result->required_encoder_type))
        success = false;
      if (success)
        result->manual_reference_buffer_control = input.manual_reference_buffer_control();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEncodeOptions::DataView, ::media::mojom::VideoEncodeOptionsPtr>::Read(
    ::media::mojom::VideoEncodeOptions::DataView input,
    ::media::mojom::VideoEncodeOptionsPtr* output) {
  bool success = true;
  ::media::mojom::VideoEncodeOptionsPtr result(::media::mojom::VideoEncodeOptions::New());
  
      if (success)
        result->force_keyframe = input.force_keyframe();
      if (success)
        result->quantizer = input.quantizer();
      if (success) {
        result->update_buffer = input.update_buffer();
      }
      if (success && !input.ReadReferenceBuffers(&result->reference_buffers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DropFrameMetadata::DataView, ::media::mojom::DropFrameMetadataPtr>::Read(
    ::media::mojom::DropFrameMetadata::DataView input,
    ::media::mojom::DropFrameMetadataPtr* output) {
  bool success = true;
  ::media::mojom::DropFrameMetadataPtr result(::media::mojom::DropFrameMetadata::New());
  
      if (success)
        result->spatial_idx = input.spatial_idx();
      if (success)
        result->end_of_picture = input.end_of_picture();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::H264Metadata::DataView, ::media::mojom::H264MetadataPtr>::Read(
    ::media::mojom::H264Metadata::DataView input,
    ::media::mojom::H264MetadataPtr* output) {
  bool success = true;
  ::media::mojom::H264MetadataPtr result(::media::mojom::H264Metadata::New());
  
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->layer_sync = input.layer_sync();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Vp8Metadata::DataView, ::media::mojom::Vp8MetadataPtr>::Read(
    ::media::mojom::Vp8Metadata::DataView input,
    ::media::mojom::Vp8MetadataPtr* output) {
  bool success = true;
  ::media::mojom::Vp8MetadataPtr result(::media::mojom::Vp8Metadata::New());
  
      if (success)
        result->non_reference = input.non_reference();
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->layer_sync = input.layer_sync();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::Vp9Metadata::DataView, ::media::mojom::Vp9MetadataPtr>::Read(
    ::media::mojom::Vp9Metadata::DataView input,
    ::media::mojom::Vp9MetadataPtr* output) {
  bool success = true;
  ::media::mojom::Vp9MetadataPtr result(::media::mojom::Vp9Metadata::New());
  
      if (success)
        result->inter_pic_predicted = input.inter_pic_predicted();
      if (success)
        result->temporal_up_switch = input.temporal_up_switch();
      if (success)
        result->referenced_by_upper_spatial_layers = input.referenced_by_upper_spatial_layers();
      if (success)
        result->reference_lower_spatial_layers = input.reference_lower_spatial_layers();
      if (success)
        result->end_of_picture = input.end_of_picture();
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->spatial_idx = input.spatial_idx();
      if (success && !input.ReadSpatialLayerResolutions(&result->spatial_layer_resolutions))
        success = false;
      if (success)
        result->begin_active_spatial_layer_index = input.begin_active_spatial_layer_index();
      if (success)
        result->end_active_spatial_layer_index = input.end_active_spatial_layer_index();
      if (success && !input.ReadPDiffs(&result->p_diffs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SVCGenericMetadata::DataView, ::media::mojom::SVCGenericMetadataPtr>::Read(
    ::media::mojom::SVCGenericMetadata::DataView input,
    ::media::mojom::SVCGenericMetadataPtr* output) {
  bool success = true;
  ::media::mojom::SVCGenericMetadataPtr result(::media::mojom::SVCGenericMetadata::New());
  
      if (success)
        result->follow_svc_spec = input.follow_svc_spec();
      if (success)
        result->temporal_idx = input.temporal_idx();
      if (success)
        result->spatial_idx = input.spatial_idx();
      if (success) {
        result->reference_flags = input.reference_flags();
      }
      if (success) {
        result->refresh_flags = input.refresh_flags();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::BitstreamBufferMetadata::DataView, ::media::mojom::BitstreamBufferMetadataPtr>::Read(
    ::media::mojom::BitstreamBufferMetadata::DataView input,
    ::media::mojom::BitstreamBufferMetadataPtr* output) {
  bool success = true;
  ::media::mojom::BitstreamBufferMetadataPtr result(::media::mojom::BitstreamBufferMetadata::New());
  
      if (success)
        result->payload_size_bytes = input.payload_size_bytes();
      if (success)
        result->key_frame = input.key_frame();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success)
        result->qp = input.qp();
      if (success && !input.ReadOptionalMetadata(&result->optional_metadata))
        success = false;
      if (success && !input.ReadSvcGeneric(&result->svc_generic))
        success = false;
      if (success && !input.ReadEncodedSize(&result->encoded_size))
        success = false;
      if (success && !input.ReadEncodedColorSpace(&result->encoded_color_space))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::Bitrate::DataView, ::media::mojom::BitratePtr>::Read(
    ::media::mojom::Bitrate::DataView input,
    ::media::mojom::BitratePtr* output) {
  using UnionType = ::media::mojom::Bitrate;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kConstant: {
      ::media::Bitrate result_constant{};
      if (!input.ReadConstant(&result_constant))
        return false;

      *output = UnionType::NewConstant(
          std::move(result_constant));
      break;
    }
    case Tag::kVariable: {
      ::media::Bitrate result_variable{};
      if (!input.ReadVariable(&result_variable))
        return false;

      *output = UnionType::NewVariable(
          std::move(result_variable));
      break;
    }
    case Tag::kExternal: {
      ::media::mojom::ExternalBitratePtr result_external{};
      if (!input.ReadExternal(&result_external))
        return false;

      *output = UnionType::NewExternal(
          std::move(result_external));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::media::mojom::OptionalMetadata::DataView, ::media::mojom::OptionalMetadataPtr>::Read(
    ::media::mojom::OptionalMetadata::DataView input,
    ::media::mojom::OptionalMetadataPtr* output) {
  using UnionType = ::media::mojom::OptionalMetadata;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDrop: {
      ::media::mojom::DropFrameMetadataPtr result_drop{};
      if (!input.ReadDrop(&result_drop))
        return false;

      *output = UnionType::NewDrop(
          std::move(result_drop));
      break;
    }
    case Tag::kH264: {
      ::media::mojom::H264MetadataPtr result_h264{};
      if (!input.ReadH264(&result_h264))
        return false;

      *output = UnionType::NewH264(
          std::move(result_h264));
      break;
    }
    case Tag::kVp8: {
      ::media::Vp8Metadata result_vp8{};
      if (!input.ReadVp8(&result_vp8))
        return false;

      *output = UnionType::NewVp8(
          std::move(result_vp8));
      break;
    }
    case Tag::kVp9: {
      ::media::Vp9Metadata result_vp9{};
      if (!input.ReadVp9(&result_vp9))
        return false;

      *output = UnionType::NewVp9(
          std::move(result_vp9));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void VideoEncodeAcceleratorProviderInterceptorForTesting::CreateVideoEncodeAccelerator(EncodeCommandBufferIdPtr command_buffer_id, ::mojo::PendingReceiver<VideoEncodeAccelerator> receiver) {
  GetForwardingInterface()->CreateVideoEncodeAccelerator(
    std::move(command_buffer_id)
    , 
    std::move(receiver)
    );
}
void VideoEncodeAcceleratorProviderInterceptorForTesting::GetVideoEncodeAcceleratorSupportedProfiles(GetVideoEncodeAcceleratorSupportedProfilesCallback callback) {
  GetForwardingInterface()->GetVideoEncodeAcceleratorSupportedProfiles(std::move(callback));
}
VideoEncodeAcceleratorProviderAsyncWaiter::VideoEncodeAcceleratorProviderAsyncWaiter(
    VideoEncodeAcceleratorProvider* proxy) : proxy_(proxy) {}

VideoEncodeAcceleratorProviderAsyncWaiter::~VideoEncodeAcceleratorProviderAsyncWaiter() = default;


void VideoEncodeAcceleratorProviderAsyncWaiter::GetVideoEncodeAcceleratorSupportedProfiles(
    std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_profiles) {
  base::RunLoop loop;
  proxy_->GetVideoEncodeAcceleratorSupportedProfiles(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoEncodeAccelerator::SupportedProfile>* out_profiles
,
             const std::vector<::media::VideoEncodeAccelerator::SupportedProfile>& profiles) {*out_profiles = std::move(profiles);
            loop->Quit();
          },
          &loop,
          out_profiles));
  loop.Run();
}

std::vector<::media::VideoEncodeAccelerator::SupportedProfile> VideoEncodeAcceleratorProviderAsyncWaiter::GetVideoEncodeAcceleratorSupportedProfiles(
    ) {
  std::vector<::media::VideoEncodeAccelerator::SupportedProfile> async_wait_result;
  GetVideoEncodeAcceleratorSupportedProfiles(&async_wait_result);
  return async_wait_result;
}




void VideoEncodeAcceleratorInterceptorForTesting::Initialize(const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(config)
    , 
    std::move(client)
    , 
    std::move(media_log)
    , std::move(callback));
}
void VideoEncodeAcceleratorInterceptorForTesting::Encode(const ::scoped_refptr<::media::VideoFrame>& frame, const ::media::VideoEncoder::EncodeOptions& options, EncodeCallback callback) {
  GetForwardingInterface()->Encode(
    std::move(frame)
    , 
    std::move(options)
    , std::move(callback));
}
void VideoEncodeAcceleratorInterceptorForTesting::UseOutputBitstreamBuffer(int32_t bitstream_buffer_id, ::base::UnsafeSharedMemoryRegion region) {
  GetForwardingInterface()->UseOutputBitstreamBuffer(
    std::move(bitstream_buffer_id)
    , 
    std::move(region)
    );
}
void VideoEncodeAcceleratorInterceptorForTesting::RequestEncodingParametersChangeWithLayers(const ::media::VideoBitrateAllocation& bitrate_allocation, uint32_t framerate, const std::optional<::gfx::Size>& size) {
  GetForwardingInterface()->RequestEncodingParametersChangeWithLayers(
    std::move(bitrate_allocation)
    , 
    std::move(framerate)
    , 
    std::move(size)
    );
}
void VideoEncodeAcceleratorInterceptorForTesting::RequestEncodingParametersChangeWithBitrate(const ::media::Bitrate& bitrate, uint32_t framerate, const std::optional<::gfx::Size>& size) {
  GetForwardingInterface()->RequestEncodingParametersChangeWithBitrate(
    std::move(bitrate)
    , 
    std::move(framerate)
    , 
    std::move(size)
    );
}
void VideoEncodeAcceleratorInterceptorForTesting::IsFlushSupported(IsFlushSupportedCallback callback) {
  GetForwardingInterface()->IsFlushSupported(std::move(callback));
}
void VideoEncodeAcceleratorInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
VideoEncodeAcceleratorAsyncWaiter::VideoEncodeAcceleratorAsyncWaiter(
    VideoEncodeAccelerator* proxy) : proxy_(proxy) {}

VideoEncodeAcceleratorAsyncWaiter::~VideoEncodeAcceleratorAsyncWaiter() = default;


void VideoEncodeAcceleratorAsyncWaiter::Initialize(
    const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log, ::media::EncoderStatus* out_result) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(config),
      std::move(client),
      std::move(media_log),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::EncoderStatus* out_result
,
             const ::media::EncoderStatus& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::media::EncoderStatus VideoEncodeAcceleratorAsyncWaiter::Initialize(
    const ::media::VideoEncodeAccelerator::Config& config, ::mojo::PendingAssociatedRemote<VideoEncodeAcceleratorClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log) {
  ::media::EncoderStatus async_wait_result;
  Initialize(std::move(config),std::move(client),std::move(media_log),&async_wait_result);
  return async_wait_result;
}

void VideoEncodeAcceleratorAsyncWaiter::Encode(
    const ::scoped_refptr<::media::VideoFrame>& frame, const ::media::VideoEncoder::EncodeOptions& options) {
  base::RunLoop loop;
  proxy_->Encode(
      std::move(frame),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void VideoEncodeAcceleratorAsyncWaiter::IsFlushSupported(
    bool* out_result) {
  base::RunLoop loop;
  proxy_->IsFlushSupported(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool VideoEncodeAcceleratorAsyncWaiter::IsFlushSupported(
    ) {
  bool async_wait_result;
  IsFlushSupported(&async_wait_result);
  return async_wait_result;
}

void VideoEncodeAcceleratorAsyncWaiter::Flush(
    bool* out_result) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool VideoEncodeAcceleratorAsyncWaiter::Flush(
    ) {
  bool async_wait_result;
  Flush(&async_wait_result);
  return async_wait_result;
}




void VideoEncodeAcceleratorClientInterceptorForTesting::RequireBitstreamBuffers(uint32_t input_count, const ::gfx::Size& input_coded_size, uint32_t output_buffer_size) {
  GetForwardingInterface()->RequireBitstreamBuffers(
    std::move(input_count)
    , 
    std::move(input_coded_size)
    , 
    std::move(output_buffer_size)
    );
}
void VideoEncodeAcceleratorClientInterceptorForTesting::BitstreamBufferReady(int32_t bitstream_buffer_id, const ::media::BitstreamBufferMetadata& metadata) {
  GetForwardingInterface()->BitstreamBufferReady(
    std::move(bitstream_buffer_id)
    , 
    std::move(metadata)
    );
}
void VideoEncodeAcceleratorClientInterceptorForTesting::NotifyErrorStatus(const ::media::EncoderStatus& status) {
  GetForwardingInterface()->NotifyErrorStatus(
    std::move(status)
    );
}
void VideoEncodeAcceleratorClientInterceptorForTesting::NotifyEncoderInfoChange(const ::media::VideoEncoderInfo& info) {
  GetForwardingInterface()->NotifyEncoderInfoChange(
    std::move(info)
    );
}
VideoEncodeAcceleratorClientAsyncWaiter::VideoEncodeAcceleratorClientAsyncWaiter(
    VideoEncodeAcceleratorClient* proxy) : proxy_(proxy) {}

VideoEncodeAcceleratorClientAsyncWaiter::~VideoEncodeAcceleratorClientAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif