// media/mojo/mojom/video_encode_accelerator.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::EncodeCommandBufferId_Data> command_buffer_id;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data>;

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data();
  ~VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data) == 24,
              "Bad sizeof(VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data)");
class  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data>;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data();
  ~VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data) == 8,
              "Bad sizeof(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data)");
class  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::VideoEncodeAcceleratorSupportedProfile_Data>>> profiles;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data>;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data();
  ~VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data) == 16,
              "Bad sizeof(VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data)");
class  VideoEncodeAccelerator_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VideoEncodeAcceleratorConfig_Data> config;
  mojo::internal::AssociatedInterface_Data client;
  mojo::internal::Interface_Data media_log;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Initialize_Params_Data>;

  VideoEncodeAccelerator_Initialize_Params_Data();
  ~VideoEncodeAccelerator_Initialize_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Initialize_Params_Data) == 32,
              "Bad sizeof(VideoEncodeAccelerator_Initialize_Params_Data)");
class  VideoEncodeAccelerator_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::EncoderStatus_Data> result;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Initialize_ResponseParams_Data>;

  VideoEncodeAccelerator_Initialize_ResponseParams_Data();
  ~VideoEncodeAccelerator_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Initialize_ResponseParams_Data) == 16,
              "Bad sizeof(VideoEncodeAccelerator_Initialize_ResponseParams_Data)");
class  VideoEncodeAccelerator_Encode_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoFrame_Data> frame;
  mojo::internal::Pointer<internal::VideoEncodeOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Encode_Params_Data>;

  VideoEncodeAccelerator_Encode_Params_Data();
  ~VideoEncodeAccelerator_Encode_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Encode_Params_Data) == 24,
              "Bad sizeof(VideoEncodeAccelerator_Encode_Params_Data)");
class  VideoEncodeAccelerator_Encode_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Encode_ResponseParams_Data>;

  VideoEncodeAccelerator_Encode_ResponseParams_Data();
  ~VideoEncodeAccelerator_Encode_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Encode_ResponseParams_Data) == 8,
              "Bad sizeof(VideoEncodeAccelerator_Encode_ResponseParams_Data)");
class  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t bitstream_buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnsafeSharedMemoryRegion_Data> region;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data>;

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data();
  ~VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data) == 24,
              "Bad sizeof(VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data)");
class  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VideoBitrateAllocation_Data> bitrate_allocation;
  uint32_t framerate;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data>;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data();
  ~VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data) == 32,
              "Bad sizeof(VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data)");
class  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::Bitrate_Data bitrate;
  uint32_t framerate;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data>;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data();
  ~VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data) == 40,
              "Bad sizeof(VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data)");
class  VideoEncodeAccelerator_IsFlushSupported_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_IsFlushSupported_Params_Data>;

  VideoEncodeAccelerator_IsFlushSupported_Params_Data();
  ~VideoEncodeAccelerator_IsFlushSupported_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_IsFlushSupported_Params_Data) == 8,
              "Bad sizeof(VideoEncodeAccelerator_IsFlushSupported_Params_Data)");
class  VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data>;

  VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data();
  ~VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data) == 16,
              "Bad sizeof(VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data)");
class  VideoEncodeAccelerator_Flush_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Flush_Params_Data>;

  VideoEncodeAccelerator_Flush_Params_Data();
  ~VideoEncodeAccelerator_Flush_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Flush_Params_Data) == 8,
              "Bad sizeof(VideoEncodeAccelerator_Flush_Params_Data)");
class  VideoEncodeAccelerator_Flush_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAccelerator_Flush_ResponseParams_Data>;

  VideoEncodeAccelerator_Flush_ResponseParams_Data();
  ~VideoEncodeAccelerator_Flush_ResponseParams_Data() = delete;
};
static_assert(sizeof(VideoEncodeAccelerator_Flush_ResponseParams_Data) == 16,
              "Bad sizeof(VideoEncodeAccelerator_Flush_ResponseParams_Data)");
class  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t input_count;
  uint32_t output_buffer_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> input_coded_size;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data>;

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data();
  ~VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data) == 24,
              "Bad sizeof(VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data)");
class  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t bitstream_buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::BitstreamBufferMetadata_Data> metadata;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data>;

  VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data();
  ~VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data) == 24,
              "Bad sizeof(VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data)");
class  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::EncoderStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data>;

  VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data();
  ~VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data) == 16,
              "Bad sizeof(VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data)");
class  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoEncoderInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data>;

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data();
  ~VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data) == 16,
              "Bad sizeof(VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data)");

}  // namespace internal


class VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView {
 public:
  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView() = default;

  VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView(
      internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCommandBufferIdDataView(
      EncodeCommandBufferIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCommandBufferId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::EncodeCommandBufferIdDataView, UserType>(),
    "Attempting to read the optional `command_buffer_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCommandBufferId` instead "
    "of `ReadCommandBufferId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->command_buffer_id.Get();
    return mojo::internal::Deserialize<::media::mojom::EncodeCommandBufferIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsDataView {
 public:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsDataView() = default;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ParamsDataView(
      internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_Params_Data* data_ = nullptr;
};


class VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView {
 public:
  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView() = default;

  VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView(
      internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfilesDataView(
      mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfiles(UserType* output) {
    
    auto* pointer = data_->profiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_Initialize_ParamsDataView {
 public:
  VideoEncodeAccelerator_Initialize_ParamsDataView() = default;

  VideoEncodeAccelerator_Initialize_ParamsDataView(
      internal::VideoEncodeAccelerator_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      VideoEncodeAcceleratorConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::VideoEncodeAcceleratorClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMediaLog() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media::mojom::MediaLogInterfaceBase>>(
            &data_->media_log, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::VideoEncodeAccelerator_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_Initialize_ResponseParamsDataView {
 public:
  VideoEncodeAccelerator_Initialize_ResponseParamsDataView() = default;

  VideoEncodeAccelerator_Initialize_ResponseParamsDataView(
      internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ::media::mojom::EncoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::media::mojom::EncoderStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAccelerator_Initialize_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_Encode_ParamsDataView {
 public:
  VideoEncodeAccelerator_Encode_ParamsDataView() = default;

  VideoEncodeAccelerator_Encode_ParamsDataView(
      internal::VideoEncodeAccelerator_Encode_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameDataView(
      ::media::mojom::VideoFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameDataView>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      VideoEncodeOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoEncodeOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAccelerator_Encode_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_Encode_ResponseParamsDataView {
 public:
  VideoEncodeAccelerator_Encode_ResponseParamsDataView() = default;

  VideoEncodeAccelerator_Encode_ResponseParamsDataView(
      internal::VideoEncodeAccelerator_Encode_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoEncodeAccelerator_Encode_ResponseParams_Data* data_ = nullptr;
};


class VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView {
 public:
  VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView() = default;

  VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView(
      internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t bitstream_buffer_id() const {
    return data_->bitstream_buffer_id;
  }
  inline void GetRegionDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAccelerator_UseOutputBitstreamBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView {
 public:
  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView() = default;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView(
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitrateAllocationDataView(
      VideoBitrateAllocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitrateAllocation(UserType* output) {
    
    auto* pointer = data_->bitrate_allocation.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoBitrateAllocationDataView>(
        pointer, output, message_);
  }
  uint32_t framerate() const {
    return data_->framerate;
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView {
 public:
  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView() = default;

  VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView(
      internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitrateDataView(
      BitrateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitrate(UserType* output) {
    
    auto* pointer = !data_->bitrate.is_null() ? &data_->bitrate : nullptr;
    return mojo::internal::Deserialize<::media::mojom::BitrateDataView>(
        pointer, output, message_);
  }
  uint32_t framerate() const {
    return data_->framerate;
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAccelerator_IsFlushSupported_ParamsDataView {
 public:
  VideoEncodeAccelerator_IsFlushSupported_ParamsDataView() = default;

  VideoEncodeAccelerator_IsFlushSupported_ParamsDataView(
      internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoEncodeAccelerator_IsFlushSupported_Params_Data* data_ = nullptr;
};


class VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView {
 public:
  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView() = default;

  VideoEncodeAccelerator_IsFlushSupported_ResponseParamsDataView(
      internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool result() const {
    return data_->result;
  }
 private:
  internal::VideoEncodeAccelerator_IsFlushSupported_ResponseParams_Data* data_ = nullptr;
};


class VideoEncodeAccelerator_Flush_ParamsDataView {
 public:
  VideoEncodeAccelerator_Flush_ParamsDataView() = default;

  VideoEncodeAccelerator_Flush_ParamsDataView(
      internal::VideoEncodeAccelerator_Flush_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::VideoEncodeAccelerator_Flush_Params_Data* data_ = nullptr;
};


class VideoEncodeAccelerator_Flush_ResponseParamsDataView {
 public:
  VideoEncodeAccelerator_Flush_ResponseParamsDataView() = default;

  VideoEncodeAccelerator_Flush_ResponseParamsDataView(
      internal::VideoEncodeAccelerator_Flush_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool result() const {
    return data_->result;
  }
 private:
  internal::VideoEncodeAccelerator_Flush_ResponseParams_Data* data_ = nullptr;
};


class VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView {
 public:
  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView() = default;

  VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView(
      internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t input_count() const {
    return data_->input_count;
  }
  inline void GetInputCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputCodedSize(UserType* output) {
    
    auto* pointer = data_->input_coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  uint32_t output_buffer_size() const {
    return data_->output_buffer_size;
  }
 private:
  internal::VideoEncodeAcceleratorClient_RequireBitstreamBuffers_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView {
 public:
  VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView() = default;

  VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView(
      internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t bitstream_buffer_id() const {
    return data_->bitstream_buffer_id;
  }
  inline void GetMetadataDataView(
      BitstreamBufferMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::mojom::BitstreamBufferMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAcceleratorClient_BitstreamBufferReady_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsDataView {
 public:
  VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsDataView() = default;

  VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsDataView(
      internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::mojom::EncoderStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::EncoderStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAcceleratorClient_NotifyErrorStatus_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView {
 public:
  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView() = default;

  VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView(
      internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::media::mojom::VideoEncoderInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoEncoderInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void VideoEncodeAcceleratorProvider_CreateVideoEncodeAccelerator_ParamsDataView::GetCommandBufferIdDataView(
    EncodeCommandBufferIdDataView* output) {
  auto pointer = data_->command_buffer_id.Get();
  *output = EncodeCommandBufferIdDataView(pointer, message_);
}




inline void VideoEncodeAcceleratorProvider_GetVideoEncodeAcceleratorSupportedProfiles_ResponseParamsDataView::GetProfilesDataView(
    mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>* output) {
  auto pointer = data_->profiles.Get();
  *output = mojo::ArrayDataView<VideoEncodeAcceleratorSupportedProfileDataView>(pointer, message_);
}


inline void VideoEncodeAccelerator_Initialize_ParamsDataView::GetConfigDataView(
    VideoEncodeAcceleratorConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = VideoEncodeAcceleratorConfigDataView(pointer, message_);
}


inline void VideoEncodeAccelerator_Initialize_ResponseParamsDataView::GetResultDataView(
    ::media::mojom::EncoderStatusDataView* output) {
  auto pointer = data_->result.Get();
  *output = ::media::mojom::EncoderStatusDataView(pointer, message_);
}


inline void VideoEncodeAccelerator_Encode_ParamsDataView::GetFrameDataView(
    ::media::mojom::VideoFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = ::media::mojom::VideoFrameDataView(pointer, message_);
}
inline void VideoEncodeAccelerator_Encode_ParamsDataView::GetOptionsDataView(
    VideoEncodeOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = VideoEncodeOptionsDataView(pointer, message_);
}




inline void VideoEncodeAccelerator_UseOutputBitstreamBuffer_ParamsDataView::GetRegionDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->region.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}


inline void VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView::GetBitrateAllocationDataView(
    VideoBitrateAllocationDataView* output) {
  auto pointer = data_->bitrate_allocation.Get();
  *output = VideoBitrateAllocationDataView(pointer, message_);
}
inline void VideoEncodeAccelerator_RequestEncodingParametersChangeWithLayers_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView::GetBitrateDataView(
    BitrateDataView* output) {
  auto pointer = &data_->bitrate;
  *output = BitrateDataView(pointer, message_);
}
inline void VideoEncodeAccelerator_RequestEncodingParametersChangeWithBitrate_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}










inline void VideoEncodeAcceleratorClient_RequireBitstreamBuffers_ParamsDataView::GetInputCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->input_coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void VideoEncodeAcceleratorClient_BitstreamBufferReady_ParamsDataView::GetMetadataDataView(
    BitstreamBufferMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = BitstreamBufferMetadataDataView(pointer, message_);
}


inline void VideoEncodeAcceleratorClient_NotifyErrorStatus_ParamsDataView::GetStatusDataView(
    ::media::mojom::EncoderStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::EncoderStatusDataView(pointer, message_);
}


inline void VideoEncodeAcceleratorClient_NotifyEncoderInfoChange_ParamsDataView::GetInfoDataView(
    ::media::mojom::VideoEncoderInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::media::mojom::VideoEncoderInfoDataView(pointer, message_);
}



}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_PARAMS_DATA_H_