// media/mojo/mojom/video_decode_stats_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_decode_stats_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_decode_stats_recorder.mojom-params-data.h"
#include "media/mojo/mojom/video_decode_stats_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_decode_stats_recorder.mojom-import-headers.h"
#include "media/mojo/mojom/video_decode_stats_recorder.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

VideoDecodeStatsRecorder::IPCStableHashFunction VideoDecodeStatsRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoDecodeStatsRecorder>(message.name())) {
    case messages::VideoDecodeStatsRecorder::kStartNewRecord: {
      return &VideoDecodeStatsRecorder::StartNewRecord_Sym::IPCStableHash;
    }
    case messages::VideoDecodeStatsRecorder::kUpdateRecord: {
      return &VideoDecodeStatsRecorder::UpdateRecord_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoDecodeStatsRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoDecodeStatsRecorder>(message.name())) {
      case messages::VideoDecodeStatsRecorder::kStartNewRecord:
            return "Receive media::mojom::VideoDecodeStatsRecorder::StartNewRecord";
      case messages::VideoDecodeStatsRecorder::kUpdateRecord:
            return "Receive media::mojom::VideoDecodeStatsRecorder::UpdateRecord";
    }
  } else {
    switch (static_cast<messages::VideoDecodeStatsRecorder>(message.name())) {
      case messages::VideoDecodeStatsRecorder::kStartNewRecord:
            return "Receive reply media::mojom::VideoDecodeStatsRecorder::StartNewRecord";
      case messages::VideoDecodeStatsRecorder::kUpdateRecord:
            return "Receive reply media::mojom::VideoDecodeStatsRecorder::UpdateRecord";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoDecodeStatsRecorder::StartNewRecord_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x184bcba4;  // IPCStableHash for media::mojom::VideoDecodeStatsRecorder::StartNewRecord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoDecodeStatsRecorder::UpdateRecord_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac479c50;  // IPCStableHash for media::mojom::VideoDecodeStatsRecorder::UpdateRecord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoDecodeStatsRecorderProxy::VideoDecodeStatsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoDecodeStatsRecorderProxy::StartNewRecord(
    ::media::mojom::PredictionFeaturesPtr in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecodeStatsRecorder::StartNewRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type ::media::mojom::PredictionFeaturesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecodeStatsRecorder::kStartNewRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType> features_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PredictionFeaturesDataView>(
    in_features,
    features_fragment);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features in VideoDecodeStatsRecorder.StartNewRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecodeStatsRecorder::Name_);
  message.set_method_name("StartNewRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoDecodeStatsRecorderProxy::UpdateRecord(
    ::media::mojom::PredictionTargetsPtr in_targets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoDecodeStatsRecorder::UpdateRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("targets"), in_targets,
                        "<value of type ::media::mojom::PredictionTargetsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoDecodeStatsRecorder::kUpdateRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->targets)::BaseType> targets_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PredictionTargetsDataView>(
    in_targets,
    targets_fragment);

  params->targets.Set(
      targets_fragment.is_null() ? nullptr : targets_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->targets.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null targets in VideoDecodeStatsRecorder.UpdateRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoDecodeStatsRecorder::Name_);
  message.set_method_name("UpdateRecord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoDecodeStatsRecorderStubDispatch::Accept(
    VideoDecodeStatsRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoDecodeStatsRecorder>(message->header()->name)) {
    case messages::VideoDecodeStatsRecorder::kStartNewRecord: {
      DCHECK(message->is_serialized());
      internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data* params =
          reinterpret_cast<internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecodeStatsRecorder.0
      bool success = true;
      ::media::mojom::PredictionFeaturesPtr p_features{};
      VideoDecodeStatsRecorder_StartNewRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecodeStatsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNewRecord(        
        std::move(p_features));
      return true;
    }
    case messages::VideoDecodeStatsRecorder::kUpdateRecord: {
      DCHECK(message->is_serialized());
      internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data* params =
          reinterpret_cast<internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoDecodeStatsRecorder.1
      bool success = true;
      ::media::mojom::PredictionTargetsPtr p_targets{};
      VideoDecodeStatsRecorder_UpdateRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargets(&p_targets))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoDecodeStatsRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRecord(        
        std::move(p_targets));
      return true;
    }
  }
  return false;
}

// static
bool VideoDecodeStatsRecorderStubDispatch::AcceptWithResponder(
    VideoDecodeStatsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoDecodeStatsRecorder>(message->header()->name)) {
    case messages::VideoDecodeStatsRecorder::kStartNewRecord: {
      break;
    }
    case messages::VideoDecodeStatsRecorder::kUpdateRecord: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoDecodeStatsRecorderValidationInfo[] = {
    { &internal::VideoDecodeStatsRecorder_StartNewRecord_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoDecodeStatsRecorder_UpdateRecord_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoDecodeStatsRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoDecodeStatsRecorder::Name_,
    kVideoDecodeStatsRecorderValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void VideoDecodeStatsRecorderInterceptorForTesting::StartNewRecord(::media::mojom::PredictionFeaturesPtr features) {
  GetForwardingInterface()->StartNewRecord(
    std::move(features)
    );
}
void VideoDecodeStatsRecorderInterceptorForTesting::UpdateRecord(::media::mojom::PredictionTargetsPtr targets) {
  GetForwardingInterface()->UpdateRecord(
    std::move(targets)
    );
}
VideoDecodeStatsRecorderAsyncWaiter::VideoDecodeStatsRecorderAsyncWaiter(
    VideoDecodeStatsRecorder* proxy) : proxy_(proxy) {}

VideoDecodeStatsRecorderAsyncWaiter::~VideoDecodeStatsRecorderAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif