// media/mojo/mojom/speech_recognizer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognizer.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognizer.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognizer.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_audio_forwarder.mojom-forward.h"
#include "media/mojo/mojom/speech_recognition_error.mojom-forward.h"
#include "media/mojo/mojom/speech_recognition_grammar.mojom.h"
#include "media/mojo/mojom/speech_recognition_result.mojom-forward.h"
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class SpeechRecognizerProxy;

template <typename ImplRefTraits>
class SpeechRecognizerStub;

class SpeechRecognizerRequestValidator;


class SpeechRecognizer
    : public SpeechRecognizerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognizer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognizerInterfaceBase;
  using Proxy_ = SpeechRecognizerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognizerStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognizerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognizer() = default;

  virtual void Start(StartSpeechRecognitionRequestParamsPtr params) = 0;
};

class OnDeviceSpeechRecognitionProxy;

template <typename ImplRefTraits>
class OnDeviceSpeechRecognitionStub;

class OnDeviceSpeechRecognitionRequestValidator;
class OnDeviceSpeechRecognitionResponseValidator;


class OnDeviceSpeechRecognition
    : public OnDeviceSpeechRecognitionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.OnDeviceSpeechRecognition";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OnDeviceSpeechRecognitionInterfaceBase;
  using Proxy_ = OnDeviceSpeechRecognitionProxy;

  template <typename ImplRefTraits>
  using Stub_ = OnDeviceSpeechRecognitionStub<ImplRefTraits>;

  using RequestValidator_ = OnDeviceSpeechRecognitionRequestValidator;
  using ResponseValidator_ = OnDeviceSpeechRecognitionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAvailableMinVersion = 0,
    kInstallMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Available_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Install_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OnDeviceSpeechRecognition() = default;

  using AvailableCallback = base::OnceCallback<void(AvailabilityStatus)>;
  using AvailableMojoCallback = base::OnceCallback<void(AvailabilityStatus)>;

  virtual void Available(const std::vector<std::string>& languages, AvailableCallback callback) = 0;

  using InstallCallback = base::OnceCallback<void(bool)>;
  using InstallMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Install(const std::vector<std::string>& languages, InstallCallback callback) = 0;
};

class SpeechRecognitionSessionProxy;

template <typename ImplRefTraits>
class SpeechRecognitionSessionStub;

class SpeechRecognitionSessionRequestValidator;


class SpeechRecognitionSession
    : public SpeechRecognitionSessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionSession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionSessionInterfaceBase;
  using Proxy_ = SpeechRecognitionSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionSessionStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionSessionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAbortMinVersion = 0,
    kStopCaptureMinVersion = 0,
    kUpdateRecognitionContextMinVersion = 1,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateRecognitionContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionSession() = default;

  virtual void Abort() = 0;

  virtual void StopCapture() = 0;

  virtual void UpdateRecognitionContext(const ::media::SpeechRecognitionRecognitionContext& recognition_context) = 0;
};

class SpeechRecognitionSessionClientProxy;

template <typename ImplRefTraits>
class SpeechRecognitionSessionClientStub;

class SpeechRecognitionSessionClientRequestValidator;


class SpeechRecognitionSessionClient
    : public SpeechRecognitionSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.SpeechRecognitionSessionClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionSessionClientInterfaceBase;
  using Proxy_ = SpeechRecognitionSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResultRetrievedMinVersion = 0,
    kErrorOccurredMinVersion = 0,
    kStartedMinVersion = 0,
    kAudioStartedMinVersion = 0,
    kSoundStartedMinVersion = 0,
    kSoundEndedMinVersion = 0,
    kAudioEndedMinVersion = 0,
    kEndedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResultRetrieved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ErrorOccurred_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Started_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SoundStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SoundEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AudioEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ended_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionSessionClient() = default;

  virtual void ResultRetrieved(std::vector<::media::mojom::WebSpeechRecognitionResultPtr> results) = 0;

  virtual void ErrorOccurred(::media::mojom::SpeechRecognitionErrorPtr error) = 0;

  virtual void Started() = 0;

  virtual void AudioStarted() = 0;

  virtual void SoundStarted() = 0;

  virtual void SoundEnded() = 0;

  virtual void AudioEnded() = 0;

  virtual void Ended() = 0;
};



class  SpeechRecognizerProxy
    : public SpeechRecognizer {
 public:
  using InterfaceType = SpeechRecognizer;

  explicit SpeechRecognizerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(StartSpeechRecognitionRequestParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OnDeviceSpeechRecognitionProxy
    : public OnDeviceSpeechRecognition {
 public:
  using InterfaceType = OnDeviceSpeechRecognition;

  explicit OnDeviceSpeechRecognitionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Available(const std::vector<std::string>& languages, AvailableCallback callback) final;
  
  void Install(const std::vector<std::string>& languages, InstallCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionSessionProxy
    : public SpeechRecognitionSession {
 public:
  using InterfaceType = SpeechRecognitionSession;

  explicit SpeechRecognitionSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Abort() final;
  
  void StopCapture() final;
  
  void UpdateRecognitionContext(const ::media::SpeechRecognitionRecognitionContext& recognition_context) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SpeechRecognitionSessionClientProxy
    : public SpeechRecognitionSessionClient {
 public:
  using InterfaceType = SpeechRecognitionSessionClient;

  explicit SpeechRecognitionSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResultRetrieved(std::vector<::media::mojom::WebSpeechRecognitionResultPtr> results) final;
  
  void ErrorOccurred(::media::mojom::SpeechRecognitionErrorPtr error) final;
  
  void Started() final;
  
  void AudioStarted() final;
  
  void SoundStarted() final;
  
  void SoundEnded() final;
  
  void AudioEnded() final;
  
  void Ended() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SpeechRecognizerStubDispatch {
 public:
  static bool Accept(SpeechRecognizer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognizer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognizer>>
class SpeechRecognizerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognizerStub() = default;
  ~SpeechRecognizerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognizerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognizerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OnDeviceSpeechRecognitionStubDispatch {
 public:
  static bool Accept(OnDeviceSpeechRecognition* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OnDeviceSpeechRecognition* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OnDeviceSpeechRecognition>>
class OnDeviceSpeechRecognitionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OnDeviceSpeechRecognitionStub() = default;
  ~OnDeviceSpeechRecognitionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceSpeechRecognitionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceSpeechRecognitionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionSessionStubDispatch {
 public:
  static bool Accept(SpeechRecognitionSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionSession>>
class SpeechRecognitionSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionSessionStub() = default;
  ~SpeechRecognitionSessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognitionSessionClientStubDispatch {
 public:
  static bool Accept(SpeechRecognitionSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionSessionClient>>
class SpeechRecognitionSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionSessionClientStub() = default;
  ~SpeechRecognitionSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SpeechRecognizerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceSpeechRecognitionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SpeechRecognitionSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceSpeechRecognitionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  StartSpeechRecognitionRequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StartSpeechRecognitionRequestParams, T>::value>;
  using DataView = StartSpeechRecognitionRequestParamsDataView;
  using Data_ = internal::StartSpeechRecognitionRequestParams_Data;

  template <typename... Args>
  static StartSpeechRecognitionRequestParamsPtr New(Args&&... args) {
    return StartSpeechRecognitionRequestParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StartSpeechRecognitionRequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<StartSpeechRecognitionRequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StartSpeechRecognitionRequestParams>::Convert(*this);
  }


  StartSpeechRecognitionRequestParams();

  StartSpeechRecognitionRequestParams(
      ::mojo::PendingReceiver<SpeechRecognitionSession> session_receiver,
      ::mojo::PendingRemote<SpeechRecognitionSessionClient> client,
      const std::string& language,
      std::vector<::media::mojom::SpeechRecognitionGrammarPtr> grammars,
      const std::optional<::media::SpeechRecognitionRecognitionContext>& recognition_context,
      uint32_t max_hypotheses,
      bool continuous,
      bool interim_results,
      bool on_device,
      bool allow_cloud_fallback,
      ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> audio_forwarder,
      int32_t channel_count,
      int32_t sample_rate);

StartSpeechRecognitionRequestParams(const StartSpeechRecognitionRequestParams&) = delete;
StartSpeechRecognitionRequestParams& operator=(const StartSpeechRecognitionRequestParams&) = delete;

  ~StartSpeechRecognitionRequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StartSpeechRecognitionRequestParamsPtr>
  StartSpeechRecognitionRequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StartSpeechRecognitionRequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StartSpeechRecognitionRequestParams_UnserializedMessageContext<
            UserType, StartSpeechRecognitionRequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StartSpeechRecognitionRequestParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StartSpeechRecognitionRequestParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StartSpeechRecognitionRequestParams_UnserializedMessageContext<
            UserType, StartSpeechRecognitionRequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StartSpeechRecognitionRequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingReceiver<SpeechRecognitionSession> session_receiver;
  
  ::mojo::PendingRemote<SpeechRecognitionSessionClient> client;
  
  std::string language;
  
  std::vector<::media::mojom::SpeechRecognitionGrammarPtr> grammars;
  
  std::optional<::media::SpeechRecognitionRecognitionContext> recognition_context;
  
  uint32_t max_hypotheses;
  
  bool continuous;
  
  bool interim_results;
  
  bool on_device;
  
  bool allow_cloud_fallback;
  
  ::mojo::PendingReceiver<::media::mojom::SpeechRecognitionAudioForwarder> audio_forwarder;
  
  int32_t channel_count;
  
  int32_t sample_rate;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StartSpeechRecognitionRequestParamsPtr StartSpeechRecognitionRequestParams::Clone() const {
  return New(
      mojo::Clone(session_receiver),
      mojo::Clone(client),
      mojo::Clone(language),
      mojo::Clone(grammars),
      mojo::Clone(recognition_context),
      mojo::Clone(max_hypotheses),
      mojo::Clone(continuous),
      mojo::Clone(interim_results),
      mojo::Clone(on_device),
      mojo::Clone(allow_cloud_fallback),
      mojo::Clone(audio_forwarder),
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate)
  );
}

template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>*>
bool StartSpeechRecognitionRequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_receiver, other_struct.session_receiver))
    return false;
  if (!mojo::Equals(this->client, other_struct.client))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->grammars, other_struct.grammars))
    return false;
  if (!mojo::Equals(this->recognition_context, other_struct.recognition_context))
    return false;
  if (!mojo::Equals(this->max_hypotheses, other_struct.max_hypotheses))
    return false;
  if (!mojo::Equals(this->continuous, other_struct.continuous))
    return false;
  if (!mojo::Equals(this->interim_results, other_struct.interim_results))
    return false;
  if (!mojo::Equals(this->on_device, other_struct.on_device))
    return false;
  if (!mojo::Equals(this->allow_cloud_fallback, other_struct.allow_cloud_fallback))
    return false;
  if (!mojo::Equals(this->audio_forwarder, other_struct.audio_forwarder))
    return false;
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  return true;
}

template <typename T, StartSpeechRecognitionRequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_receiver < rhs.session_receiver)
    return true;
  if (rhs.session_receiver < lhs.session_receiver)
    return false;
  if (lhs.client < rhs.client)
    return true;
  if (rhs.client < lhs.client)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.grammars < rhs.grammars)
    return true;
  if (rhs.grammars < lhs.grammars)
    return false;
  if (lhs.recognition_context < rhs.recognition_context)
    return true;
  if (rhs.recognition_context < lhs.recognition_context)
    return false;
  if (lhs.max_hypotheses < rhs.max_hypotheses)
    return true;
  if (rhs.max_hypotheses < lhs.max_hypotheses)
    return false;
  if (lhs.continuous < rhs.continuous)
    return true;
  if (rhs.continuous < lhs.continuous)
    return false;
  if (lhs.interim_results < rhs.interim_results)
    return true;
  if (rhs.interim_results < lhs.interim_results)
    return false;
  if (lhs.on_device < rhs.on_device)
    return true;
  if (rhs.on_device < lhs.on_device)
    return false;
  if (lhs.allow_cloud_fallback < rhs.allow_cloud_fallback)
    return true;
  if (rhs.allow_cloud_fallback < lhs.allow_cloud_fallback)
    return false;
  if (lhs.audio_forwarder < rhs.audio_forwarder)
    return true;
  if (rhs.audio_forwarder < lhs.audio_forwarder)
    return false;
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::StartSpeechRecognitionRequestParams::DataView,
                                         ::media::mojom::StartSpeechRecognitionRequestParamsPtr> {
  static bool IsNull(const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) { return !input; }
  static void SetToNull(::media::mojom::StartSpeechRecognitionRequestParamsPtr* output) { output->reset(); }

  static  decltype(::media::mojom::StartSpeechRecognitionRequestParams::session_receiver)& session_receiver(
       ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->session_receiver;
  }

  static  decltype(::media::mojom::StartSpeechRecognitionRequestParams::client)& client(
       ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->client;
  }

  static const decltype(::media::mojom::StartSpeechRecognitionRequestParams::language)& language(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->language;
  }

  static const decltype(::media::mojom::StartSpeechRecognitionRequestParams::grammars)& grammars(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->grammars;
  }

  static const decltype(::media::mojom::StartSpeechRecognitionRequestParams::recognition_context)& recognition_context(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->recognition_context;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::max_hypotheses) max_hypotheses(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->max_hypotheses;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::continuous) continuous(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->continuous;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::interim_results) interim_results(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->interim_results;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::on_device) on_device(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->on_device;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::allow_cloud_fallback) allow_cloud_fallback(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->allow_cloud_fallback;
  }

  static  decltype(::media::mojom::StartSpeechRecognitionRequestParams::audio_forwarder)& audio_forwarder(
       ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->audio_forwarder;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::channel_count) channel_count(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::StartSpeechRecognitionRequestParams::sample_rate) sample_rate(
      const ::media::mojom::StartSpeechRecognitionRequestParamsPtr& input) {
    return input->sample_rate;
  }

  static bool Read(::media::mojom::StartSpeechRecognitionRequestParams::DataView input, ::media::mojom::StartSpeechRecognitionRequestParamsPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_H_