// media/mojo/mojom/speech_recognizer.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/speech_recognizer.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT SpeechRecognizerInterceptorForTesting : public SpeechRecognizer {
  virtual SpeechRecognizer* GetForwardingInterface() = 0;
  void Start(StartSpeechRecognitionRequestParamsPtr params) override;
};
class BLINK_PLATFORM_EXPORT SpeechRecognizerAsyncWaiter {
 public:
  explicit SpeechRecognizerAsyncWaiter(SpeechRecognizer* proxy);

  SpeechRecognizerAsyncWaiter(const SpeechRecognizerAsyncWaiter&) = delete;
  SpeechRecognizerAsyncWaiter& operator=(const SpeechRecognizerAsyncWaiter&) = delete;

  ~SpeechRecognizerAsyncWaiter();

 private:
  SpeechRecognizer* const proxy_;
};


class BLINK_PLATFORM_EXPORT OnDeviceSpeechRecognitionInterceptorForTesting : public OnDeviceSpeechRecognition {
  virtual OnDeviceSpeechRecognition* GetForwardingInterface() = 0;
  void Available(const ::blink::Vector<::blink::String>& languages, AvailableCallback callback) override;
  void Install(const ::blink::Vector<::blink::String>& languages, InstallCallback callback) override;
};
class BLINK_PLATFORM_EXPORT OnDeviceSpeechRecognitionAsyncWaiter {
 public:
  explicit OnDeviceSpeechRecognitionAsyncWaiter(OnDeviceSpeechRecognition* proxy);

  OnDeviceSpeechRecognitionAsyncWaiter(const OnDeviceSpeechRecognitionAsyncWaiter&) = delete;
  OnDeviceSpeechRecognitionAsyncWaiter& operator=(const OnDeviceSpeechRecognitionAsyncWaiter&) = delete;

  ~OnDeviceSpeechRecognitionAsyncWaiter();
  void Available(
      const ::blink::Vector<::blink::String>& languages, AvailabilityStatus* out_status);
  AvailabilityStatus Available(const ::blink::Vector<::blink::String>& languages);
  void Install(
      const ::blink::Vector<::blink::String>& languages, bool* out_success);
  bool Install(const ::blink::Vector<::blink::String>& languages);

 private:
  OnDeviceSpeechRecognition* const proxy_;
};


class BLINK_PLATFORM_EXPORT SpeechRecognitionSessionInterceptorForTesting : public SpeechRecognitionSession {
  virtual SpeechRecognitionSession* GetForwardingInterface() = 0;
  void Abort() override;
  void StopCapture() override;
  void UpdateRecognitionContext(::media::mojom::blink::SpeechRecognitionRecognitionContextPtr recognition_context) override;
};
class BLINK_PLATFORM_EXPORT SpeechRecognitionSessionAsyncWaiter {
 public:
  explicit SpeechRecognitionSessionAsyncWaiter(SpeechRecognitionSession* proxy);

  SpeechRecognitionSessionAsyncWaiter(const SpeechRecognitionSessionAsyncWaiter&) = delete;
  SpeechRecognitionSessionAsyncWaiter& operator=(const SpeechRecognitionSessionAsyncWaiter&) = delete;

  ~SpeechRecognitionSessionAsyncWaiter();

 private:
  SpeechRecognitionSession* const proxy_;
};


class BLINK_PLATFORM_EXPORT SpeechRecognitionSessionClientInterceptorForTesting : public SpeechRecognitionSessionClient {
  virtual SpeechRecognitionSessionClient* GetForwardingInterface() = 0;
  void ResultRetrieved(::blink::Vector<::media::mojom::blink::WebSpeechRecognitionResultPtr> results) override;
  void ErrorOccurred(::media::mojom::blink::SpeechRecognitionErrorPtr error) override;
  void Started() override;
  void AudioStarted() override;
  void SoundStarted() override;
  void SoundEnded() override;
  void AudioEnded() override;
  void Ended() override;
};
class BLINK_PLATFORM_EXPORT SpeechRecognitionSessionClientAsyncWaiter {
 public:
  explicit SpeechRecognitionSessionClientAsyncWaiter(SpeechRecognitionSessionClient* proxy);

  SpeechRecognitionSessionClientAsyncWaiter(const SpeechRecognitionSessionClientAsyncWaiter&) = delete;
  SpeechRecognitionSessionClientAsyncWaiter& operator=(const SpeechRecognitionSessionClientAsyncWaiter&) = delete;

  ~SpeechRecognitionSessionClientAsyncWaiter();

 private:
  SpeechRecognitionSessionClient* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNIZER_MOJOM_BLINK_TEST_UTILS_H_