// media/mojo/mojom/speech_recognition_result.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_result.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_result.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_result.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>








namespace media::mojom {









class  SpeechRecognitionHypothesis {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionHypothesis, T>::value>;
  using DataView = SpeechRecognitionHypothesisDataView;
  using Data_ = internal::SpeechRecognitionHypothesis_Data;

  template <typename... Args>
  static SpeechRecognitionHypothesisPtr New(Args&&... args) {
    return SpeechRecognitionHypothesisPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionHypothesisPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionHypothesisPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionHypothesis>::Convert(*this);
  }


  SpeechRecognitionHypothesis();

  SpeechRecognitionHypothesis(
      const ::std::u16string& utterance,
      double confidence);


  ~SpeechRecognitionHypothesis();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionHypothesisPtr>
  SpeechRecognitionHypothesisPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionHypothesis::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionHypothesis::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionHypothesis::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionHypothesis_UnserializedMessageContext<
            UserType, SpeechRecognitionHypothesis::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionHypothesis::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionHypothesis::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionHypothesis_UnserializedMessageContext<
            UserType, SpeechRecognitionHypothesis::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionHypothesis::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string utterance;
  
  double confidence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebSpeechRecognitionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebSpeechRecognitionResult, T>::value>;
  using DataView = WebSpeechRecognitionResultDataView;
  using Data_ = internal::WebSpeechRecognitionResult_Data;

  template <typename... Args>
  static WebSpeechRecognitionResultPtr New(Args&&... args) {
    return WebSpeechRecognitionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebSpeechRecognitionResultPtr From(const U& u) {
    return mojo::TypeConverter<WebSpeechRecognitionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebSpeechRecognitionResult>::Convert(*this);
  }


  WebSpeechRecognitionResult();

  WebSpeechRecognitionResult(
      std::vector<SpeechRecognitionHypothesisPtr> hypotheses,
      bool is_provisional);

WebSpeechRecognitionResult(const WebSpeechRecognitionResult&) = delete;
WebSpeechRecognitionResult& operator=(const WebSpeechRecognitionResult&) = delete;

  ~WebSpeechRecognitionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebSpeechRecognitionResultPtr>
  WebSpeechRecognitionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSpeechRecognitionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebSpeechRecognitionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebSpeechRecognitionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebSpeechRecognitionResult_UnserializedMessageContext<
            UserType, WebSpeechRecognitionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebSpeechRecognitionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebSpeechRecognitionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebSpeechRecognitionResult_UnserializedMessageContext<
            UserType, WebSpeechRecognitionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebSpeechRecognitionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SpeechRecognitionHypothesisPtr> hypotheses;
  
  bool is_provisional;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeechRecognitionHypothesisPtr SpeechRecognitionHypothesis::Clone() const {
  return New(
      mojo::Clone(utterance),
      mojo::Clone(confidence)
  );
}

template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>*>
bool SpeechRecognitionHypothesis::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->utterance, other_struct.utterance))
    return false;
  if (!mojo::Equals(this->confidence, other_struct.confidence))
    return false;
  return true;
}

template <typename T, SpeechRecognitionHypothesis::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.utterance < rhs.utterance)
    return true;
  if (rhs.utterance < lhs.utterance)
    return false;
  if (lhs.confidence < rhs.confidence)
    return true;
  if (rhs.confidence < lhs.confidence)
    return false;
  return false;
}
template <typename StructPtrType>
WebSpeechRecognitionResultPtr WebSpeechRecognitionResult::Clone() const {
  return New(
      mojo::Clone(hypotheses),
      mojo::Clone(is_provisional)
  );
}

template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>*>
bool WebSpeechRecognitionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hypotheses, other_struct.hypotheses))
    return false;
  if (!mojo::Equals(this->is_provisional, other_struct.is_provisional))
    return false;
  return true;
}

template <typename T, WebSpeechRecognitionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.hypotheses < rhs.hypotheses)
    return true;
  if (rhs.hypotheses < lhs.hypotheses)
    return false;
  if (lhs.is_provisional < rhs.is_provisional)
    return true;
  if (rhs.is_provisional < lhs.is_provisional)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::SpeechRecognitionHypothesis::DataView,
                                         ::media::mojom::SpeechRecognitionHypothesisPtr> {
  static bool IsNull(const ::media::mojom::SpeechRecognitionHypothesisPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SpeechRecognitionHypothesisPtr* output) { output->reset(); }

  static const decltype(::media::mojom::SpeechRecognitionHypothesis::utterance)& utterance(
      const ::media::mojom::SpeechRecognitionHypothesisPtr& input) {
    return input->utterance;
  }

  static decltype(::media::mojom::SpeechRecognitionHypothesis::confidence) confidence(
      const ::media::mojom::SpeechRecognitionHypothesisPtr& input) {
    return input->confidence;
  }

  static bool Read(::media::mojom::SpeechRecognitionHypothesis::DataView input, ::media::mojom::SpeechRecognitionHypothesisPtr* output);
};


template <>
struct  StructTraits<::media::mojom::WebSpeechRecognitionResult::DataView,
                                         ::media::mojom::WebSpeechRecognitionResultPtr> {
  static bool IsNull(const ::media::mojom::WebSpeechRecognitionResultPtr& input) { return !input; }
  static void SetToNull(::media::mojom::WebSpeechRecognitionResultPtr* output) { output->reset(); }

  static const decltype(::media::mojom::WebSpeechRecognitionResult::hypotheses)& hypotheses(
      const ::media::mojom::WebSpeechRecognitionResultPtr& input) {
    return input->hypotheses;
  }

  static decltype(::media::mojom::WebSpeechRecognitionResult::is_provisional) is_provisional(
      const ::media::mojom::WebSpeechRecognitionResultPtr& input) {
    return input->is_provisional;
  }

  static bool Read(::media::mojom::WebSpeechRecognitionResult::DataView input, ::media::mojom::WebSpeechRecognitionResultPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RESULT_MOJOM_H_