// media/mojo/mojom/speech_recognition.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognition.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var audio_data$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_data.mojom', 'audio_data.mojom.js');
  }
  var speech_recognition_audio_forwarder$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_audio_forwarder.mojom', 'speech_recognition_audio_forwarder.mojom.js');
  }
  var speech_recognition_recognition_context$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_recognition_context.mojom', 'speech_recognition_recognition_context.mojom.js');
  }
  var speech_recognizer$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognizer.mojom', 'speech_recognizer.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var ConfidenceLevel = {};
  ConfidenceLevel.kUnknown = 0;
  ConfidenceLevel.kNotConfident = 1;
  ConfidenceLevel.kConfident = 2;
  ConfidenceLevel.kHighlyConfident = 3;
  ConfidenceLevel.MIN_VALUE = 0;
  ConfidenceLevel.MAX_VALUE = 3;
  ConfidenceLevel.DEFAULT_VALUE = 0;

  ConfidenceLevel.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ConfidenceLevel.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ConfidenceLevel.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AsrSwitchResult = {};
  AsrSwitchResult.kDefaultNoSwitch = 0;
  AsrSwitchResult.kSwitchSucceeded = 1;
  AsrSwitchResult.kSwitchFailed = 2;
  AsrSwitchResult.kSwitchSkipedNoLp = 3;
  AsrSwitchResult.MIN_VALUE = 0;
  AsrSwitchResult.MAX_VALUE = 3;
  AsrSwitchResult.DEFAULT_VALUE = 0;

  AsrSwitchResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AsrSwitchResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AsrSwitchResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SpeechRecognitionMode = {};
  SpeechRecognitionMode.kUnknown = 0;
  SpeechRecognitionMode.kIme = 1;
  SpeechRecognitionMode.kCaption = 2;
  SpeechRecognitionMode.MIN_VALUE = 0;
  SpeechRecognitionMode.MAX_VALUE = 2;
  SpeechRecognitionMode.DEFAULT_VALUE = 0;

  SpeechRecognitionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SpeechRecognitionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SpeechRecognitionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var RecognizerClientType = {};
  RecognizerClientType.kUnknown = 0;
  RecognizerClientType.kDictation = 1;
  RecognizerClientType.kLiveCaption = 2;
  RecognizerClientType.kProjector = 3;
  RecognizerClientType.kCastModerator = 4;
  RecognizerClientType.kSchoolTools = 5;
  RecognizerClientType.MIN_VALUE = 0;
  RecognizerClientType.MAX_VALUE = 5;
  RecognizerClientType.DEFAULT_VALUE = 0;

  RecognizerClientType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  RecognizerClientType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  RecognizerClientType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function HypothesisParts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HypothesisParts.prototype.initDefaults_ = function() {
    this.text = null;
    this.hypothesisPartOffset = null;
  };
  HypothesisParts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HypothesisParts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HypothesisParts.text
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HypothesisParts.hypothesisPartOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HypothesisParts.encodedSize = codec.kStructHeaderSize + 16;

  HypothesisParts.decode = function(decoder) {
    var packed;
    var val = new HypothesisParts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeArrayPointer(codec.String);
    val.hypothesisPartOffset =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  HypothesisParts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HypothesisParts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.text);
    encoder.encodeStructPointer(time$.TimeDelta, val.hypothesisPartOffset);
  };
  function MediaTimestampRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaTimestampRange.prototype.initDefaults_ = function() {
    this.start = null;
    this.end = null;
  };
  MediaTimestampRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaTimestampRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaTimestampRange.start
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaTimestampRange.end
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaTimestampRange.encodedSize = codec.kStructHeaderSize + 16;

  MediaTimestampRange.decode = function(decoder) {
    var packed;
    var val = new MediaTimestampRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.end =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaTimestampRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaTimestampRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.start);
    encoder.encodeStructPointer(time$.TimeDelta, val.end);
  };
  function TimingInformation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TimingInformation.prototype.initDefaults_ = function() {
    this.audioStartTime = null;
    this.audioEndTime = null;
    this.hypothesisParts = null;
    this.originatingMediaTimestamps = null;
  };
  TimingInformation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TimingInformation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 11, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInformation.audioStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInformation.audioEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInformation.hypothesisParts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(HypothesisParts), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check TimingInformation.originatingMediaTimestamps
    if (!messageValidator.isFieldInStructVersion(offset, 11))
      return validator.validationError.NONE;
    // validate TimingInformation.originatingMediaTimestamps
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(MediaTimestampRange), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TimingInformation.encodedSize = codec.kStructHeaderSize + 32;

  TimingInformation.decode = function(decoder) {
    var packed;
    var val = new TimingInformation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audioStartTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.audioEndTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.hypothesisParts =
        decoder.decodeArrayPointer(new codec.PointerTo(HypothesisParts));
    if (version >= 11) {
      val.originatingMediaTimestamps =
          decoder.decodeArrayPointer(new codec.PointerTo(MediaTimestampRange));
    } else {
      val.originatingMediaTimestamps = null;
    }
    return val;
  };

  TimingInformation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TimingInformation.encodedSize);
    encoder.writeUint32(11);
    encoder.encodeStructPointer(time$.TimeDelta, val.audioStartTime);
    encoder.encodeStructPointer(time$.TimeDelta, val.audioEndTime);
    encoder.encodeArrayPointer(new codec.PointerTo(HypothesisParts), val.hypothesisParts);
    encoder.encodeArrayPointer(new codec.PointerTo(MediaTimestampRange), val.originatingMediaTimestamps);
  };
  function SpeechRecognitionResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionResult.prototype.initDefaults_ = function() {
    this.transcription = null;
    this.isFinal = false;
    this.timingInformation = null;
  };
  SpeechRecognitionResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionResult.transcription
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate SpeechRecognitionResult.timingInformation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, TimingInformation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionResult.encodedSize = codec.kStructHeaderSize + 24;

  SpeechRecognitionResult.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transcription =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isFinal = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timingInformation =
        decoder.decodeStructPointer(TimingInformation);
    return val;
  };

  SpeechRecognitionResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.transcription);
    packed = 0;
    packed |= (val.isFinal & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(TimingInformation, val.timingInformation);
  };
  function LanguageIdentificationEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguageIdentificationEvent.prototype.initDefaults_ = function() {
    this.language = null;
    this.confidenceLevel = 0;
    this.asr_switch_result_$flag = false;
    this.asr_switch_result_$value = 0;
  };
  LanguageIdentificationEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguageIdentificationEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 1, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguageIdentificationEvent.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguageIdentificationEvent.confidenceLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ConfidenceLevel);
    if (err !== validator.validationError.NONE)
        return err;




    // version check LanguageIdentificationEvent.asr_switch_result_$value
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate LanguageIdentificationEvent.asr_switch_result_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, AsrSwitchResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguageIdentificationEvent.encodedSize = codec.kStructHeaderSize + 24;

  LanguageIdentificationEvent.decode = function(decoder) {
    var packed;
    var val = new LanguageIdentificationEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.language =
        decoder.decodeStruct(codec.String);
    val.confidenceLevel =
        decoder.decodeStruct(new codec.Enum(ConfidenceLevel));
    packed = decoder.readUint8();
    val.asr_switch_result_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 1) {
      val.asr_switch_result_$value =
          decoder.decodeStruct(new codec.Enum(AsrSwitchResult));
    } else {
      val.asr_switch_result_$value = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LanguageIdentificationEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguageIdentificationEvent.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.String, val.language);
    encoder.encodeStruct(codec.Int32, val.confidenceLevel);
    packed = 0;
    packed |= (val.asr_switch_result_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.asr_switch_result_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionOptions.prototype.initDefaults_ = function() {
    this.recognitionMode = 0;
    this.enableFormatting = false;
    this.isServerBased = false;
    this.skipContinuouslyEmptyAudio = false;
    this.language = null;
    this.recognizerClientType = 0;
    this.channelCount = 0;
    this.experimentRecognizerRoutingKey = null;
    this.sampleRate = 0;
    this.recognitionContext = null;
  };
  SpeechRecognitionOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 1, numBytes: 32},
      {version: 4, numBytes: 32},
      {version: 5, numBytes: 40},
      {version: 6, numBytes: 48},
      {version: 8, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionOptions.recognitionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SpeechRecognitionMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SpeechRecognitionOptions.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;




    // version check SpeechRecognitionOptions.recognizerClientType
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate SpeechRecognitionOptions.recognizerClientType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, RecognizerClientType);
    if (err !== validator.validationError.NONE)
        return err;




    // version check SpeechRecognitionOptions.experimentRecognizerRoutingKey
    if (!messageValidator.isFieldInStructVersion(offset, 5))
      return validator.validationError.NONE;
    // validate SpeechRecognitionOptions.experimentRecognizerRoutingKey
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;





    // version check SpeechRecognitionOptions.recognitionContext
    if (!messageValidator.isFieldInStructVersion(offset, 8))
      return validator.validationError.NONE;
    // validate SpeechRecognitionOptions.recognitionContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionOptions.encodedSize = codec.kStructHeaderSize + 48;

  SpeechRecognitionOptions.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recognitionMode =
        decoder.decodeStruct(new codec.Enum(SpeechRecognitionMode));
    packed = decoder.readUint8();
    val.enableFormatting = (packed >> 0) & 1 ? true : false;
    val.isServerBased = (packed >> 1) & 1 ? true : false;
    val.skipContinuouslyEmptyAudio = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.language =
        decoder.decodeStruct(codec.String);
    if (version >= 1) {
      val.recognizerClientType =
          decoder.decodeStruct(new codec.Enum(RecognizerClientType));
    } else {
      val.recognizerClientType = null;
    }
    if (version >= 6) {
      val.channelCount =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.channelCount = null;
    }
    if (version >= 5) {
      val.experimentRecognizerRoutingKey =
          decoder.decodeStruct(codec.String);
    } else {
      val.experimentRecognizerRoutingKey = null;
    }
    if (version >= 6) {
      val.sampleRate =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.sampleRate = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 8) {
      val.recognitionContext =
          decoder.decodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext);
    } else {
      val.recognitionContext = null;
    }
    return val;
  };

  SpeechRecognitionOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionOptions.encodedSize);
    encoder.writeUint32(8);
    encoder.encodeStruct(codec.Int32, val.recognitionMode);
    packed = 0;
    packed |= (val.enableFormatting & 1) << 0
    packed |= (val.isServerBased & 1) << 1
    packed |= (val.skipContinuouslyEmptyAudio & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.language);
    encoder.encodeStruct(codec.Int32, val.recognizerClientType);
    encoder.encodeStruct(codec.Int32, val.channelCount);
    encoder.encodeStruct(codec.String, val.experimentRecognizerRoutingKey);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, val.recognitionContext);
  };
  function SpeechRecognitionContext_BindRecognizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionContext_BindRecognizer_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.client = new SpeechRecognitionRecognizerClientPtr();
    this.options = null;
  };
  SpeechRecognitionContext_BindRecognizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionContext_BindRecognizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindRecognizer_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindRecognizer_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindRecognizer_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, SpeechRecognitionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionContext_BindRecognizer_Params.encodedSize = codec.kStructHeaderSize + 24;

  SpeechRecognitionContext_BindRecognizer_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionContext_BindRecognizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(SpeechRecognitionRecognizerClientPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.options =
        decoder.decodeStructPointer(SpeechRecognitionOptions);
    return val;
  };

  SpeechRecognitionContext_BindRecognizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionContext_BindRecognizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.Interface(SpeechRecognitionRecognizerClientPtr), val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SpeechRecognitionOptions, val.options);
  };
  function SpeechRecognitionContext_BindRecognizer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionContext_BindRecognizer_ResponseParams.prototype.initDefaults_ = function() {
    this.isMultichannelSupported = false;
  };
  SpeechRecognitionContext_BindRecognizer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionContext_BindRecognizer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionContext_BindRecognizer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionContext_BindRecognizer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionContext_BindRecognizer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isMultichannelSupported = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionContext_BindRecognizer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionContext_BindRecognizer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isMultichannelSupported & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionContext_BindWebSpeechRecognizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.prototype.initDefaults_ = function() {
    this.sessionReceiver = new bindings.InterfaceRequest();
    this.sessionClient = new speech_recognizer$.SpeechRecognitionSessionClientPtr();
    this.audioForwarder = new bindings.InterfaceRequest();
    this.channelCount = 0;
    this.sampleRate = 0;
    this.options = null;
    this.continuous = false;
  };
  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindWebSpeechRecognizer_Params.sessionReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindWebSpeechRecognizer_Params.sessionClient
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionContext_BindWebSpeechRecognizer_Params.audioForwarder
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 12, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate SpeechRecognitionContext_BindWebSpeechRecognizer_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, SpeechRecognitionOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.encodedSize = codec.kStructHeaderSize + 40;

  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionContext_BindWebSpeechRecognizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.sessionClient =
        decoder.decodeStruct(new codec.Interface(speech_recognizer$.SpeechRecognitionSessionClientPtr));
    val.audioForwarder =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.channelCount =
        decoder.decodeStruct(codec.Int32);
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    val.options =
        decoder.decodeStructPointer(SpeechRecognitionOptions);
    packed = decoder.readUint8();
    val.continuous = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionContext_BindWebSpeechRecognizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionContext_BindWebSpeechRecognizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.sessionReceiver);
    encoder.encodeStruct(new codec.Interface(speech_recognizer$.SpeechRecognitionSessionClientPtr), val.sessionClient);
    encoder.encodeStruct(codec.InterfaceRequest, val.audioForwarder);
    encoder.encodeStruct(codec.Int32, val.channelCount);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
    encoder.encodeStructPointer(SpeechRecognitionOptions, val.options);
    packed = 0;
    packed |= (val.continuous & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.prototype.initDefaults_ = function() {
    this.buffer = null;
    this.mediaStartPts = null;
  };
  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 10, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.buffer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data$.AudioDataS16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // version check SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.mediaStartPts
    if (!messageValidator.isFieldInStructVersion(offset, 10))
      return validator.validationError.NONE;
    // validate SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.mediaStartPts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.encodedSize = codec.kStructHeaderSize + 16;

  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStructPointer(audio_data$.AudioDataS16);
    if (version >= 10) {
      val.mediaStartPts =
          decoder.decodeStructPointer(time$.TimeDelta);
    } else {
      val.mediaStartPts = null;
    }
    return val;
  };

  SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.encodedSize);
    encoder.writeUint32(10);
    encoder.encodeStructPointer(audio_data$.AudioDataS16, val.buffer);
    encoder.encodeStructPointer(time$.TimeDelta, val.mediaStartPts);
  };
  function SpeechRecognitionRecognizer_MarkDone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizer_MarkDone_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionRecognizer_MarkDone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizer_MarkDone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizer_MarkDone_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionRecognizer_MarkDone_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizer_MarkDone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionRecognizer_MarkDone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizer_MarkDone_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionRecognizer_OnLanguageChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizer_OnLanguageChanged_Params.prototype.initDefaults_ = function() {
    this.language = null;
  };
  SpeechRecognitionRecognizer_OnLanguageChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizer_OnLanguageChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognizer_OnLanguageChanged_Params.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizer_OnLanguageChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizer_OnLanguageChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizer_OnLanguageChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SpeechRecognitionRecognizer_OnLanguageChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizer_OnLanguageChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.language);
  };
  function SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.prototype.initDefaults_ = function() {
    this.maskOffensiveWords = false;
  };
  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.maskOffensiveWords = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.maskOffensiveWords & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionRecognizer_UpdateRecognitionContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.prototype.initDefaults_ = function() {
    this.recognitionContext = null;
  };
  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.recognitionContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizer_UpdateRecognitionContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recognitionContext =
        decoder.decodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext);
    return val;
  };

  SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, val.recognitionContext);
  };
  function SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SpeechRecognitionResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(SpeechRecognitionResult);
    return val;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SpeechRecognitionResult, val.result);
  };
  function SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.prototype.initDefaults_ = function() {
    this.continueRecognition = false;
  };
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.continueRecognition = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.continueRecognition & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguageIdentificationEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(LanguageIdentificationEvent);
    return val;
  };

  SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguageIdentificationEvent, val.event);
  };
  function SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.prototype.initDefaults_ = function() {
    this.isSpeechRecognitionAvailable = false;
  };
  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isSpeechRecognitionAvailable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isSpeechRecognitionAvailable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.prototype.initDefaults_ = function() {
    this.language = null;
  };
  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.language);
  };
  function SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.prototype.initDefaults_ = function() {
    this.maskOffensiveWords = false;
  };
  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.maskOffensiveWords = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.maskOffensiveWords & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionSurface_Activate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSurface_Activate_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSurface_Activate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSurface_Activate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSurface_Activate_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSurface_Activate_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSurface_Activate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSurface_Activate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSurface_Activate_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSurface_GetBounds_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSurface_GetBounds_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSurface_GetBounds_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSurface_GetBounds_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSurface_GetBounds_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSurface_GetBounds_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSurface_GetBounds_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSurface_GetBounds_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSurface_GetBounds_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSurface_GetBounds_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSurface_GetBounds_ResponseParams.prototype.initDefaults_ = function() {
    this.bounds = null;
  };
  SpeechRecognitionSurface_GetBounds_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSurface_GetBounds_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionSurface_GetBounds_ResponseParams.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSurface_GetBounds_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionSurface_GetBounds_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSurface_GetBounds_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  SpeechRecognitionSurface_GetBounds_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSurface_GetBounds_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
  };
  function SpeechRecognitionSurfaceClient_OnSessionEnded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSurfaceClient_OnSessionEnded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSurfaceClient_OnSessionEnded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSurfaceClient_OnSessionEnded_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new SpeechRecognitionBrowserObserverPtr();
  };
  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(SpeechRecognitionBrowserObserverPtr));
    return val;
  };

  SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SpeechRecognitionBrowserObserverPtr), val.observer);
  };
  function SpeechRecognitionClientBrowserInterface_REMOVED_1_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionClientBrowserInterface_REMOVED_1_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kSpeechRecognitionContext_BindRecognizer_Name = 0;
  var kSpeechRecognitionContext_BindWebSpeechRecognizer_Name = 1;

  function SpeechRecognitionContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionContext,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionContext, associatedInterfacePtrInfo);
  }

  SpeechRecognitionContextAssociatedPtr.prototype =
      Object.create(SpeechRecognitionContextPtr.prototype);
  SpeechRecognitionContextAssociatedPtr.prototype.constructor =
      SpeechRecognitionContextAssociatedPtr;

  function SpeechRecognitionContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionContextPtr.prototype.bindRecognizer = function() {
    return SpeechRecognitionContextProxy.prototype.bindRecognizer
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionContextProxy.prototype.bindRecognizer = function(receiver, client, options) {
    var params_ = new SpeechRecognitionContext_BindRecognizer_Params();
    params_.receiver = receiver;
    params_.client = client;
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSpeechRecognitionContext_BindRecognizer_Name,
          codec.align(SpeechRecognitionContext_BindRecognizer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SpeechRecognitionContext_BindRecognizer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SpeechRecognitionContext_BindRecognizer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SpeechRecognitionContextPtr.prototype.bindWebSpeechRecognizer = function() {
    return SpeechRecognitionContextProxy.prototype.bindWebSpeechRecognizer
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionContextProxy.prototype.bindWebSpeechRecognizer = function(sessionReceiver, sessionClient, audioForwarder, channelCount, sampleRate, options, continuous) {
    var params_ = new SpeechRecognitionContext_BindWebSpeechRecognizer_Params();
    params_.sessionReceiver = sessionReceiver;
    params_.sessionClient = sessionClient;
    params_.audioForwarder = audioForwarder;
    params_.channelCount = channelCount;
    params_.sampleRate = sampleRate;
    params_.options = options;
    params_.continuous = continuous;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionContext_BindWebSpeechRecognizer_Name,
        codec.align(SpeechRecognitionContext_BindWebSpeechRecognizer_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionContext_BindWebSpeechRecognizer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionContextStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionContextStub.prototype.bindRecognizer = function(receiver, client, options) {
    return this.delegate_ && this.delegate_.bindRecognizer && this.delegate_.bindRecognizer(receiver, client, options);
  }
  SpeechRecognitionContextStub.prototype.bindWebSpeechRecognizer = function(sessionReceiver, sessionClient, audioForwarder, channelCount, sampleRate, options, continuous) {
    return this.delegate_ && this.delegate_.bindWebSpeechRecognizer && this.delegate_.bindWebSpeechRecognizer(sessionReceiver, sessionClient, audioForwarder, channelCount, sampleRate, options, continuous);
  }

  SpeechRecognitionContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionContext_BindWebSpeechRecognizer_Name:
      var params = reader.decodeStruct(SpeechRecognitionContext_BindWebSpeechRecognizer_Params);
      this.bindWebSpeechRecognizer(params.sessionReceiver, params.sessionClient, params.audioForwarder, params.channelCount, params.sampleRate, params.options, params.continuous);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionContext_BindRecognizer_Name:
      var params = reader.decodeStruct(SpeechRecognitionContext_BindRecognizer_Params);
      this.bindRecognizer(params.receiver, params.client, params.options).then(function(response) {
        var responseParams =
            new SpeechRecognitionContext_BindRecognizer_ResponseParams();
        responseParams.isMultichannelSupported = response.isMultichannelSupported;
        var builder = new codec.MessageV1Builder(
            kSpeechRecognitionContext_BindRecognizer_Name,
            codec.align(SpeechRecognitionContext_BindRecognizer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SpeechRecognitionContext_BindRecognizer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSpeechRecognitionContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionContext_BindRecognizer_Name:
        if (message.expectsResponse())
          paramsClass = SpeechRecognitionContext_BindRecognizer_Params;
      break;
      case kSpeechRecognitionContext_BindWebSpeechRecognizer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionContext_BindWebSpeechRecognizer_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionContextResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSpeechRecognitionContext_BindRecognizer_Name:
        if (message.isResponse())
          paramsClass = SpeechRecognitionContext_BindRecognizer_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SpeechRecognitionContext = {
    name: 'media.mojom.SpeechRecognitionContext',
    kVersion: 6,
    ptrClass: SpeechRecognitionContextPtr,
    proxyClass: SpeechRecognitionContextProxy,
    stubClass: SpeechRecognitionContextStub,
    validateRequest: validateSpeechRecognitionContextRequest,
    validateResponse: validateSpeechRecognitionContextResponse,
  };
  SpeechRecognitionContextStub.prototype.validator = validateSpeechRecognitionContextRequest;
  SpeechRecognitionContextProxy.prototype.validator = validateSpeechRecognitionContextResponse;
  var kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name = 0;
  var kSpeechRecognitionRecognizer_MarkDone_Name = 1;
  var kSpeechRecognitionRecognizer_OnLanguageChanged_Name = 2;
  var kSpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Name = 3;
  var kSpeechRecognitionRecognizer_UpdateRecognitionContext_Name = 4;

  function SpeechRecognitionRecognizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionRecognizer,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionRecognizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionRecognizer, associatedInterfacePtrInfo);
  }

  SpeechRecognitionRecognizerAssociatedPtr.prototype =
      Object.create(SpeechRecognitionRecognizerPtr.prototype);
  SpeechRecognitionRecognizerAssociatedPtr.prototype.constructor =
      SpeechRecognitionRecognizerAssociatedPtr;

  function SpeechRecognitionRecognizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionRecognizerPtr.prototype.sendAudioToSpeechRecognitionService = function() {
    return SpeechRecognitionRecognizerProxy.prototype.sendAudioToSpeechRecognitionService
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerProxy.prototype.sendAudioToSpeechRecognitionService = function(buffer, mediaStartPts) {
    var params_ = new SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params();
    params_.buffer = buffer;
    params_.mediaStartPts = mediaStartPts;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name,
        codec.align(SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerPtr.prototype.markDone = function() {
    return SpeechRecognitionRecognizerProxy.prototype.markDone
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerProxy.prototype.markDone = function() {
    var params_ = new SpeechRecognitionRecognizer_MarkDone_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizer_MarkDone_Name,
        codec.align(SpeechRecognitionRecognizer_MarkDone_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizer_MarkDone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerPtr.prototype.onLanguageChanged = function() {
    return SpeechRecognitionRecognizerProxy.prototype.onLanguageChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerProxy.prototype.onLanguageChanged = function(language) {
    var params_ = new SpeechRecognitionRecognizer_OnLanguageChanged_Params();
    params_.language = language;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizer_OnLanguageChanged_Name,
        codec.align(SpeechRecognitionRecognizer_OnLanguageChanged_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizer_OnLanguageChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerPtr.prototype.onMaskOffensiveWordsChanged = function() {
    return SpeechRecognitionRecognizerProxy.prototype.onMaskOffensiveWordsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerProxy.prototype.onMaskOffensiveWordsChanged = function(maskOffensiveWords) {
    var params_ = new SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params();
    params_.maskOffensiveWords = maskOffensiveWords;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Name,
        codec.align(SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerPtr.prototype.updateRecognitionContext = function() {
    return SpeechRecognitionRecognizerProxy.prototype.updateRecognitionContext
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerProxy.prototype.updateRecognitionContext = function(recognitionContext) {
    var params_ = new SpeechRecognitionRecognizer_UpdateRecognitionContext_Params();
    params_.recognitionContext = recognitionContext;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizer_UpdateRecognitionContext_Name,
        codec.align(SpeechRecognitionRecognizer_UpdateRecognitionContext_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizer_UpdateRecognitionContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionRecognizerStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionRecognizerStub.prototype.sendAudioToSpeechRecognitionService = function(buffer, mediaStartPts) {
    return this.delegate_ && this.delegate_.sendAudioToSpeechRecognitionService && this.delegate_.sendAudioToSpeechRecognitionService(buffer, mediaStartPts);
  }
  SpeechRecognitionRecognizerStub.prototype.markDone = function() {
    return this.delegate_ && this.delegate_.markDone && this.delegate_.markDone();
  }
  SpeechRecognitionRecognizerStub.prototype.onLanguageChanged = function(language) {
    return this.delegate_ && this.delegate_.onLanguageChanged && this.delegate_.onLanguageChanged(language);
  }
  SpeechRecognitionRecognizerStub.prototype.onMaskOffensiveWordsChanged = function(maskOffensiveWords) {
    return this.delegate_ && this.delegate_.onMaskOffensiveWordsChanged && this.delegate_.onMaskOffensiveWordsChanged(maskOffensiveWords);
  }
  SpeechRecognitionRecognizerStub.prototype.updateRecognitionContext = function(recognitionContext) {
    return this.delegate_ && this.delegate_.updateRecognitionContext && this.delegate_.updateRecognitionContext(recognitionContext);
  }

  SpeechRecognitionRecognizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params);
      this.sendAudioToSpeechRecognitionService(params.buffer, params.mediaStartPts);
      return true;
    case kSpeechRecognitionRecognizer_MarkDone_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizer_MarkDone_Params);
      this.markDone();
      return true;
    case kSpeechRecognitionRecognizer_OnLanguageChanged_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizer_OnLanguageChanged_Params);
      this.onLanguageChanged(params.language);
      return true;
    case kSpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params);
      this.onMaskOffensiveWordsChanged(params.maskOffensiveWords);
      return true;
    case kSpeechRecognitionRecognizer_UpdateRecognitionContext_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizer_UpdateRecognitionContext_Params);
      this.updateRecognitionContext(params.recognitionContext);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionRecognizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionRecognizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizer_SendAudioToSpeechRecognitionService_Params;
      break;
      case kSpeechRecognitionRecognizer_MarkDone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizer_MarkDone_Params;
      break;
      case kSpeechRecognitionRecognizer_OnLanguageChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizer_OnLanguageChanged_Params;
      break;
      case kSpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizer_OnMaskOffensiveWordsChanged_Params;
      break;
      case kSpeechRecognitionRecognizer_UpdateRecognitionContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizer_UpdateRecognitionContext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionRecognizerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionRecognizer = {
    name: 'media.mojom.SpeechRecognitionRecognizer',
    kVersion: 10,
    ptrClass: SpeechRecognitionRecognizerPtr,
    proxyClass: SpeechRecognitionRecognizerProxy,
    stubClass: SpeechRecognitionRecognizerStub,
    validateRequest: validateSpeechRecognitionRecognizerRequest,
    validateResponse: null,
  };
  SpeechRecognitionRecognizerStub.prototype.validator = validateSpeechRecognitionRecognizerRequest;
  SpeechRecognitionRecognizerProxy.prototype.validator = null;
  var kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name = 0;
  var kSpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Name = 1;
  var kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name = 2;
  var kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name = 3;

  function SpeechRecognitionRecognizerClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionRecognizerClient,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionRecognizerClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionRecognizerClient, associatedInterfacePtrInfo);
  }

  SpeechRecognitionRecognizerClientAssociatedPtr.prototype =
      Object.create(SpeechRecognitionRecognizerClientPtr.prototype);
  SpeechRecognitionRecognizerClientAssociatedPtr.prototype.constructor =
      SpeechRecognitionRecognizerClientAssociatedPtr;

  function SpeechRecognitionRecognizerClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionRecognizerClientPtr.prototype.onSpeechRecognitionRecognitionEvent = function() {
    return SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionRecognitionEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionRecognitionEvent = function(result) {
    var params_ = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params();
    params_.result = result;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name,
          codec.align(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SpeechRecognitionRecognizerClientPtr.prototype.onSpeechRecognitionStopped = function() {
    return SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionStopped
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionStopped = function() {
    var params_ = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Name,
        codec.align(SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerClientPtr.prototype.onSpeechRecognitionError = function() {
    return SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionError
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerClientProxy.prototype.onSpeechRecognitionError = function() {
    var params_ = new SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name,
        codec.align(SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionRecognizerClientPtr.prototype.onLanguageIdentificationEvent = function() {
    return SpeechRecognitionRecognizerClientProxy.prototype.onLanguageIdentificationEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionRecognizerClientProxy.prototype.onLanguageIdentificationEvent = function(event) {
    var params_ = new SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name,
        codec.align(SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionRecognizerClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionRecognizerClientStub.prototype.onSpeechRecognitionRecognitionEvent = function(result) {
    return this.delegate_ && this.delegate_.onSpeechRecognitionRecognitionEvent && this.delegate_.onSpeechRecognitionRecognitionEvent(result);
  }
  SpeechRecognitionRecognizerClientStub.prototype.onSpeechRecognitionStopped = function() {
    return this.delegate_ && this.delegate_.onSpeechRecognitionStopped && this.delegate_.onSpeechRecognitionStopped();
  }
  SpeechRecognitionRecognizerClientStub.prototype.onSpeechRecognitionError = function() {
    return this.delegate_ && this.delegate_.onSpeechRecognitionError && this.delegate_.onSpeechRecognitionError();
  }
  SpeechRecognitionRecognizerClientStub.prototype.onLanguageIdentificationEvent = function(event) {
    return this.delegate_ && this.delegate_.onLanguageIdentificationEvent && this.delegate_.onLanguageIdentificationEvent(event);
  }

  SpeechRecognitionRecognizerClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params);
      this.onSpeechRecognitionStopped();
      return true;
    case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params);
      this.onSpeechRecognitionError();
      return true;
    case kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params);
      this.onLanguageIdentificationEvent(params.event);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionRecognizerClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name:
      var params = reader.decodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params);
      this.onSpeechRecognitionRecognitionEvent(params.result).then(function(response) {
        var responseParams =
            new SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams();
        responseParams.continueRecognition = response.continueRecognition;
        var builder = new codec.MessageV1Builder(
            kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name,
            codec.align(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSpeechRecognitionRecognizerClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name:
        if (message.expectsResponse())
          paramsClass = SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Params;
      break;
      case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizerClient_OnSpeechRecognitionStopped_Params;
      break;
      case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizerClient_OnSpeechRecognitionError_Params;
      break;
      case kSpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionRecognizerClient_OnLanguageIdentificationEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionRecognizerClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_Name:
        if (message.isResponse())
          paramsClass = SpeechRecognitionRecognizerClient_OnSpeechRecognitionRecognitionEvent_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SpeechRecognitionRecognizerClient = {
    name: 'media.mojom.SpeechRecognitionRecognizerClient',
    kVersion: 0,
    ptrClass: SpeechRecognitionRecognizerClientPtr,
    proxyClass: SpeechRecognitionRecognizerClientProxy,
    stubClass: SpeechRecognitionRecognizerClientStub,
    validateRequest: validateSpeechRecognitionRecognizerClientRequest,
    validateResponse: validateSpeechRecognitionRecognizerClientResponse,
  };
  SpeechRecognitionRecognizerClientStub.prototype.validator = validateSpeechRecognitionRecognizerClientRequest;
  SpeechRecognitionRecognizerClientProxy.prototype.validator = validateSpeechRecognitionRecognizerClientResponse;
  var kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name = 0;
  var kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name = 1;
  var kSpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Name = 2;

  function SpeechRecognitionBrowserObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionBrowserObserver,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionBrowserObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionBrowserObserver, associatedInterfacePtrInfo);
  }

  SpeechRecognitionBrowserObserverAssociatedPtr.prototype =
      Object.create(SpeechRecognitionBrowserObserverPtr.prototype);
  SpeechRecognitionBrowserObserverAssociatedPtr.prototype.constructor =
      SpeechRecognitionBrowserObserverAssociatedPtr;

  function SpeechRecognitionBrowserObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionBrowserObserverPtr.prototype.speechRecognitionAvailabilityChanged = function() {
    return SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionAvailabilityChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionAvailabilityChanged = function(isSpeechRecognitionAvailable) {
    var params_ = new SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params();
    params_.isSpeechRecognitionAvailable = isSpeechRecognitionAvailable;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name,
        codec.align(SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionBrowserObserverPtr.prototype.speechRecognitionLanguageChanged = function() {
    return SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionLanguageChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionLanguageChanged = function(language) {
    var params_ = new SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params();
    params_.language = language;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name,
        codec.align(SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionBrowserObserverPtr.prototype.speechRecognitionMaskOffensiveWordsChanged = function() {
    return SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionMaskOffensiveWordsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionBrowserObserverProxy.prototype.speechRecognitionMaskOffensiveWordsChanged = function(maskOffensiveWords) {
    var params_ = new SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params();
    params_.maskOffensiveWords = maskOffensiveWords;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Name,
        codec.align(SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionBrowserObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionBrowserObserverStub.prototype.speechRecognitionAvailabilityChanged = function(isSpeechRecognitionAvailable) {
    return this.delegate_ && this.delegate_.speechRecognitionAvailabilityChanged && this.delegate_.speechRecognitionAvailabilityChanged(isSpeechRecognitionAvailable);
  }
  SpeechRecognitionBrowserObserverStub.prototype.speechRecognitionLanguageChanged = function(language) {
    return this.delegate_ && this.delegate_.speechRecognitionLanguageChanged && this.delegate_.speechRecognitionLanguageChanged(language);
  }
  SpeechRecognitionBrowserObserverStub.prototype.speechRecognitionMaskOffensiveWordsChanged = function(maskOffensiveWords) {
    return this.delegate_ && this.delegate_.speechRecognitionMaskOffensiveWordsChanged && this.delegate_.speechRecognitionMaskOffensiveWordsChanged(maskOffensiveWords);
  }

  SpeechRecognitionBrowserObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name:
      var params = reader.decodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params);
      this.speechRecognitionAvailabilityChanged(params.isSpeechRecognitionAvailable);
      return true;
    case kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name:
      var params = reader.decodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params);
      this.speechRecognitionLanguageChanged(params.language);
      return true;
    case kSpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Name:
      var params = reader.decodeStruct(SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params);
      this.speechRecognitionMaskOffensiveWordsChanged(params.maskOffensiveWords);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionBrowserObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionBrowserObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionBrowserObserver_SpeechRecognitionAvailabilityChanged_Params;
      break;
      case kSpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionBrowserObserver_SpeechRecognitionLanguageChanged_Params;
      break;
      case kSpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionBrowserObserver_SpeechRecognitionMaskOffensiveWordsChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionBrowserObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionBrowserObserver = {
    name: 'media.mojom.SpeechRecognitionBrowserObserver',
    kVersion: 2,
    ptrClass: SpeechRecognitionBrowserObserverPtr,
    proxyClass: SpeechRecognitionBrowserObserverProxy,
    stubClass: SpeechRecognitionBrowserObserverStub,
    validateRequest: validateSpeechRecognitionBrowserObserverRequest,
    validateResponse: null,
  };
  SpeechRecognitionBrowserObserverStub.prototype.validator = validateSpeechRecognitionBrowserObserverRequest;
  SpeechRecognitionBrowserObserverProxy.prototype.validator = null;
  var kSpeechRecognitionSurface_Activate_Name = 0;
  var kSpeechRecognitionSurface_GetBounds_Name = 1;

  function SpeechRecognitionSurfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionSurface,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionSurfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionSurface, associatedInterfacePtrInfo);
  }

  SpeechRecognitionSurfaceAssociatedPtr.prototype =
      Object.create(SpeechRecognitionSurfacePtr.prototype);
  SpeechRecognitionSurfaceAssociatedPtr.prototype.constructor =
      SpeechRecognitionSurfaceAssociatedPtr;

  function SpeechRecognitionSurfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionSurfacePtr.prototype.activate = function() {
    return SpeechRecognitionSurfaceProxy.prototype.activate
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSurfaceProxy.prototype.activate = function() {
    var params_ = new SpeechRecognitionSurface_Activate_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSurface_Activate_Name,
        codec.align(SpeechRecognitionSurface_Activate_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSurface_Activate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSurfacePtr.prototype.getBounds = function() {
    return SpeechRecognitionSurfaceProxy.prototype.getBounds
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSurfaceProxy.prototype.getBounds = function() {
    var params_ = new SpeechRecognitionSurface_GetBounds_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSpeechRecognitionSurface_GetBounds_Name,
          codec.align(SpeechRecognitionSurface_GetBounds_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SpeechRecognitionSurface_GetBounds_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SpeechRecognitionSurface_GetBounds_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SpeechRecognitionSurfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionSurfaceStub.prototype.activate = function() {
    return this.delegate_ && this.delegate_.activate && this.delegate_.activate();
  }
  SpeechRecognitionSurfaceStub.prototype.getBounds = function() {
    return this.delegate_ && this.delegate_.getBounds && this.delegate_.getBounds();
  }

  SpeechRecognitionSurfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionSurface_Activate_Name:
      var params = reader.decodeStruct(SpeechRecognitionSurface_Activate_Params);
      this.activate();
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionSurfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionSurface_GetBounds_Name:
      var params = reader.decodeStruct(SpeechRecognitionSurface_GetBounds_Params);
      this.getBounds().then(function(response) {
        var responseParams =
            new SpeechRecognitionSurface_GetBounds_ResponseParams();
        responseParams.bounds = response.bounds;
        var builder = new codec.MessageV1Builder(
            kSpeechRecognitionSurface_GetBounds_Name,
            codec.align(SpeechRecognitionSurface_GetBounds_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SpeechRecognitionSurface_GetBounds_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSpeechRecognitionSurfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionSurface_Activate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSurface_Activate_Params;
      break;
      case kSpeechRecognitionSurface_GetBounds_Name:
        if (message.expectsResponse())
          paramsClass = SpeechRecognitionSurface_GetBounds_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionSurfaceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSpeechRecognitionSurface_GetBounds_Name:
        if (message.isResponse())
          paramsClass = SpeechRecognitionSurface_GetBounds_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SpeechRecognitionSurface = {
    name: 'media.mojom.SpeechRecognitionSurface',
    kVersion: 0,
    ptrClass: SpeechRecognitionSurfacePtr,
    proxyClass: SpeechRecognitionSurfaceProxy,
    stubClass: SpeechRecognitionSurfaceStub,
    validateRequest: validateSpeechRecognitionSurfaceRequest,
    validateResponse: validateSpeechRecognitionSurfaceResponse,
  };
  SpeechRecognitionSurfaceStub.prototype.validator = validateSpeechRecognitionSurfaceRequest;
  SpeechRecognitionSurfaceProxy.prototype.validator = validateSpeechRecognitionSurfaceResponse;
  var kSpeechRecognitionSurfaceClient_OnSessionEnded_Name = 0;
  var kSpeechRecognitionSurfaceClient_OnFullscreenToggled_Name = 1;

  function SpeechRecognitionSurfaceClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionSurfaceClient,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionSurfaceClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionSurfaceClient, associatedInterfacePtrInfo);
  }

  SpeechRecognitionSurfaceClientAssociatedPtr.prototype =
      Object.create(SpeechRecognitionSurfaceClientPtr.prototype);
  SpeechRecognitionSurfaceClientAssociatedPtr.prototype.constructor =
      SpeechRecognitionSurfaceClientAssociatedPtr;

  function SpeechRecognitionSurfaceClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionSurfaceClientPtr.prototype.onSessionEnded = function() {
    return SpeechRecognitionSurfaceClientProxy.prototype.onSessionEnded
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSurfaceClientProxy.prototype.onSessionEnded = function() {
    var params_ = new SpeechRecognitionSurfaceClient_OnSessionEnded_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSurfaceClient_OnSessionEnded_Name,
        codec.align(SpeechRecognitionSurfaceClient_OnSessionEnded_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSurfaceClient_OnSessionEnded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSurfaceClientPtr.prototype.onFullscreenToggled = function() {
    return SpeechRecognitionSurfaceClientProxy.prototype.onFullscreenToggled
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSurfaceClientProxy.prototype.onFullscreenToggled = function() {
    var params_ = new SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSurfaceClient_OnFullscreenToggled_Name,
        codec.align(SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionSurfaceClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionSurfaceClientStub.prototype.onSessionEnded = function() {
    return this.delegate_ && this.delegate_.onSessionEnded && this.delegate_.onSessionEnded();
  }
  SpeechRecognitionSurfaceClientStub.prototype.onFullscreenToggled = function() {
    return this.delegate_ && this.delegate_.onFullscreenToggled && this.delegate_.onFullscreenToggled();
  }

  SpeechRecognitionSurfaceClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionSurfaceClient_OnSessionEnded_Name:
      var params = reader.decodeStruct(SpeechRecognitionSurfaceClient_OnSessionEnded_Params);
      this.onSessionEnded();
      return true;
    case kSpeechRecognitionSurfaceClient_OnFullscreenToggled_Name:
      var params = reader.decodeStruct(SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params);
      this.onFullscreenToggled();
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionSurfaceClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionSurfaceClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionSurfaceClient_OnSessionEnded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSurfaceClient_OnSessionEnded_Params;
      break;
      case kSpeechRecognitionSurfaceClient_OnFullscreenToggled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSurfaceClient_OnFullscreenToggled_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionSurfaceClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionSurfaceClient = {
    name: 'media.mojom.SpeechRecognitionSurfaceClient',
    kVersion: 0,
    ptrClass: SpeechRecognitionSurfaceClientPtr,
    proxyClass: SpeechRecognitionSurfaceClientProxy,
    stubClass: SpeechRecognitionSurfaceClientStub,
    validateRequest: validateSpeechRecognitionSurfaceClientRequest,
    validateResponse: null,
  };
  SpeechRecognitionSurfaceClientStub.prototype.validator = validateSpeechRecognitionSurfaceClientRequest;
  SpeechRecognitionSurfaceClientProxy.prototype.validator = null;
  var kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name = 0;
  var kSpeechRecognitionClientBrowserInterface_REMOVED_1_Name = 1;

  function SpeechRecognitionClientBrowserInterfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionClientBrowserInterface,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionClientBrowserInterfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionClientBrowserInterface, associatedInterfacePtrInfo);
  }

  SpeechRecognitionClientBrowserInterfaceAssociatedPtr.prototype =
      Object.create(SpeechRecognitionClientBrowserInterfacePtr.prototype);
  SpeechRecognitionClientBrowserInterfaceAssociatedPtr.prototype.constructor =
      SpeechRecognitionClientBrowserInterfaceAssociatedPtr;

  function SpeechRecognitionClientBrowserInterfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionClientBrowserInterfacePtr.prototype.bindSpeechRecognitionBrowserObserver = function() {
    return SpeechRecognitionClientBrowserInterfaceProxy.prototype.bindSpeechRecognitionBrowserObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionClientBrowserInterfaceProxy.prototype.bindSpeechRecognitionBrowserObserver = function(observer) {
    var params_ = new SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name,
        codec.align(SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionClientBrowserInterfacePtr.prototype.rEMOVED1 = function() {
    return SpeechRecognitionClientBrowserInterfaceProxy.prototype.rEMOVED1
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionClientBrowserInterfaceProxy.prototype.rEMOVED1 = function() {
    var params_ = new SpeechRecognitionClientBrowserInterface_REMOVED_1_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionClientBrowserInterface_REMOVED_1_Name,
        codec.align(SpeechRecognitionClientBrowserInterface_REMOVED_1_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionClientBrowserInterface_REMOVED_1_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionClientBrowserInterfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionClientBrowserInterfaceStub.prototype.bindSpeechRecognitionBrowserObserver = function(observer) {
    return this.delegate_ && this.delegate_.bindSpeechRecognitionBrowserObserver && this.delegate_.bindSpeechRecognitionBrowserObserver(observer);
  }
  SpeechRecognitionClientBrowserInterfaceStub.prototype.rEMOVED1 = function() {
    return this.delegate_ && this.delegate_.rEMOVED1 && this.delegate_.rEMOVED1();
  }

  SpeechRecognitionClientBrowserInterfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name:
      var params = reader.decodeStruct(SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params);
      this.bindSpeechRecognitionBrowserObserver(params.observer);
      return true;
    case kSpeechRecognitionClientBrowserInterface_REMOVED_1_Name:
      var params = reader.decodeStruct(SpeechRecognitionClientBrowserInterface_REMOVED_1_Params);
      this.rEMOVED1();
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionClientBrowserInterfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionClientBrowserInterfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionClientBrowserInterface_BindSpeechRecognitionBrowserObserver_Params;
      break;
      case kSpeechRecognitionClientBrowserInterface_REMOVED_1_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionClientBrowserInterface_REMOVED_1_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionClientBrowserInterfaceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionClientBrowserInterface = {
    name: 'media.mojom.SpeechRecognitionClientBrowserInterface',
    kVersion: 1,
    ptrClass: SpeechRecognitionClientBrowserInterfacePtr,
    proxyClass: SpeechRecognitionClientBrowserInterfaceProxy,
    stubClass: SpeechRecognitionClientBrowserInterfaceStub,
    validateRequest: validateSpeechRecognitionClientBrowserInterfaceRequest,
    validateResponse: null,
  };
  SpeechRecognitionClientBrowserInterfaceStub.prototype.validator = validateSpeechRecognitionClientBrowserInterfaceRequest;
  SpeechRecognitionClientBrowserInterfaceProxy.prototype.validator = null;
  exports.ConfidenceLevel = ConfidenceLevel;
  exports.AsrSwitchResult = AsrSwitchResult;
  exports.SpeechRecognitionMode = SpeechRecognitionMode;
  exports.RecognizerClientType = RecognizerClientType;
  exports.HypothesisParts = HypothesisParts;
  exports.MediaTimestampRange = MediaTimestampRange;
  exports.TimingInformation = TimingInformation;
  exports.SpeechRecognitionResult = SpeechRecognitionResult;
  exports.LanguageIdentificationEvent = LanguageIdentificationEvent;
  exports.SpeechRecognitionOptions = SpeechRecognitionOptions;
  exports.SpeechRecognitionContext = SpeechRecognitionContext;
  exports.SpeechRecognitionContextPtr = SpeechRecognitionContextPtr;
  exports.SpeechRecognitionContextAssociatedPtr = SpeechRecognitionContextAssociatedPtr;
  exports.SpeechRecognitionRecognizer = SpeechRecognitionRecognizer;
  exports.SpeechRecognitionRecognizerPtr = SpeechRecognitionRecognizerPtr;
  exports.SpeechRecognitionRecognizerAssociatedPtr = SpeechRecognitionRecognizerAssociatedPtr;
  exports.SpeechRecognitionRecognizerClient = SpeechRecognitionRecognizerClient;
  exports.SpeechRecognitionRecognizerClientPtr = SpeechRecognitionRecognizerClientPtr;
  exports.SpeechRecognitionRecognizerClientAssociatedPtr = SpeechRecognitionRecognizerClientAssociatedPtr;
  exports.SpeechRecognitionBrowserObserver = SpeechRecognitionBrowserObserver;
  exports.SpeechRecognitionBrowserObserverPtr = SpeechRecognitionBrowserObserverPtr;
  exports.SpeechRecognitionBrowserObserverAssociatedPtr = SpeechRecognitionBrowserObserverAssociatedPtr;
  exports.SpeechRecognitionSurface = SpeechRecognitionSurface;
  exports.SpeechRecognitionSurfacePtr = SpeechRecognitionSurfacePtr;
  exports.SpeechRecognitionSurfaceAssociatedPtr = SpeechRecognitionSurfaceAssociatedPtr;
  exports.SpeechRecognitionSurfaceClient = SpeechRecognitionSurfaceClient;
  exports.SpeechRecognitionSurfaceClientPtr = SpeechRecognitionSurfaceClientPtr;
  exports.SpeechRecognitionSurfaceClientAssociatedPtr = SpeechRecognitionSurfaceClientAssociatedPtr;
  exports.SpeechRecognitionClientBrowserInterface = SpeechRecognitionClientBrowserInterface;
  exports.SpeechRecognitionClientBrowserInterfacePtr = SpeechRecognitionClientBrowserInterfacePtr;
  exports.SpeechRecognitionClientBrowserInterfaceAssociatedPtr = SpeechRecognitionClientBrowserInterfaceAssociatedPtr;
})();