// media/mojo/mojom/renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/renderer.mojom-params-data.h"
#include "media/mojo/mojom/renderer.mojom-shared-message-ids.h"

#include "media/mojo/mojom/renderer.mojom-import-headers.h"
#include "media/mojo/mojom/renderer.mojom-test-utils.h"
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

Renderer::IPCStableHashFunction Renderer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Renderer>(message.name())) {
    case messages::Renderer::kInitialize: {
      return &Renderer::Initialize_Sym::IPCStableHash;
    }
    case messages::Renderer::kFlush: {
      return &Renderer::Flush_Sym::IPCStableHash;
    }
    case messages::Renderer::kStartPlayingFrom: {
      return &Renderer::StartPlayingFrom_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetPlaybackRate: {
      return &Renderer::SetPlaybackRate_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetVolume: {
      return &Renderer::SetVolume_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetCdm: {
      return &Renderer::SetCdm_Sym::IPCStableHash;
    }
    case messages::Renderer::kSetLatencyHint: {
      return &Renderer::SetLatencyHint_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Renderer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kInitialize:
            return "Receive media::mojom::Renderer::Initialize";
      case messages::Renderer::kFlush:
            return "Receive media::mojom::Renderer::Flush";
      case messages::Renderer::kStartPlayingFrom:
            return "Receive media::mojom::Renderer::StartPlayingFrom";
      case messages::Renderer::kSetPlaybackRate:
            return "Receive media::mojom::Renderer::SetPlaybackRate";
      case messages::Renderer::kSetVolume:
            return "Receive media::mojom::Renderer::SetVolume";
      case messages::Renderer::kSetCdm:
            return "Receive media::mojom::Renderer::SetCdm";
      case messages::Renderer::kSetLatencyHint:
            return "Receive media::mojom::Renderer::SetLatencyHint";
    }
  } else {
    switch (static_cast<messages::Renderer>(message.name())) {
      case messages::Renderer::kInitialize:
            return "Receive reply media::mojom::Renderer::Initialize";
      case messages::Renderer::kFlush:
            return "Receive reply media::mojom::Renderer::Flush";
      case messages::Renderer::kStartPlayingFrom:
            return "Receive reply media::mojom::Renderer::StartPlayingFrom";
      case messages::Renderer::kSetPlaybackRate:
            return "Receive reply media::mojom::Renderer::SetPlaybackRate";
      case messages::Renderer::kSetVolume:
            return "Receive reply media::mojom::Renderer::SetVolume";
      case messages::Renderer::kSetCdm:
            return "Receive reply media::mojom::Renderer::SetCdm";
      case messages::Renderer::kSetLatencyHint:
            return "Receive reply media::mojom::Renderer::SetLatencyHint";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Renderer::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeac84d62;  // IPCStableHash for media::mojom::Renderer::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee912d1f;  // IPCStableHash for media::mojom::Renderer::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::StartPlayingFrom_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27e1c5c7;  // IPCStableHash for media::mojom::Renderer::StartPlayingFrom
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetPlaybackRate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfeaedc0c;  // IPCStableHash for media::mojom::Renderer::SetPlaybackRate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetVolume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc71d86cb;  // IPCStableHash for media::mojom::Renderer::SetVolume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetCdm_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba6084a8;  // IPCStableHash for media::mojom::Renderer::SetCdm
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Renderer::SetLatencyHint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb49192b;  // IPCStableHash for media::mojom::Renderer::SetLatencyHint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Renderer_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_Initialize_ForwardToCallback(
      Renderer::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_Initialize_ForwardToCallback(const Renderer_Initialize_ForwardToCallback&) = delete;
  Renderer_Initialize_ForwardToCallback& operator=(const Renderer_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::InitializeCallback callback_;
};

class Renderer_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_Flush_ForwardToCallback(
      Renderer::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_Flush_ForwardToCallback(const Renderer_Flush_ForwardToCallback&) = delete;
  Renderer_Flush_ForwardToCallback& operator=(const Renderer_Flush_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::FlushCallback callback_;
};

class Renderer_SetCdm_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Renderer_SetCdm_ForwardToCallback(
      Renderer::SetCdmCallback callback
      ) : callback_(std::move(callback)) {
  }

  Renderer_SetCdm_ForwardToCallback(const Renderer_SetCdm_ForwardToCallback&) = delete;
  Renderer_SetCdm_ForwardToCallback& operator=(const Renderer_SetCdm_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Renderer::SetCdmCallback callback_;
};

RendererProxy::RendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererProxy::Initialize(
    ::mojo::PendingAssociatedRemote<RendererClient> in_client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> in_streams, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<RendererClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("streams"), in_streams,
                        "<value of type std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Initialize_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::RendererClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in Renderer.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->streams)::BaseType>
      streams_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& streams_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>>(
    in_streams,
    streams_fragment,
    &streams_validate_params);

  params->streams.Set(
      streams_fragment.is_null() ? nullptr : streams_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::Renderer::Flush");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_Flush_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::StartPlayingFrom(
    ::base::TimeDelta in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::StartPlayingFrom", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kStartPlayingFrom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_StartPlayingFrom_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in Renderer.StartPlayingFrom request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("StartPlayingFrom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetPlaybackRate(
    double in_playback_rate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::SetPlaybackRate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("playback_rate"), in_playback_rate,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetPlaybackRate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetPlaybackRate_Params_Data> params(
          message);
  params.Allocate();

  params->playback_rate = in_playback_rate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetPlaybackRate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetVolume(
    float in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetVolume_Params_Data> params(
          message);
  params.Allocate();

  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererProxy::SetCdm(
    const std::optional<::base::UnguessableToken>& in_cdm_id, SetCdmCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::SetCdm", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_id"), in_cdm_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetCdm_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_id)::BaseType> cdm_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_cdm_id,
    cdm_id_fragment);

  params->cdm_id.Set(
      cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetCdm");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Renderer_SetCdm_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RendererProxy::SetLatencyHint(
    std::optional<::base::TimeDelta> in_latency_hint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::Renderer::SetLatencyHint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("latency_hint"), in_latency_hint,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetLatencyHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetLatencyHint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->latency_hint)::BaseType> latency_hint_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_latency_hint,
    latency_hint_fragment);

  params->latency_hint.Set(
      latency_hint_fragment.is_null() ? nullptr : latency_hint_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetLatencyHint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Renderer_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_Initialize_ProxyToResponder> proxy(
        new Renderer_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Renderer::InitializeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Renderer_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Renderer.0
  bool success = true;
  bool p_success{};
  Renderer_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Renderer_Initialize_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Renderer::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_Flush_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::FlushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_Flush_ProxyToResponder> proxy(
        new Renderer_Flush_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_Flush_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Renderer::FlushCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Renderer_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Renderer.1
  bool success = true;
  Renderer_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Renderer_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply media::mojom::Renderer::Flush");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Renderer_SetCdm_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Renderer::SetCdmCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Renderer_SetCdm_ProxyToResponder> proxy(
        new Renderer_SetCdm_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Renderer_SetCdm_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Renderer_SetCdm_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Renderer_SetCdm_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Renderer::SetCdmCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Renderer_SetCdm_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Renderer_SetCdm_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Renderer_SetCdm_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Renderer.5
  bool success = true;
  bool p_success{};
  Renderer_SetCdm_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Renderer::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Renderer_SetCdm_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::Renderer::SetCdm", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Renderer::kSetCdm), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::Renderer_SetCdm_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Renderer::Name_);
  message.set_method_name("SetCdm");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererStubDispatch::Accept(
    Renderer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kInitialize: {
      break;
    }
    case messages::Renderer::kFlush: {
      break;
    }
    case messages::Renderer::kStartPlayingFrom: {
      DCHECK(message->is_serialized());
      internal::Renderer_StartPlayingFrom_Params_Data* params =
          reinterpret_cast<internal::Renderer_StartPlayingFrom_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Renderer.2
      bool success = true;
      ::base::TimeDelta p_time{};
      Renderer_StartPlayingFrom_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPlayingFrom(        
        std::move(p_time));
      return true;
    }
    case messages::Renderer::kSetPlaybackRate: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetPlaybackRate_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetPlaybackRate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Renderer.3
      bool success = true;
      double p_playback_rate{};
      Renderer_SetPlaybackRate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_playback_rate = input_data_view.playback_rate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackRate(        
        std::move(p_playback_rate));
      return true;
    }
    case messages::Renderer::kSetVolume: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetVolume_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetVolume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Renderer.4
      bool success = true;
      float p_volume{};
      Renderer_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(        
        std::move(p_volume));
      return true;
    }
    case messages::Renderer::kSetCdm: {
      break;
    }
    case messages::Renderer::kSetLatencyHint: {
      DCHECK(message->is_serialized());
      internal::Renderer_SetLatencyHint_Params_Data* params =
          reinterpret_cast<internal::Renderer_SetLatencyHint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Renderer.6
      bool success = true;
      std::optional<::base::TimeDelta> p_latency_hint{};
      Renderer_SetLatencyHint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLatencyHint(&p_latency_hint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLatencyHint(        
        std::move(p_latency_hint));
      return true;
    }
  }
  return false;
}

// static
bool RendererStubDispatch::AcceptWithResponder(
    Renderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Renderer>(message->header()->name)) {
    case messages::Renderer::kInitialize: {
      internal::Renderer_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_Initialize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Renderer.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<RendererClient> p_client{};
      std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> p_streams{};
      Renderer_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadStreams(&p_streams))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 0, false);
        return false;
      }
      auto callback =
          Renderer_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_client), 
        std::move(p_streams), std::move(callback));
      return true;
    }
    case messages::Renderer::kFlush: {
      internal::Renderer_Flush_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_Flush_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Renderer.1
      bool success = true;
      Renderer_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 1, false);
        return false;
      }
      auto callback =
          Renderer_Flush_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case messages::Renderer::kStartPlayingFrom: {
      break;
    }
    case messages::Renderer::kSetPlaybackRate: {
      break;
    }
    case messages::Renderer::kSetVolume: {
      break;
    }
    case messages::Renderer::kSetCdm: {
      internal::Renderer_SetCdm_Params_Data* params =
          reinterpret_cast<
              internal::Renderer_SetCdm_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Renderer.5
      bool success = true;
      std::optional<::base::UnguessableToken> p_cdm_id{};
      Renderer_SetCdm_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmId(&p_cdm_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Renderer::Name_, 5, false);
        return false;
      }
      auto callback =
          Renderer_SetCdm_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCdm(        
        std::move(p_cdm_id), std::move(callback));
      return true;
    }
    case messages::Renderer::kSetLatencyHint: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererValidationInfo[] = {
    { &internal::Renderer_Initialize_Params_Data::Validate,
     &internal::Renderer_Initialize_ResponseParams_Data::Validate},
    { &internal::Renderer_Flush_Params_Data::Validate,
     &internal::Renderer_Flush_ResponseParams_Data::Validate},
    { &internal::Renderer_StartPlayingFrom_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Renderer_SetPlaybackRate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Renderer_SetVolume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Renderer_SetCdm_Params_Data::Validate,
     &internal::Renderer_SetCdm_ResponseParams_Data::Validate},
    { &internal::Renderer_SetLatencyHint_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::Renderer::Name_,
    kRendererValidationInfo);
}

bool RendererResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::Renderer::Name_,
    kRendererValidationInfo);
}
// The declaration includes the definition on other builds.

RendererClient::IPCStableHashFunction RendererClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererClient>(message.name())) {
    case messages::RendererClient::kOnTimeUpdate: {
      return &RendererClient::OnTimeUpdate_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnBufferingStateChange: {
      return &RendererClient::OnBufferingStateChange_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnEnded: {
      return &RendererClient::OnEnded_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnError: {
      return &RendererClient::OnError_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnAudioConfigChange: {
      return &RendererClient::OnAudioConfigChange_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnVideoConfigChange: {
      return &RendererClient::OnVideoConfigChange_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnVideoNaturalSizeChange: {
      return &RendererClient::OnVideoNaturalSizeChange_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnVideoOpacityChange: {
      return &RendererClient::OnVideoOpacityChange_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnStatisticsUpdate: {
      return &RendererClient::OnStatisticsUpdate_Sym::IPCStableHash;
    }
    case messages::RendererClient::kOnWaiting: {
      return &RendererClient::OnWaiting_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererClient>(message.name())) {
      case messages::RendererClient::kOnTimeUpdate:
            return "Receive media::mojom::RendererClient::OnTimeUpdate";
      case messages::RendererClient::kOnBufferingStateChange:
            return "Receive media::mojom::RendererClient::OnBufferingStateChange";
      case messages::RendererClient::kOnEnded:
            return "Receive media::mojom::RendererClient::OnEnded";
      case messages::RendererClient::kOnError:
            return "Receive media::mojom::RendererClient::OnError";
      case messages::RendererClient::kOnAudioConfigChange:
            return "Receive media::mojom::RendererClient::OnAudioConfigChange";
      case messages::RendererClient::kOnVideoConfigChange:
            return "Receive media::mojom::RendererClient::OnVideoConfigChange";
      case messages::RendererClient::kOnVideoNaturalSizeChange:
            return "Receive media::mojom::RendererClient::OnVideoNaturalSizeChange";
      case messages::RendererClient::kOnVideoOpacityChange:
            return "Receive media::mojom::RendererClient::OnVideoOpacityChange";
      case messages::RendererClient::kOnStatisticsUpdate:
            return "Receive media::mojom::RendererClient::OnStatisticsUpdate";
      case messages::RendererClient::kOnWaiting:
            return "Receive media::mojom::RendererClient::OnWaiting";
    }
  } else {
    switch (static_cast<messages::RendererClient>(message.name())) {
      case messages::RendererClient::kOnTimeUpdate:
            return "Receive reply media::mojom::RendererClient::OnTimeUpdate";
      case messages::RendererClient::kOnBufferingStateChange:
            return "Receive reply media::mojom::RendererClient::OnBufferingStateChange";
      case messages::RendererClient::kOnEnded:
            return "Receive reply media::mojom::RendererClient::OnEnded";
      case messages::RendererClient::kOnError:
            return "Receive reply media::mojom::RendererClient::OnError";
      case messages::RendererClient::kOnAudioConfigChange:
            return "Receive reply media::mojom::RendererClient::OnAudioConfigChange";
      case messages::RendererClient::kOnVideoConfigChange:
            return "Receive reply media::mojom::RendererClient::OnVideoConfigChange";
      case messages::RendererClient::kOnVideoNaturalSizeChange:
            return "Receive reply media::mojom::RendererClient::OnVideoNaturalSizeChange";
      case messages::RendererClient::kOnVideoOpacityChange:
            return "Receive reply media::mojom::RendererClient::OnVideoOpacityChange";
      case messages::RendererClient::kOnStatisticsUpdate:
            return "Receive reply media::mojom::RendererClient::OnStatisticsUpdate";
      case messages::RendererClient::kOnWaiting:
            return "Receive reply media::mojom::RendererClient::OnWaiting";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererClient::OnTimeUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdebfc81b;  // IPCStableHash for media::mojom::RendererClient::OnTimeUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnBufferingStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1101c168;  // IPCStableHash for media::mojom::RendererClient::OnBufferingStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnEnded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc025f2f;  // IPCStableHash for media::mojom::RendererClient::OnEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x032b0ad5;  // IPCStableHash for media::mojom::RendererClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnAudioConfigChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79d7d61b;  // IPCStableHash for media::mojom::RendererClient::OnAudioConfigChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnVideoConfigChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xda9904cd;  // IPCStableHash for media::mojom::RendererClient::OnVideoConfigChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnVideoNaturalSizeChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2582523;  // IPCStableHash for media::mojom::RendererClient::OnVideoNaturalSizeChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnVideoOpacityChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c2a676b;  // IPCStableHash for media::mojom::RendererClient::OnVideoOpacityChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnStatisticsUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff69201c;  // IPCStableHash for media::mojom::RendererClient::OnStatisticsUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererClient::OnWaiting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79db3829;  // IPCStableHash for media::mojom::RendererClient::OnWaiting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererClientProxy::RendererClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererClientProxy::OnTimeUpdate(
    ::base::TimeDelta in_time, ::base::TimeDelta in_max_time, ::base::TimeTicks in_capture_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnTimeUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_time"), in_max_time,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_time"), in_capture_time,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnTimeUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnTimeUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in RendererClient.OnTimeUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_time)::BaseType> max_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_max_time,
    max_time_fragment);

  params->max_time.Set(
      max_time_fragment.is_null() ? nullptr : max_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->max_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null max_time in RendererClient.OnTimeUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->capture_time)::BaseType> capture_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_capture_time,
    capture_time_fragment);

  params->capture_time.Set(
      capture_time_fragment.is_null() ? nullptr : capture_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->capture_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null capture_time in RendererClient.OnTimeUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnTimeUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnBufferingStateChange(
    ::media::BufferingState in_state, ::media::BufferingStateChangeReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnBufferingStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::media::BufferingState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::BufferingStateChangeReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnBufferingStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnBufferingStateChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::BufferingState>(
    in_state,
    &params->state);

  
  mojo::internal::Serialize<::media::mojom::BufferingStateChangeReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnBufferingStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::RendererClient::OnEnded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnEnded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnError(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in RendererClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnAudioConfigChange(
    const ::media::AudioDecoderConfig& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnAudioConfigChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::AudioDecoderConfig&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnAudioConfigChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnAudioConfigChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in RendererClient.OnAudioConfigChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnAudioConfigChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnVideoConfigChange(
    const ::media::VideoDecoderConfig& in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnVideoConfigChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type const ::media::VideoDecoderConfig&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnVideoConfigChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoConfigChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in RendererClient.OnVideoConfigChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoConfigChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnVideoNaturalSizeChange(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnVideoNaturalSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnVideoNaturalSizeChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoNaturalSizeChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in RendererClient.OnVideoNaturalSizeChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoNaturalSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnVideoOpacityChange(
    bool in_opaque) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnVideoOpacityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opaque"), in_opaque,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnVideoOpacityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnVideoOpacityChange_Params_Data> params(
          message);
  params.Allocate();

  params->opaque = in_opaque;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnVideoOpacityChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnStatisticsUpdate(
    const ::media::PipelineStatistics& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnStatisticsUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type const ::media::PipelineStatistics&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnStatisticsUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnStatisticsUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatisticsDataView>(
    in_stats,
    stats_fragment);

  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stats in RendererClient.OnStatisticsUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnStatisticsUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererClientProxy::OnWaiting(
    ::media::WaitingReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::RendererClient::OnWaiting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::WaitingReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererClient::kOnWaiting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::RendererClient_OnWaiting_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::WaitingReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererClient::Name_);
  message.set_method_name("OnWaiting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererClientStubDispatch::Accept(
    RendererClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererClient>(message->header()->name)) {
    case messages::RendererClient::kOnTimeUpdate: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnTimeUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnTimeUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.0
      bool success = true;
      ::base::TimeDelta p_time{};
      ::base::TimeDelta p_max_time{};
      ::base::TimeTicks p_capture_time{};
      RendererClient_OnTimeUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (success && !input_data_view.ReadMaxTime(&p_max_time))
        success = false;
      if (success && !input_data_view.ReadCaptureTime(&p_capture_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTimeUpdate(        
        std::move(p_time), 
        std::move(p_max_time), 
        std::move(p_capture_time));
      return true;
    }
    case messages::RendererClient::kOnBufferingStateChange: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnBufferingStateChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnBufferingStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.1
      bool success = true;
      ::media::BufferingState p_state{};
      ::media::BufferingStateChangeReason p_reason{};
      RendererClient_OnBufferingStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferingStateChange(        
        std::move(p_state), 
        std::move(p_reason));
      return true;
    }
    case messages::RendererClient::kOnEnded: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnEnded_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.2
      bool success = true;
      RendererClient_OnEnded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEnded(        );
      return true;
    }
    case messages::RendererClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnError_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.3
      bool success = true;
      ::media::PipelineStatus p_status{};
      RendererClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_status));
      return true;
    }
    case messages::RendererClient::kOnAudioConfigChange: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnAudioConfigChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnAudioConfigChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.4
      bool success = true;
      ::media::AudioDecoderConfig p_config{};
      RendererClient_OnAudioConfigChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAudioConfigChange(        
        std::move(p_config));
      return true;
    }
    case messages::RendererClient::kOnVideoConfigChange: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoConfigChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoConfigChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.5
      bool success = true;
      ::media::VideoDecoderConfig p_config{};
      RendererClient_OnVideoConfigChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoConfigChange(        
        std::move(p_config));
      return true;
    }
    case messages::RendererClient::kOnVideoNaturalSizeChange: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoNaturalSizeChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoNaturalSizeChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.6
      bool success = true;
      ::gfx::Size p_size{};
      RendererClient_OnVideoNaturalSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoNaturalSizeChange(        
        std::move(p_size));
      return true;
    }
    case messages::RendererClient::kOnVideoOpacityChange: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnVideoOpacityChange_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnVideoOpacityChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.7
      bool success = true;
      bool p_opaque{};
      RendererClient_OnVideoOpacityChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_opaque = input_data_view.opaque();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoOpacityChange(        
        std::move(p_opaque));
      return true;
    }
    case messages::RendererClient::kOnStatisticsUpdate: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnStatisticsUpdate_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnStatisticsUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.8
      bool success = true;
      ::media::PipelineStatistics p_stats{};
      RendererClient_OnStatisticsUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStats(&p_stats))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStatisticsUpdate(        
        std::move(p_stats));
      return true;
    }
    case messages::RendererClient::kOnWaiting: {
      DCHECK(message->is_serialized());
      internal::RendererClient_OnWaiting_Params_Data* params =
          reinterpret_cast<internal::RendererClient_OnWaiting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererClient.9
      bool success = true;
      ::media::WaitingReason p_reason{};
      RendererClient_OnWaiting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWaiting(        
        std::move(p_reason));
      return true;
    }
  }
  return false;
}

// static
bool RendererClientStubDispatch::AcceptWithResponder(
    RendererClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererClient>(message->header()->name)) {
    case messages::RendererClient::kOnTimeUpdate: {
      break;
    }
    case messages::RendererClient::kOnBufferingStateChange: {
      break;
    }
    case messages::RendererClient::kOnEnded: {
      break;
    }
    case messages::RendererClient::kOnError: {
      break;
    }
    case messages::RendererClient::kOnAudioConfigChange: {
      break;
    }
    case messages::RendererClient::kOnVideoConfigChange: {
      break;
    }
    case messages::RendererClient::kOnVideoNaturalSizeChange: {
      break;
    }
    case messages::RendererClient::kOnVideoOpacityChange: {
      break;
    }
    case messages::RendererClient::kOnStatisticsUpdate: {
      break;
    }
    case messages::RendererClient::kOnWaiting: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererClientValidationInfo[] = {
    { &internal::RendererClient_OnTimeUpdate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnBufferingStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnAudioConfigChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnVideoConfigChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnVideoNaturalSizeChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnVideoOpacityChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnStatisticsUpdate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RendererClient_OnWaiting_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::RendererClient::Name_,
    kRendererClientValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void RendererInterceptorForTesting::Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(client)
    , 
    std::move(streams)
    , std::move(callback));
}
void RendererInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void RendererInterceptorForTesting::StartPlayingFrom(::base::TimeDelta time) {
  GetForwardingInterface()->StartPlayingFrom(
    std::move(time)
    );
}
void RendererInterceptorForTesting::SetPlaybackRate(double playback_rate) {
  GetForwardingInterface()->SetPlaybackRate(
    std::move(playback_rate)
    );
}
void RendererInterceptorForTesting::SetVolume(float volume) {
  GetForwardingInterface()->SetVolume(
    std::move(volume)
    );
}
void RendererInterceptorForTesting::SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) {
  GetForwardingInterface()->SetCdm(
    std::move(cdm_id)
    , std::move(callback));
}
void RendererInterceptorForTesting::SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) {
  GetForwardingInterface()->SetLatencyHint(
    std::move(latency_hint)
    );
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;


void RendererAsyncWaiter::Initialize(
    ::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, bool* out_success) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(client),
      std::move(streams),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool RendererAsyncWaiter::Initialize(
    ::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams) {
  bool async_wait_result;
  Initialize(std::move(client),std::move(streams),&async_wait_result);
  return async_wait_result;
}

void RendererAsyncWaiter::Flush(
    ) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RendererAsyncWaiter::SetCdm(
    const std::optional<::base::UnguessableToken>& cdm_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetCdm(
      std::move(cdm_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool RendererAsyncWaiter::SetCdm(
    const std::optional<::base::UnguessableToken>& cdm_id) {
  bool async_wait_result;
  SetCdm(std::move(cdm_id),&async_wait_result);
  return async_wait_result;
}




void RendererClientInterceptorForTesting::OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) {
  GetForwardingInterface()->OnTimeUpdate(
    std::move(time)
    , 
    std::move(max_time)
    , 
    std::move(capture_time)
    );
}
void RendererClientInterceptorForTesting::OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) {
  GetForwardingInterface()->OnBufferingStateChange(
    std::move(state)
    , 
    std::move(reason)
    );
}
void RendererClientInterceptorForTesting::OnEnded() {
  GetForwardingInterface()->OnEnded();
}
void RendererClientInterceptorForTesting::OnError(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnError(
    std::move(status)
    );
}
void RendererClientInterceptorForTesting::OnAudioConfigChange(const ::media::AudioDecoderConfig& config) {
  GetForwardingInterface()->OnAudioConfigChange(
    std::move(config)
    );
}
void RendererClientInterceptorForTesting::OnVideoConfigChange(const ::media::VideoDecoderConfig& config) {
  GetForwardingInterface()->OnVideoConfigChange(
    std::move(config)
    );
}
void RendererClientInterceptorForTesting::OnVideoNaturalSizeChange(const ::gfx::Size& size) {
  GetForwardingInterface()->OnVideoNaturalSizeChange(
    std::move(size)
    );
}
void RendererClientInterceptorForTesting::OnVideoOpacityChange(bool opaque) {
  GetForwardingInterface()->OnVideoOpacityChange(
    std::move(opaque)
    );
}
void RendererClientInterceptorForTesting::OnStatisticsUpdate(const ::media::PipelineStatistics& stats) {
  GetForwardingInterface()->OnStatisticsUpdate(
    std::move(stats)
    );
}
void RendererClientInterceptorForTesting::OnWaiting(::media::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(
    std::move(reason)
    );
}
RendererClientAsyncWaiter::RendererClientAsyncWaiter(
    RendererClient* proxy) : proxy_(proxy) {}

RendererClientAsyncWaiter::~RendererClientAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif