// media/mojo/mojom/renderer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/renderer.mojom.h"


namespace media::mojom {


class  RendererInterceptorForTesting : public Renderer {
  virtual Renderer* GetForwardingInterface() = 0;
  void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, InitializeCallback callback) override;
  void Flush(FlushCallback callback) override;
  void StartPlayingFrom(::base::TimeDelta time) override;
  void SetPlaybackRate(double playback_rate) override;
  void SetVolume(float volume) override;
  void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) override;
  void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) override;
};
class  RendererAsyncWaiter {
 public:
  explicit RendererAsyncWaiter(Renderer* proxy);

  RendererAsyncWaiter(const RendererAsyncWaiter&) = delete;
  RendererAsyncWaiter& operator=(const RendererAsyncWaiter&) = delete;

  ~RendererAsyncWaiter();
  void Initialize(
      ::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams, bool* out_success);
  bool Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<std::vector<::mojo::PendingRemote<::media::mojom::DemuxerStream>>> streams);
  void Flush(
      );
  
  void SetCdm(
      const std::optional<::base::UnguessableToken>& cdm_id, bool* out_success);
  bool SetCdm(const std::optional<::base::UnguessableToken>& cdm_id);

 private:
  Renderer* const proxy_;
};


class  RendererClientInterceptorForTesting : public RendererClient {
  virtual RendererClient* GetForwardingInterface() = 0;
  void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) override;
  void OnBufferingStateChange(::media::BufferingState state, ::media::BufferingStateChangeReason reason) override;
  void OnEnded() override;
  void OnError(const ::media::PipelineStatus& status) override;
  void OnAudioConfigChange(const ::media::AudioDecoderConfig& config) override;
  void OnVideoConfigChange(const ::media::VideoDecoderConfig& config) override;
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) override;
  void OnVideoOpacityChange(bool opaque) override;
  void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) override;
  void OnWaiting(::media::WaitingReason reason) override;
};
class  RendererClientAsyncWaiter {
 public:
  explicit RendererClientAsyncWaiter(RendererClient* proxy);

  RendererClientAsyncWaiter(const RendererClientAsyncWaiter&) = delete;
  RendererClientAsyncWaiter& operator=(const RendererClientAsyncWaiter&) = delete;

  ~RendererClientAsyncWaiter();

 private:
  RendererClient* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_TEST_UTILS_H_