// media/mojo/mojom/provision_fetcher.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/provision_fetcher.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/provision_fetcher.mojom-params-data.h"
#include "media/mojo/mojom/provision_fetcher.mojom-shared-message-ids.h"

#include "media/mojo/mojom/provision_fetcher.mojom-blink-import-headers.h"
#include "media/mojo/mojom/provision_fetcher.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

ProvisionFetcher::IPCStableHashFunction ProvisionFetcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProvisionFetcher>(message.name())) {
    case messages::ProvisionFetcher::kRetrieve: {
      return &ProvisionFetcher::Retrieve_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProvisionFetcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProvisionFetcher>(message.name())) {
      case messages::ProvisionFetcher::kRetrieve:
            return "Receive media::mojom::ProvisionFetcher::Retrieve";
    }
  } else {
    switch (static_cast<messages::ProvisionFetcher>(message.name())) {
      case messages::ProvisionFetcher::kRetrieve:
            return "Receive reply media::mojom::ProvisionFetcher::Retrieve";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProvisionFetcher::Retrieve_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6aa286fb;  // IPCStableHash for media::mojom::ProvisionFetcher::Retrieve
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProvisionFetcher_Retrieve_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProvisionFetcher_Retrieve_ForwardToCallback(
      ProvisionFetcher::RetrieveCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProvisionFetcher_Retrieve_ForwardToCallback(const ProvisionFetcher_Retrieve_ForwardToCallback&) = delete;
  ProvisionFetcher_Retrieve_ForwardToCallback& operator=(const ProvisionFetcher_Retrieve_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProvisionFetcher::RetrieveCallback callback_;
};

ProvisionFetcherProxy::ProvisionFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProvisionFetcherProxy::Retrieve(
    const ::blink::KURL& in_default_url, const ::blink::String& in_request_data, RetrieveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::ProvisionFetcher::Retrieve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_url"), in_default_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_data"), in_request_data,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProvisionFetcher::kRetrieve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ProvisionFetcher_Retrieve_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->default_url)::BaseType> default_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_default_url,
    default_url_fragment);

  params->default_url.Set(
      default_url_fragment.is_null() ? nullptr : default_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_url in ProvisionFetcher.Retrieve request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_data)::BaseType> request_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_request_data,
    request_data_fragment);

  params->request_data.Set(
      request_data_fragment.is_null() ? nullptr : request_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_data in ProvisionFetcher.Retrieve request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProvisionFetcher::Name_);
  message.set_method_name("Retrieve");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProvisionFetcher_Retrieve_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProvisionFetcher_Retrieve_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProvisionFetcher::RetrieveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProvisionFetcher_Retrieve_ProxyToResponder> proxy(
        new ProvisionFetcher_Retrieve_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProvisionFetcher_Retrieve_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProvisionFetcher_Retrieve_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProvisionFetcher_Retrieve_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProvisionFetcher::RetrieveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result, const ::blink::String& in_response);
};

bool ProvisionFetcher_Retrieve_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProvisionFetcher_Retrieve_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProvisionFetcher_Retrieve_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProvisionFetcher.0
  bool success = true;
  bool p_result{};
  ::blink::String p_response{};
  ProvisionFetcher_Retrieve_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProvisionFetcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_response));
  }
  return true;
}

void ProvisionFetcher_Retrieve_ProxyToResponder::Run(
    bool in_result, const ::blink::String& in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::ProvisionFetcher::Retrieve", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProvisionFetcher::kRetrieve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::ProvisionFetcher_Retrieve_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProvisionFetcher::Name_);
  message.set_method_name("Retrieve");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProvisionFetcherStubDispatch::Accept(
    ProvisionFetcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProvisionFetcher>(message->header()->name)) {
    case messages::ProvisionFetcher::kRetrieve: {
      break;
    }
  }
  return false;
}

// static
bool ProvisionFetcherStubDispatch::AcceptWithResponder(
    ProvisionFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProvisionFetcher>(message->header()->name)) {
    case messages::ProvisionFetcher::kRetrieve: {
      internal::ProvisionFetcher_Retrieve_Params_Data* params =
          reinterpret_cast<
              internal::ProvisionFetcher_Retrieve_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProvisionFetcher.0
      bool success = true;
      ::blink::KURL p_default_url{};
      ::blink::String p_request_data{};
      ProvisionFetcher_Retrieve_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDefaultUrl(&p_default_url))
        success = false;
      if (success && !input_data_view.ReadRequestData(&p_request_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProvisionFetcher::Name_, 0, false);
        return false;
      }
      auto callback =
          ProvisionFetcher_Retrieve_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Retrieve(        
        std::move(p_default_url), 
        std::move(p_request_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProvisionFetcherValidationInfo[] = {
    { &internal::ProvisionFetcher_Retrieve_Params_Data::Validate,
     &internal::ProvisionFetcher_Retrieve_ResponseParams_Data::Validate},
};

bool ProvisionFetcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::ProvisionFetcher::Name_,
    kProvisionFetcherValidationInfo);
}

bool ProvisionFetcherResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::ProvisionFetcher::Name_,
    kProvisionFetcherValidationInfo);
}


}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void ProvisionFetcherInterceptorForTesting::Retrieve(const ::blink::KURL& default_url, const ::blink::String& request_data, RetrieveCallback callback) {
  GetForwardingInterface()->Retrieve(
    std::move(default_url)
    , 
    std::move(request_data)
    , std::move(callback));
}
ProvisionFetcherAsyncWaiter::ProvisionFetcherAsyncWaiter(
    ProvisionFetcher* proxy) : proxy_(proxy) {}

ProvisionFetcherAsyncWaiter::~ProvisionFetcherAsyncWaiter() = default;


void ProvisionFetcherAsyncWaiter::Retrieve(
    const ::blink::KURL& default_url, const ::blink::String& request_data, bool* out_result, ::blink::String* out_response) {
  base::RunLoop loop;
  proxy_->Retrieve(
      std::move(default_url),
      std::move(request_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             ::blink::String* out_response
,
             bool result,
             const ::blink::String& response) {*out_result = std::move(result);*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_result,
          out_response));
  loop.Run();
}








}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif