// media/mojo/mojom/playback_events_recorder.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  PipelineStatistics as media_mojom_PipelineStatistics,
  PipelineStatisticsSpec as media_mojom_PipelineStatisticsSpec,
  PipelineStatus as media_mojom_PipelineStatus,
  PipelineStatusSpec as media_mojom_PipelineStatusSpec
} from './media_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PlaybackEventsRecorderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.PlaybackEventsRecorder', scope);
  }
}

/** @interface */
export class PlaybackEventsRecorderInterface {
  
  /**
   */

  onPlaying() {}
  
  /**
   */

  onPaused() {}
  
  /**
   */

  onSeeking() {}
  
  /**
   */

  onEnded() {}
  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(status) {}
  
  /**
   */

  onBuffering() {}
  
  /**
   */

  onBufferingComplete() {}
  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onNaturalSizeChanged(size) {}
  
  /**
   * @param { !media_mojom_PipelineStatistics } stats
   */

  onPipelineStatistics(stats) {}
}

/**
 * @implements { PlaybackEventsRecorderInterface }
 */
export class PlaybackEventsRecorderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PlaybackEventsRecorderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlaybackEventsRecorderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PlaybackEventsRecorderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onPlaying() {
    this.proxy.sendMessage(
        0,
        PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onPaused() {
    this.proxy.sendMessage(
        1,
        PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onSeeking() {
    this.proxy.sendMessage(
        2,
        PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onEnded() {
    this.proxy.sendMessage(
        3,
        PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        4,
        PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   */

  onBuffering() {
    this.proxy.sendMessage(
        5,
        PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onBufferingComplete() {
    this.proxy.sendMessage(
        6,
        PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Size } size
   */

  onNaturalSizeChanged(
      size) {
    this.proxy.sendMessage(
        7,
        PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_PipelineStatistics } stats
   */

  onPipelineStatistics(
      stats) {
    this.proxy.sendMessage(
        8,
        PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        [
          stats
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PlaybackEventsRecorder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlaybackEventsRecorderReceiver {
  /**
   * @param {!PlaybackEventsRecorderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PlaybackEventsRecorderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlaybackEventsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlaybackEventsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        impl.onPlaying.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        impl.onPaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        impl.onSeeking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        impl.onEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        impl.onBuffering.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        impl.onBufferingComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        impl.onNaturalSizeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        impl.onPipelineStatistics.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlaybackEventsRecorder {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.PlaybackEventsRecorder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PlaybackEventsRecorderRemote}
   */
  static getRemote() {
    let remote = new PlaybackEventsRecorderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PlaybackEventsRecorder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlaybackEventsRecorderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlaybackEventsRecorderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlaybackEventsRecorderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPlaying =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
        null,
        this.onPlaying.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
        null,
        this.onPaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSeeking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
        null,
        this.onSeeking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
        null,
        this.onEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PlaybackEventsRecorder_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBuffering =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
        null,
        this.onBuffering.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferingComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
        null,
        this.onBufferingComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNaturalSizeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
        null,
        this.onNaturalSizeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPipelineStatistics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
        null,
        this.onPipelineStatistics.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnPlaying_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnPaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnSeeking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnBuffering_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PlaybackEventsRecorder_OnPlaying_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPlaying_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnPlaying_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnPaused_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPaused_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnPaused_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnSeeking_ParamsSpec.$,
    'PlaybackEventsRecorder_OnSeeking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnSeeking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnEnded_ParamsSpec.$,
    'PlaybackEventsRecorder_OnEnded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnEnded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnError_ParamsSpec.$,
    'PlaybackEventsRecorder_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media_mojom_PipelineStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnError_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnBuffering_ParamsSpec.$,
    'PlaybackEventsRecorder_OnBuffering_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnBuffering_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnBufferingComplete_ParamsSpec.$,
    'PlaybackEventsRecorder_OnBufferingComplete_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnBufferingComplete_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnNaturalSizeChanged_ParamsSpec.$,
    'PlaybackEventsRecorder_OnNaturalSizeChanged_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnNaturalSizeChanged_Params {
  constructor() {
    /** @type { !gfx_mojom_Size } */
    this.size;
  }
}



mojo.internal.Struct(
    PlaybackEventsRecorder_OnPipelineStatistics_ParamsSpec.$,
    'PlaybackEventsRecorder_OnPipelineStatistics_Params',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        media_mojom_PipelineStatisticsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlaybackEventsRecorder_OnPipelineStatistics_Params {
  constructor() {
    /** @type { !media_mojom_PipelineStatistics } */
    this.stats;
  }
}

