// media/mojo/mojom/output_protection.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/output_protection.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/output_protection.mojom-params-data.h"
#include "media/mojo/mojom/output_protection.mojom-shared-message-ids.h"

#include "media/mojo/mojom/output_protection.mojom-import-headers.h"
#include "media/mojo/mojom/output_protection.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

OutputProtection::IPCStableHashFunction OutputProtection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OutputProtection>(message.name())) {
    case messages::OutputProtection::kQueryStatus: {
      return &OutputProtection::QueryStatus_Sym::IPCStableHash;
    }
    case messages::OutputProtection::kEnableProtection: {
      return &OutputProtection::EnableProtection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OutputProtection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OutputProtection>(message.name())) {
      case messages::OutputProtection::kQueryStatus:
            return "Receive media::mojom::OutputProtection::QueryStatus";
      case messages::OutputProtection::kEnableProtection:
            return "Receive media::mojom::OutputProtection::EnableProtection";
    }
  } else {
    switch (static_cast<messages::OutputProtection>(message.name())) {
      case messages::OutputProtection::kQueryStatus:
            return "Receive reply media::mojom::OutputProtection::QueryStatus";
      case messages::OutputProtection::kEnableProtection:
            return "Receive reply media::mojom::OutputProtection::EnableProtection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OutputProtection::QueryStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ad61ab3;  // IPCStableHash for media::mojom::OutputProtection::QueryStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OutputProtection::EnableProtection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3304e01;  // IPCStableHash for media::mojom::OutputProtection::EnableProtection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OutputProtection_QueryStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OutputProtection_QueryStatus_ForwardToCallback(
      OutputProtection::QueryStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  OutputProtection_QueryStatus_ForwardToCallback(const OutputProtection_QueryStatus_ForwardToCallback&) = delete;
  OutputProtection_QueryStatus_ForwardToCallback& operator=(const OutputProtection_QueryStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OutputProtection::QueryStatusCallback callback_;
};

class OutputProtection_EnableProtection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OutputProtection_EnableProtection_ForwardToCallback(
      OutputProtection::EnableProtectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  OutputProtection_EnableProtection_ForwardToCallback(const OutputProtection_EnableProtection_ForwardToCallback&) = delete;
  OutputProtection_EnableProtection_ForwardToCallback& operator=(const OutputProtection_EnableProtection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OutputProtection::EnableProtectionCallback callback_;
};

OutputProtectionProxy::OutputProtectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OutputProtectionProxy::QueryStatus(
    QueryStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::OutputProtection::QueryStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OutputProtection::kQueryStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_QueryStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("QueryStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OutputProtection_QueryStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OutputProtectionProxy::EnableProtection(
    uint32_t in_desired_protection_mask, EnableProtectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::OutputProtection::EnableProtection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_protection_mask"), in_desired_protection_mask,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OutputProtection::kEnableProtection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_EnableProtection_Params_Data> params(
          message);
  params.Allocate();

  params->desired_protection_mask = in_desired_protection_mask;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("EnableProtection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OutputProtection_EnableProtection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OutputProtection_QueryStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OutputProtection::QueryStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OutputProtection_QueryStatus_ProxyToResponder> proxy(
        new OutputProtection_QueryStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OutputProtection_QueryStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OutputProtection_QueryStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OutputProtection_QueryStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OutputProtection::QueryStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint32_t in_link_mask, uint32_t in_protection_mask);
};

bool OutputProtection_QueryStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OutputProtection_QueryStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OutputProtection_QueryStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OutputProtection.0
  bool success = true;
  bool p_success{};
  uint32_t p_link_mask{};
  uint32_t p_protection_mask{};
  OutputProtection_QueryStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_link_mask = input_data_view.link_mask();
  if (success)
    p_protection_mask = input_data_view.protection_mask();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OutputProtection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_link_mask), 
std::move(p_protection_mask));
  }
  return true;
}

void OutputProtection_QueryStatus_ProxyToResponder::Run(
    bool in_success, uint32_t in_link_mask, uint32_t in_protection_mask) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::OutputProtection::QueryStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_mask"), in_link_mask,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protection_mask"), in_protection_mask,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OutputProtection::kQueryStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_QueryStatus_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->link_mask = in_link_mask;

  params->protection_mask = in_protection_mask;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("QueryStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OutputProtection_EnableProtection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OutputProtection::EnableProtectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OutputProtection_EnableProtection_ProxyToResponder> proxy(
        new OutputProtection_EnableProtection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OutputProtection_EnableProtection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OutputProtection_EnableProtection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OutputProtection_EnableProtection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OutputProtection::EnableProtectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool OutputProtection_EnableProtection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OutputProtection_EnableProtection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OutputProtection_EnableProtection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OutputProtection.1
  bool success = true;
  bool p_success{};
  OutputProtection_EnableProtection_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OutputProtection::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void OutputProtection_EnableProtection_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::OutputProtection::EnableProtection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OutputProtection::kEnableProtection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::OutputProtection_EnableProtection_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OutputProtection::Name_);
  message.set_method_name("EnableProtection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OutputProtectionStubDispatch::Accept(
    OutputProtection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OutputProtection>(message->header()->name)) {
    case messages::OutputProtection::kQueryStatus: {
      break;
    }
    case messages::OutputProtection::kEnableProtection: {
      break;
    }
  }
  return false;
}

// static
bool OutputProtectionStubDispatch::AcceptWithResponder(
    OutputProtection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OutputProtection>(message->header()->name)) {
    case messages::OutputProtection::kQueryStatus: {
      internal::OutputProtection_QueryStatus_Params_Data* params =
          reinterpret_cast<
              internal::OutputProtection_QueryStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OutputProtection.0
      bool success = true;
      OutputProtection_QueryStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OutputProtection::Name_, 0, false);
        return false;
      }
      auto callback =
          OutputProtection_QueryStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryStatus(std::move(callback));
      return true;
    }
    case messages::OutputProtection::kEnableProtection: {
      internal::OutputProtection_EnableProtection_Params_Data* params =
          reinterpret_cast<
              internal::OutputProtection_EnableProtection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OutputProtection.1
      bool success = true;
      uint32_t p_desired_protection_mask{};
      OutputProtection_EnableProtection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_desired_protection_mask = input_data_view.desired_protection_mask();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OutputProtection::Name_, 1, false);
        return false;
      }
      auto callback =
          OutputProtection_EnableProtection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableProtection(        
        std::move(p_desired_protection_mask), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOutputProtectionValidationInfo[] = {
    { &internal::OutputProtection_QueryStatus_Params_Data::Validate,
     &internal::OutputProtection_QueryStatus_ResponseParams_Data::Validate},
    { &internal::OutputProtection_EnableProtection_Params_Data::Validate,
     &internal::OutputProtection_EnableProtection_ResponseParams_Data::Validate},
};

bool OutputProtectionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::OutputProtection::Name_,
    kOutputProtectionValidationInfo);
}

bool OutputProtectionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::OutputProtection::Name_,
    kOutputProtectionValidationInfo);
}


}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void OutputProtectionInterceptorForTesting::QueryStatus(QueryStatusCallback callback) {
  GetForwardingInterface()->QueryStatus(std::move(callback));
}
void OutputProtectionInterceptorForTesting::EnableProtection(uint32_t desired_protection_mask, EnableProtectionCallback callback) {
  GetForwardingInterface()->EnableProtection(
    std::move(desired_protection_mask)
    , std::move(callback));
}
OutputProtectionAsyncWaiter::OutputProtectionAsyncWaiter(
    OutputProtection* proxy) : proxy_(proxy) {}

OutputProtectionAsyncWaiter::~OutputProtectionAsyncWaiter() = default;


void OutputProtectionAsyncWaiter::QueryStatus(
    bool* out_success, uint32_t* out_link_mask, uint32_t* out_protection_mask) {
  base::RunLoop loop;
  proxy_->QueryStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint32_t* out_link_mask
,
             uint32_t* out_protection_mask
,
             bool success,
             uint32_t link_mask,
             uint32_t protection_mask) {*out_success = std::move(success);*out_link_mask = std::move(link_mask);*out_protection_mask = std::move(protection_mask);
            loop->Quit();
          },
          &loop,
          out_success,
          out_link_mask,
          out_protection_mask));
  loop.Run();
}



void OutputProtectionAsyncWaiter::EnableProtection(
    uint32_t desired_protection_mask, bool* out_success) {
  base::RunLoop loop;
  proxy_->EnableProtection(
      std::move(desired_protection_mask),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool OutputProtectionAsyncWaiter::EnableProtection(
    uint32_t desired_protection_mask) {
  bool async_wait_result;
  EnableProtection(std::move(desired_protection_mask),&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif