// media/mojo/mojom/media_metrics_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_metrics_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-params-data.h"
#include "media/mojo/mojom/media_metrics_provider.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-import-headers.h"
#include "media/mojo/mojom/media_metrics_provider.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

MediaMetricsProvider::IPCStableHashFunction MediaMetricsProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaMetricsProvider>(message.name())) {
    case messages::MediaMetricsProvider::kInitialize: {
      return &MediaMetricsProvider::Initialize_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kOnStarted: {
      return &MediaMetricsProvider::OnStarted_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kOnError: {
      return &MediaMetricsProvider::OnError_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kOnFallback: {
      return &MediaMetricsProvider::OnFallback_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetHasPlayed: {
      return &MediaMetricsProvider::SetHasPlayed_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetHaveEnough: {
      return &MediaMetricsProvider::SetHaveEnough_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetIsEME: {
      return &MediaMetricsProvider::SetIsEME_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetTimeToMetadata: {
      return &MediaMetricsProvider::SetTimeToMetadata_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetTimeToFirstFrame: {
      return &MediaMetricsProvider::SetTimeToFirstFrame_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetTimeToPlayReady: {
      return &MediaMetricsProvider::SetTimeToPlayReady_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetRendererType: {
      return &MediaMetricsProvider::SetRendererType_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetDemuxerType: {
      return &MediaMetricsProvider::SetDemuxerType_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetKeySystem: {
      return &MediaMetricsProvider::SetKeySystem_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetHasWaitingForKey: {
      return &MediaMetricsProvider::SetHasWaitingForKey_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetIsHardwareSecure: {
      return &MediaMetricsProvider::SetIsHardwareSecure_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetContainerName: {
      return &MediaMetricsProvider::SetContainerName_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kAcquireWatchTimeRecorder: {
      return &MediaMetricsProvider::AcquireWatchTimeRecorder_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder: {
      return &MediaMetricsProvider::AcquireVideoDecodeStatsRecorder_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder: {
      return &MediaMetricsProvider::AcquirePlaybackEventsRecorder_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetHasAudio: {
      return &MediaMetricsProvider::SetHasAudio_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetHasVideo: {
      return &MediaMetricsProvider::SetHasVideo_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetVideoPipelineInfo: {
      return &MediaMetricsProvider::SetVideoPipelineInfo_Sym::IPCStableHash;
    }
    case messages::MediaMetricsProvider::kSetAudioPipelineInfo: {
      return &MediaMetricsProvider::SetAudioPipelineInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaMetricsProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaMetricsProvider>(message.name())) {
      case messages::MediaMetricsProvider::kInitialize:
            return "Receive media::mojom::MediaMetricsProvider::Initialize";
      case messages::MediaMetricsProvider::kOnStarted:
            return "Receive media::mojom::MediaMetricsProvider::OnStarted";
      case messages::MediaMetricsProvider::kOnError:
            return "Receive media::mojom::MediaMetricsProvider::OnError";
      case messages::MediaMetricsProvider::kOnFallback:
            return "Receive media::mojom::MediaMetricsProvider::OnFallback";
      case messages::MediaMetricsProvider::kSetHasPlayed:
            return "Receive media::mojom::MediaMetricsProvider::SetHasPlayed";
      case messages::MediaMetricsProvider::kSetHaveEnough:
            return "Receive media::mojom::MediaMetricsProvider::SetHaveEnough";
      case messages::MediaMetricsProvider::kSetIsEME:
            return "Receive media::mojom::MediaMetricsProvider::SetIsEME";
      case messages::MediaMetricsProvider::kSetTimeToMetadata:
            return "Receive media::mojom::MediaMetricsProvider::SetTimeToMetadata";
      case messages::MediaMetricsProvider::kSetTimeToFirstFrame:
            return "Receive media::mojom::MediaMetricsProvider::SetTimeToFirstFrame";
      case messages::MediaMetricsProvider::kSetTimeToPlayReady:
            return "Receive media::mojom::MediaMetricsProvider::SetTimeToPlayReady";
      case messages::MediaMetricsProvider::kSetRendererType:
            return "Receive media::mojom::MediaMetricsProvider::SetRendererType";
      case messages::MediaMetricsProvider::kSetDemuxerType:
            return "Receive media::mojom::MediaMetricsProvider::SetDemuxerType";
      case messages::MediaMetricsProvider::kSetKeySystem:
            return "Receive media::mojom::MediaMetricsProvider::SetKeySystem";
      case messages::MediaMetricsProvider::kSetHasWaitingForKey:
            return "Receive media::mojom::MediaMetricsProvider::SetHasWaitingForKey";
      case messages::MediaMetricsProvider::kSetIsHardwareSecure:
            return "Receive media::mojom::MediaMetricsProvider::SetIsHardwareSecure";
      case messages::MediaMetricsProvider::kSetContainerName:
            return "Receive media::mojom::MediaMetricsProvider::SetContainerName";
      case messages::MediaMetricsProvider::kAcquireWatchTimeRecorder:
            return "Receive media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder";
      case messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder:
            return "Receive media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder";
      case messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder:
            return "Receive media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder";
      case messages::MediaMetricsProvider::kSetHasAudio:
            return "Receive media::mojom::MediaMetricsProvider::SetHasAudio";
      case messages::MediaMetricsProvider::kSetHasVideo:
            return "Receive media::mojom::MediaMetricsProvider::SetHasVideo";
      case messages::MediaMetricsProvider::kSetVideoPipelineInfo:
            return "Receive media::mojom::MediaMetricsProvider::SetVideoPipelineInfo";
      case messages::MediaMetricsProvider::kSetAudioPipelineInfo:
            return "Receive media::mojom::MediaMetricsProvider::SetAudioPipelineInfo";
    }
  } else {
    switch (static_cast<messages::MediaMetricsProvider>(message.name())) {
      case messages::MediaMetricsProvider::kInitialize:
            return "Receive reply media::mojom::MediaMetricsProvider::Initialize";
      case messages::MediaMetricsProvider::kOnStarted:
            return "Receive reply media::mojom::MediaMetricsProvider::OnStarted";
      case messages::MediaMetricsProvider::kOnError:
            return "Receive reply media::mojom::MediaMetricsProvider::OnError";
      case messages::MediaMetricsProvider::kOnFallback:
            return "Receive reply media::mojom::MediaMetricsProvider::OnFallback";
      case messages::MediaMetricsProvider::kSetHasPlayed:
            return "Receive reply media::mojom::MediaMetricsProvider::SetHasPlayed";
      case messages::MediaMetricsProvider::kSetHaveEnough:
            return "Receive reply media::mojom::MediaMetricsProvider::SetHaveEnough";
      case messages::MediaMetricsProvider::kSetIsEME:
            return "Receive reply media::mojom::MediaMetricsProvider::SetIsEME";
      case messages::MediaMetricsProvider::kSetTimeToMetadata:
            return "Receive reply media::mojom::MediaMetricsProvider::SetTimeToMetadata";
      case messages::MediaMetricsProvider::kSetTimeToFirstFrame:
            return "Receive reply media::mojom::MediaMetricsProvider::SetTimeToFirstFrame";
      case messages::MediaMetricsProvider::kSetTimeToPlayReady:
            return "Receive reply media::mojom::MediaMetricsProvider::SetTimeToPlayReady";
      case messages::MediaMetricsProvider::kSetRendererType:
            return "Receive reply media::mojom::MediaMetricsProvider::SetRendererType";
      case messages::MediaMetricsProvider::kSetDemuxerType:
            return "Receive reply media::mojom::MediaMetricsProvider::SetDemuxerType";
      case messages::MediaMetricsProvider::kSetKeySystem:
            return "Receive reply media::mojom::MediaMetricsProvider::SetKeySystem";
      case messages::MediaMetricsProvider::kSetHasWaitingForKey:
            return "Receive reply media::mojom::MediaMetricsProvider::SetHasWaitingForKey";
      case messages::MediaMetricsProvider::kSetIsHardwareSecure:
            return "Receive reply media::mojom::MediaMetricsProvider::SetIsHardwareSecure";
      case messages::MediaMetricsProvider::kSetContainerName:
            return "Receive reply media::mojom::MediaMetricsProvider::SetContainerName";
      case messages::MediaMetricsProvider::kAcquireWatchTimeRecorder:
            return "Receive reply media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder";
      case messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder:
            return "Receive reply media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder";
      case messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder:
            return "Receive reply media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder";
      case messages::MediaMetricsProvider::kSetHasAudio:
            return "Receive reply media::mojom::MediaMetricsProvider::SetHasAudio";
      case messages::MediaMetricsProvider::kSetHasVideo:
            return "Receive reply media::mojom::MediaMetricsProvider::SetHasVideo";
      case messages::MediaMetricsProvider::kSetVideoPipelineInfo:
            return "Receive reply media::mojom::MediaMetricsProvider::SetVideoPipelineInfo";
      case messages::MediaMetricsProvider::kSetAudioPipelineInfo:
            return "Receive reply media::mojom::MediaMetricsProvider::SetAudioPipelineInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaMetricsProvider::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0529df82;  // IPCStableHash for media::mojom::MediaMetricsProvider::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::OnStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33753b5b;  // IPCStableHash for media::mojom::MediaMetricsProvider::OnStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x724f2185;  // IPCStableHash for media::mojom::MediaMetricsProvider::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::OnFallback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68703edb;  // IPCStableHash for media::mojom::MediaMetricsProvider::OnFallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetHasPlayed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2848db8c;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetHasPlayed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetHaveEnough_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ba3c14c;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetHaveEnough
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetIsEME_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24114162;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetIsEME
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetTimeToMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ee033e8;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetTimeToMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetTimeToFirstFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61ad147d;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetTimeToFirstFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetTimeToPlayReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d842eba;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetTimeToPlayReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetRendererType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09eb28c1;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetRendererType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetDemuxerType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e5f259e;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetDemuxerType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetKeySystem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bc1bce6;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetKeySystem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetHasWaitingForKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf71f57aa;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetHasWaitingForKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetIsHardwareSecure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef23edb5;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetIsHardwareSecure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetContainerName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefb85dd0;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetContainerName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::AcquireWatchTimeRecorder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd9d7408;  // IPCStableHash for media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::AcquireVideoDecodeStatsRecorder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafa961d4;  // IPCStableHash for media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::AcquirePlaybackEventsRecorder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27c371d6;  // IPCStableHash for media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetHasAudio_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84b8640b;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetHasAudio
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetHasVideo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x481c8fd8;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetHasVideo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetVideoPipelineInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c444156;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetVideoPipelineInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaMetricsProvider::SetAudioPipelineInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3cc321b;  // IPCStableHash for media::mojom::MediaMetricsProvider::SetAudioPipelineInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaMetricsProviderProxy::MediaMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaMetricsProviderProxy::Initialize(
    bool in_is_mse, MediaURLScheme in_url_scheme, ::media::mojom::MediaStreamType in_stream_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mse"), in_is_mse,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_scheme"), in_url_scheme,
                        "<value of type MediaURLScheme>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type ::media::mojom::MediaStreamType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_Initialize_Params_Data> params(
          message);
  params.Allocate();

  params->is_mse = in_is_mse;

  
  mojo::internal::Serialize<::media::mojom::MediaURLScheme>(
    in_url_scheme,
    &params->url_scheme);

  
  mojo::internal::Serialize<::media::mojom::MediaStreamType>(
    in_stream_type,
    &params->stream_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::OnStarted(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::OnStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kOnStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_OnStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in MediaMetricsProvider.OnStarted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("OnStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::OnError(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in MediaMetricsProvider.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::OnFallback(
    const ::media::PipelineStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::OnFallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::media::PipelineStatus&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kOnFallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_OnFallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PipelineStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in MediaMetricsProvider.OnFallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("OnFallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetHasPlayed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaMetricsProvider::SetHasPlayed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetHasPlayed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasPlayed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasPlayed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetHaveEnough(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaMetricsProvider::SetHaveEnough");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetHaveEnough), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHaveEnough_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHaveEnough");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetIsEME(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaMetricsProvider::SetIsEME");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetIsEME), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetIsEME_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetIsEME");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetTimeToMetadata(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetTimeToMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetTimeToMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_elapsed,
    elapsed_fragment);

  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elapsed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elapsed in MediaMetricsProvider.SetTimeToMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetTimeToFirstFrame(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetTimeToFirstFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetTimeToFirstFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_elapsed,
    elapsed_fragment);

  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elapsed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elapsed in MediaMetricsProvider.SetTimeToFirstFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToFirstFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetTimeToPlayReady(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetTimeToPlayReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetTimeToPlayReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_elapsed,
    elapsed_fragment);

  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elapsed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elapsed in MediaMetricsProvider.SetTimeToPlayReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToPlayReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetRendererType(
    ::media::RendererType in_renderer_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetRendererType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_type"), in_renderer_type,
                        "<value of type ::media::RendererType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetRendererType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetRendererType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::RendererType>(
    in_renderer_type,
    &params->renderer_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetRendererType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetDemuxerType(
    ::media::DemuxerType in_demuxer_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetDemuxerType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("demuxer_type"), in_demuxer_type,
                        "<value of type ::media::DemuxerType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetDemuxerType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetDemuxerType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::DemuxerType>(
    in_demuxer_type,
    &params->demuxer_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetDemuxerType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetKeySystem(
    const std::string& in_key_system) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetKeySystem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_system"), in_key_system,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetKeySystem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetKeySystem_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_system)::BaseType> key_system_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key_system,
    key_system_fragment);

  params->key_system.Set(
      key_system_fragment.is_null() ? nullptr : key_system_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_system.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_system in MediaMetricsProvider.SetKeySystem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetKeySystem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetHasWaitingForKey(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaMetricsProvider::SetHasWaitingForKey");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetHasWaitingForKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasWaitingForKey_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasWaitingForKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetIsHardwareSecure(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaMetricsProvider::SetIsHardwareSecure");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetIsHardwareSecure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetIsHardwareSecure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetContainerName(
    ::media::container_names::MediaContainerName in_container_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetContainerName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_name"), in_container_name,
                        "<value of type ::media::container_names::MediaContainerName>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetContainerName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetContainerName_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::MediaContainerName>(
    in_container_name,
    &params->container_name);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetContainerName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::AcquireWatchTimeRecorder(
    ::media::mojom::PlaybackPropertiesPtr in_properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::media::mojom::PlaybackPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recorder"), in_recorder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kAcquireWatchTimeRecorder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::PlaybackPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in MediaMetricsProvider.AcquireWatchTimeRecorder request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::WatchTimeRecorderInterfaceBase>>(
    in_recorder,
    &params->recorder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->recorder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid recorder in MediaMetricsProvider.AcquireWatchTimeRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireWatchTimeRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::AcquireVideoDecodeStatsRecorder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recorder"), in_recorder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecodeStatsRecorderInterfaceBase>>(
    in_recorder,
    &params->recorder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->recorder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid recorder in MediaMetricsProvider.AcquireVideoDecodeStatsRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireVideoDecodeStatsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::AcquirePlaybackEventsRecorder(
    ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::PlaybackEventsRecorderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in MediaMetricsProvider.AcquirePlaybackEventsRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquirePlaybackEventsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetHasAudio(
    ::media::AudioCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetHasAudio", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ::media::AudioCodec>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetHasAudio), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasAudio_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::AudioCodec>(
    in_codec,
    &params->codec);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasAudio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetHasVideo(
    ::media::VideoCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetHasVideo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ::media::VideoCodec>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetHasVideo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasVideo_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::VideoCodec>(
    in_codec,
    &params->codec);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasVideo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetVideoPipelineInfo(
    const ::media::VideoPipelineInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetVideoPipelineInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::VideoPipelineInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetVideoPipelineInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoPipelineInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in MediaMetricsProvider.SetVideoPipelineInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetVideoPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaMetricsProviderProxy::SetAudioPipelineInfo(
    const ::media::AudioPipelineInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaMetricsProvider::SetAudioPipelineInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::AudioPipelineInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaMetricsProvider::kSetAudioPipelineInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioPipelineInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in MediaMetricsProvider.SetAudioPipelineInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetAudioPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaMetricsProviderStubDispatch::Accept(
    MediaMetricsProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaMetricsProvider>(message->header()->name)) {
    case messages::MediaMetricsProvider::kInitialize: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_Initialize_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_Initialize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.0
      bool success = true;
      bool p_is_mse{};
      MediaURLScheme p_url_scheme{};
      ::media::mojom::MediaStreamType p_stream_type{};
      MediaMetricsProvider_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_mse = input_data_view.is_mse();
      if (success && !input_data_view.ReadUrlScheme(&p_url_scheme))
        success = false;
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_is_mse), 
        std::move(p_url_scheme), 
        std::move(p_stream_type));
      return true;
    }
    case messages::MediaMetricsProvider::kOnStarted: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_OnStarted_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_OnStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.1
      bool success = true;
      ::media::PipelineStatus p_status{};
      MediaMetricsProvider_OnStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStarted(        
        std::move(p_status));
      return true;
    }
    case messages::MediaMetricsProvider::kOnError: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_OnError_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.2
      bool success = true;
      ::media::PipelineStatus p_status{};
      MediaMetricsProvider_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_status));
      return true;
    }
    case messages::MediaMetricsProvider::kOnFallback: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_OnFallback_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_OnFallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.3
      bool success = true;
      ::media::PipelineStatus p_status{};
      MediaMetricsProvider_OnFallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFallback(        
        std::move(p_status));
      return true;
    }
    case messages::MediaMetricsProvider::kSetHasPlayed: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasPlayed_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasPlayed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.4
      bool success = true;
      MediaMetricsProvider_SetHasPlayed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasPlayed(        );
      return true;
    }
    case messages::MediaMetricsProvider::kSetHaveEnough: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHaveEnough_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHaveEnough_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.5
      bool success = true;
      MediaMetricsProvider_SetHaveEnough_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHaveEnough(        );
      return true;
    }
    case messages::MediaMetricsProvider::kSetIsEME: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetIsEME_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetIsEME_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.6
      bool success = true;
      MediaMetricsProvider_SetIsEME_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsEME(        );
      return true;
    }
    case messages::MediaMetricsProvider::kSetTimeToMetadata: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.7
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToMetadata(        
        std::move(p_elapsed));
      return true;
    }
    case messages::MediaMetricsProvider::kSetTimeToFirstFrame: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.8
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToFirstFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToFirstFrame(        
        std::move(p_elapsed));
      return true;
    }
    case messages::MediaMetricsProvider::kSetTimeToPlayReady: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.9
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToPlayReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToPlayReady(        
        std::move(p_elapsed));
      return true;
    }
    case messages::MediaMetricsProvider::kSetRendererType: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetRendererType_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetRendererType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.10
      bool success = true;
      ::media::RendererType p_renderer_type{};
      MediaMetricsProvider_SetRendererType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRendererType(&p_renderer_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRendererType(        
        std::move(p_renderer_type));
      return true;
    }
    case messages::MediaMetricsProvider::kSetDemuxerType: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetDemuxerType_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetDemuxerType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.11
      bool success = true;
      ::media::DemuxerType p_demuxer_type{};
      MediaMetricsProvider_SetDemuxerType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDemuxerType(&p_demuxer_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDemuxerType(        
        std::move(p_demuxer_type));
      return true;
    }
    case messages::MediaMetricsProvider::kSetKeySystem: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetKeySystem_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetKeySystem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.12
      bool success = true;
      std::string p_key_system{};
      MediaMetricsProvider_SetKeySystem_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeySystem(&p_key_system))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetKeySystem(        
        std::move(p_key_system));
      return true;
    }
    case messages::MediaMetricsProvider::kSetHasWaitingForKey: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasWaitingForKey_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasWaitingForKey_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.13
      bool success = true;
      MediaMetricsProvider_SetHasWaitingForKey_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasWaitingForKey(        );
      return true;
    }
    case messages::MediaMetricsProvider::kSetIsHardwareSecure: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.14
      bool success = true;
      MediaMetricsProvider_SetIsHardwareSecure_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsHardwareSecure(        );
      return true;
    }
    case messages::MediaMetricsProvider::kSetContainerName: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetContainerName_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetContainerName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.15
      bool success = true;
      ::media::container_names::MediaContainerName p_container_name{};
      MediaMetricsProvider_SetContainerName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContainerName(&p_container_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContainerName(        
        std::move(p_container_name));
      return true;
    }
    case messages::MediaMetricsProvider::kAcquireWatchTimeRecorder: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.16
      bool success = true;
      ::media::mojom::PlaybackPropertiesPtr p_properties{};
      ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> p_recorder{};
      MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireWatchTimeRecorder(        
        std::move(p_properties), 
        std::move(p_recorder));
      return true;
    }
    case messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.17
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> p_recorder{};
      MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireVideoDecodeStatsRecorder(        
        std::move(p_recorder));
      return true;
    }
    case messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.18
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> p_receiver{};
      MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquirePlaybackEventsRecorder(        
        std::move(p_receiver));
      return true;
    }
    case messages::MediaMetricsProvider::kSetHasAudio: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasAudio_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasAudio_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.19
      bool success = true;
      ::media::AudioCodec p_codec{};
      MediaMetricsProvider_SetHasAudio_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasAudio(        
        std::move(p_codec));
      return true;
    }
    case messages::MediaMetricsProvider::kSetHasVideo: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasVideo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasVideo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.20
      bool success = true;
      ::media::VideoCodec p_codec{};
      MediaMetricsProvider_SetHasVideo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasVideo(        
        std::move(p_codec));
      return true;
    }
    case messages::MediaMetricsProvider::kSetVideoPipelineInfo: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.21
      bool success = true;
      ::media::VideoPipelineInfo p_info{};
      MediaMetricsProvider_SetVideoPipelineInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVideoPipelineInfo(        
        std::move(p_info));
      return true;
    }
    case messages::MediaMetricsProvider::kSetAudioPipelineInfo: {
      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaMetricsProvider.22
      bool success = true;
      ::media::AudioPipelineInfo p_info{};
      MediaMetricsProvider_SetAudioPipelineInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioPipelineInfo(        
        std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool MediaMetricsProviderStubDispatch::AcceptWithResponder(
    MediaMetricsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaMetricsProvider>(message->header()->name)) {
    case messages::MediaMetricsProvider::kInitialize: {
      break;
    }
    case messages::MediaMetricsProvider::kOnStarted: {
      break;
    }
    case messages::MediaMetricsProvider::kOnError: {
      break;
    }
    case messages::MediaMetricsProvider::kOnFallback: {
      break;
    }
    case messages::MediaMetricsProvider::kSetHasPlayed: {
      break;
    }
    case messages::MediaMetricsProvider::kSetHaveEnough: {
      break;
    }
    case messages::MediaMetricsProvider::kSetIsEME: {
      break;
    }
    case messages::MediaMetricsProvider::kSetTimeToMetadata: {
      break;
    }
    case messages::MediaMetricsProvider::kSetTimeToFirstFrame: {
      break;
    }
    case messages::MediaMetricsProvider::kSetTimeToPlayReady: {
      break;
    }
    case messages::MediaMetricsProvider::kSetRendererType: {
      break;
    }
    case messages::MediaMetricsProvider::kSetDemuxerType: {
      break;
    }
    case messages::MediaMetricsProvider::kSetKeySystem: {
      break;
    }
    case messages::MediaMetricsProvider::kSetHasWaitingForKey: {
      break;
    }
    case messages::MediaMetricsProvider::kSetIsHardwareSecure: {
      break;
    }
    case messages::MediaMetricsProvider::kSetContainerName: {
      break;
    }
    case messages::MediaMetricsProvider::kAcquireWatchTimeRecorder: {
      break;
    }
    case messages::MediaMetricsProvider::kAcquireVideoDecodeStatsRecorder: {
      break;
    }
    case messages::MediaMetricsProvider::kAcquirePlaybackEventsRecorder: {
      break;
    }
    case messages::MediaMetricsProvider::kSetHasAudio: {
      break;
    }
    case messages::MediaMetricsProvider::kSetHasVideo: {
      break;
    }
    case messages::MediaMetricsProvider::kSetVideoPipelineInfo: {
      break;
    }
    case messages::MediaMetricsProvider::kSetAudioPipelineInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaMetricsProviderValidationInfo[] = {
    { &internal::MediaMetricsProvider_Initialize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_OnStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_OnFallback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetHasPlayed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetHaveEnough_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetIsEME_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetRendererType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetDemuxerType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetKeySystem_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetHasWaitingForKey_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetContainerName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetHasAudio_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetHasVideo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaMetricsProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::MediaMetricsProvider::Name_,
    kMediaMetricsProviderValidationInfo);
}



}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void MediaMetricsProviderInterceptorForTesting::Initialize(bool is_mse, MediaURLScheme url_scheme, ::media::mojom::MediaStreamType stream_type) {
  GetForwardingInterface()->Initialize(
    std::move(is_mse)
    , 
    std::move(url_scheme)
    , 
    std::move(stream_type)
    );
}
void MediaMetricsProviderInterceptorForTesting::OnStarted(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnStarted(
    std::move(status)
    );
}
void MediaMetricsProviderInterceptorForTesting::OnError(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnError(
    std::move(status)
    );
}
void MediaMetricsProviderInterceptorForTesting::OnFallback(const ::media::PipelineStatus& status) {
  GetForwardingInterface()->OnFallback(
    std::move(status)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetHasPlayed() {
  GetForwardingInterface()->SetHasPlayed();
}
void MediaMetricsProviderInterceptorForTesting::SetHaveEnough() {
  GetForwardingInterface()->SetHaveEnough();
}
void MediaMetricsProviderInterceptorForTesting::SetIsEME() {
  GetForwardingInterface()->SetIsEME();
}
void MediaMetricsProviderInterceptorForTesting::SetTimeToMetadata(::base::TimeDelta elapsed) {
  GetForwardingInterface()->SetTimeToMetadata(
    std::move(elapsed)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetTimeToFirstFrame(::base::TimeDelta elapsed) {
  GetForwardingInterface()->SetTimeToFirstFrame(
    std::move(elapsed)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetTimeToPlayReady(::base::TimeDelta elapsed) {
  GetForwardingInterface()->SetTimeToPlayReady(
    std::move(elapsed)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetRendererType(::media::RendererType renderer_type) {
  GetForwardingInterface()->SetRendererType(
    std::move(renderer_type)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetDemuxerType(::media::DemuxerType demuxer_type) {
  GetForwardingInterface()->SetDemuxerType(
    std::move(demuxer_type)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetKeySystem(const std::string& key_system) {
  GetForwardingInterface()->SetKeySystem(
    std::move(key_system)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetHasWaitingForKey() {
  GetForwardingInterface()->SetHasWaitingForKey();
}
void MediaMetricsProviderInterceptorForTesting::SetIsHardwareSecure() {
  GetForwardingInterface()->SetIsHardwareSecure();
}
void MediaMetricsProviderInterceptorForTesting::SetContainerName(::media::container_names::MediaContainerName container_name) {
  GetForwardingInterface()->SetContainerName(
    std::move(container_name)
    );
}
void MediaMetricsProviderInterceptorForTesting::AcquireWatchTimeRecorder(::media::mojom::PlaybackPropertiesPtr properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> recorder) {
  GetForwardingInterface()->AcquireWatchTimeRecorder(
    std::move(properties)
    , 
    std::move(recorder)
    );
}
void MediaMetricsProviderInterceptorForTesting::AcquireVideoDecodeStatsRecorder(::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> recorder) {
  GetForwardingInterface()->AcquireVideoDecodeStatsRecorder(
    std::move(recorder)
    );
}
void MediaMetricsProviderInterceptorForTesting::AcquirePlaybackEventsRecorder(::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> receiver) {
  GetForwardingInterface()->AcquirePlaybackEventsRecorder(
    std::move(receiver)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetHasAudio(::media::AudioCodec codec) {
  GetForwardingInterface()->SetHasAudio(
    std::move(codec)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetHasVideo(::media::VideoCodec codec) {
  GetForwardingInterface()->SetHasVideo(
    std::move(codec)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetVideoPipelineInfo(const ::media::VideoPipelineInfo& info) {
  GetForwardingInterface()->SetVideoPipelineInfo(
    std::move(info)
    );
}
void MediaMetricsProviderInterceptorForTesting::SetAudioPipelineInfo(const ::media::AudioPipelineInfo& info) {
  GetForwardingInterface()->SetAudioPipelineInfo(
    std::move(info)
    );
}
MediaMetricsProviderAsyncWaiter::MediaMetricsProviderAsyncWaiter(
    MediaMetricsProvider* proxy) : proxy_(proxy) {}

MediaMetricsProviderAsyncWaiter::~MediaMetricsProviderAsyncWaiter() = default;







}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif