// media/mojo/mojom/key_system_support.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/key_system_support.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/key_system_support.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/key_system_support.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/content_decryption_module.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/version.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class KeySystemSupportObserverProxy;

template <typename ImplRefTraits>
class KeySystemSupportObserverStub;

class KeySystemSupportObserverRequestValidator;


class BLINK_PLATFORM_EXPORT KeySystemSupportObserver
    : public KeySystemSupportObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.KeySystemSupportObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = KeySystemSupportObserverInterfaceBase;
  using Proxy_ = KeySystemSupportObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = KeySystemSupportObserverStub<ImplRefTraits>;

  using RequestValidator_ = KeySystemSupportObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnKeySystemSupportUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnKeySystemSupportUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~KeySystemSupportObserver() = default;

  virtual void OnKeySystemSupportUpdated(::blink::HashMap<::blink::String, KeySystemCapabilityPtr> key_systems) = 0;
};

class KeySystemSupportProxy;

template <typename ImplRefTraits>
class KeySystemSupportStub;

class KeySystemSupportRequestValidator;


class BLINK_PLATFORM_EXPORT KeySystemSupport
    : public KeySystemSupportInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.KeySystemSupport";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = KeySystemSupportInterfaceBase;
  using Proxy_ = KeySystemSupportProxy;

  template <typename ImplRefTraits>
  using Stub_ = KeySystemSupportStub<ImplRefTraits>;

  using RequestValidator_ = KeySystemSupportRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~KeySystemSupport() = default;

  virtual void SetObserver(::mojo::PendingRemote<KeySystemSupportObserver> observer) = 0;
};



class BLINK_PLATFORM_EXPORT KeySystemSupportObserverProxy
    : public KeySystemSupportObserver {
 public:
  using InterfaceType = KeySystemSupportObserver;

  explicit KeySystemSupportObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnKeySystemSupportUpdated(::blink::HashMap<::blink::String, KeySystemCapabilityPtr> key_systems) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT KeySystemSupportProxy
    : public KeySystemSupport {
 public:
  using InterfaceType = KeySystemSupport;

  explicit KeySystemSupportProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetObserver(::mojo::PendingRemote<KeySystemSupportObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT KeySystemSupportObserverStubDispatch {
 public:
  static bool Accept(KeySystemSupportObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      KeySystemSupportObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<KeySystemSupportObserver>>
class KeySystemSupportObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  KeySystemSupportObserverStub() = default;
  ~KeySystemSupportObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT KeySystemSupportStubDispatch {
 public:
  static bool Accept(KeySystemSupport* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      KeySystemSupport* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<KeySystemSupport>>
class KeySystemSupportStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  KeySystemSupportStub() = default;
  ~KeySystemSupportStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeySystemSupportStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT KeySystemSupportObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT KeySystemSupportRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_PLATFORM_EXPORT VideoCodecInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCodecInfo, T>::value>;
  using DataView = VideoCodecInfoDataView;
  using Data_ = internal::VideoCodecInfo_Data;

  template <typename... Args>
  static VideoCodecInfoPtr New(Args&&... args) {
    return VideoCodecInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCodecInfoPtr From(const U& u) {
    return mojo::TypeConverter<VideoCodecInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCodecInfo>::Convert(*this);
  }


  VideoCodecInfo();

  VideoCodecInfo(
      ::blink::Vector<::media::VideoCodecProfile> supported_profiles,
      bool supports_clear_lead);


  ~VideoCodecInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCodecInfoPtr>
  VideoCodecInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCodecInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCodecInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCodecInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCodecInfo_UnserializedMessageContext<
            UserType, VideoCodecInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCodecInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCodecInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCodecInfo_UnserializedMessageContext<
            UserType, VideoCodecInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCodecInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::media::VideoCodecProfile> supported_profiles;
  
  bool supports_clear_lead;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCodecInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CdmCapability {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CdmCapability, T>::value>;
  using DataView = CdmCapabilityDataView;
  using Data_ = internal::CdmCapability_Data;

  template <typename... Args>
  static CdmCapabilityPtr New(Args&&... args) {
    return CdmCapabilityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CdmCapabilityPtr From(const U& u) {
    return mojo::TypeConverter<CdmCapabilityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CdmCapability>::Convert(*this);
  }


  CdmCapability();

  CdmCapability(
      ::blink::Vector<::media::AudioCodec> audio_codecs,
      ::blink::HashMap<::media::VideoCodec, VideoCodecInfoPtr> video_codecs,
      ::blink::Vector<::media::EncryptionScheme> encryption_schemes,
      ::blink::Vector<::media::mojom::blink::CdmSessionType> session_types,
      const ::base::Version& version);

CdmCapability(const CdmCapability&) = delete;
CdmCapability& operator=(const CdmCapability&) = delete;

  ~CdmCapability();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CdmCapabilityPtr>
  CdmCapabilityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CdmCapability::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CdmCapability::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CdmCapability::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CdmCapability_UnserializedMessageContext<
            UserType, CdmCapability::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CdmCapability::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CdmCapability::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CdmCapability_UnserializedMessageContext<
            UserType, CdmCapability::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CdmCapability::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::media::AudioCodec> audio_codecs;
  
  ::blink::HashMap<::media::VideoCodec, VideoCodecInfoPtr> video_codecs;
  
  ::blink::Vector<::media::EncryptionScheme> encryption_schemes;
  
  ::blink::Vector<::media::mojom::blink::CdmSessionType> session_types;
  
  ::base::Version version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CdmCapability::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT KeySystemCapability {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<KeySystemCapability, T>::value>;
  using DataView = KeySystemCapabilityDataView;
  using Data_ = internal::KeySystemCapability_Data;

  template <typename... Args>
  static KeySystemCapabilityPtr New(Args&&... args) {
    return KeySystemCapabilityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static KeySystemCapabilityPtr From(const U& u) {
    return mojo::TypeConverter<KeySystemCapabilityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, KeySystemCapability>::Convert(*this);
  }


  KeySystemCapability();

  KeySystemCapability(
      CdmCapabilityPtr sw_secure_capability,
      CdmCapabilityPtr hw_secure_capability,
      std::optional<CdmCapabilityQueryStatus> sw_secure_capability_query_status,
      std::optional<CdmCapabilityQueryStatus> hw_secure_capability_query_status);

KeySystemCapability(const KeySystemCapability&) = delete;
KeySystemCapability& operator=(const KeySystemCapability&) = delete;

  ~KeySystemCapability();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = KeySystemCapabilityPtr>
  KeySystemCapabilityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeySystemCapability::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        KeySystemCapability::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        KeySystemCapability::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::KeySystemCapability_UnserializedMessageContext<
            UserType, KeySystemCapability::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<KeySystemCapability::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return KeySystemCapability::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::KeySystemCapability_UnserializedMessageContext<
            UserType, KeySystemCapability::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<KeySystemCapability::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CdmCapabilityPtr sw_secure_capability;
  
  CdmCapabilityPtr hw_secure_capability;
  
  std::optional<CdmCapabilityQueryStatus> sw_secure_capability_query_status;
  
  std::optional<CdmCapabilityQueryStatus> hw_secure_capability_query_status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, KeySystemCapability::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VideoCodecInfoPtr VideoCodecInfo::Clone() const {
  return New(
      mojo::Clone(supported_profiles),
      mojo::Clone(supports_clear_lead)
  );
}

template <typename T, VideoCodecInfo::EnableIfSame<T>*>
bool VideoCodecInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_profiles, other_struct.supported_profiles))
    return false;
  if (!mojo::Equals(this->supports_clear_lead, other_struct.supports_clear_lead))
    return false;
  return true;
}

template <typename T, VideoCodecInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_profiles < rhs.supported_profiles)
    return true;
  if (rhs.supported_profiles < lhs.supported_profiles)
    return false;
  if (lhs.supports_clear_lead < rhs.supports_clear_lead)
    return true;
  if (rhs.supports_clear_lead < lhs.supports_clear_lead)
    return false;
  return false;
}
template <typename StructPtrType>
CdmCapabilityPtr CdmCapability::Clone() const {
  return New(
      mojo::Clone(audio_codecs),
      mojo::Clone(video_codecs),
      mojo::Clone(encryption_schemes),
      mojo::Clone(session_types),
      mojo::Clone(version)
  );
}

template <typename T, CdmCapability::EnableIfSame<T>*>
bool CdmCapability::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->audio_codecs, other_struct.audio_codecs))
    return false;
  if (!mojo::Equals(this->video_codecs, other_struct.video_codecs))
    return false;
  if (!mojo::Equals(this->encryption_schemes, other_struct.encryption_schemes))
    return false;
  if (!mojo::Equals(this->session_types, other_struct.session_types))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, CdmCapability::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.audio_codecs < rhs.audio_codecs)
    return true;
  if (rhs.audio_codecs < lhs.audio_codecs)
    return false;
  if (lhs.video_codecs < rhs.video_codecs)
    return true;
  if (rhs.video_codecs < lhs.video_codecs)
    return false;
  if (lhs.encryption_schemes < rhs.encryption_schemes)
    return true;
  if (rhs.encryption_schemes < lhs.encryption_schemes)
    return false;
  if (lhs.session_types < rhs.session_types)
    return true;
  if (rhs.session_types < lhs.session_types)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  return false;
}
template <typename StructPtrType>
KeySystemCapabilityPtr KeySystemCapability::Clone() const {
  return New(
      mojo::Clone(sw_secure_capability),
      mojo::Clone(hw_secure_capability),
      mojo::Clone(sw_secure_capability_query_status),
      mojo::Clone(hw_secure_capability_query_status)
  );
}

template <typename T, KeySystemCapability::EnableIfSame<T>*>
bool KeySystemCapability::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sw_secure_capability, other_struct.sw_secure_capability))
    return false;
  if (!mojo::Equals(this->hw_secure_capability, other_struct.hw_secure_capability))
    return false;
  if (!mojo::Equals(this->sw_secure_capability_query_status, other_struct.sw_secure_capability_query_status))
    return false;
  if (!mojo::Equals(this->hw_secure_capability_query_status, other_struct.hw_secure_capability_query_status))
    return false;
  return true;
}

template <typename T, KeySystemCapability::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sw_secure_capability < rhs.sw_secure_capability)
    return true;
  if (rhs.sw_secure_capability < lhs.sw_secure_capability)
    return false;
  if (lhs.hw_secure_capability < rhs.hw_secure_capability)
    return true;
  if (rhs.hw_secure_capability < lhs.hw_secure_capability)
    return false;
  if (lhs.sw_secure_capability_query_status < rhs.sw_secure_capability_query_status)
    return true;
  if (rhs.sw_secure_capability_query_status < lhs.sw_secure_capability_query_status)
    return false;
  if (lhs.hw_secure_capability_query_status < rhs.hw_secure_capability_query_status)
    return true;
  if (rhs.hw_secure_capability_query_status < lhs.hw_secure_capability_query_status)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::VideoCodecInfo::DataView,
                                         ::media::mojom::blink::VideoCodecInfoPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCodecInfoPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCodecInfoPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::VideoCodecInfo::supported_profiles)& supported_profiles(
      const ::media::mojom::blink::VideoCodecInfoPtr& input) {
    return input->supported_profiles;
  }

  static decltype(::media::mojom::blink::VideoCodecInfo::supports_clear_lead) supports_clear_lead(
      const ::media::mojom::blink::VideoCodecInfoPtr& input) {
    return input->supports_clear_lead;
  }

  static bool Read(::media::mojom::blink::VideoCodecInfo::DataView input, ::media::mojom::blink::VideoCodecInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::CdmCapability::DataView,
                                         ::media::mojom::blink::CdmCapabilityPtr> {
  static bool IsNull(const ::media::mojom::blink::CdmCapabilityPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::CdmCapabilityPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::CdmCapability::audio_codecs)& audio_codecs(
      const ::media::mojom::blink::CdmCapabilityPtr& input) {
    return input->audio_codecs;
  }

  static const decltype(::media::mojom::blink::CdmCapability::video_codecs)& video_codecs(
      const ::media::mojom::blink::CdmCapabilityPtr& input) {
    return input->video_codecs;
  }

  static const decltype(::media::mojom::blink::CdmCapability::encryption_schemes)& encryption_schemes(
      const ::media::mojom::blink::CdmCapabilityPtr& input) {
    return input->encryption_schemes;
  }

  static const decltype(::media::mojom::blink::CdmCapability::session_types)& session_types(
      const ::media::mojom::blink::CdmCapabilityPtr& input) {
    return input->session_types;
  }

  static const decltype(::media::mojom::blink::CdmCapability::version)& version(
      const ::media::mojom::blink::CdmCapabilityPtr& input) {
    return input->version;
  }

  static bool Read(::media::mojom::blink::CdmCapability::DataView input, ::media::mojom::blink::CdmCapabilityPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::KeySystemCapability::DataView,
                                         ::media::mojom::blink::KeySystemCapabilityPtr> {
  static bool IsNull(const ::media::mojom::blink::KeySystemCapabilityPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::KeySystemCapabilityPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::KeySystemCapability::sw_secure_capability)& sw_secure_capability(
      const ::media::mojom::blink::KeySystemCapabilityPtr& input) {
    return input->sw_secure_capability;
  }

  static const decltype(::media::mojom::blink::KeySystemCapability::hw_secure_capability)& hw_secure_capability(
      const ::media::mojom::blink::KeySystemCapabilityPtr& input) {
    return input->hw_secure_capability;
  }

  static decltype(::media::mojom::blink::KeySystemCapability::sw_secure_capability_query_status) sw_secure_capability_query_status(
      const ::media::mojom::blink::KeySystemCapabilityPtr& input) {
    return input->sw_secure_capability_query_status;
  }

  static decltype(::media::mojom::blink::KeySystemCapability::hw_secure_capability_query_status) hw_secure_capability_query_status(
      const ::media::mojom::blink::KeySystemCapabilityPtr& input) {
    return input->hw_secure_capability_query_status;
  }

  static bool Read(::media::mojom::blink::KeySystemCapability::DataView input, ::media::mojom::blink::KeySystemCapabilityPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_KEY_SYSTEM_SUPPORT_MOJOM_BLINK_H_