// media/mojo/mojom/key_system_support.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/key_system_support.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/key_system_support.mojom-params-data.h"
#include "media/mojo/mojom/key_system_support.mojom-shared-message-ids.h"

#include "media/mojo/mojom/key_system_support.mojom-blink-import-headers.h"
#include "media/mojo/mojom/key_system_support.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
VideoCodecInfo::VideoCodecInfo()
    : supported_profiles(),
      supports_clear_lead(true) {}

VideoCodecInfo::VideoCodecInfo(
    ::blink::Vector<::media::VideoCodecProfile> supported_profiles_in,
    bool supports_clear_lead_in)
    : supported_profiles(std::move(supported_profiles_in)),
      supports_clear_lead(std::move(supports_clear_lead_in)) {}

VideoCodecInfo::~VideoCodecInfo() = default;

void VideoCodecInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_profiles"), this->supported_profiles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::media::VideoCodecProfile>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_clear_lead"), this->supports_clear_lead,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCodecInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CdmCapability::CdmCapability()
    : audio_codecs(),
      video_codecs(),
      encryption_schemes(),
      session_types(),
      version() {}

CdmCapability::CdmCapability(
    ::blink::Vector<::media::AudioCodec> audio_codecs_in,
    ::blink::HashMap<::media::VideoCodec, VideoCodecInfoPtr> video_codecs_in,
    ::blink::Vector<::media::EncryptionScheme> encryption_schemes_in,
    ::blink::Vector<::media::mojom::blink::CdmSessionType> session_types_in,
    const ::base::Version& version_in)
    : audio_codecs(std::move(audio_codecs_in)),
      video_codecs(std::move(video_codecs_in)),
      encryption_schemes(std::move(encryption_schemes_in)),
      session_types(std::move(session_types_in)),
      version(std::move(version_in)) {}

CdmCapability::~CdmCapability() = default;

void CdmCapability::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codecs"), this->audio_codecs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::media::AudioCodec>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codecs"), this->video_codecs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::HashMap<::media::VideoCodec, VideoCodecInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_schemes"), this->encryption_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::media::EncryptionScheme>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_types"), this->session_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::media::mojom::blink::CdmSessionType>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Version&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CdmCapability::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
KeySystemCapability::KeySystemCapability()
    : sw_secure_capability(),
      hw_secure_capability(),
      sw_secure_capability_query_status(),
      hw_secure_capability_query_status() {}

KeySystemCapability::KeySystemCapability(
    CdmCapabilityPtr sw_secure_capability_in,
    CdmCapabilityPtr hw_secure_capability_in,
    std::optional<CdmCapabilityQueryStatus> sw_secure_capability_query_status_in,
    std::optional<CdmCapabilityQueryStatus> hw_secure_capability_query_status_in)
    : sw_secure_capability(std::move(sw_secure_capability_in)),
      hw_secure_capability(std::move(hw_secure_capability_in)),
      sw_secure_capability_query_status(std::move(sw_secure_capability_query_status_in)),
      hw_secure_capability_query_status(std::move(hw_secure_capability_query_status_in)) {}

KeySystemCapability::~KeySystemCapability() = default;

void KeySystemCapability::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sw_secure_capability"), this->sw_secure_capability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CdmCapabilityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_secure_capability"), this->hw_secure_capability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CdmCapabilityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sw_secure_capability_query_status"), this->sw_secure_capability_query_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<CdmCapabilityQueryStatus>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_secure_capability_query_status"), this->hw_secure_capability_query_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<CdmCapabilityQueryStatus>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeySystemCapability::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

KeySystemSupportObserver::IPCStableHashFunction KeySystemSupportObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::KeySystemSupportObserver>(message.name())) {
    case messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated: {
      return &KeySystemSupportObserver::OnKeySystemSupportUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* KeySystemSupportObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::KeySystemSupportObserver>(message.name())) {
      case messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated:
            return "Receive media::mojom::KeySystemSupportObserver::OnKeySystemSupportUpdated";
    }
  } else {
    switch (static_cast<messages::KeySystemSupportObserver>(message.name())) {
      case messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated:
            return "Receive reply media::mojom::KeySystemSupportObserver::OnKeySystemSupportUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t KeySystemSupportObserver::OnKeySystemSupportUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf7b3c9f;  // IPCStableHash for media::mojom::KeySystemSupportObserver::OnKeySystemSupportUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

KeySystemSupportObserverProxy::KeySystemSupportObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void KeySystemSupportObserverProxy::OnKeySystemSupportUpdated(
    ::blink::HashMap<::blink::String, KeySystemCapabilityPtr> in_key_systems) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::KeySystemSupportObserver::OnKeySystemSupportUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_systems"), in_key_systems,
                        "<value of type ::blink::HashMap<::blink::String, KeySystemCapabilityPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::KeySystemSupportObserver_OnKeySystemSupportUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_systems)::BaseType>
      key_systems_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_systems_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::media::mojom::KeySystemCapabilityDataView>>(
    in_key_systems,
    key_systems_fragment,
    &key_systems_validate_params);

  params->key_systems.Set(
      key_systems_fragment.is_null() ? nullptr : key_systems_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_systems.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_systems in KeySystemSupportObserver.OnKeySystemSupportUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeySystemSupportObserver::Name_);
  message.set_method_name("OnKeySystemSupportUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool KeySystemSupportObserverStubDispatch::Accept(
    KeySystemSupportObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::KeySystemSupportObserver>(message->header()->name)) {
    case messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated: {
      DCHECK(message->is_serialized());
      internal::KeySystemSupportObserver_OnKeySystemSupportUpdated_Params_Data* params =
          reinterpret_cast<internal::KeySystemSupportObserver_OnKeySystemSupportUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for KeySystemSupportObserver.0
      bool success = true;
      ::blink::HashMap<::blink::String, KeySystemCapabilityPtr> p_key_systems{};
      KeySystemSupportObserver_OnKeySystemSupportUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeySystems(&p_key_systems))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeySystemSupportObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnKeySystemSupportUpdated(        
        std::move(p_key_systems));
      return true;
    }
  }
  return false;
}

// static
bool KeySystemSupportObserverStubDispatch::AcceptWithResponder(
    KeySystemSupportObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::KeySystemSupportObserver>(message->header()->name)) {
    case messages::KeySystemSupportObserver::kOnKeySystemSupportUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kKeySystemSupportObserverValidationInfo[] = {
    { &internal::KeySystemSupportObserver_OnKeySystemSupportUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool KeySystemSupportObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::KeySystemSupportObserver::Name_,
    kKeySystemSupportObserverValidationInfo);
}

// The declaration includes the definition on other builds.

KeySystemSupport::IPCStableHashFunction KeySystemSupport::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::KeySystemSupport>(message.name())) {
    case messages::KeySystemSupport::kSetObserver: {
      return &KeySystemSupport::SetObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* KeySystemSupport::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::KeySystemSupport>(message.name())) {
      case messages::KeySystemSupport::kSetObserver:
            return "Receive media::mojom::KeySystemSupport::SetObserver";
    }
  } else {
    switch (static_cast<messages::KeySystemSupport>(message.name())) {
      case messages::KeySystemSupport::kSetObserver:
            return "Receive reply media::mojom::KeySystemSupport::SetObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t KeySystemSupport::SetObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb673f2a8;  // IPCStableHash for media::mojom::KeySystemSupport::SetObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

KeySystemSupportProxy::KeySystemSupportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void KeySystemSupportProxy::SetObserver(
    ::mojo::PendingRemote<KeySystemSupportObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::KeySystemSupport::SetObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<KeySystemSupportObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeySystemSupport::kSetObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::KeySystemSupport_SetObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::KeySystemSupportObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in KeySystemSupport.SetObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeySystemSupport::Name_);
  message.set_method_name("SetObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool KeySystemSupportStubDispatch::Accept(
    KeySystemSupport* impl,
    mojo::Message* message) {
  switch (static_cast<messages::KeySystemSupport>(message->header()->name)) {
    case messages::KeySystemSupport::kSetObserver: {
      DCHECK(message->is_serialized());
      internal::KeySystemSupport_SetObserver_Params_Data* params =
          reinterpret_cast<internal::KeySystemSupport_SetObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for KeySystemSupport.0
      bool success = true;
      ::mojo::PendingRemote<KeySystemSupportObserver> p_observer{};
      KeySystemSupport_SetObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeySystemSupport::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetObserver(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool KeySystemSupportStubDispatch::AcceptWithResponder(
    KeySystemSupport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::KeySystemSupport>(message->header()->name)) {
    case messages::KeySystemSupport::kSetObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kKeySystemSupportValidationInfo[] = {
    { &internal::KeySystemSupport_SetObserver_Params_Data::Validate,
     nullptr /* no response */},
};

bool KeySystemSupportRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::KeySystemSupport::Name_,
    kKeySystemSupportValidationInfo);
}



}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::VideoCodecInfo::DataView, ::media::mojom::blink::VideoCodecInfoPtr>::Read(
    ::media::mojom::blink::VideoCodecInfo::DataView input,
    ::media::mojom::blink::VideoCodecInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCodecInfoPtr result(::media::mojom::blink::VideoCodecInfo::New());
  
      if (success && !input.ReadSupportedProfiles(&result->supported_profiles))
        success = false;
      if (success)
        result->supports_clear_lead = input.supports_clear_lead();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::CdmCapability::DataView, ::media::mojom::blink::CdmCapabilityPtr>::Read(
    ::media::mojom::blink::CdmCapability::DataView input,
    ::media::mojom::blink::CdmCapabilityPtr* output) {
  bool success = true;
  ::media::mojom::blink::CdmCapabilityPtr result(::media::mojom::blink::CdmCapability::New());
  
      if (success && !input.ReadAudioCodecs(&result->audio_codecs))
        success = false;
      if (success && !input.ReadVideoCodecs(&result->video_codecs))
        success = false;
      if (success && !input.ReadEncryptionSchemes(&result->encryption_schemes))
        success = false;
      if (success && !input.ReadSessionTypes(&result->session_types))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::KeySystemCapability::DataView, ::media::mojom::blink::KeySystemCapabilityPtr>::Read(
    ::media::mojom::blink::KeySystemCapability::DataView input,
    ::media::mojom::blink::KeySystemCapabilityPtr* output) {
  bool success = true;
  ::media::mojom::blink::KeySystemCapabilityPtr result(::media::mojom::blink::KeySystemCapability::New());
  
      if (success && !input.ReadSwSecureCapability(&result->sw_secure_capability))
        success = false;
      if (success && !input.ReadHwSecureCapability(&result->hw_secure_capability))
        success = false;
      if (success && !input.ReadSwSecureCapabilityQueryStatus(&result->sw_secure_capability_query_status)) {
        success = false;
      }
      if (success && !input.ReadHwSecureCapabilityQueryStatus(&result->hw_secure_capability_query_status)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void KeySystemSupportObserverInterceptorForTesting::OnKeySystemSupportUpdated(::blink::HashMap<::blink::String, KeySystemCapabilityPtr> key_systems) {
  GetForwardingInterface()->OnKeySystemSupportUpdated(
    std::move(key_systems)
    );
}
KeySystemSupportObserverAsyncWaiter::KeySystemSupportObserverAsyncWaiter(
    KeySystemSupportObserver* proxy) : proxy_(proxy) {}

KeySystemSupportObserverAsyncWaiter::~KeySystemSupportObserverAsyncWaiter() = default;





void KeySystemSupportInterceptorForTesting::SetObserver(::mojo::PendingRemote<KeySystemSupportObserver> observer) {
  GetForwardingInterface()->SetObserver(
    std::move(observer)
    );
}
KeySystemSupportAsyncWaiter::KeySystemSupportAsyncWaiter(
    KeySystemSupport* proxy) : proxy_(proxy) {}

KeySystemSupportAsyncWaiter::~KeySystemSupportAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif