// media/mojo/mojom/display_media_information.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/display_media_information.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/display_media_information.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/display_media_information.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/capture_handle.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {








class BLINK_PLATFORM_EXPORT DisplayMediaInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayMediaInformation, T>::value>;
  using DataView = DisplayMediaInformationDataView;
  using Data_ = internal::DisplayMediaInformation_Data;

  template <typename... Args>
  static DisplayMediaInformationPtr New(Args&&... args) {
    return DisplayMediaInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayMediaInformationPtr From(const U& u) {
    return mojo::TypeConverter<DisplayMediaInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayMediaInformation>::Convert(*this);
  }


  DisplayMediaInformation();

  DisplayMediaInformation(
      DisplayCaptureSurfaceType display_surface,
      bool logical_surface,
      CursorCaptureType cursor,
      ::media::mojom::blink::CaptureHandlePtr capture_handle,
      int32_t initial_zoom_level);

DisplayMediaInformation(const DisplayMediaInformation&) = delete;
DisplayMediaInformation& operator=(const DisplayMediaInformation&) = delete;

  ~DisplayMediaInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayMediaInformationPtr>
  DisplayMediaInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayMediaInformation::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayMediaInformation::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayMediaInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayMediaInformation_UnserializedMessageContext<
            UserType, DisplayMediaInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DisplayMediaInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DisplayMediaInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayMediaInformation_UnserializedMessageContext<
            UserType, DisplayMediaInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayMediaInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DisplayCaptureSurfaceType display_surface;
  
  bool logical_surface;
  
  CursorCaptureType cursor;
  
  ::media::mojom::blink::CaptureHandlePtr capture_handle;
  
  int32_t initial_zoom_level;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplayMediaInformationPtr DisplayMediaInformation::Clone() const {
  return New(
      mojo::Clone(display_surface),
      mojo::Clone(logical_surface),
      mojo::Clone(cursor),
      mojo::Clone(capture_handle),
      mojo::Clone(initial_zoom_level)
  );
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>*>
bool DisplayMediaInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_surface, other_struct.display_surface))
    return false;
  if (!mojo::Equals(this->logical_surface, other_struct.logical_surface))
    return false;
  if (!mojo::Equals(this->cursor, other_struct.cursor))
    return false;
  if (!mojo::Equals(this->capture_handle, other_struct.capture_handle))
    return false;
  if (!mojo::Equals(this->initial_zoom_level, other_struct.initial_zoom_level))
    return false;
  return true;
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_surface < rhs.display_surface)
    return true;
  if (rhs.display_surface < lhs.display_surface)
    return false;
  if (lhs.logical_surface < rhs.logical_surface)
    return true;
  if (rhs.logical_surface < lhs.logical_surface)
    return false;
  if (lhs.cursor < rhs.cursor)
    return true;
  if (rhs.cursor < lhs.cursor)
    return false;
  if (lhs.capture_handle < rhs.capture_handle)
    return true;
  if (rhs.capture_handle < lhs.capture_handle)
    return false;
  if (lhs.initial_zoom_level < rhs.initial_zoom_level)
    return true;
  if (rhs.initial_zoom_level < lhs.initial_zoom_level)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::DisplayMediaInformation::DataView,
                                         ::media::mojom::blink::DisplayMediaInformationPtr> {
  static bool IsNull(const ::media::mojom::blink::DisplayMediaInformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::DisplayMediaInformationPtr* output) { output->reset(); }

  static decltype(::media::mojom::blink::DisplayMediaInformation::display_surface) display_surface(
      const ::media::mojom::blink::DisplayMediaInformationPtr& input) {
    return input->display_surface;
  }

  static decltype(::media::mojom::blink::DisplayMediaInformation::logical_surface) logical_surface(
      const ::media::mojom::blink::DisplayMediaInformationPtr& input) {
    return input->logical_surface;
  }

  static decltype(::media::mojom::blink::DisplayMediaInformation::cursor) cursor(
      const ::media::mojom::blink::DisplayMediaInformationPtr& input) {
    return input->cursor;
  }

  static const decltype(::media::mojom::blink::DisplayMediaInformation::capture_handle)& capture_handle(
      const ::media::mojom::blink::DisplayMediaInformationPtr& input) {
    return input->capture_handle;
  }

  static decltype(::media::mojom::blink::DisplayMediaInformation::initial_zoom_level) initial_zoom_level(
      const ::media::mojom::blink::DisplayMediaInformationPtr& input) {
    return input->initial_zoom_level;
  }

  static bool Read(::media::mojom::blink::DisplayMediaInformation::DataView input, ::media::mojom::blink::DisplayMediaInformationPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_BLINK_H_