// media/mojo/mojom/demuxer_stream.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.DemuxerStreamPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.DemuxerStream.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.DemuxerStreamInterface }
 */
media.mojom.DemuxerStreamRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.DemuxerStreamPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.DemuxerStreamPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.DemuxerStreamPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        type: !media.mojom.DemuxerStream_Type,
        pipe: !MojoHandle,
        audioConfig: ?media.mojom.AudioDecoderConfig,
        videoConfig: ?media.mojom.VideoDecoderConfig,
   *  }>}
   */

  initialize() {
    return this.proxy.sendMessage(
        0,
        media.mojom.DemuxerStream_Initialize_ParamsSpec.$,
        media.mojom.DemuxerStream_Initialize_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } count
   * @return {!Promise<{
        status: !media.mojom.DemuxerStream_Status,
        batchBuffers: !Array<!media.mojom.DecoderBuffer>,
        audioConfig: ?media.mojom.AudioDecoderConfig,
        videoConfig: ?media.mojom.VideoDecoderConfig,
   *  }>}
   */

  read(
      count) {
    return this.proxy.sendMessage(
        1,
        media.mojom.DemuxerStream_Read_ParamsSpec.$,
        media.mojom.DemuxerStream_Read_ResponseParamsSpec.$,
        [
          count
        ],
        false);
  }

  
  /**
   */

  enableBitstreamConverter() {
    this.proxy.sendMessage(
        2,
        media.mojom.DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DemuxerStream
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.DemuxerStreamReceiver = class {
  /**
   * @param {!media.mojom.DemuxerStreamInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.DemuxerStreamRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.DemuxerStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DemuxerStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.DemuxerStream_Initialize_ParamsSpec.$,
        media.mojom.DemuxerStream_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.DemuxerStream_Read_ParamsSpec.$,
        media.mojom.DemuxerStream_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        impl.enableBitstreamConverter.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.DemuxerStream = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.DemuxerStream";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.DemuxerStreamRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.DemuxerStreamRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.DemuxerStream.TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.DemuxerStream_Type = {
  
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.DemuxerStream.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.DemuxerStream_Status = {
  
};

/**
 * An object which receives request messages for the DemuxerStream
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.DemuxerStreamCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.DemuxerStreamRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DemuxerStreamRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.DemuxerStream_Initialize_ParamsSpec.$,
        media.mojom.DemuxerStream_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.DemuxerStream_Read_ParamsSpec.$,
        media.mojom.DemuxerStream_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableBitstreamConverter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
        null,
        this.enableBitstreamConverter.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DemuxerStream_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DemuxerStream_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DemuxerStream_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DemuxerStream_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.DemuxerStream_EnableBitstreamConverter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.DemuxerStream_Initialize_ParamsSpec.$,
    'DemuxerStream_Initialize_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.DemuxerStream_Initialize_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.DemuxerStream_Initialize_ResponseParamsSpec.$,
    'DemuxerStream_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        media.mojom.DemuxerStream.TypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pipe', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioConfig', 8,
        0,
        media.mojom.AudioDecoderConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoConfig', 16,
        0,
        media.mojom.VideoDecoderConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.DemuxerStream_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DemuxerStream_Type } */
    this.type;
    /** @export { !MojoHandle } */
    this.pipe;
    /** @export { (media.mojom.AudioDecoderConfig|undefined) } */
    this.audioConfig;
    /** @export { (media.mojom.VideoDecoderConfig|undefined) } */
    this.videoConfig;
  }
};



mojo.internal.Struct(
    media.mojom.DemuxerStream_Read_ParamsSpec.$,
    'DemuxerStream_Read_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.DemuxerStream_Read_Params = class {
  constructor() {
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    media.mojom.DemuxerStream_Read_ResponseParamsSpec.$,
    'DemuxerStream_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.DemuxerStream.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'batchBuffers', 8,
        0,
        mojo.internal.Array(media.mojom.DecoderBufferSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioConfig', 16,
        0,
        media.mojom.AudioDecoderConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoConfig', 24,
        0,
        media.mojom.VideoDecoderConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
media.mojom.DemuxerStream_Read_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.DemuxerStream_Status } */
    this.status;
    /** @export { !Array<!media.mojom.DecoderBuffer> } */
    this.batchBuffers;
    /** @export { (media.mojom.AudioDecoderConfig|undefined) } */
    this.audioConfig;
    /** @export { (media.mojom.VideoDecoderConfig|undefined) } */
    this.videoConfig;
  }
};



mojo.internal.Struct(
    media.mojom.DemuxerStream_EnableBitstreamConverter_ParamsSpec.$,
    'DemuxerStream_EnableBitstreamConverter_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.DemuxerStream_EnableBitstreamConverter_Params = class {
  constructor() {
  }
};

