// media/capture/mojom/video_capture_buffer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_DATA_VIEW_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/capture/mojom/video_capture_buffer.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"


namespace media::mojom {
class VideoFrameInfoDataView;

class ReadyBufferDataView;

class SharedImageBufferHandleSetDataView;

class VideoBufferHandleDataView;


}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoFrameInfoDataView> {
  using Data = ::media::mojom::internal::VideoFrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ReadyBufferDataView> {
  using Data = ::media::mojom::internal::ReadyBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SharedImageBufferHandleSetDataView> {
  using Data = ::media::mojom::internal::SharedImageBufferHandleSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoBufferHandleDataView> {
  using Data = ::media::mojom::internal::VideoBufferHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class VideoFrameInfoDataView {
 public:
  VideoFrameInfoDataView() = default;

  VideoFrameInfoDataView(
      internal::VideoFrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::media::mojom::VideoFrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameMetadataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }
  ::media::mojom::VideoCapturePixelFormat pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format));
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool is_premapped() const {
    return data_->is_premapped;
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetStridesDataView(
      ::media::mojom::PlaneStridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PlaneStridesDataView, UserType>(),
    "Attempting to read the optional `strides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStrides` instead "
    "of `ReadStrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::media::mojom::PlaneStridesDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadyBufferDataView {
 public:
  ReadyBufferDataView() = default;

  ReadyBufferDataView(
      internal::ReadyBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetInfoDataView(
      VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReadyBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedImageBufferHandleSetDataView {
 public:
  SharedImageBufferHandleSetDataView() = default;

  SharedImageBufferHandleSetDataView(
      internal::SharedImageBufferHandleSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedImageBufferHandleSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoBufferHandleDataView {
 public:
  using Tag = internal::VideoBufferHandle_Data::VideoBufferHandle_Tag;

  VideoBufferHandleDataView() = default;

  VideoBufferHandleDataView(
      internal::VideoBufferHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_unsafe_shmem_region() const { return data_->tag == Tag::kUnsafeShmemRegion; }
  inline void GetUnsafeShmemRegionDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnsafeShmemRegion(UserType* output) const {
    
    CHECK(is_unsafe_shmem_region());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_unsafe_shmem_region.Get(), output, message_);
  }
  bool is_read_only_shmem_region() const { return data_->tag == Tag::kReadOnlyShmemRegion; }
  inline void GetReadOnlyShmemRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReadOnlyShmemRegion(UserType* output) const {
    
    CHECK(is_read_only_shmem_region());
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        data_->data.f_read_only_shmem_region.Get(), output, message_);
  }
  bool is_shared_image_handle() const { return data_->tag == Tag::kSharedImageHandle; }
  inline void GetSharedImageHandleDataView(
      SharedImageBufferHandleSetDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageHandle(UserType* output) const {
    
    CHECK(is_shared_image_handle());
    return mojo::internal::Deserialize<::media::mojom::SharedImageBufferHandleSetDataView>(
        data_->data.f_shared_image_handle.Get(), output, message_);
  }
  bool is_gpu_memory_buffer_handle() const { return data_->tag == Tag::kGpuMemoryBufferHandle; }
  inline void GetGpuMemoryBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferHandle(UserType* output) const {
    
    CHECK(is_gpu_memory_buffer_handle());
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        data_->data.f_gpu_memory_buffer_handle.Get(), output, message_);
  }

 private:
  internal::VideoBufferHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_DATA_VIEW_H_