// media/capture/mojom/video_capture.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture.mojom-params-data.h"
#include "media/capture/mojom/video_capture.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture.mojom-import-headers.h"
#include "media/capture/mojom/video_capture.mojom-test-utils.h"


namespace media::mojom {
VideoCaptureResultPtr
VideoCaptureResult::NewState(
    VideoCaptureState value) {
  return VideoCaptureResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kState)>,
      std::move(value));
}

VideoCaptureResultPtr
VideoCaptureResult::NewErrorCode(
    ::media::VideoCaptureError value) {
  return VideoCaptureResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
      std::move(value));
}

VideoCaptureResult::VideoCaptureResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kState)>,
    VideoCaptureState value)
    : tag_(Tag::kState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kState)>,
            std::move(value)) {}

VideoCaptureResult::VideoCaptureResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ::media::VideoCaptureError value)
    : tag_(Tag::kErrorCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
            std::move(value)) {}
VideoCaptureResult::~VideoCaptureResult() {
  DestroyActive();
}

void VideoCaptureResult::set_state(VideoCaptureState state) {
  if (tag_ != Tag::kState) {
    DestroyActive();
    tag_ = Tag::kState;
  }
  data_.state = state;
}

void VideoCaptureResult::set_error_code(::media::VideoCaptureError error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}


VideoCaptureResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kState)>,
    VideoCaptureState value)
    : state(std::move(value)) {}

VideoCaptureResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    ::media::VideoCaptureError value)
    : error_code(std::move(value)) {}

void VideoCaptureResult::DestroyActive() {
  switch (tag_) {

    case Tag::kState:
      std::destroy_at(&data_.state);
      break;
    case Tag::kErrorCode:
      std::destroy_at(&data_.error_code);
      break;
  }
}

bool VideoCaptureResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

VideoCaptureObserver::IPCStableHashFunction VideoCaptureObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoCaptureObserver>(message.name())) {
    case messages::VideoCaptureObserver::kOnStateChanged: {
      return &VideoCaptureObserver::OnStateChanged_Sym::IPCStableHash;
    }
    case messages::VideoCaptureObserver::kOnNewBuffer: {
      return &VideoCaptureObserver::OnNewBuffer_Sym::IPCStableHash;
    }
    case messages::VideoCaptureObserver::kOnBufferReady: {
      return &VideoCaptureObserver::OnBufferReady_Sym::IPCStableHash;
    }
    case messages::VideoCaptureObserver::kOnBufferDestroyed: {
      return &VideoCaptureObserver::OnBufferDestroyed_Sym::IPCStableHash;
    }
    case messages::VideoCaptureObserver::kOnFrameDropped: {
      return &VideoCaptureObserver::OnFrameDropped_Sym::IPCStableHash;
    }
    case messages::VideoCaptureObserver::kOnNewCaptureVersion: {
      return &VideoCaptureObserver::OnNewCaptureVersion_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoCaptureObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoCaptureObserver>(message.name())) {
      case messages::VideoCaptureObserver::kOnStateChanged:
            return "Receive media::mojom::VideoCaptureObserver::OnStateChanged";
      case messages::VideoCaptureObserver::kOnNewBuffer:
            return "Receive media::mojom::VideoCaptureObserver::OnNewBuffer";
      case messages::VideoCaptureObserver::kOnBufferReady:
            return "Receive media::mojom::VideoCaptureObserver::OnBufferReady";
      case messages::VideoCaptureObserver::kOnBufferDestroyed:
            return "Receive media::mojom::VideoCaptureObserver::OnBufferDestroyed";
      case messages::VideoCaptureObserver::kOnFrameDropped:
            return "Receive media::mojom::VideoCaptureObserver::OnFrameDropped";
      case messages::VideoCaptureObserver::kOnNewCaptureVersion:
            return "Receive media::mojom::VideoCaptureObserver::OnNewCaptureVersion";
    }
  } else {
    switch (static_cast<messages::VideoCaptureObserver>(message.name())) {
      case messages::VideoCaptureObserver::kOnStateChanged:
            return "Receive reply media::mojom::VideoCaptureObserver::OnStateChanged";
      case messages::VideoCaptureObserver::kOnNewBuffer:
            return "Receive reply media::mojom::VideoCaptureObserver::OnNewBuffer";
      case messages::VideoCaptureObserver::kOnBufferReady:
            return "Receive reply media::mojom::VideoCaptureObserver::OnBufferReady";
      case messages::VideoCaptureObserver::kOnBufferDestroyed:
            return "Receive reply media::mojom::VideoCaptureObserver::OnBufferDestroyed";
      case messages::VideoCaptureObserver::kOnFrameDropped:
            return "Receive reply media::mojom::VideoCaptureObserver::OnFrameDropped";
      case messages::VideoCaptureObserver::kOnNewCaptureVersion:
            return "Receive reply media::mojom::VideoCaptureObserver::OnNewCaptureVersion";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoCaptureObserver::OnStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d4e2571;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureObserver::OnNewBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b12c42f;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnNewBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureObserver::OnBufferReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe668e083;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnBufferReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureObserver::OnBufferDestroyed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51689f8a;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnBufferDestroyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureObserver::OnFrameDropped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa96da998;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnFrameDropped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureObserver::OnNewCaptureVersion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca3790eb;  // IPCStableHash for media::mojom::VideoCaptureObserver::OnNewCaptureVersion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VideoCaptureObserverProxy::VideoCaptureObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureObserverProxy::OnStateChanged(
    VideoCaptureResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type VideoCaptureResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnStateChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in VideoCaptureObserver.OnStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureObserverProxy::OnNewBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoBufferHandlePtr in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnNewBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnNewBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnNewBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<decltype(params->buffer_handle)>
      buffer_handle_fragment(params.message());
  buffer_handle_fragment.Claim(&params->buffer_handle);
  
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
    in_buffer_handle,
    buffer_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer_handle in VideoCaptureObserver.OnNewBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnNewBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureObserverProxy::OnBufferReady(
    ::media::mojom::ReadyBufferPtr in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnBufferReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::ReadyBufferPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnBufferReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnBufferReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadyBufferDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in VideoCaptureObserver.OnBufferReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnBufferReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureObserverProxy::OnBufferDestroyed(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnBufferDestroyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnBufferDestroyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnBufferDestroyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureObserverProxy::OnFrameDropped(
    ::media::VideoCaptureFrameDropReason in_reason) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnFrameDropped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::media::VideoCaptureFrameDropReason>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnFrameDropped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnFrameDropped_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::VideoCaptureFrameDropReason>(
    in_reason,
    &params->reason);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnFrameDropped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureObserverProxy::OnNewCaptureVersion(
    const ::media::CaptureVersion& in_capture_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureObserver::OnNewCaptureVersion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_version"), in_capture_version,
                        "<value of type const ::media::CaptureVersion&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureObserver::kOnNewCaptureVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureObserver_OnNewCaptureVersion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->capture_version)::BaseType> capture_version_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::CaptureVersionDataView>(
    in_capture_version,
    capture_version_fragment);

  params->capture_version.Set(
      capture_version_fragment.is_null() ? nullptr : capture_version_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->capture_version.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null capture_version in VideoCaptureObserver.OnNewCaptureVersion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureObserver::Name_);
  message.set_method_name("OnNewCaptureVersion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VideoCaptureObserverStubDispatch::Accept(
    VideoCaptureObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoCaptureObserver>(message->header()->name)) {
    case messages::VideoCaptureObserver::kOnStateChanged: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnStateChanged_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.0
      bool success = true;
      VideoCaptureResultPtr p_result{};
      VideoCaptureObserver_OnStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStateChanged(        
        std::move(p_result));
      return true;
    }
    case messages::VideoCaptureObserver::kOnNewBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnNewBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnNewBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.1
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoBufferHandlePtr p_buffer_handle{};
      VideoCaptureObserver_OnNewBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewBuffer(        
        std::move(p_buffer_id), 
        std::move(p_buffer_handle));
      return true;
    }
    case messages::VideoCaptureObserver::kOnBufferReady: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnBufferReady_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnBufferReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.2
      bool success = true;
      ::media::mojom::ReadyBufferPtr p_buffer{};
      VideoCaptureObserver_OnBufferReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferReady(        
        std::move(p_buffer));
      return true;
    }
    case messages::VideoCaptureObserver::kOnBufferDestroyed: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.3
      bool success = true;
      int32_t p_buffer_id{};
      VideoCaptureObserver_OnBufferDestroyed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferDestroyed(        
        std::move(p_buffer_id));
      return true;
    }
    case messages::VideoCaptureObserver::kOnFrameDropped: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnFrameDropped_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnFrameDropped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.4
      bool success = true;
      ::media::VideoCaptureFrameDropReason p_reason{};
      VideoCaptureObserver_OnFrameDropped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameDropped(        
        std::move(p_reason));
      return true;
    }
    case messages::VideoCaptureObserver::kOnNewCaptureVersion: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureObserver_OnNewCaptureVersion_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureObserver_OnNewCaptureVersion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureObserver.5
      bool success = true;
      ::media::CaptureVersion p_capture_version{};
      VideoCaptureObserver_OnNewCaptureVersion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCaptureVersion(&p_capture_version))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewCaptureVersion(        
        std::move(p_capture_version));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureObserverStubDispatch::AcceptWithResponder(
    VideoCaptureObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoCaptureObserver>(message->header()->name)) {
    case messages::VideoCaptureObserver::kOnStateChanged: {
      break;
    }
    case messages::VideoCaptureObserver::kOnNewBuffer: {
      break;
    }
    case messages::VideoCaptureObserver::kOnBufferReady: {
      break;
    }
    case messages::VideoCaptureObserver::kOnBufferDestroyed: {
      break;
    }
    case messages::VideoCaptureObserver::kOnFrameDropped: {
      break;
    }
    case messages::VideoCaptureObserver::kOnNewCaptureVersion: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoCaptureObserverValidationInfo[] = {
    { &internal::VideoCaptureObserver_OnStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureObserver_OnNewBuffer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureObserver_OnBufferReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureObserver_OnBufferDestroyed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureObserver_OnFrameDropped_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureObserver_OnNewCaptureVersion_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoCaptureObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoCaptureObserver::Name_,
    kVideoCaptureObserverValidationInfo);
}

// The declaration includes the definition on other builds.

VideoCaptureHost::IPCStableHashFunction VideoCaptureHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoCaptureHost>(message.name())) {
    case messages::VideoCaptureHost::kStart: {
      return &VideoCaptureHost::Start_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kStop: {
      return &VideoCaptureHost::Stop_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kPause: {
      return &VideoCaptureHost::Pause_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kResume: {
      return &VideoCaptureHost::Resume_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kRequestRefreshFrame: {
      return &VideoCaptureHost::RequestRefreshFrame_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kReleaseBuffer: {
      return &VideoCaptureHost::ReleaseBuffer_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kGetDeviceSupportedFormats: {
      return &VideoCaptureHost::GetDeviceSupportedFormats_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kGetDeviceFormatsInUse: {
      return &VideoCaptureHost::GetDeviceFormatsInUse_Sym::IPCStableHash;
    }
    case messages::VideoCaptureHost::kOnLog: {
      return &VideoCaptureHost::OnLog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoCaptureHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoCaptureHost>(message.name())) {
      case messages::VideoCaptureHost::kStart:
            return "Receive media::mojom::VideoCaptureHost::Start";
      case messages::VideoCaptureHost::kStop:
            return "Receive media::mojom::VideoCaptureHost::Stop";
      case messages::VideoCaptureHost::kPause:
            return "Receive media::mojom::VideoCaptureHost::Pause";
      case messages::VideoCaptureHost::kResume:
            return "Receive media::mojom::VideoCaptureHost::Resume";
      case messages::VideoCaptureHost::kRequestRefreshFrame:
            return "Receive media::mojom::VideoCaptureHost::RequestRefreshFrame";
      case messages::VideoCaptureHost::kReleaseBuffer:
            return "Receive media::mojom::VideoCaptureHost::ReleaseBuffer";
      case messages::VideoCaptureHost::kGetDeviceSupportedFormats:
            return "Receive media::mojom::VideoCaptureHost::GetDeviceSupportedFormats";
      case messages::VideoCaptureHost::kGetDeviceFormatsInUse:
            return "Receive media::mojom::VideoCaptureHost::GetDeviceFormatsInUse";
      case messages::VideoCaptureHost::kOnLog:
            return "Receive media::mojom::VideoCaptureHost::OnLog";
    }
  } else {
    switch (static_cast<messages::VideoCaptureHost>(message.name())) {
      case messages::VideoCaptureHost::kStart:
            return "Receive reply media::mojom::VideoCaptureHost::Start";
      case messages::VideoCaptureHost::kStop:
            return "Receive reply media::mojom::VideoCaptureHost::Stop";
      case messages::VideoCaptureHost::kPause:
            return "Receive reply media::mojom::VideoCaptureHost::Pause";
      case messages::VideoCaptureHost::kResume:
            return "Receive reply media::mojom::VideoCaptureHost::Resume";
      case messages::VideoCaptureHost::kRequestRefreshFrame:
            return "Receive reply media::mojom::VideoCaptureHost::RequestRefreshFrame";
      case messages::VideoCaptureHost::kReleaseBuffer:
            return "Receive reply media::mojom::VideoCaptureHost::ReleaseBuffer";
      case messages::VideoCaptureHost::kGetDeviceSupportedFormats:
            return "Receive reply media::mojom::VideoCaptureHost::GetDeviceSupportedFormats";
      case messages::VideoCaptureHost::kGetDeviceFormatsInUse:
            return "Receive reply media::mojom::VideoCaptureHost::GetDeviceFormatsInUse";
      case messages::VideoCaptureHost::kOnLog:
            return "Receive reply media::mojom::VideoCaptureHost::OnLog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoCaptureHost::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f69b6b5;  // IPCStableHash for media::mojom::VideoCaptureHost::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad455156;  // IPCStableHash for media::mojom::VideoCaptureHost::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::Pause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28c79f85;  // IPCStableHash for media::mojom::VideoCaptureHost::Pause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe641cea0;  // IPCStableHash for media::mojom::VideoCaptureHost::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::RequestRefreshFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x075d2769;  // IPCStableHash for media::mojom::VideoCaptureHost::RequestRefreshFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::ReleaseBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa238273d;  // IPCStableHash for media::mojom::VideoCaptureHost::ReleaseBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::GetDeviceSupportedFormats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15115b3c;  // IPCStableHash for media::mojom::VideoCaptureHost::GetDeviceSupportedFormats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::GetDeviceFormatsInUse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f85de68;  // IPCStableHash for media::mojom::VideoCaptureHost::GetDeviceFormatsInUse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoCaptureHost::OnLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb945e168;  // IPCStableHash for media::mojom::VideoCaptureHost::OnLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback(
      VideoCaptureHost::GetDeviceSupportedFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback(const VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback&) = delete;
  VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback& operator=(const VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoCaptureHost::GetDeviceSupportedFormatsCallback callback_;
};

class VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback(
      VideoCaptureHost::GetDeviceFormatsInUseCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback(const VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback&) = delete;
  VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback& operator=(const VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoCaptureHost::GetDeviceFormatsInUseCallback callback_;
};

VideoCaptureHostProxy::VideoCaptureHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoCaptureHostProxy::Start(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, const ::media::VideoCaptureParams& in_params, ::mojo::PendingRemote<VideoCaptureObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::VideoCaptureParams&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<VideoCaptureObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in VideoCaptureHost.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in VideoCaptureHost.Start request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::VideoCaptureObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in VideoCaptureHost.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::Stop(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.Stop request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::Pause(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::Pause", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Pause_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.Pause request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::Resume(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, const ::media::VideoCaptureParams& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::Resume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::VideoCaptureParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_Resume_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.Resume request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in VideoCaptureHost.Resume request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in VideoCaptureHost.Resume request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::RequestRefreshFrame(
    const ::base::UnguessableToken& in_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::RequestRefreshFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kRequestRefreshFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_RequestRefreshFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.RequestRefreshFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("RequestRefreshFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::ReleaseBuffer(
    const ::base::UnguessableToken& in_device_id, int32_t in_buffer_id, const ::media::VideoCaptureFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::ReleaseBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type const ::media::VideoCaptureFeedback&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kReleaseBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_ReleaseBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.ReleaseBuffer request");

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureFeedbackDataView>(
    in_feedback,
    feedback_fragment);

  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->feedback.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null feedback in VideoCaptureHost.ReleaseBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("ReleaseBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoCaptureHostProxy::GetDeviceSupportedFormats(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, GetDeviceSupportedFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::GetDeviceSupportedFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kGetDeviceSupportedFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.GetDeviceSupportedFormats request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in VideoCaptureHost.GetDeviceSupportedFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceSupportedFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoCaptureHostProxy::GetDeviceFormatsInUse(
    const ::base::UnguessableToken& in_device_id, const ::base::UnguessableToken& in_session_id, GetDeviceFormatsInUseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::GetDeviceFormatsInUse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kGetDeviceFormatsInUse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.GetDeviceFormatsInUse request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in VideoCaptureHost.GetDeviceFormatsInUse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceFormatsInUse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoCaptureHostProxy::OnLog(
    const ::base::UnguessableToken& in_device_id, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::VideoCaptureHost::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kOnLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in VideoCaptureHost.OnLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in VideoCaptureHost.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoCaptureHost::GetDeviceSupportedFormatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder> proxy(
        new VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoCaptureHost::GetDeviceSupportedFormatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats_supported);
};

bool VideoCaptureHost_GetDeviceSupportedFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoCaptureHost.6
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats_supported{};
  VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatsSupported(&p_formats_supported))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoCaptureHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_formats_supported));
  }
  return true;
}

void VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats_supported) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoCaptureHost::GetDeviceSupportedFormats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats_supported"), in_formats_supported,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kGetDeviceSupportedFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats_supported)::BaseType>
      formats_supported_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& formats_supported_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
    in_formats_supported,
    formats_supported_fragment,
    &formats_supported_validate_params);

  params->formats_supported.Set(
      formats_supported_fragment.is_null() ? nullptr : formats_supported_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->formats_supported.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null formats_supported in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceSupportedFormats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoCaptureHost::GetDeviceFormatsInUseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder> proxy(
        new VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoCaptureHost::GetDeviceFormatsInUseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats_in_use);
};

bool VideoCaptureHost_GetDeviceFormatsInUse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoCaptureHost.7
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats_in_use{};
  VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatsInUse(&p_formats_in_use))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoCaptureHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_formats_in_use));
  }
  return true;
}

void VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats_in_use) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::VideoCaptureHost::GetDeviceFormatsInUse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats_in_use"), in_formats_in_use,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoCaptureHost::kGetDeviceFormatsInUse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats_in_use)::BaseType>
      formats_in_use_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& formats_in_use_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
    in_formats_in_use,
    formats_in_use_fragment,
    &formats_in_use_validate_params);

  params->formats_in_use.Set(
      formats_in_use_fragment.is_null() ? nullptr : formats_in_use_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->formats_in_use.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null formats_in_use in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoCaptureHost::Name_);
  message.set_method_name("GetDeviceFormatsInUse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoCaptureHostStubDispatch::Accept(
    VideoCaptureHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoCaptureHost>(message->header()->name)) {
    case messages::VideoCaptureHost::kStart: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Start_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.0
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      ::media::VideoCaptureParams p_params{};
      ::mojo::PendingRemote<VideoCaptureObserver> p_observer{};
      VideoCaptureHost_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_device_id), 
        std::move(p_session_id), 
        std::move(p_params), 
        std::move(p_observer));
      return true;
    }
    case messages::VideoCaptureHost::kStop: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Stop_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.1
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        
        std::move(p_device_id));
      return true;
    }
    case messages::VideoCaptureHost::kPause: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Pause_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Pause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.2
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_Pause_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(        
        std::move(p_device_id));
      return true;
    }
    case messages::VideoCaptureHost::kResume: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_Resume_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.3
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      ::media::VideoCaptureParams p_params{};
      VideoCaptureHost_Resume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        
        std::move(p_device_id), 
        std::move(p_session_id), 
        std::move(p_params));
      return true;
    }
    case messages::VideoCaptureHost::kRequestRefreshFrame: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_RequestRefreshFrame_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_RequestRefreshFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.4
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      VideoCaptureHost_RequestRefreshFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestRefreshFrame(        
        std::move(p_device_id));
      return true;
    }
    case messages::VideoCaptureHost::kReleaseBuffer: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_ReleaseBuffer_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_ReleaseBuffer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.5
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      int32_t p_buffer_id{};
      ::media::VideoCaptureFeedback p_feedback{};
      VideoCaptureHost_ReleaseBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReleaseBuffer(        
        std::move(p_device_id), 
        std::move(p_buffer_id), 
        std::move(p_feedback));
      return true;
    }
    case messages::VideoCaptureHost::kGetDeviceSupportedFormats: {
      break;
    }
    case messages::VideoCaptureHost::kGetDeviceFormatsInUse: {
      break;
    }
    case messages::VideoCaptureHost::kOnLog: {
      DCHECK(message->is_serialized());
      internal::VideoCaptureHost_OnLog_Params_Data* params =
          reinterpret_cast<internal::VideoCaptureHost_OnLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoCaptureHost.8
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      std::string p_message{};
      VideoCaptureHost_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(        
        std::move(p_device_id), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool VideoCaptureHostStubDispatch::AcceptWithResponder(
    VideoCaptureHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoCaptureHost>(message->header()->name)) {
    case messages::VideoCaptureHost::kStart: {
      break;
    }
    case messages::VideoCaptureHost::kStop: {
      break;
    }
    case messages::VideoCaptureHost::kPause: {
      break;
    }
    case messages::VideoCaptureHost::kResume: {
      break;
    }
    case messages::VideoCaptureHost::kRequestRefreshFrame: {
      break;
    }
    case messages::VideoCaptureHost::kReleaseBuffer: {
      break;
    }
    case messages::VideoCaptureHost::kGetDeviceSupportedFormats: {
      internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data* params =
          reinterpret_cast<
              internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoCaptureHost.6
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      VideoCaptureHost_GetDeviceSupportedFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 6, false);
        return false;
      }
      auto callback =
          VideoCaptureHost_GetDeviceSupportedFormats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceSupportedFormats(        
        std::move(p_device_id), 
        std::move(p_session_id), std::move(callback));
      return true;
    }
    case messages::VideoCaptureHost::kGetDeviceFormatsInUse: {
      internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data* params =
          reinterpret_cast<
              internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoCaptureHost.7
      bool success = true;
      ::base::UnguessableToken p_device_id{};
      ::base::UnguessableToken p_session_id{};
      VideoCaptureHost_GetDeviceFormatsInUse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoCaptureHost::Name_, 7, false);
        return false;
      }
      auto callback =
          VideoCaptureHost_GetDeviceFormatsInUse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceFormatsInUse(        
        std::move(p_device_id), 
        std::move(p_session_id), std::move(callback));
      return true;
    }
    case messages::VideoCaptureHost::kOnLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoCaptureHostValidationInfo[] = {
    { &internal::VideoCaptureHost_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_Stop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_Pause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_RequestRefreshFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_ReleaseBuffer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoCaptureHost_GetDeviceSupportedFormats_Params_Data::Validate,
     &internal::VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams_Data::Validate},
    { &internal::VideoCaptureHost_GetDeviceFormatsInUse_Params_Data::Validate,
     &internal::VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams_Data::Validate},
    { &internal::VideoCaptureHost_OnLog_Params_Data::Validate,
     nullptr /* no response */},
};

bool VideoCaptureHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::VideoCaptureHost::Name_,
    kVideoCaptureHostValidationInfo);
}

bool VideoCaptureHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::VideoCaptureHost::Name_,
    kVideoCaptureHostValidationInfo);
}


}  // media::mojom


namespace mojo {

// static
bool UnionTraits<::media::mojom::VideoCaptureResult::DataView, ::media::mojom::VideoCaptureResultPtr>::Read(
    ::media::mojom::VideoCaptureResult::DataView input,
    ::media::mojom::VideoCaptureResultPtr* output) {
  using UnionType = ::media::mojom::VideoCaptureResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kState: {
      ::media::mojom::VideoCaptureState result_state;
      if (!input.ReadState(&result_state))
        return false;

      *output = UnionType::NewState(result_state);
      break;
    }
    case Tag::kErrorCode: {
      ::media::VideoCaptureError result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void VideoCaptureObserverInterceptorForTesting::OnStateChanged(VideoCaptureResultPtr result) {
  GetForwardingInterface()->OnStateChanged(
    std::move(result)
    );
}
void VideoCaptureObserverInterceptorForTesting::OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) {
  GetForwardingInterface()->OnNewBuffer(
    std::move(buffer_id)
    , 
    std::move(buffer_handle)
    );
}
void VideoCaptureObserverInterceptorForTesting::OnBufferReady(::media::mojom::ReadyBufferPtr buffer) {
  GetForwardingInterface()->OnBufferReady(
    std::move(buffer)
    );
}
void VideoCaptureObserverInterceptorForTesting::OnBufferDestroyed(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferDestroyed(
    std::move(buffer_id)
    );
}
void VideoCaptureObserverInterceptorForTesting::OnFrameDropped(::media::VideoCaptureFrameDropReason reason) {
  GetForwardingInterface()->OnFrameDropped(
    std::move(reason)
    );
}
void VideoCaptureObserverInterceptorForTesting::OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) {
  GetForwardingInterface()->OnNewCaptureVersion(
    std::move(capture_version)
    );
}
VideoCaptureObserverAsyncWaiter::VideoCaptureObserverAsyncWaiter(
    VideoCaptureObserver* proxy) : proxy_(proxy) {}

VideoCaptureObserverAsyncWaiter::~VideoCaptureObserverAsyncWaiter() = default;





void VideoCaptureHostInterceptorForTesting::Start(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params, ::mojo::PendingRemote<VideoCaptureObserver> observer) {
  GetForwardingInterface()->Start(
    std::move(device_id)
    , 
    std::move(session_id)
    , 
    std::move(params)
    , 
    std::move(observer)
    );
}
void VideoCaptureHostInterceptorForTesting::Stop(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->Stop(
    std::move(device_id)
    );
}
void VideoCaptureHostInterceptorForTesting::Pause(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->Pause(
    std::move(device_id)
    );
}
void VideoCaptureHostInterceptorForTesting::Resume(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params) {
  GetForwardingInterface()->Resume(
    std::move(device_id)
    , 
    std::move(session_id)
    , 
    std::move(params)
    );
}
void VideoCaptureHostInterceptorForTesting::RequestRefreshFrame(const ::base::UnguessableToken& device_id) {
  GetForwardingInterface()->RequestRefreshFrame(
    std::move(device_id)
    );
}
void VideoCaptureHostInterceptorForTesting::ReleaseBuffer(const ::base::UnguessableToken& device_id, int32_t buffer_id, const ::media::VideoCaptureFeedback& feedback) {
  GetForwardingInterface()->ReleaseBuffer(
    std::move(device_id)
    , 
    std::move(buffer_id)
    , 
    std::move(feedback)
    );
}
void VideoCaptureHostInterceptorForTesting::GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceSupportedFormatsCallback callback) {
  GetForwardingInterface()->GetDeviceSupportedFormats(
    std::move(device_id)
    , 
    std::move(session_id)
    , std::move(callback));
}
void VideoCaptureHostInterceptorForTesting::GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceFormatsInUseCallback callback) {
  GetForwardingInterface()->GetDeviceFormatsInUse(
    std::move(device_id)
    , 
    std::move(session_id)
    , std::move(callback));
}
void VideoCaptureHostInterceptorForTesting::OnLog(const ::base::UnguessableToken& device_id, const std::string& message) {
  GetForwardingInterface()->OnLog(
    std::move(device_id)
    , 
    std::move(message)
    );
}
VideoCaptureHostAsyncWaiter::VideoCaptureHostAsyncWaiter(
    VideoCaptureHost* proxy) : proxy_(proxy) {}

VideoCaptureHostAsyncWaiter::~VideoCaptureHostAsyncWaiter() = default;


void VideoCaptureHostAsyncWaiter::GetDeviceSupportedFormats(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, std::vector<::media::VideoCaptureFormat>* out_formats_supported) {
  base::RunLoop loop;
  proxy_->GetDeviceSupportedFormats(
      std::move(device_id),
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureFormat>* out_formats_supported
,
             const std::vector<::media::VideoCaptureFormat>& formats_supported) {*out_formats_supported = std::move(formats_supported);
            loop->Quit();
          },
          &loop,
          out_formats_supported));
  loop.Run();
}

std::vector<::media::VideoCaptureFormat> VideoCaptureHostAsyncWaiter::GetDeviceSupportedFormats(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id) {
  std::vector<::media::VideoCaptureFormat> async_wait_result;
  GetDeviceSupportedFormats(std::move(device_id),std::move(session_id),&async_wait_result);
  return async_wait_result;
}

void VideoCaptureHostAsyncWaiter::GetDeviceFormatsInUse(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, std::vector<::media::VideoCaptureFormat>* out_formats_in_use) {
  base::RunLoop loop;
  proxy_->GetDeviceFormatsInUse(
      std::move(device_id),
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureFormat>* out_formats_in_use
,
             const std::vector<::media::VideoCaptureFormat>& formats_in_use) {*out_formats_in_use = std::move(formats_in_use);
            loop->Quit();
          },
          &loop,
          out_formats_in_use));
  loop.Run();
}

std::vector<::media::VideoCaptureFormat> VideoCaptureHostAsyncWaiter::GetDeviceFormatsInUse(
    const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id) {
  std::vector<::media::VideoCaptureFormat> async_wait_result;
  GetDeviceFormatsInUse(std::move(device_id),std::move(session_id),&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif