// media/capture/mojom/video_capture.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture.mojom-features.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture.mojom-shared.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-blink-forward.h"
#include "media/capture/mojom/video_capture_types.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class VideoCaptureObserverProxy;

template <typename ImplRefTraits>
class VideoCaptureObserverStub;

class VideoCaptureObserverRequestValidator;


class BLINK_PLATFORM_EXPORT VideoCaptureObserver
    : public VideoCaptureObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoCaptureObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoCaptureObserverInterfaceBase;
  using Proxy_ = VideoCaptureObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoCaptureObserverStub<ImplRefTraits>;

  using RequestValidator_ = VideoCaptureObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnStateChangedMinVersion = 0,
    kOnNewBufferMinVersion = 0,
    kOnBufferReadyMinVersion = 0,
    kOnBufferDestroyedMinVersion = 0,
    kOnFrameDroppedMinVersion = 0,
    kOnNewCaptureVersionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferDestroyed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameDropped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewCaptureVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoCaptureObserver() = default;

  virtual void OnStateChanged(VideoCaptureResultPtr result) = 0;

  virtual void OnNewBuffer(int32_t buffer_id, ::media::mojom::blink::VideoBufferHandlePtr buffer_handle) = 0;

  virtual void OnBufferReady(::media::mojom::blink::ReadyBufferPtr buffer) = 0;

  virtual void OnBufferDestroyed(int32_t buffer_id) = 0;

  virtual void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) = 0;

  virtual void OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) = 0;
};

class VideoCaptureHostProxy;

template <typename ImplRefTraits>
class VideoCaptureHostStub;

class VideoCaptureHostRequestValidator;
class VideoCaptureHostResponseValidator;


class BLINK_PLATFORM_EXPORT VideoCaptureHost
    : public VideoCaptureHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.VideoCaptureHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoCaptureHostInterfaceBase;
  using Proxy_ = VideoCaptureHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoCaptureHostStub<ImplRefTraits>;

  using RequestValidator_ = VideoCaptureHostRequestValidator;
  using ResponseValidator_ = VideoCaptureHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kStopMinVersion = 0,
    kPauseMinVersion = 0,
    kResumeMinVersion = 0,
    kRequestRefreshFrameMinVersion = 0,
    kReleaseBufferMinVersion = 0,
    kGetDeviceSupportedFormatsMinVersion = 0,
    kGetDeviceFormatsInUseMinVersion = 0,
    kOnLogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Pause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestRefreshFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReleaseBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceSupportedFormats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceFormatsInUse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoCaptureHost() = default;

  virtual void Start(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params, ::mojo::PendingRemote<VideoCaptureObserver> observer) = 0;

  virtual void Stop(const ::base::UnguessableToken& device_id) = 0;

  virtual void Pause(const ::base::UnguessableToken& device_id) = 0;

  virtual void Resume(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params) = 0;

  virtual void RequestRefreshFrame(const ::base::UnguessableToken& device_id) = 0;

  virtual void ReleaseBuffer(const ::base::UnguessableToken& device_id, int32_t buffer_id, const ::media::VideoCaptureFeedback& feedback) = 0;

  using GetDeviceSupportedFormatsCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;
  using GetDeviceSupportedFormatsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;

  virtual void GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceSupportedFormatsCallback callback) = 0;

  using GetDeviceFormatsInUseCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;
  using GetDeviceFormatsInUseMojoCallback = base::OnceCallback<void(const ::blink::Vector<::media::VideoCaptureFormat>&)>;

  virtual void GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceFormatsInUseCallback callback) = 0;

  virtual void OnLog(const ::base::UnguessableToken& device_id, const ::blink::String& message) = 0;
};



class BLINK_PLATFORM_EXPORT VideoCaptureObserverProxy
    : public VideoCaptureObserver {
 public:
  using InterfaceType = VideoCaptureObserver;

  explicit VideoCaptureObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStateChanged(VideoCaptureResultPtr result) final;
  
  void OnNewBuffer(int32_t buffer_id, ::media::mojom::blink::VideoBufferHandlePtr buffer_handle) final;
  
  void OnBufferReady(::media::mojom::blink::ReadyBufferPtr buffer) final;
  
  void OnBufferDestroyed(int32_t buffer_id) final;
  
  void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) final;
  
  void OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT VideoCaptureHostProxy
    : public VideoCaptureHost {
 public:
  using InterfaceType = VideoCaptureHost;

  explicit VideoCaptureHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params, ::mojo::PendingRemote<VideoCaptureObserver> observer) final;
  
  void Stop(const ::base::UnguessableToken& device_id) final;
  
  void Pause(const ::base::UnguessableToken& device_id) final;
  
  void Resume(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, const ::media::VideoCaptureParams& params) final;
  
  void RequestRefreshFrame(const ::base::UnguessableToken& device_id) final;
  
  void ReleaseBuffer(const ::base::UnguessableToken& device_id, int32_t buffer_id, const ::media::VideoCaptureFeedback& feedback) final;
  
  void GetDeviceSupportedFormats(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceSupportedFormatsCallback callback) final;
  
  void GetDeviceFormatsInUse(const ::base::UnguessableToken& device_id, const ::base::UnguessableToken& session_id, GetDeviceFormatsInUseCallback callback) final;
  
  void OnLog(const ::base::UnguessableToken& device_id, const ::blink::String& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT VideoCaptureObserverStubDispatch {
 public:
  static bool Accept(VideoCaptureObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoCaptureObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoCaptureObserver>>
class VideoCaptureObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoCaptureObserverStub() = default;
  ~VideoCaptureObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoCaptureHostStubDispatch {
 public:
  static bool Accept(VideoCaptureHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoCaptureHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoCaptureHost>>
class VideoCaptureHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoCaptureHostStub() = default;
  ~VideoCaptureHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT VideoCaptureObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoCaptureHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT VideoCaptureHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT VideoCaptureResult {
 public:
  using DataView = VideoCaptureResultDataView;
  using Data_ = internal::VideoCaptureResult_Data;
  using Tag = Data_::VideoCaptureResult_Tag;

  template <typename... Args>
  static VideoCaptureResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |state|.
  static VideoCaptureResultPtr NewState(
      VideoCaptureState value);
  // Construct an instance holding |error_code|.
  static VideoCaptureResultPtr NewErrorCode(
      ::media::VideoCaptureError value);

  template <typename U>
  static VideoCaptureResultPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureResult>::Convert(*this);
  }
  ~VideoCaptureResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoCaptureResultPtr>
  VideoCaptureResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoCaptureResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoCaptureResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_state() const { return tag_ == Tag::kState; }
  VideoCaptureState get_state() const {
    CHECK(tag_ == Tag::kState);
    return data_.state;
  }
  void set_state(VideoCaptureState state);

  bool is_error_code() const { return tag_ == Tag::kErrorCode; }
  ::media::VideoCaptureError get_error_code() const {
    CHECK(tag_ == Tag::kErrorCode);
    return data_.error_code;
  }
  void set_error_code(::media::VideoCaptureError error_code);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kState)>,
        VideoCaptureState value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
        ::media::VideoCaptureError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    VideoCaptureState state;
    ::media::VideoCaptureError error_code;
  };

  VideoCaptureResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kState)>,
      VideoCaptureState value);
  VideoCaptureResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
      ::media::VideoCaptureError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
VideoCaptureResultPtr VideoCaptureResult::Clone() const {
  switch (tag_) {
    case Tag::kState:
      return NewState(
          mojo::Clone(data_.state));
    case Tag::kErrorCode:
      return NewErrorCode(
          mojo::Clone(data_.error_code));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoCaptureResult>::value>::type*>
bool VideoCaptureResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kState:
      return mojo::Equals(data_.state, other.data_.state);
    case Tag::kErrorCode:
      return mojo::Equals(data_.error_code, other.data_.error_code);
  }

  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::media::mojom::blink::VideoCaptureResult::DataView,
                                        ::media::mojom::blink::VideoCaptureResultPtr> {
  static bool IsNull(const ::media::mojom::blink::VideoCaptureResultPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::VideoCaptureResultPtr* output) { output->reset(); }

  static ::media::mojom::blink::VideoCaptureResult::Tag GetTag(const ::media::mojom::blink::VideoCaptureResultPtr& input) {
    return input->which();
  }

  static  ::media::mojom::blink::VideoCaptureState state(const ::media::mojom::blink::VideoCaptureResultPtr& input) {
    return input->get_state();
  }

  static  ::media::VideoCaptureError error_code(const ::media::mojom::blink::VideoCaptureResultPtr& input) {
    return input->get_error_code();
  }

  static bool Read(::media::mojom::blink::VideoCaptureResult::DataView input, ::media::mojom::blink::VideoCaptureResultPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_MOJOM_BLINK_H_