// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef headless_protocol_Page_h
#define headless_protocol_Page_h

#include "headless/public/headless_export.h"
#include "headless/lib/browser/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace headless {
namespace protocol {
namespace Page {

// ------------- Forward and enum declarations.

namespace CaptureScreenshot {
namespace FormatEnum {
HEADLESS_EXPORT extern const char* Jpeg;
HEADLESS_EXPORT extern const char* Png;
HEADLESS_EXPORT extern const char* Webp;
} // FormatEnum
} // CaptureScreenshot

namespace CaptureSnapshot {
namespace FormatEnum {
HEADLESS_EXPORT extern const char* Mhtml;
} // FormatEnum
} // CaptureSnapshot

namespace PrintToPDF {
namespace TransferModeEnum {
HEADLESS_EXPORT extern const char* ReturnAsBase64;
HEADLESS_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // PrintToPDF

namespace SetDownloadBehavior {
namespace BehaviorEnum {
HEADLESS_EXPORT extern const char* Deny;
HEADLESS_EXPORT extern const char* Allow;
HEADLESS_EXPORT extern const char* Default;
} // BehaviorEnum
} // SetDownloadBehavior

namespace SetTouchEmulationEnabled {
namespace ConfigurationEnum {
HEADLESS_EXPORT extern const char* Mobile;
HEADLESS_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetTouchEmulationEnabled

namespace StartScreencast {
namespace FormatEnum {
HEADLESS_EXPORT extern const char* Jpeg;
HEADLESS_EXPORT extern const char* Png;
} // FormatEnum
} // StartScreencast

namespace SetWebLifecycleState {
namespace StateEnum {
HEADLESS_EXPORT extern const char* Frozen;
HEADLESS_EXPORT extern const char* Active;
} // StateEnum
} // SetWebLifecycleState

namespace SetSPCTransactionMode {
namespace ModeEnum {
HEADLESS_EXPORT extern const char* None;
HEADLESS_EXPORT extern const char* AutoAccept;
HEADLESS_EXPORT extern const char* AutoChooseToAuthAnotherWay;
HEADLESS_EXPORT extern const char* AutoReject;
HEADLESS_EXPORT extern const char* AutoOptOut;
} // ModeEnum
} // SetSPCTransactionMode

namespace SetRPHRegistrationMode {
namespace ModeEnum {
HEADLESS_EXPORT extern const char* None;
HEADLESS_EXPORT extern const char* AutoAccept;
HEADLESS_EXPORT extern const char* AutoReject;
} // ModeEnum
} // SetRPHRegistrationMode

namespace FileChooserOpened {
namespace ModeEnum {
HEADLESS_EXPORT extern const char* SelectSingle;
HEADLESS_EXPORT extern const char* SelectMultiple;
} // ModeEnum
} // FileChooserOpened

namespace FrameDetached {
namespace ReasonEnum {
HEADLESS_EXPORT extern const char* Remove;
HEADLESS_EXPORT extern const char* Swap;
} // ReasonEnum
} // FrameDetached

namespace FrameStartedNavigating {
namespace NavigationTypeEnum {
HEADLESS_EXPORT extern const char* Reload;
HEADLESS_EXPORT extern const char* ReloadBypassingCache;
HEADLESS_EXPORT extern const char* Restore;
HEADLESS_EXPORT extern const char* RestoreWithPost;
HEADLESS_EXPORT extern const char* HistorySameDocument;
HEADLESS_EXPORT extern const char* HistoryDifferentDocument;
HEADLESS_EXPORT extern const char* SameDocument;
HEADLESS_EXPORT extern const char* DifferentDocument;
} // NavigationTypeEnum
} // FrameStartedNavigating

namespace DownloadProgress {
namespace StateEnum {
HEADLESS_EXPORT extern const char* InProgress;
HEADLESS_EXPORT extern const char* Completed;
HEADLESS_EXPORT extern const char* Canceled;
} // StateEnum
} // DownloadProgress

namespace NavigatedWithinDocument {
namespace NavigationTypeEnum {
HEADLESS_EXPORT extern const char* Fragment;
HEADLESS_EXPORT extern const char* HistoryApi;
HEADLESS_EXPORT extern const char* Other;
} // NavigationTypeEnum
} // NavigatedWithinDocument

// ------------- Type and builder declarations.

// ------------- Backend interface.

class HEADLESS_EXPORT Backend {
public:
    virtual ~Backend() { }

    class HEADLESS_EXPORT PrintToPDFCallback {
    public:
        virtual void sendSuccess(const Binary& data, std::optional<String> stream) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~PrintToPDFCallback() { }
    };
    virtual void PrintToPDF(std::optional<bool> in_landscape, std::optional<bool> in_displayHeaderFooter, std::optional<bool> in_printBackground, std::optional<double> in_scale, std::optional<double> in_paperWidth, std::optional<double> in_paperHeight, std::optional<double> in_marginTop, std::optional<double> in_marginBottom, std::optional<double> in_marginLeft, std::optional<double> in_marginRight, std::optional<String> in_pageRanges, std::optional<String> in_headerTemplate, std::optional<String> in_footerTemplate, std::optional<bool> in_preferCSSPageSize, std::optional<String> in_transferMode, std::optional<bool> in_generateTaggedPDF, std::optional<bool> in_generateDocumentOutline, std::unique_ptr<PrintToPDFCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class HEADLESS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class HEADLESS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class HEADLESS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Page
} // namespace headless
} // namespace protocol

#endif // !defined(headless_protocol_Page_h)
