// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef headless_protocol_Emulation_h
#define headless_protocol_Emulation_h

#include "headless/public/headless_export.h"
#include "headless/lib/browser/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "headless/lib/browser/protocol/page.h"

namespace headless {
namespace protocol {
namespace Emulation {
class ScreenOrientation;
class WorkAreaInsets;
using ScreenId = String;
class ScreenInfo;

// ------------- Forward and enum declarations.

namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
HEADLESS_EXPORT extern const char* Mobile;
HEADLESS_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
HEADLESS_EXPORT extern const char* None;
HEADLESS_EXPORT extern const char* BlurredVision;
HEADLESS_EXPORT extern const char* ReducedContrast;
HEADLESS_EXPORT extern const char* Achromatopsia;
HEADLESS_EXPORT extern const char* Deuteranopia;
HEADLESS_EXPORT extern const char* Protanopia;
HEADLESS_EXPORT extern const char* Tritanopia;
} // TypeEnum
} // SetEmulatedVisionDeficiency

// ------------- Type and builder declarations.

class HEADLESS_EXPORT ScreenOrientation : public ::crdtp::ProtocolObject<ScreenOrientation> {
public:
    ~ScreenOrientation() override { }

    struct HEADLESS_EXPORT TypeEnum {
        static const char* PortraitPrimary;
        static const char* PortraitSecondary;
        static const char* LandscapePrimary;
        static const char* LandscapeSecondary;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    int GetAngle() { return m_angle; }
    void SetAngle(int value) { m_angle = value; }

    template<int STATE>
    class ScreenOrientationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AngleSet = 1 << 2,
            AllFieldsSet = (TypeSet | AngleSet | 0)};


        ScreenOrientationBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        ScreenOrientationBuilder<STATE | AngleSet>& SetAngle(int value)
        {
            static_assert(!(STATE & AngleSet), "property angle should not be set yet");
            m_result->SetAngle(value);
            return castState<AngleSet>();
        }

        std::unique_ptr<ScreenOrientation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenOrientation;
        ScreenOrientationBuilder() : m_result(new ScreenOrientation()) { }

        template<int STEP> ScreenOrientationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenOrientationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenOrientation> m_result;
    };

    static ScreenOrientationBuilder<0> Create()
    {
        return ScreenOrientationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenOrientation()
    {
          m_angle = 0;
    }

    String m_type;
    int m_angle;
};


class HEADLESS_EXPORT WorkAreaInsets : public ::crdtp::ProtocolObject<WorkAreaInsets> {
public:
    ~WorkAreaInsets() override { }

    bool HasTop() { return !!m_top; }
    int GetTop(int defaultValue) const {
       return m_top.value_or(defaultValue);
    }
    const std::optional<int>& GetTop() const {
       return m_top;
    }
    void SetTop(int value) { m_top = value; }

    bool HasLeft() { return !!m_left; }
    int GetLeft(int defaultValue) const {
       return m_left.value_or(defaultValue);
    }
    const std::optional<int>& GetLeft() const {
       return m_left;
    }
    void SetLeft(int value) { m_left = value; }

    bool HasBottom() { return !!m_bottom; }
    int GetBottom(int defaultValue) const {
       return m_bottom.value_or(defaultValue);
    }
    const std::optional<int>& GetBottom() const {
       return m_bottom;
    }
    void SetBottom(int value) { m_bottom = value; }

    bool HasRight() { return !!m_right; }
    int GetRight(int defaultValue) const {
       return m_right.value_or(defaultValue);
    }
    const std::optional<int>& GetRight() const {
       return m_right;
    }
    void SetRight(int value) { m_right = value; }

    template<int STATE>
    class WorkAreaInsetsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        WorkAreaInsetsBuilder<STATE>& SetTop(int value)
        {
            m_result->SetTop(value);
            return *this;
        }

        WorkAreaInsetsBuilder<STATE>& SetLeft(int value)
        {
            m_result->SetLeft(value);
            return *this;
        }

        WorkAreaInsetsBuilder<STATE>& SetBottom(int value)
        {
            m_result->SetBottom(value);
            return *this;
        }

        WorkAreaInsetsBuilder<STATE>& SetRight(int value)
        {
            m_result->SetRight(value);
            return *this;
        }

        std::unique_ptr<WorkAreaInsets> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WorkAreaInsets;
        WorkAreaInsetsBuilder() : m_result(new WorkAreaInsets()) { }

        template<int STEP> WorkAreaInsetsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WorkAreaInsetsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::WorkAreaInsets> m_result;
    };

    static WorkAreaInsetsBuilder<0> Create()
    {
        return WorkAreaInsetsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WorkAreaInsets()
    {
    }

    std::optional<int> m_top;
    std::optional<int> m_left;
    std::optional<int> m_bottom;
    std::optional<int> m_right;
};


class HEADLESS_EXPORT ScreenInfo : public ::crdtp::ProtocolObject<ScreenInfo> {
public:
    ~ScreenInfo() override { }

    int GetLeft() { return m_left; }
    void SetLeft(int value) { m_left = value; }

    int GetTop() { return m_top; }
    void SetTop(int value) { m_top = value; }

    int GetWidth() { return m_width; }
    void SetWidth(int value) { m_width = value; }

    int GetHeight() { return m_height; }
    void SetHeight(int value) { m_height = value; }

    int GetAvailLeft() { return m_availLeft; }
    void SetAvailLeft(int value) { m_availLeft = value; }

    int GetAvailTop() { return m_availTop; }
    void SetAvailTop(int value) { m_availTop = value; }

    int GetAvailWidth() { return m_availWidth; }
    void SetAvailWidth(int value) { m_availWidth = value; }

    int GetAvailHeight() { return m_availHeight; }
    void SetAvailHeight(int value) { m_availHeight = value; }

    double GetDevicePixelRatio() { return m_devicePixelRatio; }
    void SetDevicePixelRatio(double value) { m_devicePixelRatio = value; }

    protocol::Emulation::ScreenOrientation* GetOrientation() { return m_orientation.get(); }
    void SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value) { m_orientation = std::move(value); }

    int GetColorDepth() { return m_colorDepth; }
    void SetColorDepth(int value) { m_colorDepth = value; }

    bool GetIsExtended() { return m_isExtended; }
    void SetIsExtended(bool value) { m_isExtended = value; }

    bool GetIsInternal() { return m_isInternal; }
    void SetIsInternal(bool value) { m_isInternal = value; }

    bool GetIsPrimary() { return m_isPrimary; }
    void SetIsPrimary(bool value) { m_isPrimary = value; }

    String GetLabel() { return m_label; }
    void SetLabel(const String& value) { m_label = value; }

    String GetId() { return m_id; }
    void SetId(const String& value) { m_id = value; }

    template<int STATE>
    class ScreenInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LeftSet = 1 << 1,
            TopSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            AvailLeftSet = 1 << 5,
            AvailTopSet = 1 << 6,
            AvailWidthSet = 1 << 7,
            AvailHeightSet = 1 << 8,
            DevicePixelRatioSet = 1 << 9,
            OrientationSet = 1 << 10,
            ColorDepthSet = 1 << 11,
            IsExtendedSet = 1 << 12,
            IsInternalSet = 1 << 13,
            IsPrimarySet = 1 << 14,
            LabelSet = 1 << 15,
            IdSet = 1 << 16,
            AllFieldsSet = (LeftSet | TopSet | WidthSet | HeightSet | AvailLeftSet | AvailTopSet | AvailWidthSet | AvailHeightSet | DevicePixelRatioSet | OrientationSet | ColorDepthSet | IsExtendedSet | IsInternalSet | IsPrimarySet | LabelSet | IdSet | 0)};


        ScreenInfoBuilder<STATE | LeftSet>& SetLeft(int value)
        {
            static_assert(!(STATE & LeftSet), "property left should not be set yet");
            m_result->SetLeft(value);
            return castState<LeftSet>();
        }

        ScreenInfoBuilder<STATE | TopSet>& SetTop(int value)
        {
            static_assert(!(STATE & TopSet), "property top should not be set yet");
            m_result->SetTop(value);
            return castState<TopSet>();
        }

        ScreenInfoBuilder<STATE | WidthSet>& SetWidth(int value)
        {
            static_assert(!(STATE & WidthSet), "property width should not be set yet");
            m_result->SetWidth(value);
            return castState<WidthSet>();
        }

        ScreenInfoBuilder<STATE | HeightSet>& SetHeight(int value)
        {
            static_assert(!(STATE & HeightSet), "property height should not be set yet");
            m_result->SetHeight(value);
            return castState<HeightSet>();
        }

        ScreenInfoBuilder<STATE | AvailLeftSet>& SetAvailLeft(int value)
        {
            static_assert(!(STATE & AvailLeftSet), "property availLeft should not be set yet");
            m_result->SetAvailLeft(value);
            return castState<AvailLeftSet>();
        }

        ScreenInfoBuilder<STATE | AvailTopSet>& SetAvailTop(int value)
        {
            static_assert(!(STATE & AvailTopSet), "property availTop should not be set yet");
            m_result->SetAvailTop(value);
            return castState<AvailTopSet>();
        }

        ScreenInfoBuilder<STATE | AvailWidthSet>& SetAvailWidth(int value)
        {
            static_assert(!(STATE & AvailWidthSet), "property availWidth should not be set yet");
            m_result->SetAvailWidth(value);
            return castState<AvailWidthSet>();
        }

        ScreenInfoBuilder<STATE | AvailHeightSet>& SetAvailHeight(int value)
        {
            static_assert(!(STATE & AvailHeightSet), "property availHeight should not be set yet");
            m_result->SetAvailHeight(value);
            return castState<AvailHeightSet>();
        }

        ScreenInfoBuilder<STATE | DevicePixelRatioSet>& SetDevicePixelRatio(double value)
        {
            static_assert(!(STATE & DevicePixelRatioSet), "property devicePixelRatio should not be set yet");
            m_result->SetDevicePixelRatio(value);
            return castState<DevicePixelRatioSet>();
        }

        ScreenInfoBuilder<STATE | OrientationSet>& SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value)
        {
            static_assert(!(STATE & OrientationSet), "property orientation should not be set yet");
            m_result->SetOrientation(std::move(value));
            return castState<OrientationSet>();
        }

        ScreenInfoBuilder<STATE | ColorDepthSet>& SetColorDepth(int value)
        {
            static_assert(!(STATE & ColorDepthSet), "property colorDepth should not be set yet");
            m_result->SetColorDepth(value);
            return castState<ColorDepthSet>();
        }

        ScreenInfoBuilder<STATE | IsExtendedSet>& SetIsExtended(bool value)
        {
            static_assert(!(STATE & IsExtendedSet), "property isExtended should not be set yet");
            m_result->SetIsExtended(value);
            return castState<IsExtendedSet>();
        }

        ScreenInfoBuilder<STATE | IsInternalSet>& SetIsInternal(bool value)
        {
            static_assert(!(STATE & IsInternalSet), "property isInternal should not be set yet");
            m_result->SetIsInternal(value);
            return castState<IsInternalSet>();
        }

        ScreenInfoBuilder<STATE | IsPrimarySet>& SetIsPrimary(bool value)
        {
            static_assert(!(STATE & IsPrimarySet), "property isPrimary should not be set yet");
            m_result->SetIsPrimary(value);
            return castState<IsPrimarySet>();
        }

        ScreenInfoBuilder<STATE | LabelSet>& SetLabel(const String& value)
        {
            static_assert(!(STATE & LabelSet), "property label should not be set yet");
            m_result->SetLabel(value);
            return castState<LabelSet>();
        }

        ScreenInfoBuilder<STATE | IdSet>& SetId(const String& value)
        {
            static_assert(!(STATE & IdSet), "property id should not be set yet");
            m_result->SetId(value);
            return castState<IdSet>();
        }

        std::unique_ptr<ScreenInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenInfo;
        ScreenInfoBuilder() : m_result(new ScreenInfo()) { }

        template<int STEP> ScreenInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenInfo> m_result;
    };

    static ScreenInfoBuilder<0> Create()
    {
        return ScreenInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenInfo()
    {
          m_left = 0;
          m_top = 0;
          m_width = 0;
          m_height = 0;
          m_availLeft = 0;
          m_availTop = 0;
          m_availWidth = 0;
          m_availHeight = 0;
          m_devicePixelRatio = 0;
          m_colorDepth = 0;
          m_isExtended = false;
          m_isInternal = false;
          m_isPrimary = false;
    }

    int m_left;
    int m_top;
    int m_width;
    int m_height;
    int m_availLeft;
    int m_availTop;
    int m_availWidth;
    int m_availHeight;
    double m_devicePixelRatio;
    std::unique_ptr<protocol::Emulation::ScreenOrientation> m_orientation;
    int m_colorDepth;
    bool m_isExtended;
    bool m_isInternal;
    bool m_isPrimary;
    String m_label;
    String m_id;
};


// ------------- Backend interface.

class HEADLESS_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse GetScreenInfos(std::unique_ptr<protocol::Array<protocol::Emulation::ScreenInfo>>* out_screenInfos) = 0;
    virtual DispatchResponse AddScreen(int in_left, int in_top, int in_width, int in_height, std::unique_ptr<protocol::Emulation::WorkAreaInsets> in_workAreaInsets, std::optional<double> in_devicePixelRatio, std::optional<int> in_rotation, std::optional<int> in_colorDepth, std::optional<String> in_label, std::optional<bool> in_isInternal, std::unique_ptr<protocol::Emulation::ScreenInfo>* out_screenInfo) = 0;
    virtual DispatchResponse RemoveScreen(const String& in_screenId) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class HEADLESS_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class HEADLESS_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class HEADLESS_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Emulation
} // namespace headless
} // namespace protocol

#endif // !defined(headless_protocol_Emulation_h)
