// gpu/ipc/common/shared_image_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'gpu/ipc/common/shared_image_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gpu.mojom');
  var shared_image_format$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/shared_image_format.mojom', '../../../services/viz/public/mojom/compositing/shared_image_format.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../ui/gfx/mojom/color_space.mojom.js');
  }
  var surface_origin$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/surface_origin.mojom', '../../../skia/public/mojom/surface_origin.mojom.js');
  }
  var image_info$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/image_info.mojom', '../../../skia/public/mojom/image_info.mojom.js');
  }



  function SharedImageMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedImageMetadata.prototype.initDefaults_ = function() {
    this.format = null;
    this.size = null;
    this.colorSpace = null;
    this.surfaceOrigin = 0;
    this.alphaType = 0;
    this.usage = 0;
  };
  SharedImageMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedImageMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageMetadata.format
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, shared_image_format$.SharedImageFormat, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageMetadata.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageMetadata.colorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, color_space$.ColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageMetadata.surfaceOrigin
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, surface_origin$.SurfaceOrigin);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedImageMetadata.alphaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, image_info$.AlphaType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedImageMetadata.encodedSize = codec.kStructHeaderSize + 48;

  SharedImageMetadata.decode = function(decoder) {
    var packed;
    var val = new SharedImageMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStruct(shared_image_format$.SharedImageFormat);
    val.size =
        decoder.decodeStructPointer(geometry$.Size);
    val.colorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    val.surfaceOrigin =
        decoder.decodeStruct(new codec.Enum(surface_origin$.SurfaceOrigin));
    val.alphaType =
        decoder.decodeStruct(new codec.Enum(image_info$.AlphaType));
    val.usage =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedImageMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedImageMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(shared_image_format$.SharedImageFormat, val.format);
    encoder.encodeStructPointer(geometry$.Size, val.size);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.colorSpace);
    encoder.encodeStruct(codec.Int32, val.surfaceOrigin);
    encoder.encodeStruct(codec.Int32, val.alphaType);
    encoder.encodeStruct(codec.Uint32, val.usage);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.SharedImageMetadata = SharedImageMetadata;
})();