// gpu/ipc/common/mailbox_holder.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/mailbox_holder.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"

#include "gpu/ipc/common/mailbox_holder.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::MailboxHolderDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::MailboxHolderDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::MailboxHolder_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mailbox.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mailbox in MailboxHolder struct");

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in MailboxHolder struct");

      fragment->texture_target = Traits::texture_target(input);
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_MAILBOX_HOLDER_MOJOM_SEND_VALIDATION_H_