// gpu/ipc/common/gpu_disk_cache_type.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-params-data.h"
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-shared-message-ids.h"

#include "gpu/ipc/common/gpu_disk_cache_type.mojom-blink-import-headers.h"
#include "gpu/ipc/common/gpu_disk_cache_type.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gpu::mojom::blink {
GpuDiskCacheGlShaderHandle::GpuDiskCacheGlShaderHandle()
    : value() {}

GpuDiskCacheGlShaderHandle::GpuDiskCacheGlShaderHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheGlShaderHandle::~GpuDiskCacheGlShaderHandle() = default;
size_t GpuDiskCacheGlShaderHandle::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void GpuDiskCacheGlShaderHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheGlShaderHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheDawnWebGPUHandle::GpuDiskCacheDawnWebGPUHandle()
    : value() {}

GpuDiskCacheDawnWebGPUHandle::GpuDiskCacheDawnWebGPUHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheDawnWebGPUHandle::~GpuDiskCacheDawnWebGPUHandle() = default;
size_t GpuDiskCacheDawnWebGPUHandle::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void GpuDiskCacheDawnWebGPUHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheDawnWebGPUHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheDawnGraphiteHandle::GpuDiskCacheDawnGraphiteHandle()
    : value() {}

GpuDiskCacheDawnGraphiteHandle::GpuDiskCacheDawnGraphiteHandle(
    int32_t value_in)
    : value(std::move(value_in)) {}

GpuDiskCacheDawnGraphiteHandle::~GpuDiskCacheDawnGraphiteHandle() = default;
size_t GpuDiskCacheDawnGraphiteHandle::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void GpuDiskCacheDawnGraphiteHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuDiskCacheDawnGraphiteHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewGlShaderHandle(
    GpuDiskCacheGlShaderHandlePtr value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGlShaderHandle)>,
      std::move(value));
}

GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewDawnWebgpuHandle(
    GpuDiskCacheDawnWebGPUHandlePtr value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
      std::move(value));
}

GpuDiskCacheHandlePtr
GpuDiskCacheHandle::NewDawnGraphiteHandle(
    GpuDiskCacheDawnGraphiteHandlePtr value) {
  return GpuDiskCacheHandlePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
      std::move(value));
}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
    GpuDiskCacheGlShaderHandlePtr value)
    : tag_(Tag::kGlShaderHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGlShaderHandle)>,
            std::move(value)) {}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
    GpuDiskCacheDawnWebGPUHandlePtr value)
    : tag_(Tag::kDawnWebgpuHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
            std::move(value)) {}

GpuDiskCacheHandle::GpuDiskCacheHandle(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
    GpuDiskCacheDawnGraphiteHandlePtr value)
    : tag_(Tag::kDawnGraphiteHandle),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
            std::move(value)) {}
GpuDiskCacheHandle::~GpuDiskCacheHandle() {
  DestroyActive();
}

void GpuDiskCacheHandle::set_gl_shader_handle(GpuDiskCacheGlShaderHandlePtr gl_shader_handle) {
  if (tag_ == Tag::kGlShaderHandle) {
    data_.gl_shader_handle = std::move(gl_shader_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kGlShaderHandle;
    new (&data_.gl_shader_handle) GpuDiskCacheGlShaderHandlePtr(
        std::move(gl_shader_handle));
  }
}

void GpuDiskCacheHandle::set_dawn_webgpu_handle(GpuDiskCacheDawnWebGPUHandlePtr dawn_webgpu_handle) {
  if (tag_ == Tag::kDawnWebgpuHandle) {
    data_.dawn_webgpu_handle = std::move(dawn_webgpu_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kDawnWebgpuHandle;
    new (&data_.dawn_webgpu_handle) GpuDiskCacheDawnWebGPUHandlePtr(
        std::move(dawn_webgpu_handle));
  }
}

void GpuDiskCacheHandle::set_dawn_graphite_handle(GpuDiskCacheDawnGraphiteHandlePtr dawn_graphite_handle) {
  if (tag_ == Tag::kDawnGraphiteHandle) {
    data_.dawn_graphite_handle = std::move(dawn_graphite_handle);
  } else {
    DestroyActive();
    tag_ = Tag::kDawnGraphiteHandle;
    new (&data_.dawn_graphite_handle) GpuDiskCacheDawnGraphiteHandlePtr(
        std::move(dawn_graphite_handle));
  }
}


GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGlShaderHandle)>,
    GpuDiskCacheGlShaderHandlePtr value)
    : gl_shader_handle(std::move(value)) {}

GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnWebgpuHandle)>,
    GpuDiskCacheDawnWebGPUHandlePtr value)
    : dawn_webgpu_handle(std::move(value)) {}

GpuDiskCacheHandle::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDawnGraphiteHandle)>,
    GpuDiskCacheDawnGraphiteHandlePtr value)
    : dawn_graphite_handle(std::move(value)) {}

void GpuDiskCacheHandle::DestroyActive() {
  switch (tag_) {

    case Tag::kGlShaderHandle:
      std::destroy_at(&data_.gl_shader_handle);
      break;
    case Tag::kDawnWebgpuHandle:
      std::destroy_at(&data_.dawn_webgpu_handle);
      break;
    case Tag::kDawnGraphiteHandle:
      std::destroy_at(&data_.dawn_graphite_handle);
      break;
  }
}
size_t GpuDiskCacheHandle::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kGlShaderHandle:
      return mojo::internal::WTFHash(seed, data_.gl_shader_handle);
    case Tag::kDawnWebgpuHandle:
      return mojo::internal::WTFHash(seed, data_.dawn_webgpu_handle);
    case Tag::kDawnGraphiteHandle:
      return mojo::internal::WTFHash(seed, data_.dawn_graphite_handle);
    default:
      NOTREACHED();
  }
}

bool GpuDiskCacheHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // gpu::mojom::blink


namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::DataView, ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr>::Read(
    ::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::DataView input,
    ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr result(::gpu::mojom::blink::GpuDiskCacheGlShaderHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::DataView, ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr>::Read(
    ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::DataView input,
    ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr result(::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::DataView, ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr>::Read(
    ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::DataView input,
    ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr* output) {
  bool success = true;
  ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr result(::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandle::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::gpu::mojom::blink::GpuDiskCacheHandle::DataView, ::gpu::mojom::blink::GpuDiskCacheHandlePtr>::Read(
    ::gpu::mojom::blink::GpuDiskCacheHandle::DataView input,
    ::gpu::mojom::blink::GpuDiskCacheHandlePtr* output) {
  using UnionType = ::gpu::mojom::blink::GpuDiskCacheHandle;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kGlShaderHandle: {
      ::gpu::mojom::blink::GpuDiskCacheGlShaderHandlePtr result_gl_shader_handle{};
      if (!input.ReadGlShaderHandle(&result_gl_shader_handle))
        return false;

      *output = UnionType::NewGlShaderHandle(
          std::move(result_gl_shader_handle));
      break;
    }
    case Tag::kDawnWebgpuHandle: {
      ::gpu::mojom::blink::GpuDiskCacheDawnWebGPUHandlePtr result_dawn_webgpu_handle{};
      if (!input.ReadDawnWebgpuHandle(&result_dawn_webgpu_handle))
        return false;

      *output = UnionType::NewDawnWebgpuHandle(
          std::move(result_dawn_webgpu_handle));
      break;
    }
    case Tag::kDawnGraphiteHandle: {
      ::gpu::mojom::blink::GpuDiskCacheDawnGraphiteHandlePtr result_dawn_graphite_handle{};
      if (!input.ReadDawnGraphiteHandle(&result_dawn_graphite_handle))
        return false;

      *output = UnionType::NewDawnGraphiteHandle(
          std::move(result_dawn_graphite_handle));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom::blink {




}  // gpu::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif