// gpu/ipc/common/device_perf_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/device_perf_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/device_perf_info.mojom-params-data.h"
#include "gpu/ipc/common/device_perf_info.mojom-shared-message-ids.h"

#include "gpu/ipc/common/device_perf_info.mojom-blink-import-headers.h"
#include "gpu/ipc/common/device_perf_info.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace gpu::mojom::blink {
DevicePerfInfo::DevicePerfInfo()
    : total_physical_memory_mb(),
      total_disk_space_mb(),
      hardware_concurrency() {}

DevicePerfInfo::DevicePerfInfo(
    uint32_t total_physical_memory_mb_in,
    uint32_t total_disk_space_mb_in,
    uint32_t hardware_concurrency_in)
    : total_physical_memory_mb(std::move(total_physical_memory_mb_in)),
      total_disk_space_mb(std::move(total_disk_space_mb_in)),
      hardware_concurrency(std::move(hardware_concurrency_in)) {}

DevicePerfInfo::~DevicePerfInfo() = default;
size_t DevicePerfInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->total_physical_memory_mb);
  seed = mojo::internal::WTFHash(seed, this->total_disk_space_mb);
  seed = mojo::internal::WTFHash(seed, this->hardware_concurrency);
  return seed;
}

void DevicePerfInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_physical_memory_mb"), this->total_physical_memory_mb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_disk_space_mb"), this->total_disk_space_mb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hardware_concurrency"), this->hardware_concurrency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DevicePerfInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gpu::mojom::blink


namespace mojo {


// static
bool StructTraits<::gpu::mojom::blink::DevicePerfInfo::DataView, ::gpu::mojom::blink::DevicePerfInfoPtr>::Read(
    ::gpu::mojom::blink::DevicePerfInfo::DataView input,
    ::gpu::mojom::blink::DevicePerfInfoPtr* output) {
  bool success = true;
  ::gpu::mojom::blink::DevicePerfInfoPtr result(::gpu::mojom::blink::DevicePerfInfo::New());
  
      if (success)
        result->total_physical_memory_mb = input.total_physical_memory_mb();
      if (success)
        result->total_disk_space_mb = input.total_disk_space_mb();
      if (success)
        result->hardware_concurrency = input.hardware_concurrency();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom::blink {




}  // gpu::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif