// extensions/common/mojom/renderer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.RendererPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.Renderer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.RendererInterface }
 */
extensions.mojom.RendererRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.RendererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.RendererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.RendererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   */

  activateExtension(
      extensionId) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.Renderer_ActivateExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setActivityLoggingEnabled(
      enabled) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions.mojom.ExtensionLoadedParams> } params
   */

  loadExtensions(
      params) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.Renderer_LoadExtensions_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   */

  unloadExtension(
      extensionId) {
    this.proxy.sendMessage(
        3,
        extensions.mojom.Renderer_UnloadExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @return {!Promise}
   */

  suspendExtension(
      extensionId) {
    return this.proxy.sendMessage(
        4,
        extensions.mojom.Renderer_SuspendExtension_ParamsSpec.$,
        extensions.mojom.Renderer_SuspendExtension_ResponseParamsSpec.$,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   */

  cancelSuspendExtension(
      extensionId) {
    this.proxy.sendMessage(
        5,
        extensions.mojom.Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        [
          extensionId
        ],
        false);
  }

  
  /**
   * @param { !boolean } developerModeOnly
   */

  setDeveloperMode(
      developerModeOnly) {
    this.proxy.sendMessage(
        6,
        extensions.mojom.Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        [
          developerModeOnly
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !boolean } allowed
   */

  setUserScriptsAllowed(
      extensionId,
      allowed) {
    this.proxy.sendMessage(
        7,
        extensions.mojom.Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        [
          extensionId,
          allowed
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.Channel } channel
   * @param { !extensions.mojom.FeatureSessionType } session
   */

  setSessionInfo(
      channel,
      session) {
    this.proxy.sendMessage(
        8,
        extensions.mojom.Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        [
          channel,
          session
        ],
        false);
  }

  
  /**
   * @param { !string } fontFamily
   * @param { !string } fontSize
   */

  setSystemFont(
      fontFamily,
      fontSize) {
    this.proxy.sendMessage(
        9,
        extensions.mojom.Renderer_SetSystemFont_ParamsSpec.$,
        null,
        [
          fontFamily,
          fontSize
        ],
        false);
  }

  
  /**
   * @param { !string } partitionId
   */

  setWebViewPartitionID(
      partitionId) {
    this.proxy.sendMessage(
        10,
        extensions.mojom.Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        [
          partitionId
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions.mojom.ExtensionId> } extensionIds
   */

  setScriptingAllowlist(
      extensionIds) {
    this.proxy.sendMessage(
        11,
        extensions.mojom.Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        [
          extensionIds
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions.mojom.UserScriptWorldInfo> } infos
   */

  updateUserScriptWorlds(
      infos) {
    this.proxy.sendMessage(
        12,
        extensions.mojom.Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        [
          infos
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { ?string } worldId
   */

  clearUserScriptWorldConfig(
      extensionId,
      worldId) {
    this.proxy.sendMessage(
        13,
        extensions.mojom.Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        [
          extensionId,
          worldId
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  shouldSuspend() {
    return this.proxy.sendMessage(
        14,
        extensions.mojom.Renderer_ShouldSuspend_ParamsSpec.$,
        extensions.mojom.Renderer_ShouldSuspend_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  transferBlobs() {
    return this.proxy.sendMessage(
        15,
        extensions.mojom.Renderer_TransferBlobs_ParamsSpec.$,
        extensions.mojom.Renderer_TransferBlobs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !extensions.mojom.PermissionSet } activePermissions
   * @param { !extensions.mojom.PermissionSet } withheldPermissions
   * @param { !extensions.mojom.URLPatternSet } policyBlockedHosts
   * @param { !extensions.mojom.URLPatternSet } policyAllowedHosts
   * @param { !boolean } usesDefaultPolicyHostRestrictions
   */

  updatePermissions(
      extensionId,
      activePermissions,
      withheldPermissions,
      policyBlockedHosts,
      policyAllowedHosts,
      usesDefaultPolicyHostRestrictions) {
    this.proxy.sendMessage(
        16,
        extensions.mojom.Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        [
          extensionId,
          activePermissions,
          withheldPermissions,
          policyBlockedHosts,
          policyAllowedHosts,
          usesDefaultPolicyHostRestrictions
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.URLPatternSet } defaultPolicyBlockedHosts
   * @param { !extensions.mojom.URLPatternSet } defaultPolicyAllowedHosts
   */

  updateDefaultPolicyHostRestrictions(
      defaultPolicyBlockedHosts,
      defaultPolicyAllowedHosts) {
    this.proxy.sendMessage(
        17,
        extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        [
          defaultPolicyBlockedHosts,
          defaultPolicyAllowedHosts
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.URLPatternSet } userBlockedHosts
   * @param { !extensions.mojom.URLPatternSet } userAllowedHosts
   */

  updateUserHostRestrictions(
      userBlockedHosts,
      userAllowedHosts) {
    this.proxy.sendMessage(
        18,
        extensions.mojom.Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        [
          userBlockedHosts,
          userAllowedHosts
        ],
        false);
  }

  
  /**
   * @param { !extensions.mojom.ExtensionId } extensionId
   * @param { !extensions.mojom.URLPatternSet } newHosts
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  updateTabSpecificPermissions(
      extensionId,
      newHosts,
      tabId,
      updateOriginAllowlist) {
    this.proxy.sendMessage(
        19,
        extensions.mojom.Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        [
          extensionId,
          newHosts,
          tabId,
          updateOriginAllowlist
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } region
   * @param { !extensions.mojom.HostID } owner
   */

  updateUserScripts(
      region,
      owner) {
    this.proxy.sendMessage(
        20,
        extensions.mojom.Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        [
          region,
          owner
        ],
        false);
  }

  
  /**
   * @param { !Array<!extensions.mojom.ExtensionId> } extensionIds
   * @param { !number } tabId
   * @param { !boolean } updateOriginAllowlist
   */

  clearTabSpecificPermissions(
      extensionIds,
      tabId,
      updateOriginAllowlist) {
    this.proxy.sendMessage(
        21,
        extensions.mojom.Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        [
          extensionIds,
          tabId,
          updateOriginAllowlist
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } cssSelectors
   */

  watchPages(
      cssSelectors) {
    this.proxy.sendMessage(
        22,
        extensions.mojom.Renderer_WatchPages_ParamsSpec.$,
        null,
        [
          cssSelectors
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Renderer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.RendererReceiver = class {
  /**
   * @param {!extensions.mojom.RendererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.RendererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.Renderer_ActivateExtension_ParamsSpec.$,
        null,
        impl.activateExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        impl.setActivityLoggingEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.Renderer_LoadExtensions_ParamsSpec.$,
        null,
        impl.loadExtensions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.Renderer_UnloadExtension_ParamsSpec.$,
        null,
        impl.unloadExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.Renderer_SuspendExtension_ParamsSpec.$,
        extensions.mojom.Renderer_SuspendExtension_ResponseParamsSpec.$,
        impl.suspendExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        impl.cancelSuspendExtension.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        impl.setDeveloperMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        impl.setUserScriptsAllowed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        impl.setSessionInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.Renderer_SetSystemFont_ParamsSpec.$,
        null,
        impl.setSystemFont.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        impl.setWebViewPartitionID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        impl.setScriptingAllowlist.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        extensions.mojom.Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        impl.updateUserScriptWorlds.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        extensions.mojom.Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        impl.clearUserScriptWorldConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        extensions.mojom.Renderer_ShouldSuspend_ParamsSpec.$,
        extensions.mojom.Renderer_ShouldSuspend_ResponseParamsSpec.$,
        impl.shouldSuspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        extensions.mojom.Renderer_TransferBlobs_ParamsSpec.$,
        extensions.mojom.Renderer_TransferBlobs_ResponseParamsSpec.$,
        impl.transferBlobs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        extensions.mojom.Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        impl.updatePermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        impl.updateDefaultPolicyHostRestrictions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        extensions.mojom.Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        impl.updateUserHostRestrictions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        extensions.mojom.Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        impl.updateTabSpecificPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        extensions.mojom.Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        impl.updateUserScripts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        extensions.mojom.Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        impl.clearTabSpecificPermissions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        extensions.mojom.Renderer_WatchPages_ParamsSpec.$,
        null,
        impl.watchPages.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.Renderer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.Renderer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.RendererRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.RendererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Renderer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.RendererCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.activateExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.Renderer_ActivateExtension_ParamsSpec.$,
        null,
        this.activateExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setActivityLoggingEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
        null,
        this.setActivityLoggingEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadExtensions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.Renderer_LoadExtensions_ParamsSpec.$,
        null,
        this.loadExtensions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unloadExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.Renderer_UnloadExtension_ParamsSpec.$,
        null,
        this.unloadExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        extensions.mojom.Renderer_SuspendExtension_ParamsSpec.$,
        extensions.mojom.Renderer_SuspendExtension_ResponseParamsSpec.$,
        this.suspendExtension.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelSuspendExtension =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        extensions.mojom.Renderer_CancelSuspendExtension_ParamsSpec.$,
        null,
        this.cancelSuspendExtension.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setDeveloperMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        extensions.mojom.Renderer_SetDeveloperMode_ParamsSpec.$,
        null,
        this.setDeveloperMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUserScriptsAllowed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        extensions.mojom.Renderer_SetUserScriptsAllowed_ParamsSpec.$,
        null,
        this.setUserScriptsAllowed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSessionInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        extensions.mojom.Renderer_SetSessionInfo_ParamsSpec.$,
        null,
        this.setSessionInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSystemFont =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        extensions.mojom.Renderer_SetSystemFont_ParamsSpec.$,
        null,
        this.setSystemFont.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setWebViewPartitionID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        extensions.mojom.Renderer_SetWebViewPartitionID_ParamsSpec.$,
        null,
        this.setWebViewPartitionID.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setScriptingAllowlist =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        extensions.mojom.Renderer_SetScriptingAllowlist_ParamsSpec.$,
        null,
        this.setScriptingAllowlist.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserScriptWorlds =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        extensions.mojom.Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
        null,
        this.updateUserScriptWorlds.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearUserScriptWorldConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        extensions.mojom.Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
        null,
        this.clearUserScriptWorldConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSuspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        extensions.mojom.Renderer_ShouldSuspend_ParamsSpec.$,
        extensions.mojom.Renderer_ShouldSuspend_ResponseParamsSpec.$,
        this.shouldSuspend.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transferBlobs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        extensions.mojom.Renderer_TransferBlobs_ParamsSpec.$,
        extensions.mojom.Renderer_TransferBlobs_ResponseParamsSpec.$,
        this.transferBlobs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        extensions.mojom.Renderer_UpdatePermissions_ParamsSpec.$,
        null,
        this.updatePermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateDefaultPolicyHostRestrictions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
        null,
        this.updateDefaultPolicyHostRestrictions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserHostRestrictions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        extensions.mojom.Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
        null,
        this.updateUserHostRestrictions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTabSpecificPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        extensions.mojom.Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
        null,
        this.updateTabSpecificPermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateUserScripts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        extensions.mojom.Renderer_UpdateUserScripts_ParamsSpec.$,
        null,
        this.updateUserScripts.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearTabSpecificPermissions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        extensions.mojom.Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
        null,
        this.clearTabSpecificPermissions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watchPages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        extensions.mojom.Renderer_WatchPages_ParamsSpec.$,
        null,
        this.watchPages.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.ExtensionLoadedParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.UserScriptWorldInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_ActivateExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetActivityLoggingEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_LoadExtensions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UnloadExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SuspendExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SuspendExtension_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_CancelSuspendExtension_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetDeveloperMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetUserScriptsAllowed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetSessionInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetSystemFont_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetWebViewPartitionID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_SetScriptingAllowlist_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdateUserScriptWorlds_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_ClearUserScriptWorldConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_ShouldSuspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_ShouldSuspend_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_TransferBlobs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_TransferBlobs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdatePermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdateUserHostRestrictions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdateTabSpecificPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_UpdateUserScripts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_ClearTabSpecificPermissions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.Renderer_WatchPages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.ExtensionLoadedParamsSpec.$,
    'ExtensionLoadedParams',
    [
      mojo.internal.StructField(
        'manifest', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        extensions.mojom.ManifestLocationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 16,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activePermissions', 24,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 32,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabSpecificPermissions', 40,
        0,
        mojo.internal.Map(mojo.internal.Int32, extensions.mojom.PermissionSetSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyBlockedHosts', 48,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyAllowedHosts', 56,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usesDefaultPolicyBlockedAllowedHosts', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userScriptsAllowed', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 64,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workerActivationToken', 72,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'creationFlags', 80,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'guid', 88,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 104],]);





/** @record */
extensions.mojom.ExtensionLoadedParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.manifest;
    /** @export { !extensions.mojom.ManifestLocation } */
    this.location;
    /** @export { !mojoBase.mojom.FilePath } */
    this.path;
    /** @export { !extensions.mojom.PermissionSet } */
    this.activePermissions;
    /** @export { !extensions.mojom.PermissionSet } */
    this.withheldPermissions;
    /** @export { !Object<!number, !extensions.mojom.PermissionSet> } */
    this.tabSpecificPermissions;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.policyBlockedHosts;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.policyAllowedHosts;
    /** @export { !boolean } */
    this.usesDefaultPolicyBlockedAllowedHosts;
    /** @export { !boolean } */
    this.userScriptsAllowed;
    /** @export { !string } */
    this.id;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.workerActivationToken;
    /** @export { !number } */
    this.creationFlags;
    /** @export { !string } */
    this.guid;
  }
};



mojo.internal.Struct(
    extensions.mojom.UserScriptWorldInfoSpec.$,
    'UserScriptWorldInfo',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'worldId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'csp', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableMessaging', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
extensions.mojom.UserScriptWorldInfo = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { (string|undefined) } */
    this.worldId;
    /** @export { (string|undefined) } */
    this.csp;
    /** @export { !boolean } */
    this.enableMessaging;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_ActivateExtension_ParamsSpec.$,
    'Renderer_ActivateExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_ActivateExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetActivityLoggingEnabled_ParamsSpec.$,
    'Renderer_SetActivityLoggingEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SetActivityLoggingEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_LoadExtensions_ParamsSpec.$,
    'Renderer_LoadExtensions_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        mojo.internal.Array(extensions.mojom.ExtensionLoadedParamsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_LoadExtensions_Params = class {
  constructor() {
    /** @export { !Array<!extensions.mojom.ExtensionLoadedParams> } */
    this.params;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UnloadExtension_ParamsSpec.$,
    'Renderer_UnloadExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_UnloadExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SuspendExtension_ParamsSpec.$,
    'Renderer_SuspendExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SuspendExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SuspendExtension_ResponseParamsSpec.$,
    'Renderer_SuspendExtension_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.Renderer_SuspendExtension_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_CancelSuspendExtension_ParamsSpec.$,
    'Renderer_CancelSuspendExtension_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_CancelSuspendExtension_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetDeveloperMode_ParamsSpec.$,
    'Renderer_SetDeveloperMode_Params',
    [
      mojo.internal.StructField(
        'developerModeOnly', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SetDeveloperMode_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.developerModeOnly;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetUserScriptsAllowed_ParamsSpec.$,
    'Renderer_SetUserScriptsAllowed_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowed', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_SetUserScriptsAllowed_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !boolean } */
    this.allowed;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetSessionInfo_ParamsSpec.$,
    'Renderer_SetSessionInfo_Params',
    [
      mojo.internal.StructField(
        'channel', 0,
        0,
        extensions.mojom.ChannelSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 4,
        0,
        extensions.mojom.FeatureSessionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SetSessionInfo_Params = class {
  constructor() {
    /** @export { !extensions.mojom.Channel } */
    this.channel;
    /** @export { !extensions.mojom.FeatureSessionType } */
    this.session;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetSystemFont_ParamsSpec.$,
    'Renderer_SetSystemFont_Params',
    [
      mojo.internal.StructField(
        'fontFamily', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fontSize', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_SetSystemFont_Params = class {
  constructor() {
    /** @export { !string } */
    this.fontFamily;
    /** @export { !string } */
    this.fontSize;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetWebViewPartitionID_ParamsSpec.$,
    'Renderer_SetWebViewPartitionID_Params',
    [
      mojo.internal.StructField(
        'partitionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SetWebViewPartitionID_Params = class {
  constructor() {
    /** @export { !string } */
    this.partitionId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_SetScriptingAllowlist_ParamsSpec.$,
    'Renderer_SetScriptingAllowlist_Params',
    [
      mojo.internal.StructField(
        'extensionIds', 0,
        0,
        mojo.internal.Array(extensions.mojom.ExtensionIdSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_SetScriptingAllowlist_Params = class {
  constructor() {
    /** @export { !Array<!extensions.mojom.ExtensionId> } */
    this.extensionIds;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdateUserScriptWorlds_ParamsSpec.$,
    'Renderer_UpdateUserScriptWorlds_Params',
    [
      mojo.internal.StructField(
        'infos', 0,
        0,
        mojo.internal.Array(extensions.mojom.UserScriptWorldInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_UpdateUserScriptWorlds_Params = class {
  constructor() {
    /** @export { !Array<!extensions.mojom.UserScriptWorldInfo> } */
    this.infos;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_ClearUserScriptWorldConfig_ParamsSpec.$,
    'Renderer_ClearUserScriptWorldConfig_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'worldId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_ClearUserScriptWorldConfig_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { (string|undefined) } */
    this.worldId;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_ShouldSuspend_ParamsSpec.$,
    'Renderer_ShouldSuspend_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.Renderer_ShouldSuspend_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_ShouldSuspend_ResponseParamsSpec.$,
    'Renderer_ShouldSuspend_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.Renderer_ShouldSuspend_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_TransferBlobs_ParamsSpec.$,
    'Renderer_TransferBlobs_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.Renderer_TransferBlobs_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_TransferBlobs_ResponseParamsSpec.$,
    'Renderer_TransferBlobs_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.Renderer_TransferBlobs_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdatePermissions_ParamsSpec.$,
    'Renderer_UpdatePermissions_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activePermissions', 8,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withheldPermissions', 16,
        0,
        extensions.mojom.PermissionSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyBlockedHosts', 24,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyAllowedHosts', 32,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usesDefaultPolicyHostRestrictions', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
extensions.mojom.Renderer_UpdatePermissions_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !extensions.mojom.PermissionSet } */
    this.activePermissions;
    /** @export { !extensions.mojom.PermissionSet } */
    this.withheldPermissions;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.policyBlockedHosts;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.policyAllowedHosts;
    /** @export { !boolean } */
    this.usesDefaultPolicyHostRestrictions;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_ParamsSpec.$,
    'Renderer_UpdateDefaultPolicyHostRestrictions_Params',
    [
      mojo.internal.StructField(
        'defaultPolicyBlockedHosts', 0,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultPolicyAllowedHosts', 8,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_UpdateDefaultPolicyHostRestrictions_Params = class {
  constructor() {
    /** @export { !extensions.mojom.URLPatternSet } */
    this.defaultPolicyBlockedHosts;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.defaultPolicyAllowedHosts;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdateUserHostRestrictions_ParamsSpec.$,
    'Renderer_UpdateUserHostRestrictions_Params',
    [
      mojo.internal.StructField(
        'userBlockedHosts', 0,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userAllowedHosts', 8,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_UpdateUserHostRestrictions_Params = class {
  constructor() {
    /** @export { !extensions.mojom.URLPatternSet } */
    this.userBlockedHosts;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.userAllowedHosts;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdateTabSpecificPermissions_ParamsSpec.$,
    'Renderer_UpdateTabSpecificPermissions_Params',
    [
      mojo.internal.StructField(
        'extensionId', 0,
        0,
        extensions.mojom.ExtensionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newHosts', 8,
        0,
        extensions.mojom.URLPatternSetSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabId', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateOriginAllowlist', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
extensions.mojom.Renderer_UpdateTabSpecificPermissions_Params = class {
  constructor() {
    /** @export { !extensions.mojom.ExtensionId } */
    this.extensionId;
    /** @export { !extensions.mojom.URLPatternSet } */
    this.newHosts;
    /** @export { !number } */
    this.tabId;
    /** @export { !boolean } */
    this.updateOriginAllowlist;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_UpdateUserScripts_ParamsSpec.$,
    'Renderer_UpdateUserScripts_Params',
    [
      mojo.internal.StructField(
        'region', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'owner', 8,
        0,
        extensions.mojom.HostIDSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_UpdateUserScripts_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.region;
    /** @export { !extensions.mojom.HostID } */
    this.owner;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_ClearTabSpecificPermissions_ParamsSpec.$,
    'Renderer_ClearTabSpecificPermissions_Params',
    [
      mojo.internal.StructField(
        'extensionIds', 0,
        0,
        mojo.internal.Array(extensions.mojom.ExtensionIdSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabId', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateOriginAllowlist', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.Renderer_ClearTabSpecificPermissions_Params = class {
  constructor() {
    /** @export { !Array<!extensions.mojom.ExtensionId> } */
    this.extensionIds;
    /** @export { !number } */
    this.tabId;
    /** @export { !boolean } */
    this.updateOriginAllowlist;
  }
};



mojo.internal.Struct(
    extensions.mojom.Renderer_WatchPages_ParamsSpec.$,
    'Renderer_WatchPages_Params',
    [
      mojo.internal.StructField(
        'cssSelectors', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.Renderer_WatchPages_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.cssSelectors;
  }
};

