// extensions/common/mojom/guest_view.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/guest_view.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/guest_view.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/guest_view.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/api/mime_handler.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/transferrable_url_loader.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class GuestViewProxy;

template <typename ImplRefTraits>
class GuestViewStub;

class GuestViewRequestValidator;
class GuestViewResponseValidator;


class GuestView
    : public GuestViewInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.GuestView";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GuestViewInterfaceBase;
  using Proxy_ = GuestViewProxy;

  template <typename ImplRefTraits>
  using Stub_ = GuestViewStub<ImplRefTraits>;

  using RequestValidator_ = GuestViewRequestValidator;
  using ResponseValidator_ = GuestViewResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadyToCreateMimeHandlerViewMinVersion = 0,
    kCanExecuteContentScriptMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReadyToCreateMimeHandlerView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanExecuteContentScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GuestView() = default;

  virtual void ReadyToCreateMimeHandlerView(bool success) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CanExecuteContentScript(const std::string& script_id, bool* out_allowed);
  using CanExecuteContentScriptCallback = base::OnceCallback<void(bool)>;
  using CanExecuteContentScriptMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanExecuteContentScript(const std::string& script_id, CanExecuteContentScriptCallback callback) = 0;
};

class MimeHandlerViewContainerManagerProxy;

template <typename ImplRefTraits>
class MimeHandlerViewContainerManagerStub;

class MimeHandlerViewContainerManagerRequestValidator;
class MimeHandlerViewContainerManagerResponseValidator;


class MimeHandlerViewContainerManager
    : public MimeHandlerViewContainerManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.MimeHandlerViewContainerManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MimeHandlerViewContainerManagerInterfaceBase;
  using Proxy_ = MimeHandlerViewContainerManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MimeHandlerViewContainerManagerStub<ImplRefTraits>;

  using RequestValidator_ = MimeHandlerViewContainerManagerRequestValidator;
  using ResponseValidator_ = MimeHandlerViewContainerManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetInternalIdMinVersion = 0,
    kCreateBeforeUnloadControlMinVersion = 0,
    kDestroyFrameContainerMinVersion = 0,
    kDidLoadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetInternalId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateBeforeUnloadControl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyFrameContainer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MimeHandlerViewContainerManager() = default;

  virtual void SetInternalId(const std::string& token_id) = 0;

  using CreateBeforeUnloadControlCallback = base::OnceCallback<void(::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>)>;
  using CreateBeforeUnloadControlMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<::extensions::mime_handler::BeforeUnloadControl>)>;

  virtual void CreateBeforeUnloadControl(CreateBeforeUnloadControlCallback callback) = 0;

  virtual void DestroyFrameContainer(int32_t element_instance_id) = 0;

  virtual void DidLoad(int32_t mime_handler_view_guest_element_instance_id, const ::GURL& resource_url) = 0;
};



class  GuestViewProxy
    : public GuestView {
 public:
  using InterfaceType = GuestView;

  explicit GuestViewProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadyToCreateMimeHandlerView(bool success) final;
  
  bool CanExecuteContentScript(const std::string& script_id, bool* out_allowed) final;
  
  void CanExecuteContentScript(const std::string& script_id, CanExecuteContentScriptCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MimeHandlerViewContainerManagerProxy
    : public MimeHandlerViewContainerManager {
 public:
  using InterfaceType = MimeHandlerViewContainerManager;

  explicit MimeHandlerViewContainerManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInternalId(const std::string& token_id) final;
  
  void CreateBeforeUnloadControl(CreateBeforeUnloadControlCallback callback) final;
  
  void DestroyFrameContainer(int32_t element_instance_id) final;
  
  void DidLoad(int32_t mime_handler_view_guest_element_instance_id, const ::GURL& resource_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GuestViewStubDispatch {
 public:
  static bool Accept(GuestView* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GuestView* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GuestView>>
class GuestViewStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GuestViewStub() = default;
  ~GuestViewStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GuestViewStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MimeHandlerViewContainerManagerStubDispatch {
 public:
  static bool Accept(MimeHandlerViewContainerManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MimeHandlerViewContainerManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MimeHandlerViewContainerManager>>
class MimeHandlerViewContainerManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MimeHandlerViewContainerManagerStub() = default;
  ~MimeHandlerViewContainerManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerViewContainerManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeHandlerViewContainerManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GuestViewRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MimeHandlerViewContainerManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GuestViewResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MimeHandlerViewContainerManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_GUEST_VIEW_MOJOM_H_