// extensions/common/mojom/event_dispatcher.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/event_dispatcher.mojom-shared-internal.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "extensions/common/mojom/event_dispatcher.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::EventFilteringInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::EventFilteringInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::EventFilteringInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      decltype(Traits::service_type(input)) in_service_type = Traits::service_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_type)::BaseType> service_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_service_type,
        service_type_fragment);

      fragment->service_type.Set(
          service_type_fragment.is_null() ? nullptr : service_type_fragment.data());

      fragment->has_instance_id = Traits::has_instance_id(input);

      fragment->instance_id = Traits::instance_id(input);

      decltype(Traits::window_type(input)) in_window_type = Traits::window_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->window_type)::BaseType> window_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_window_type,
        window_type_fragment);

      fragment->window_type.Set(
          window_type_fragment.is_null() ? nullptr : window_type_fragment.data());

      fragment->has_window_exposed_by_default = Traits::has_window_exposed_by_default(input);

      fragment->window_exposed_by_default = Traits::window_exposed_by_default(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::DispatchEventParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::DispatchEventParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::DispatchEventParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->worker_thread_id = Traits::worker_thread_id(input);

      decltype(Traits::host_id(input)) in_host_id = Traits::host_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_id)::BaseType> host_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::HostIDDataView, send_validation>(
        in_host_id,
        host_id_fragment);

      fragment->host_id.Set(
          host_id_fragment.is_null() ? nullptr : host_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_id in DispatchEventParams struct");

      decltype(Traits::event_name(input)) in_event_name = Traits::event_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_name)::BaseType> event_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_event_name,
        event_name_fragment);

      fragment->event_name.Set(
          event_name_fragment.is_null() ? nullptr : event_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_name in DispatchEventParams struct");

      fragment->event_id = Traits::event_id(input);

      fragment->is_user_gesture = Traits::is_user_gesture(input);

      decltype(Traits::filtering_info(input)) in_filtering_info = Traits::filtering_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filtering_info)::BaseType> filtering_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::EventFilteringInfoDataView, send_validation>(
        in_filtering_info,
        filtering_info_fragment);

      fragment->filtering_info.Set(
          filtering_info_fragment.is_null() ? nullptr : filtering_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filtering_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filtering_info in DispatchEventParams struct");
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_DISPATCHER_MOJOM_SEND_VALIDATION_H_