// extensions/common/mojom/code_injection.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'extensions/common/mojom/code_injection.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('extensions.mojom');
  var css_origin$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/css_origin.mojom', 'css_origin.mojom.js');
  }
  var execution_world$ =
      mojo.internal.exposeNamespace('extensions.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'extensions/common/mojom/execution_world.mojom', 'execution_world.mojom.js');
  }
  var script_evaluation_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/script/script_evaluation_params.mojom', '../../../third_party/blink/public/mojom/script/script_evaluation_params.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function JSSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JSSource.prototype.initDefaults_ = function() {
    this.code = null;
    this.scriptUrl = null;
  };
  JSSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JSSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSSource.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSSource.scriptUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JSSource.encodedSize = codec.kStructHeaderSize + 16;

  JSSource.decode = function(decoder) {
    var packed;
    var val = new JSSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    val.scriptUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  JSSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JSSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
    encoder.encodeStructPointer(url$.Url, val.scriptUrl);
  };
  function CSSSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CSSSource.prototype.initDefaults_ = function() {
    this.code = null;
    this.key = null;
  };
  CSSSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CSSSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CSSSource.code
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CSSSource.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CSSSource.encodedSize = codec.kStructHeaderSize + 16;

  CSSSource.decode = function(decoder) {
    var packed;
    var val = new CSSSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(codec.String);
    val.key =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CSSSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CSSSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.code);
    encoder.encodeStruct(codec.String, val.key);
  };
  function JSInjection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JSInjection.prototype.initDefaults_ = function() {
    this.sources = null;
    this.world = 0;
    this.wantsResult = 0;
    this.worldId = null;
    this.userGesture = 0;
    this.waitForPromise = 0;
  };
  JSInjection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JSInjection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.sources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(JSSource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.world
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, execution_world$.ExecutionWorld);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.worldId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.wantsResult
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, script_evaluation_params$.WantResultOption);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.userGesture
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, script_evaluation_params$.UserActivationOption);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JSInjection.waitForPromise
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, script_evaluation_params$.PromiseResultOption);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JSInjection.encodedSize = codec.kStructHeaderSize + 32;

  JSInjection.decode = function(decoder) {
    var packed;
    var val = new JSInjection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sources =
        decoder.decodeArrayPointer(new codec.PointerTo(JSSource));
    val.world =
        decoder.decodeStruct(new codec.Enum(execution_world$.ExecutionWorld));
    val.wantsResult =
        decoder.decodeStruct(new codec.Enum(script_evaluation_params$.WantResultOption));
    val.worldId =
        decoder.decodeStruct(codec.String);
    val.userGesture =
        decoder.decodeStruct(new codec.Enum(script_evaluation_params$.UserActivationOption));
    val.waitForPromise =
        decoder.decodeStruct(new codec.Enum(script_evaluation_params$.PromiseResultOption));
    return val;
  };

  JSInjection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JSInjection.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(JSSource), val.sources);
    encoder.encodeStruct(codec.Int32, val.world);
    encoder.encodeStruct(codec.Int32, val.wantsResult);
    encoder.encodeStruct(codec.String, val.worldId);
    encoder.encodeStruct(codec.Int32, val.userGesture);
    encoder.encodeStruct(codec.Int32, val.waitForPromise);
  };
  function CSSInjection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  CSSInjection.Operation = {};
  CSSInjection.Operation.kAdd = 0;
  CSSInjection.Operation.kRemove = 1;
  CSSInjection.Operation.MIN_VALUE = 0;
  CSSInjection.Operation.MAX_VALUE = 1;

  CSSInjection.Operation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CSSInjection.Operation.toKnownEnumValue = function(value) {
    return value;
  };

  CSSInjection.Operation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  CSSInjection.prototype.initDefaults_ = function() {
    this.sources = null;
    this.cssOrigin = 0;
    this.operation = 0;
  };
  CSSInjection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CSSInjection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CSSInjection.sources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CSSSource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CSSInjection.cssOrigin
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, css_origin$.CSSOrigin);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CSSInjection.operation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, CSSInjection.Operation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CSSInjection.encodedSize = codec.kStructHeaderSize + 16;

  CSSInjection.decode = function(decoder) {
    var packed;
    var val = new CSSInjection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sources =
        decoder.decodeArrayPointer(new codec.PointerTo(CSSSource));
    val.cssOrigin =
        decoder.decodeStruct(new codec.Enum(css_origin$.CSSOrigin));
    val.operation =
        decoder.decodeStruct(new codec.Enum(CSSInjection.Operation));
    return val;
  };

  CSSInjection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CSSInjection.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CSSSource), val.sources);
    encoder.encodeStruct(codec.Int32, val.cssOrigin);
    encoder.encodeStruct(codec.Int32, val.operation);
  };

  function CodeInjection(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CodeInjection.Tags = {
    css: 0,
    js: 1,
  };

  CodeInjection.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CodeInjection.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "css",
        "js",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CodeInjection member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CodeInjection.prototype, "css", {
    get: function() {
      if (this.$tag != CodeInjection.Tags.css) {
        throw new ReferenceError(
            "CodeInjection.css is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CodeInjection.Tags.css;
      this.$data = value;
    }
  });
  Object.defineProperty(CodeInjection.prototype, "js", {
    get: function() {
      if (this.$tag != CodeInjection.Tags.js) {
        throw new ReferenceError(
            "CodeInjection.js is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CodeInjection.Tags.js;
      this.$data = value;
    }
  });


    CodeInjection.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CodeInjection.Tags.css:
          encoder.encodeStructPointer(CSSInjection, val.css);
          break;
        case CodeInjection.Tags.js:
          encoder.encodeStructPointer(JSInjection, val.js);
          break;
      }
      encoder.align();
    };


    CodeInjection.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CodeInjection();
      var tag = decoder.readUint32();
      switch (tag) {
        case CodeInjection.Tags.css:
          result.css = decoder.decodeStructPointer(CSSInjection);
          break;
        case CodeInjection.Tags.js:
          result.js = decoder.decodeStructPointer(JSInjection);
          break;
      }
      decoder.align();

      return result;
    };


    CodeInjection.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CodeInjection.Tags.css:
          

    // validate CodeInjection.css
    err = messageValidator.validateStructPointer(data_offset, CSSInjection, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CodeInjection.Tags.js:
          

    // validate CodeInjection.js
    err = messageValidator.validateStructPointer(data_offset, JSInjection, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CodeInjection.encodedSize = 16;
  exports.JSSource = JSSource;
  exports.CSSSource = CSSSource;
  exports.JSInjection = JSInjection;
  exports.CSSInjection = CSSInjection;
  exports.CodeInjection = CodeInjection;
})();