// extensions/common/mojom/app_window.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_APP_WINDOW_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_APP_WINDOW_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/app_window.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/app_window.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/app_window.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class AppWindowProxy;

template <typename ImplRefTraits>
class AppWindowStub;

class AppWindowRequestValidator;


class AppWindow
    : public AppWindowInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.AppWindow";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AppWindowInterfaceBase;
  using Proxy_ = AppWindowProxy;

  template <typename ImplRefTraits>
  using Stub_ = AppWindowStub<ImplRefTraits>;

  using RequestValidator_ = AppWindowRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVisuallyDeemphasizedMinVersion = 0,
    kSetSupportsDraggableRegionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetVisuallyDeemphasized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSupportsDraggableRegions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AppWindow() = default;

  virtual void SetVisuallyDeemphasized(bool deemphasized) = 0;

  virtual void SetSupportsDraggableRegions(bool supports_draggable_regions) = 0;
};



class  AppWindowProxy
    : public AppWindow {
 public:
  using InterfaceType = AppWindow;

  explicit AppWindowProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVisuallyDeemphasized(bool deemphasized) final;
  
  void SetSupportsDraggableRegions(bool supports_draggable_regions) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AppWindowStubDispatch {
 public:
  static bool Accept(AppWindow* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AppWindow* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AppWindow>>
class AppWindowStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AppWindowStub() = default;
  ~AppWindowStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppWindowStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AppWindowStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AppWindowRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_APP_WINDOW_MOJOM_H_